/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;

public enum AddressType implements BmcEnum
{
    PrivateIPv4("Private_IPv4"),
    OracleAllocatedPublicIPv4("Oracle_Allocated_Public_IPv4"),
    ByoipIPv4("BYOIP_IPv4"),
    UlaIPv6("ULA_IPv6"),
    OracleAllocatedGuaIPv6("Oracle_Allocated_GUA_IPv6"),
    ByoipIPv6("BYOIP_IPv6");

    private final String value;
    private static Map<String, AddressType> map;

    private AddressType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static AddressType create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid AddressType: " + key);
    }

    static {
        map = new HashMap<String, AddressType>();
        for (AddressType v : AddressType.values()) {
            map.put(v.getValue(), v);
        }
    }
}

