/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.core.Compute;
import com.oracle.bmc.core.ComputePaginators;
import com.oracle.bmc.core.ComputeWaiters;
import com.oracle.bmc.core.model.AppCatalogListing;
import com.oracle.bmc.core.model.AppCatalogListingResourceVersion;
import com.oracle.bmc.core.model.AppCatalogListingResourceVersionAgreements;
import com.oracle.bmc.core.model.AppCatalogListingResourceVersionSummary;
import com.oracle.bmc.core.model.AppCatalogListingSummary;
import com.oracle.bmc.core.model.AppCatalogSubscription;
import com.oracle.bmc.core.model.AppCatalogSubscriptionSummary;
import com.oracle.bmc.core.model.BootVolumeAttachment;
import com.oracle.bmc.core.model.CapacityReservationInstanceSummary;
import com.oracle.bmc.core.model.ComputeBareMetalHostCollection;
import com.oracle.bmc.core.model.ComputeCapacityReport;
import com.oracle.bmc.core.model.ComputeCapacityReservation;
import com.oracle.bmc.core.model.ComputeCapacityReservationInstanceShapeSummary;
import com.oracle.bmc.core.model.ComputeCapacityReservationSummary;
import com.oracle.bmc.core.model.ComputeCapacityTopology;
import com.oracle.bmc.core.model.ComputeCapacityTopologyCollection;
import com.oracle.bmc.core.model.ComputeCluster;
import com.oracle.bmc.core.model.ComputeClusterCollection;
import com.oracle.bmc.core.model.ComputeGlobalImageCapabilitySchema;
import com.oracle.bmc.core.model.ComputeGlobalImageCapabilitySchemaSummary;
import com.oracle.bmc.core.model.ComputeGlobalImageCapabilitySchemaVersion;
import com.oracle.bmc.core.model.ComputeGlobalImageCapabilitySchemaVersionSummary;
import com.oracle.bmc.core.model.ComputeGpuMemoryCluster;
import com.oracle.bmc.core.model.ComputeGpuMemoryClusterCollection;
import com.oracle.bmc.core.model.ComputeGpuMemoryClusterInstanceCollection;
import com.oracle.bmc.core.model.ComputeGpuMemoryFabric;
import com.oracle.bmc.core.model.ComputeGpuMemoryFabricCollection;
import com.oracle.bmc.core.model.ComputeHost;
import com.oracle.bmc.core.model.ComputeHostCollection;
import com.oracle.bmc.core.model.ComputeHpcIslandCollection;
import com.oracle.bmc.core.model.ComputeImageCapabilitySchema;
import com.oracle.bmc.core.model.ComputeImageCapabilitySchemaSummary;
import com.oracle.bmc.core.model.ComputeNetworkBlockCollection;
import com.oracle.bmc.core.model.ConsoleHistory;
import com.oracle.bmc.core.model.DedicatedVmHost;
import com.oracle.bmc.core.model.DedicatedVmHostInstanceShapeSummary;
import com.oracle.bmc.core.model.DedicatedVmHostInstanceSummary;
import com.oracle.bmc.core.model.DedicatedVmHostShapeSummary;
import com.oracle.bmc.core.model.DedicatedVmHostSummary;
import com.oracle.bmc.core.model.Device;
import com.oracle.bmc.core.model.Image;
import com.oracle.bmc.core.model.ImageShapeCompatibilityEntry;
import com.oracle.bmc.core.model.ImageShapeCompatibilitySummary;
import com.oracle.bmc.core.model.Instance;
import com.oracle.bmc.core.model.InstanceConsoleConnection;
import com.oracle.bmc.core.model.InstanceCredentials;
import com.oracle.bmc.core.model.InstanceMaintenanceEvent;
import com.oracle.bmc.core.model.InstanceMaintenanceEventSummary;
import com.oracle.bmc.core.model.InstanceMaintenanceReboot;
import com.oracle.bmc.core.model.MeasuredBootReport;
import com.oracle.bmc.core.model.Shape;
import com.oracle.bmc.core.model.VnicAttachment;
import com.oracle.bmc.core.model.VolumeAttachment;
import com.oracle.bmc.core.requests.AcceptShieldedIntegrityPolicyRequest;
import com.oracle.bmc.core.requests.AddImageShapeCompatibilityEntryRequest;
import com.oracle.bmc.core.requests.AttachBootVolumeRequest;
import com.oracle.bmc.core.requests.AttachVnicRequest;
import com.oracle.bmc.core.requests.AttachVolumeRequest;
import com.oracle.bmc.core.requests.CaptureConsoleHistoryRequest;
import com.oracle.bmc.core.requests.ChangeComputeCapacityReservationCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeComputeCapacityTopologyCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeComputeClusterCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeComputeGpuMemoryClusterCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeComputeGpuMemoryFabricCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeComputeHostCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeComputeImageCapabilitySchemaCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeDedicatedVmHostCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeImageCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeInstanceCompartmentRequest;
import com.oracle.bmc.core.requests.CreateAppCatalogSubscriptionRequest;
import com.oracle.bmc.core.requests.CreateComputeCapacityReportRequest;
import com.oracle.bmc.core.requests.CreateComputeCapacityReservationRequest;
import com.oracle.bmc.core.requests.CreateComputeCapacityTopologyRequest;
import com.oracle.bmc.core.requests.CreateComputeClusterRequest;
import com.oracle.bmc.core.requests.CreateComputeGpuMemoryClusterRequest;
import com.oracle.bmc.core.requests.CreateComputeImageCapabilitySchemaRequest;
import com.oracle.bmc.core.requests.CreateDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.CreateImageRequest;
import com.oracle.bmc.core.requests.CreateInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.requests.DeleteAppCatalogSubscriptionRequest;
import com.oracle.bmc.core.requests.DeleteComputeCapacityReservationRequest;
import com.oracle.bmc.core.requests.DeleteComputeCapacityTopologyRequest;
import com.oracle.bmc.core.requests.DeleteComputeClusterRequest;
import com.oracle.bmc.core.requests.DeleteComputeGpuMemoryClusterRequest;
import com.oracle.bmc.core.requests.DeleteComputeImageCapabilitySchemaRequest;
import com.oracle.bmc.core.requests.DeleteConsoleHistoryRequest;
import com.oracle.bmc.core.requests.DeleteDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.DeleteImageRequest;
import com.oracle.bmc.core.requests.DeleteInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.requests.DetachBootVolumeRequest;
import com.oracle.bmc.core.requests.DetachVnicRequest;
import com.oracle.bmc.core.requests.DetachVolumeRequest;
import com.oracle.bmc.core.requests.ExportImageRequest;
import com.oracle.bmc.core.requests.GetAppCatalogListingAgreementsRequest;
import com.oracle.bmc.core.requests.GetAppCatalogListingRequest;
import com.oracle.bmc.core.requests.GetAppCatalogListingResourceVersionRequest;
import com.oracle.bmc.core.requests.GetBootVolumeAttachmentRequest;
import com.oracle.bmc.core.requests.GetComputeCapacityReservationRequest;
import com.oracle.bmc.core.requests.GetComputeCapacityTopologyRequest;
import com.oracle.bmc.core.requests.GetComputeClusterRequest;
import com.oracle.bmc.core.requests.GetComputeGlobalImageCapabilitySchemaRequest;
import com.oracle.bmc.core.requests.GetComputeGlobalImageCapabilitySchemaVersionRequest;
import com.oracle.bmc.core.requests.GetComputeGpuMemoryClusterRequest;
import com.oracle.bmc.core.requests.GetComputeGpuMemoryFabricRequest;
import com.oracle.bmc.core.requests.GetComputeHostRequest;
import com.oracle.bmc.core.requests.GetComputeImageCapabilitySchemaRequest;
import com.oracle.bmc.core.requests.GetConsoleHistoryContentRequest;
import com.oracle.bmc.core.requests.GetConsoleHistoryRequest;
import com.oracle.bmc.core.requests.GetDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.GetImageRequest;
import com.oracle.bmc.core.requests.GetImageShapeCompatibilityEntryRequest;
import com.oracle.bmc.core.requests.GetInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.requests.GetInstanceMaintenanceEventRequest;
import com.oracle.bmc.core.requests.GetInstanceMaintenanceRebootRequest;
import com.oracle.bmc.core.requests.GetInstanceRequest;
import com.oracle.bmc.core.requests.GetMeasuredBootReportRequest;
import com.oracle.bmc.core.requests.GetVnicAttachmentRequest;
import com.oracle.bmc.core.requests.GetVolumeAttachmentRequest;
import com.oracle.bmc.core.requests.GetWindowsInstanceInitialCredentialsRequest;
import com.oracle.bmc.core.requests.InstanceActionRequest;
import com.oracle.bmc.core.requests.LaunchInstanceRequest;
import com.oracle.bmc.core.requests.ListAppCatalogListingResourceVersionsRequest;
import com.oracle.bmc.core.requests.ListAppCatalogListingsRequest;
import com.oracle.bmc.core.requests.ListAppCatalogSubscriptionsRequest;
import com.oracle.bmc.core.requests.ListBootVolumeAttachmentsRequest;
import com.oracle.bmc.core.requests.ListComputeCapacityReservationInstanceShapesRequest;
import com.oracle.bmc.core.requests.ListComputeCapacityReservationInstancesRequest;
import com.oracle.bmc.core.requests.ListComputeCapacityReservationsRequest;
import com.oracle.bmc.core.requests.ListComputeCapacityTopologiesRequest;
import com.oracle.bmc.core.requests.ListComputeCapacityTopologyComputeBareMetalHostsRequest;
import com.oracle.bmc.core.requests.ListComputeCapacityTopologyComputeHpcIslandsRequest;
import com.oracle.bmc.core.requests.ListComputeCapacityTopologyComputeNetworkBlocksRequest;
import com.oracle.bmc.core.requests.ListComputeClustersRequest;
import com.oracle.bmc.core.requests.ListComputeGlobalImageCapabilitySchemaVersionsRequest;
import com.oracle.bmc.core.requests.ListComputeGlobalImageCapabilitySchemasRequest;
import com.oracle.bmc.core.requests.ListComputeGpuMemoryClusterInstancesRequest;
import com.oracle.bmc.core.requests.ListComputeGpuMemoryClustersRequest;
import com.oracle.bmc.core.requests.ListComputeGpuMemoryFabricsRequest;
import com.oracle.bmc.core.requests.ListComputeHostsRequest;
import com.oracle.bmc.core.requests.ListComputeImageCapabilitySchemasRequest;
import com.oracle.bmc.core.requests.ListConsoleHistoriesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostInstanceShapesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostInstancesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostShapesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostsRequest;
import com.oracle.bmc.core.requests.ListImageShapeCompatibilityEntriesRequest;
import com.oracle.bmc.core.requests.ListImagesRequest;
import com.oracle.bmc.core.requests.ListInstanceConsoleConnectionsRequest;
import com.oracle.bmc.core.requests.ListInstanceDevicesRequest;
import com.oracle.bmc.core.requests.ListInstanceMaintenanceEventsRequest;
import com.oracle.bmc.core.requests.ListInstancesRequest;
import com.oracle.bmc.core.requests.ListShapesRequest;
import com.oracle.bmc.core.requests.ListVnicAttachmentsRequest;
import com.oracle.bmc.core.requests.ListVolumeAttachmentsRequest;
import com.oracle.bmc.core.requests.RemoveImageShapeCompatibilityEntryRequest;
import com.oracle.bmc.core.requests.TerminateInstanceRequest;
import com.oracle.bmc.core.requests.UpdateComputeCapacityReservationRequest;
import com.oracle.bmc.core.requests.UpdateComputeCapacityTopologyRequest;
import com.oracle.bmc.core.requests.UpdateComputeClusterRequest;
import com.oracle.bmc.core.requests.UpdateComputeGpuMemoryClusterRequest;
import com.oracle.bmc.core.requests.UpdateComputeGpuMemoryFabricRequest;
import com.oracle.bmc.core.requests.UpdateComputeHostRequest;
import com.oracle.bmc.core.requests.UpdateComputeImageCapabilitySchemaRequest;
import com.oracle.bmc.core.requests.UpdateConsoleHistoryRequest;
import com.oracle.bmc.core.requests.UpdateDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.UpdateImageRequest;
import com.oracle.bmc.core.requests.UpdateInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.requests.UpdateInstanceMaintenanceEventRequest;
import com.oracle.bmc.core.requests.UpdateInstanceRequest;
import com.oracle.bmc.core.requests.UpdateVolumeAttachmentRequest;
import com.oracle.bmc.core.responses.AcceptShieldedIntegrityPolicyResponse;
import com.oracle.bmc.core.responses.AddImageShapeCompatibilityEntryResponse;
import com.oracle.bmc.core.responses.AttachBootVolumeResponse;
import com.oracle.bmc.core.responses.AttachVnicResponse;
import com.oracle.bmc.core.responses.AttachVolumeResponse;
import com.oracle.bmc.core.responses.CaptureConsoleHistoryResponse;
import com.oracle.bmc.core.responses.ChangeComputeCapacityReservationCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeComputeCapacityTopologyCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeComputeClusterCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeComputeGpuMemoryClusterCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeComputeGpuMemoryFabricCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeComputeHostCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeComputeImageCapabilitySchemaCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeDedicatedVmHostCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeImageCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeInstanceCompartmentResponse;
import com.oracle.bmc.core.responses.CreateAppCatalogSubscriptionResponse;
import com.oracle.bmc.core.responses.CreateComputeCapacityReportResponse;
import com.oracle.bmc.core.responses.CreateComputeCapacityReservationResponse;
import com.oracle.bmc.core.responses.CreateComputeCapacityTopologyResponse;
import com.oracle.bmc.core.responses.CreateComputeClusterResponse;
import com.oracle.bmc.core.responses.CreateComputeGpuMemoryClusterResponse;
import com.oracle.bmc.core.responses.CreateComputeImageCapabilitySchemaResponse;
import com.oracle.bmc.core.responses.CreateDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.CreateImageResponse;
import com.oracle.bmc.core.responses.CreateInstanceConsoleConnectionResponse;
import com.oracle.bmc.core.responses.DeleteAppCatalogSubscriptionResponse;
import com.oracle.bmc.core.responses.DeleteComputeCapacityReservationResponse;
import com.oracle.bmc.core.responses.DeleteComputeCapacityTopologyResponse;
import com.oracle.bmc.core.responses.DeleteComputeClusterResponse;
import com.oracle.bmc.core.responses.DeleteComputeGpuMemoryClusterResponse;
import com.oracle.bmc.core.responses.DeleteComputeImageCapabilitySchemaResponse;
import com.oracle.bmc.core.responses.DeleteConsoleHistoryResponse;
import com.oracle.bmc.core.responses.DeleteDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.DeleteImageResponse;
import com.oracle.bmc.core.responses.DeleteInstanceConsoleConnectionResponse;
import com.oracle.bmc.core.responses.DetachBootVolumeResponse;
import com.oracle.bmc.core.responses.DetachVnicResponse;
import com.oracle.bmc.core.responses.DetachVolumeResponse;
import com.oracle.bmc.core.responses.ExportImageResponse;
import com.oracle.bmc.core.responses.GetAppCatalogListingAgreementsResponse;
import com.oracle.bmc.core.responses.GetAppCatalogListingResourceVersionResponse;
import com.oracle.bmc.core.responses.GetAppCatalogListingResponse;
import com.oracle.bmc.core.responses.GetBootVolumeAttachmentResponse;
import com.oracle.bmc.core.responses.GetComputeCapacityReservationResponse;
import com.oracle.bmc.core.responses.GetComputeCapacityTopologyResponse;
import com.oracle.bmc.core.responses.GetComputeClusterResponse;
import com.oracle.bmc.core.responses.GetComputeGlobalImageCapabilitySchemaResponse;
import com.oracle.bmc.core.responses.GetComputeGlobalImageCapabilitySchemaVersionResponse;
import com.oracle.bmc.core.responses.GetComputeGpuMemoryClusterResponse;
import com.oracle.bmc.core.responses.GetComputeGpuMemoryFabricResponse;
import com.oracle.bmc.core.responses.GetComputeHostResponse;
import com.oracle.bmc.core.responses.GetComputeImageCapabilitySchemaResponse;
import com.oracle.bmc.core.responses.GetConsoleHistoryContentResponse;
import com.oracle.bmc.core.responses.GetConsoleHistoryResponse;
import com.oracle.bmc.core.responses.GetDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.GetImageResponse;
import com.oracle.bmc.core.responses.GetImageShapeCompatibilityEntryResponse;
import com.oracle.bmc.core.responses.GetInstanceConsoleConnectionResponse;
import com.oracle.bmc.core.responses.GetInstanceMaintenanceEventResponse;
import com.oracle.bmc.core.responses.GetInstanceMaintenanceRebootResponse;
import com.oracle.bmc.core.responses.GetInstanceResponse;
import com.oracle.bmc.core.responses.GetMeasuredBootReportResponse;
import com.oracle.bmc.core.responses.GetVnicAttachmentResponse;
import com.oracle.bmc.core.responses.GetVolumeAttachmentResponse;
import com.oracle.bmc.core.responses.GetWindowsInstanceInitialCredentialsResponse;
import com.oracle.bmc.core.responses.InstanceActionResponse;
import com.oracle.bmc.core.responses.LaunchInstanceResponse;
import com.oracle.bmc.core.responses.ListAppCatalogListingResourceVersionsResponse;
import com.oracle.bmc.core.responses.ListAppCatalogListingsResponse;
import com.oracle.bmc.core.responses.ListAppCatalogSubscriptionsResponse;
import com.oracle.bmc.core.responses.ListBootVolumeAttachmentsResponse;
import com.oracle.bmc.core.responses.ListComputeCapacityReservationInstanceShapesResponse;
import com.oracle.bmc.core.responses.ListComputeCapacityReservationInstancesResponse;
import com.oracle.bmc.core.responses.ListComputeCapacityReservationsResponse;
import com.oracle.bmc.core.responses.ListComputeCapacityTopologiesResponse;
import com.oracle.bmc.core.responses.ListComputeCapacityTopologyComputeBareMetalHostsResponse;
import com.oracle.bmc.core.responses.ListComputeCapacityTopologyComputeHpcIslandsResponse;
import com.oracle.bmc.core.responses.ListComputeCapacityTopologyComputeNetworkBlocksResponse;
import com.oracle.bmc.core.responses.ListComputeClustersResponse;
import com.oracle.bmc.core.responses.ListComputeGlobalImageCapabilitySchemaVersionsResponse;
import com.oracle.bmc.core.responses.ListComputeGlobalImageCapabilitySchemasResponse;
import com.oracle.bmc.core.responses.ListComputeGpuMemoryClusterInstancesResponse;
import com.oracle.bmc.core.responses.ListComputeGpuMemoryClustersResponse;
import com.oracle.bmc.core.responses.ListComputeGpuMemoryFabricsResponse;
import com.oracle.bmc.core.responses.ListComputeHostsResponse;
import com.oracle.bmc.core.responses.ListComputeImageCapabilitySchemasResponse;
import com.oracle.bmc.core.responses.ListConsoleHistoriesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostInstanceShapesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostInstancesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostShapesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostsResponse;
import com.oracle.bmc.core.responses.ListImageShapeCompatibilityEntriesResponse;
import com.oracle.bmc.core.responses.ListImagesResponse;
import com.oracle.bmc.core.responses.ListInstanceConsoleConnectionsResponse;
import com.oracle.bmc.core.responses.ListInstanceDevicesResponse;
import com.oracle.bmc.core.responses.ListInstanceMaintenanceEventsResponse;
import com.oracle.bmc.core.responses.ListInstancesResponse;
import com.oracle.bmc.core.responses.ListShapesResponse;
import com.oracle.bmc.core.responses.ListVnicAttachmentsResponse;
import com.oracle.bmc.core.responses.ListVolumeAttachmentsResponse;
import com.oracle.bmc.core.responses.RemoveImageShapeCompatibilityEntryResponse;
import com.oracle.bmc.core.responses.TerminateInstanceResponse;
import com.oracle.bmc.core.responses.UpdateComputeCapacityReservationResponse;
import com.oracle.bmc.core.responses.UpdateComputeCapacityTopologyResponse;
import com.oracle.bmc.core.responses.UpdateComputeClusterResponse;
import com.oracle.bmc.core.responses.UpdateComputeGpuMemoryClusterResponse;
import com.oracle.bmc.core.responses.UpdateComputeGpuMemoryFabricResponse;
import com.oracle.bmc.core.responses.UpdateComputeHostResponse;
import com.oracle.bmc.core.responses.UpdateComputeImageCapabilitySchemaResponse;
import com.oracle.bmc.core.responses.UpdateConsoleHistoryResponse;
import com.oracle.bmc.core.responses.UpdateDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.UpdateImageResponse;
import com.oracle.bmc.core.responses.UpdateInstanceConsoleConnectionResponse;
import com.oracle.bmc.core.responses.UpdateInstanceMaintenanceEventResponse;
import com.oracle.bmc.core.responses.UpdateInstanceResponse;
import com.oracle.bmc.core.responses.UpdateVolumeAttachmentResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.workrequests.WorkRequest;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeClient
extends BaseSyncClient
implements Compute {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("COMPUTE").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ComputeClient.class);
    protected final ExecutorService executorService;
    private final ComputeWaiters waiters;
    private final ComputePaginators paginators;

    ComputeClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, null);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Compute-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.executorService = executorService;
        this.waiters = new ComputeWaiters(executorService, this);
        this.paginators = new ComputePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AcceptShieldedIntegrityPolicyResponse acceptShieldedIntegrityPolicy(AcceptShieldedIntegrityPolicyRequest request) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        return (AcceptShieldedIntegrityPolicyResponse)this.clientCall(request, AcceptShieldedIntegrityPolicyResponse::builder).logger(LOG, "acceptShieldedIntegrityPolicy").serviceDetails("Compute", "AcceptShieldedIntegrityPolicy", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/MeasuredBootReport/AcceptShieldedIntegrityPolicy").method(Method.POST).requestBuilder(AcceptShieldedIntegrityPolicyRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).appendPathParam("actions").appendPathParam("acceptShieldedIntegrityPolicy").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", AcceptShieldedIntegrityPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AddImageShapeCompatibilityEntryResponse addImageShapeCompatibilityEntry(AddImageShapeCompatibilityEntryRequest request) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getShapeName(), (String)"shapeName must not be blank", (Object[])new Object[0]);
        return (AddImageShapeCompatibilityEntryResponse)this.clientCall(request, AddImageShapeCompatibilityEntryResponse::builder).logger(LOG, "addImageShapeCompatibilityEntry").serviceDetails("Compute", "AddImageShapeCompatibilityEntry", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ImageShapeCompatibilityEntry/AddImageShapeCompatibilityEntry").method(Method.PUT).requestBuilder(AddImageShapeCompatibilityEntryRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).appendPathParam("shapes").appendPathParam(request.getShapeName()).accept(new String[]{"application/json"}).hasBody().handleBody(ImageShapeCompatibilityEntry.class, AddImageShapeCompatibilityEntryResponse.Builder::imageShapeCompatibilityEntry).handleResponseHeaderString("opc-request-id", AddImageShapeCompatibilityEntryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AttachBootVolumeResponse attachBootVolume(AttachBootVolumeRequest request) {
        Objects.requireNonNull(request.getAttachBootVolumeDetails(), "attachBootVolumeDetails is required");
        return (AttachBootVolumeResponse)this.clientCall(request, AttachBootVolumeResponse::builder).logger(LOG, "attachBootVolume").serviceDetails("Compute", "AttachBootVolume", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolumeAttachment/AttachBootVolume").method(Method.POST).requestBuilder(AttachBootVolumeRequest::builder).basePath("/20160918").appendPathParam("bootVolumeAttachments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(BootVolumeAttachment.class, AttachBootVolumeResponse.Builder::bootVolumeAttachment).handleResponseHeaderString("etag", AttachBootVolumeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AttachBootVolumeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AttachVnicResponse attachVnic(AttachVnicRequest request) {
        Objects.requireNonNull(request.getAttachVnicDetails(), "attachVnicDetails is required");
        return (AttachVnicResponse)this.clientCall(request, AttachVnicResponse::builder).logger(LOG, "attachVnic").serviceDetails("Compute", "AttachVnic", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VnicAttachment/AttachVnic").method(Method.POST).requestBuilder(AttachVnicRequest::builder).basePath("/20160918").appendPathParam("vnicAttachments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(VnicAttachment.class, AttachVnicResponse.Builder::vnicAttachment).handleResponseHeaderString("etag", AttachVnicResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AttachVnicResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AttachVolumeResponse attachVolume(AttachVolumeRequest request) {
        Objects.requireNonNull(request.getAttachVolumeDetails(), "attachVolumeDetails is required");
        return (AttachVolumeResponse)this.clientCall(request, AttachVolumeResponse::builder).logger(LOG, "attachVolume").serviceDetails("Compute", "AttachVolume", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeAttachment/AttachVolume").method(Method.POST).requestBuilder(AttachVolumeRequest::builder).basePath("/20160918").appendPathParam("volumeAttachments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(VolumeAttachment.class, AttachVolumeResponse.Builder::volumeAttachment).handleResponseHeaderString("etag", AttachVolumeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AttachVolumeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CaptureConsoleHistoryResponse captureConsoleHistory(CaptureConsoleHistoryRequest request) {
        Objects.requireNonNull(request.getCaptureConsoleHistoryDetails(), "captureConsoleHistoryDetails is required");
        return (CaptureConsoleHistoryResponse)this.clientCall(request, CaptureConsoleHistoryResponse::builder).logger(LOG, "captureConsoleHistory").serviceDetails("Compute", "CaptureConsoleHistory", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ConsoleHistory/CaptureConsoleHistory").method(Method.POST).requestBuilder(CaptureConsoleHistoryRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleHistories").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ConsoleHistory.class, CaptureConsoleHistoryResponse.Builder::consoleHistory).handleResponseHeaderString("etag", CaptureConsoleHistoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CaptureConsoleHistoryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeComputeCapacityReservationCompartmentResponse changeComputeCapacityReservationCompartment(ChangeComputeCapacityReservationCompartmentRequest request) {
        Validate.notBlank((String)request.getCapacityReservationId(), (String)"capacityReservationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeComputeCapacityReservationCompartmentDetails(), "changeComputeCapacityReservationCompartmentDetails is required");
        return (ChangeComputeCapacityReservationCompartmentResponse)this.clientCall(request, ChangeComputeCapacityReservationCompartmentResponse::builder).logger(LOG, "changeComputeCapacityReservationCompartment").serviceDetails("Compute", "ChangeComputeCapacityReservationCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityReservation/ChangeComputeCapacityReservationCompartment").method(Method.POST).requestBuilder(ChangeComputeCapacityReservationCompartmentRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReservations").appendPathParam(request.getCapacityReservationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeComputeCapacityReservationCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeComputeCapacityReservationCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeComputeCapacityTopologyCompartmentResponse changeComputeCapacityTopologyCompartment(ChangeComputeCapacityTopologyCompartmentRequest request) {
        Validate.notBlank((String)request.getComputeCapacityTopologyId(), (String)"computeCapacityTopologyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeComputeCapacityTopologyCompartmentDetails(), "changeComputeCapacityTopologyCompartmentDetails is required");
        return (ChangeComputeCapacityTopologyCompartmentResponse)this.clientCall(request, ChangeComputeCapacityTopologyCompartmentResponse::builder).logger(LOG, "changeComputeCapacityTopologyCompartment").serviceDetails("Compute", "ChangeComputeCapacityTopologyCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityTopology/ChangeComputeCapacityTopologyCompartment").method(Method.POST).requestBuilder(ChangeComputeCapacityTopologyCompartmentRequest::builder).basePath("/20160918").appendPathParam("computeCapacityTopologies").appendPathParam(request.getComputeCapacityTopologyId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeComputeCapacityTopologyCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeComputeCapacityTopologyCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeComputeClusterCompartmentResponse changeComputeClusterCompartment(ChangeComputeClusterCompartmentRequest request) {
        Validate.notBlank((String)request.getComputeClusterId(), (String)"computeClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeComputeClusterCompartmentDetails(), "changeComputeClusterCompartmentDetails is required");
        return (ChangeComputeClusterCompartmentResponse)this.clientCall(request, ChangeComputeClusterCompartmentResponse::builder).logger(LOG, "changeComputeClusterCompartment").serviceDetails("Compute", "ChangeComputeClusterCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCluster/ChangeComputeClusterCompartment").method(Method.POST).requestBuilder(ChangeComputeClusterCompartmentRequest::builder).basePath("/20160918").appendPathParam("computeClusters").appendPathParam(request.getComputeClusterId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeComputeClusterCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeComputeGpuMemoryClusterCompartmentResponse changeComputeGpuMemoryClusterCompartment(ChangeComputeGpuMemoryClusterCompartmentRequest request) {
        Validate.notBlank((String)request.getComputeGpuMemoryClusterId(), (String)"computeGpuMemoryClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeComputeGpuMemoryClusterCompartmentDetails(), "changeComputeGpuMemoryClusterCompartmentDetails is required");
        return (ChangeComputeGpuMemoryClusterCompartmentResponse)this.clientCall(request, ChangeComputeGpuMemoryClusterCompartmentResponse::builder).logger(LOG, "changeComputeGpuMemoryClusterCompartment").serviceDetails("Compute", "ChangeComputeGpuMemoryClusterCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGpuMemoryCluster/ChangeComputeGpuMemoryClusterCompartment").method(Method.POST).requestBuilder(ChangeComputeGpuMemoryClusterCompartmentRequest::builder).basePath("/20160918").appendPathParam("computeGpuMemoryClusters").appendPathParam(request.getComputeGpuMemoryClusterId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeComputeGpuMemoryClusterCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeComputeGpuMemoryFabricCompartmentResponse changeComputeGpuMemoryFabricCompartment(ChangeComputeGpuMemoryFabricCompartmentRequest request) {
        Validate.notBlank((String)request.getComputeGpuMemoryFabricId(), (String)"computeGpuMemoryFabricId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeComputeGpuMemoryFabricCompartmentDetails(), "changeComputeGpuMemoryFabricCompartmentDetails is required");
        return (ChangeComputeGpuMemoryFabricCompartmentResponse)this.clientCall(request, ChangeComputeGpuMemoryFabricCompartmentResponse::builder).logger(LOG, "changeComputeGpuMemoryFabricCompartment").serviceDetails("Compute", "ChangeComputeGpuMemoryFabricCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGpuMemoryFabric/ChangeComputeGpuMemoryFabricCompartment").method(Method.POST).requestBuilder(ChangeComputeGpuMemoryFabricCompartmentRequest::builder).basePath("/20160918").appendPathParam("computeGpuMemoryFabrics").appendPathParam(request.getComputeGpuMemoryFabricId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeComputeGpuMemoryFabricCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeComputeHostCompartmentResponse changeComputeHostCompartment(ChangeComputeHostCompartmentRequest request) {
        Validate.notBlank((String)request.getComputeHostId(), (String)"computeHostId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeComputeHostCompartmentDetails(), "changeComputeHostCompartmentDetails is required");
        return (ChangeComputeHostCompartmentResponse)this.clientCall(request, ChangeComputeHostCompartmentResponse::builder).logger(LOG, "changeComputeHostCompartment").serviceDetails("Compute", "ChangeComputeHostCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeHost/ChangeComputeHostCompartment").method(Method.POST).requestBuilder(ChangeComputeHostCompartmentRequest::builder).basePath("/20160918").appendPathParam("computeHosts").appendPathParam(request.getComputeHostId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeComputeHostCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeComputeHostCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeComputeImageCapabilitySchemaCompartmentResponse changeComputeImageCapabilitySchemaCompartment(ChangeComputeImageCapabilitySchemaCompartmentRequest request) {
        Validate.notBlank((String)request.getComputeImageCapabilitySchemaId(), (String)"computeImageCapabilitySchemaId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeComputeImageCapabilitySchemaCompartmentDetails(), "changeComputeImageCapabilitySchemaCompartmentDetails is required");
        return (ChangeComputeImageCapabilitySchemaCompartmentResponse)this.clientCall(request, ChangeComputeImageCapabilitySchemaCompartmentResponse::builder).logger(LOG, "changeComputeImageCapabilitySchemaCompartment").serviceDetails("Compute", "ChangeComputeImageCapabilitySchemaCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeImageCapabilitySchema/ChangeComputeImageCapabilitySchemaCompartment").method(Method.POST).requestBuilder(ChangeComputeImageCapabilitySchemaCompartmentRequest::builder).basePath("/20160918").appendPathParam("computeImageCapabilitySchemas").appendPathParam(request.getComputeImageCapabilitySchemaId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeComputeImageCapabilitySchemaCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeDedicatedVmHostCompartmentResponse changeDedicatedVmHostCompartment(ChangeDedicatedVmHostCompartmentRequest request) {
        Validate.notBlank((String)request.getDedicatedVmHostId(), (String)"dedicatedVmHostId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDedicatedVmHostCompartmentDetails(), "changeDedicatedVmHostCompartmentDetails is required");
        return (ChangeDedicatedVmHostCompartmentResponse)this.clientCall(request, ChangeDedicatedVmHostCompartmentResponse::builder).logger(LOG, "changeDedicatedVmHostCompartment").serviceDetails("Compute", "ChangeDedicatedVmHostCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHost/ChangeDedicatedVmHostCompartment").method(Method.POST).requestBuilder(ChangeDedicatedVmHostCompartmentRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHosts").appendPathParam(request.getDedicatedVmHostId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeDedicatedVmHostCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeDedicatedVmHostCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeDedicatedVmHostCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeImageCompartmentResponse changeImageCompartment(ChangeImageCompartmentRequest request) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeImageCompartmentDetails(), "changeImageCompartmentDetails is required");
        return (ChangeImageCompartmentResponse)this.clientCall(request, ChangeImageCompartmentResponse::builder).logger(LOG, "changeImageCompartment").serviceDetails("Compute", "ChangeImageCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Image/ChangeImageCompartment").method(Method.POST).requestBuilder(ChangeImageCompartmentRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("etag", ChangeImageCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeImageCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeInstanceCompartmentResponse changeInstanceCompartment(ChangeInstanceCompartmentRequest request) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeInstanceCompartmentDetails(), "changeInstanceCompartmentDetails is required");
        return (ChangeInstanceCompartmentResponse)this.clientCall(request, ChangeInstanceCompartmentResponse::builder).logger(LOG, "changeInstanceCompartment").serviceDetails("Compute", "ChangeInstanceCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Instance/ChangeInstanceCompartment").method(Method.POST).requestBuilder(ChangeInstanceCompartmentRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeInstanceCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeInstanceCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeInstanceCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateAppCatalogSubscriptionResponse createAppCatalogSubscription(CreateAppCatalogSubscriptionRequest request) {
        Objects.requireNonNull(request.getCreateAppCatalogSubscriptionDetails(), "createAppCatalogSubscriptionDetails is required");
        return (CreateAppCatalogSubscriptionResponse)this.clientCall(request, CreateAppCatalogSubscriptionResponse::builder).logger(LOG, "createAppCatalogSubscription").serviceDetails("Compute", "CreateAppCatalogSubscription", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/AppCatalogSubscription/CreateAppCatalogSubscription").method(Method.POST).requestBuilder(CreateAppCatalogSubscriptionRequest::builder).basePath("/20160918").appendPathParam("appCatalogSubscriptions").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(AppCatalogSubscription.class, CreateAppCatalogSubscriptionResponse.Builder::appCatalogSubscription).handleResponseHeaderString("etag", CreateAppCatalogSubscriptionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAppCatalogSubscriptionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateComputeCapacityReportResponse createComputeCapacityReport(CreateComputeCapacityReportRequest request) {
        Objects.requireNonNull(request.getCreateComputeCapacityReportDetails(), "createComputeCapacityReportDetails is required");
        return (CreateComputeCapacityReportResponse)this.clientCall(request, CreateComputeCapacityReportResponse::builder).logger(LOG, "createComputeCapacityReport").serviceDetails("Compute", "CreateComputeCapacityReport", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityReport/CreateComputeCapacityReport").method(Method.POST).requestBuilder(CreateComputeCapacityReportRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReports").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(ComputeCapacityReport.class, CreateComputeCapacityReportResponse.Builder::computeCapacityReport).handleResponseHeaderString("opc-request-id", CreateComputeCapacityReportResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateComputeCapacityReservationResponse createComputeCapacityReservation(CreateComputeCapacityReservationRequest request) {
        Objects.requireNonNull(request.getCreateComputeCapacityReservationDetails(), "createComputeCapacityReservationDetails is required");
        return (CreateComputeCapacityReservationResponse)this.clientCall(request, CreateComputeCapacityReservationResponse::builder).logger(LOG, "createComputeCapacityReservation").serviceDetails("Compute", "CreateComputeCapacityReservation", "").method(Method.POST).requestBuilder(CreateComputeCapacityReservationRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReservations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ComputeCapacityReservation.class, CreateComputeCapacityReservationResponse.Builder::computeCapacityReservation).handleResponseHeaderString("etag", CreateComputeCapacityReservationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateComputeCapacityReservationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateComputeCapacityReservationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", CreateComputeCapacityReservationResponse.Builder::location).callSync();
    }

    @Override
    public CreateComputeCapacityTopologyResponse createComputeCapacityTopology(CreateComputeCapacityTopologyRequest request) {
        Objects.requireNonNull(request.getCreateComputeCapacityTopologyDetails(), "createComputeCapacityTopologyDetails is required");
        return (CreateComputeCapacityTopologyResponse)this.clientCall(request, CreateComputeCapacityTopologyResponse::builder).logger(LOG, "createComputeCapacityTopology").serviceDetails("Compute", "CreateComputeCapacityTopology", "").method(Method.POST).requestBuilder(CreateComputeCapacityTopologyRequest::builder).basePath("/20160918").appendPathParam("computeCapacityTopologies").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(ComputeCapacityTopology.class, CreateComputeCapacityTopologyResponse.Builder::computeCapacityTopology).handleResponseHeaderString("etag", CreateComputeCapacityTopologyResponse.Builder::etag).handleResponseHeaderString("location", CreateComputeCapacityTopologyResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateComputeCapacityTopologyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateComputeCapacityTopologyResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateComputeClusterResponse createComputeCluster(CreateComputeClusterRequest request) {
        Objects.requireNonNull(request.getCreateComputeClusterDetails(), "createComputeClusterDetails is required");
        return (CreateComputeClusterResponse)this.clientCall(request, CreateComputeClusterResponse::builder).logger(LOG, "createComputeCluster").serviceDetails("Compute", "CreateComputeCluster", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCluster/CreateComputeCluster").method(Method.POST).requestBuilder(CreateComputeClusterRequest::builder).basePath("/20160918").appendPathParam("computeClusters").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ComputeCluster.class, CreateComputeClusterResponse.Builder::computeCluster).handleResponseHeaderString("etag", CreateComputeClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateComputeClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateComputeGpuMemoryClusterResponse createComputeGpuMemoryCluster(CreateComputeGpuMemoryClusterRequest request) {
        Objects.requireNonNull(request.getCreateComputeGpuMemoryClusterDetails(), "createComputeGpuMemoryClusterDetails is required");
        return (CreateComputeGpuMemoryClusterResponse)this.clientCall(request, CreateComputeGpuMemoryClusterResponse::builder).logger(LOG, "createComputeGpuMemoryCluster").serviceDetails("Compute", "CreateComputeGpuMemoryCluster", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGpuMemoryCluster/CreateComputeGpuMemoryCluster").method(Method.POST).requestBuilder(CreateComputeGpuMemoryClusterRequest::builder).basePath("/20160918").appendPathParam("computeGpuMemoryClusters").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(ComputeGpuMemoryCluster.class, CreateComputeGpuMemoryClusterResponse.Builder::computeGpuMemoryCluster).handleResponseHeaderString("etag", CreateComputeGpuMemoryClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateComputeGpuMemoryClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateComputeGpuMemoryClusterResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateComputeImageCapabilitySchemaResponse createComputeImageCapabilitySchema(CreateComputeImageCapabilitySchemaRequest request) {
        Objects.requireNonNull(request.getCreateComputeImageCapabilitySchemaDetails(), "createComputeImageCapabilitySchemaDetails is required");
        return (CreateComputeImageCapabilitySchemaResponse)this.clientCall(request, CreateComputeImageCapabilitySchemaResponse::builder).logger(LOG, "createComputeImageCapabilitySchema").serviceDetails("Compute", "CreateComputeImageCapabilitySchema", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeImageCapabilitySchema/CreateComputeImageCapabilitySchema").method(Method.POST).requestBuilder(CreateComputeImageCapabilitySchemaRequest::builder).basePath("/20160918").appendPathParam("computeImageCapabilitySchemas").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(ComputeImageCapabilitySchema.class, CreateComputeImageCapabilitySchemaResponse.Builder::computeImageCapabilitySchema).handleResponseHeaderString("etag", CreateComputeImageCapabilitySchemaResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateComputeImageCapabilitySchemaResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDedicatedVmHostResponse createDedicatedVmHost(CreateDedicatedVmHostRequest request) {
        Objects.requireNonNull(request.getCreateDedicatedVmHostDetails(), "createDedicatedVmHostDetails is required");
        return (CreateDedicatedVmHostResponse)this.clientCall(request, CreateDedicatedVmHostResponse::builder).logger(LOG, "createDedicatedVmHost").serviceDetails("Compute", "CreateDedicatedVmHost", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHost/CreateDedicatedVmHost").method(Method.POST).requestBuilder(CreateDedicatedVmHostRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHosts").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DedicatedVmHost.class, CreateDedicatedVmHostResponse.Builder::dedicatedVmHost).handleResponseHeaderString("etag", CreateDedicatedVmHostResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDedicatedVmHostResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateDedicatedVmHostResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateImageResponse createImage(CreateImageRequest request) {
        Objects.requireNonNull(request.getCreateImageDetails(), "createImageDetails is required");
        return (CreateImageResponse)this.clientCall(request, CreateImageResponse::builder).logger(LOG, "createImage").serviceDetails("Compute", "CreateImage", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Image/CreateImage").method(Method.POST).requestBuilder(CreateImageRequest::builder).basePath("/20160918").appendPathParam("images").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(Image.class, CreateImageResponse.Builder::image).handleResponseHeaderString("etag", CreateImageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateImageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateImageResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateInstanceConsoleConnectionResponse createInstanceConsoleConnection(CreateInstanceConsoleConnectionRequest request) {
        Objects.requireNonNull(request.getCreateInstanceConsoleConnectionDetails(), "createInstanceConsoleConnectionDetails is required");
        return (CreateInstanceConsoleConnectionResponse)this.clientCall(request, CreateInstanceConsoleConnectionResponse::builder).logger(LOG, "createInstanceConsoleConnection").serviceDetails("Compute", "CreateInstanceConsoleConnection", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceConsoleConnection/CreateInstanceConsoleConnection").method(Method.POST).requestBuilder(CreateInstanceConsoleConnectionRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleConnections").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(InstanceConsoleConnection.class, CreateInstanceConsoleConnectionResponse.Builder::instanceConsoleConnection).handleResponseHeaderString("etag", CreateInstanceConsoleConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateInstanceConsoleConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteAppCatalogSubscriptionResponse deleteAppCatalogSubscription(DeleteAppCatalogSubscriptionRequest request) {
        Objects.requireNonNull(request.getListingId(), "listingId is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getResourceVersion(), "resourceVersion is required");
        return (DeleteAppCatalogSubscriptionResponse)this.clientCall(request, DeleteAppCatalogSubscriptionResponse::builder).logger(LOG, "deleteAppCatalogSubscription").serviceDetails("Compute", "DeleteAppCatalogSubscription", "").method(Method.DELETE).requestBuilder(DeleteAppCatalogSubscriptionRequest::builder).basePath("/20160918").appendPathParam("appCatalogSubscriptions").appendQueryParam("listingId", (Object)request.getListingId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceVersion", (Object)request.getResourceVersion()).accept(new String[]{"application/json"}).handleResponseHeaderString("opc-request-id", DeleteAppCatalogSubscriptionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteComputeCapacityReservationResponse deleteComputeCapacityReservation(DeleteComputeCapacityReservationRequest request) {
        Validate.notBlank((String)request.getCapacityReservationId(), (String)"capacityReservationId must not be blank", (Object[])new Object[0]);
        return (DeleteComputeCapacityReservationResponse)this.clientCall(request, DeleteComputeCapacityReservationResponse::builder).logger(LOG, "deleteComputeCapacityReservation").serviceDetails("Compute", "DeleteComputeCapacityReservation", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityReservation/DeleteComputeCapacityReservation").method(Method.DELETE).requestBuilder(DeleteComputeCapacityReservationRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReservations").appendPathParam(request.getCapacityReservationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteComputeCapacityReservationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteComputeCapacityReservationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteComputeCapacityTopologyResponse deleteComputeCapacityTopology(DeleteComputeCapacityTopologyRequest request) {
        Validate.notBlank((String)request.getComputeCapacityTopologyId(), (String)"computeCapacityTopologyId must not be blank", (Object[])new Object[0]);
        return (DeleteComputeCapacityTopologyResponse)this.clientCall(request, DeleteComputeCapacityTopologyResponse::builder).logger(LOG, "deleteComputeCapacityTopology").serviceDetails("Compute", "DeleteComputeCapacityTopology", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityTopology/DeleteComputeCapacityTopology").method(Method.DELETE).requestBuilder(DeleteComputeCapacityTopologyRequest::builder).basePath("/20160918").appendPathParam("computeCapacityTopologies").appendPathParam(request.getComputeCapacityTopologyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteComputeCapacityTopologyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteComputeCapacityTopologyResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteComputeClusterResponse deleteComputeCluster(DeleteComputeClusterRequest request) {
        Validate.notBlank((String)request.getComputeClusterId(), (String)"computeClusterId must not be blank", (Object[])new Object[0]);
        return (DeleteComputeClusterResponse)this.clientCall(request, DeleteComputeClusterResponse::builder).logger(LOG, "deleteComputeCluster").serviceDetails("Compute", "DeleteComputeCluster", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCluster/DeleteComputeCluster").method(Method.DELETE).requestBuilder(DeleteComputeClusterRequest::builder).basePath("/20160918").appendPathParam("computeClusters").appendPathParam(request.getComputeClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteComputeClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteComputeGpuMemoryClusterResponse deleteComputeGpuMemoryCluster(DeleteComputeGpuMemoryClusterRequest request) {
        Validate.notBlank((String)request.getComputeGpuMemoryClusterId(), (String)"computeGpuMemoryClusterId must not be blank", (Object[])new Object[0]);
        return (DeleteComputeGpuMemoryClusterResponse)this.clientCall(request, DeleteComputeGpuMemoryClusterResponse::builder).logger(LOG, "deleteComputeGpuMemoryCluster").serviceDetails("Compute", "DeleteComputeGpuMemoryCluster", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGpuMemoryCluster/DeleteComputeGpuMemoryCluster").method(Method.DELETE).requestBuilder(DeleteComputeGpuMemoryClusterRequest::builder).basePath("/20160918").appendPathParam("computeGpuMemoryClusters").appendPathParam(request.getComputeGpuMemoryClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteComputeGpuMemoryClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteComputeGpuMemoryClusterResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteComputeImageCapabilitySchemaResponse deleteComputeImageCapabilitySchema(DeleteComputeImageCapabilitySchemaRequest request) {
        Validate.notBlank((String)request.getComputeImageCapabilitySchemaId(), (String)"computeImageCapabilitySchemaId must not be blank", (Object[])new Object[0]);
        return (DeleteComputeImageCapabilitySchemaResponse)this.clientCall(request, DeleteComputeImageCapabilitySchemaResponse::builder).logger(LOG, "deleteComputeImageCapabilitySchema").serviceDetails("Compute", "DeleteComputeImageCapabilitySchema", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeImageCapabilitySchema/DeleteComputeImageCapabilitySchema").method(Method.DELETE).requestBuilder(DeleteComputeImageCapabilitySchemaRequest::builder).basePath("/20160918").appendPathParam("computeImageCapabilitySchemas").appendPathParam(request.getComputeImageCapabilitySchemaId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteComputeImageCapabilitySchemaResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteConsoleHistoryResponse deleteConsoleHistory(DeleteConsoleHistoryRequest request) {
        Validate.notBlank((String)request.getInstanceConsoleHistoryId(), (String)"instanceConsoleHistoryId must not be blank", (Object[])new Object[0]);
        return (DeleteConsoleHistoryResponse)this.clientCall(request, DeleteConsoleHistoryResponse::builder).logger(LOG, "deleteConsoleHistory").serviceDetails("Compute", "DeleteConsoleHistory", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ConsoleHistory/DeleteConsoleHistory").method(Method.DELETE).requestBuilder(DeleteConsoleHistoryRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleHistories").appendPathParam(request.getInstanceConsoleHistoryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteConsoleHistoryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDedicatedVmHostResponse deleteDedicatedVmHost(DeleteDedicatedVmHostRequest request) {
        Validate.notBlank((String)request.getDedicatedVmHostId(), (String)"dedicatedVmHostId must not be blank", (Object[])new Object[0]);
        return (DeleteDedicatedVmHostResponse)this.clientCall(request, DeleteDedicatedVmHostResponse::builder).logger(LOG, "deleteDedicatedVmHost").serviceDetails("Compute", "DeleteDedicatedVmHost", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHost/DeleteDedicatedVmHost").method(Method.DELETE).requestBuilder(DeleteDedicatedVmHostRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHosts").appendPathParam(request.getDedicatedVmHostId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDedicatedVmHostResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteDedicatedVmHostResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteImageResponse deleteImage(DeleteImageRequest request) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        return (DeleteImageResponse)this.clientCall(request, DeleteImageResponse::builder).logger(LOG, "deleteImage").serviceDetails("Compute", "DeleteImage", "").method(Method.DELETE).requestBuilder(DeleteImageRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteImageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteInstanceConsoleConnectionResponse deleteInstanceConsoleConnection(DeleteInstanceConsoleConnectionRequest request) {
        Validate.notBlank((String)request.getInstanceConsoleConnectionId(), (String)"instanceConsoleConnectionId must not be blank", (Object[])new Object[0]);
        return (DeleteInstanceConsoleConnectionResponse)this.clientCall(request, DeleteInstanceConsoleConnectionResponse::builder).logger(LOG, "deleteInstanceConsoleConnection").serviceDetails("Compute", "DeleteInstanceConsoleConnection", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceConsoleConnection/DeleteInstanceConsoleConnection").method(Method.DELETE).requestBuilder(DeleteInstanceConsoleConnectionRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleConnections").appendPathParam(request.getInstanceConsoleConnectionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteInstanceConsoleConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DetachBootVolumeResponse detachBootVolume(DetachBootVolumeRequest request) {
        Validate.notBlank((String)request.getBootVolumeAttachmentId(), (String)"bootVolumeAttachmentId must not be blank", (Object[])new Object[0]);
        return (DetachBootVolumeResponse)this.clientCall(request, DetachBootVolumeResponse::builder).logger(LOG, "detachBootVolume").serviceDetails("Compute", "DetachBootVolume", "").method(Method.DELETE).requestBuilder(DetachBootVolumeRequest::builder).basePath("/20160918").appendPathParam("bootVolumeAttachments").appendPathParam(request.getBootVolumeAttachmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DetachBootVolumeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DetachVnicResponse detachVnic(DetachVnicRequest request) {
        Validate.notBlank((String)request.getVnicAttachmentId(), (String)"vnicAttachmentId must not be blank", (Object[])new Object[0]);
        return (DetachVnicResponse)this.clientCall(request, DetachVnicResponse::builder).logger(LOG, "detachVnic").serviceDetails("Compute", "DetachVnic", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VnicAttachment/DetachVnic").method(Method.DELETE).requestBuilder(DetachVnicRequest::builder).basePath("/20160918").appendPathParam("vnicAttachments").appendPathParam(request.getVnicAttachmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DetachVnicResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DetachVolumeResponse detachVolume(DetachVolumeRequest request) {
        Validate.notBlank((String)request.getVolumeAttachmentId(), (String)"volumeAttachmentId must not be blank", (Object[])new Object[0]);
        return (DetachVolumeResponse)this.clientCall(request, DetachVolumeResponse::builder).logger(LOG, "detachVolume").serviceDetails("Compute", "DetachVolume", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeAttachment/DetachVolume").method(Method.DELETE).requestBuilder(DetachVolumeRequest::builder).basePath("/20160918").appendPathParam("volumeAttachments").appendPathParam(request.getVolumeAttachmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DetachVolumeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ExportImageResponse exportImage(ExportImageRequest request) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getExportImageDetails(), "exportImageDetails is required");
        return (ExportImageResponse)this.clientCall(request, ExportImageResponse::builder).logger(LOG, "exportImage").serviceDetails("Compute", "ExportImage", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Image/ExportImage").method(Method.POST).requestBuilder(ExportImageRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).appendPathParam("actions").appendPathParam("export").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(Image.class, ExportImageResponse.Builder::image).handleResponseHeaderString("etag", ExportImageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ExportImageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ExportImageResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetAppCatalogListingResponse getAppCatalogListing(GetAppCatalogListingRequest request) {
        Validate.notBlank((String)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        return (GetAppCatalogListingResponse)this.clientCall(request, GetAppCatalogListingResponse::builder).logger(LOG, "getAppCatalogListing").serviceDetails("Compute", "GetAppCatalogListing", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/AppCatalogListing/GetAppCatalogListing").method(Method.GET).requestBuilder(GetAppCatalogListingRequest::builder).basePath("/20160918").appendPathParam("appCatalogListings").appendPathParam(request.getListingId()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(AppCatalogListing.class, GetAppCatalogListingResponse.Builder::appCatalogListing).handleResponseHeaderString("etag", GetAppCatalogListingResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAppCatalogListingResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAppCatalogListingAgreementsResponse getAppCatalogListingAgreements(GetAppCatalogListingAgreementsRequest request) {
        Validate.notBlank((String)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getResourceVersion(), (String)"resourceVersion must not be blank", (Object[])new Object[0]);
        return (GetAppCatalogListingAgreementsResponse)this.clientCall(request, GetAppCatalogListingAgreementsResponse::builder).logger(LOG, "getAppCatalogListingAgreements").serviceDetails("Compute", "GetAppCatalogListingAgreements", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/AppCatalogListingResourceVersionAgreements/GetAppCatalogListingAgreements").method(Method.GET).requestBuilder(GetAppCatalogListingAgreementsRequest::builder).basePath("/20160918").appendPathParam("appCatalogListings").appendPathParam(request.getListingId()).appendPathParam("resourceVersions").appendPathParam(request.getResourceVersion()).appendPathParam("agreements").accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(AppCatalogListingResourceVersionAgreements.class, GetAppCatalogListingAgreementsResponse.Builder::appCatalogListingResourceVersionAgreements).handleResponseHeaderString("etag", GetAppCatalogListingAgreementsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAppCatalogListingAgreementsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAppCatalogListingResourceVersionResponse getAppCatalogListingResourceVersion(GetAppCatalogListingResourceVersionRequest request) {
        Validate.notBlank((String)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getResourceVersion(), (String)"resourceVersion must not be blank", (Object[])new Object[0]);
        return (GetAppCatalogListingResourceVersionResponse)this.clientCall(request, GetAppCatalogListingResourceVersionResponse::builder).logger(LOG, "getAppCatalogListingResourceVersion").serviceDetails("Compute", "GetAppCatalogListingResourceVersion", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/AppCatalogListingResourceVersion/GetAppCatalogListingResourceVersion").method(Method.GET).requestBuilder(GetAppCatalogListingResourceVersionRequest::builder).basePath("/20160918").appendPathParam("appCatalogListings").appendPathParam(request.getListingId()).appendPathParam("resourceVersions").appendPathParam(request.getResourceVersion()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(AppCatalogListingResourceVersion.class, GetAppCatalogListingResourceVersionResponse.Builder::appCatalogListingResourceVersion).handleResponseHeaderString("etag", GetAppCatalogListingResourceVersionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAppCatalogListingResourceVersionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetBootVolumeAttachmentResponse getBootVolumeAttachment(GetBootVolumeAttachmentRequest request) {
        Validate.notBlank((String)request.getBootVolumeAttachmentId(), (String)"bootVolumeAttachmentId must not be blank", (Object[])new Object[0]);
        return (GetBootVolumeAttachmentResponse)this.clientCall(request, GetBootVolumeAttachmentResponse::builder).logger(LOG, "getBootVolumeAttachment").serviceDetails("Compute", "GetBootVolumeAttachment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolumeAttachment/GetBootVolumeAttachment").method(Method.GET).requestBuilder(GetBootVolumeAttachmentRequest::builder).basePath("/20160918").appendPathParam("bootVolumeAttachments").appendPathParam(request.getBootVolumeAttachmentId()).accept(new String[]{"application/json"}).handleBody(BootVolumeAttachment.class, GetBootVolumeAttachmentResponse.Builder::bootVolumeAttachment).handleResponseHeaderString("etag", GetBootVolumeAttachmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBootVolumeAttachmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetComputeCapacityReservationResponse getComputeCapacityReservation(GetComputeCapacityReservationRequest request) {
        Validate.notBlank((String)request.getCapacityReservationId(), (String)"capacityReservationId must not be blank", (Object[])new Object[0]);
        return (GetComputeCapacityReservationResponse)this.clientCall(request, GetComputeCapacityReservationResponse::builder).logger(LOG, "getComputeCapacityReservation").serviceDetails("Compute", "GetComputeCapacityReservation", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityReservation/GetComputeCapacityReservation").method(Method.GET).requestBuilder(GetComputeCapacityReservationRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReservations").appendPathParam(request.getCapacityReservationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ComputeCapacityReservation.class, GetComputeCapacityReservationResponse.Builder::computeCapacityReservation).handleResponseHeaderString("etag", GetComputeCapacityReservationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetComputeCapacityReservationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetComputeCapacityTopologyResponse getComputeCapacityTopology(GetComputeCapacityTopologyRequest request) {
        Validate.notBlank((String)request.getComputeCapacityTopologyId(), (String)"computeCapacityTopologyId must not be blank", (Object[])new Object[0]);
        return (GetComputeCapacityTopologyResponse)this.clientCall(request, GetComputeCapacityTopologyResponse::builder).logger(LOG, "getComputeCapacityTopology").serviceDetails("Compute", "GetComputeCapacityTopology", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityTopology/GetComputeCapacityTopology").method(Method.GET).requestBuilder(GetComputeCapacityTopologyRequest::builder).basePath("/20160918").appendPathParam("computeCapacityTopologies").appendPathParam(request.getComputeCapacityTopologyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ComputeCapacityTopology.class, GetComputeCapacityTopologyResponse.Builder::computeCapacityTopology).handleResponseHeaderString("etag", GetComputeCapacityTopologyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetComputeCapacityTopologyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetComputeClusterResponse getComputeCluster(GetComputeClusterRequest request) {
        Validate.notBlank((String)request.getComputeClusterId(), (String)"computeClusterId must not be blank", (Object[])new Object[0]);
        return (GetComputeClusterResponse)this.clientCall(request, GetComputeClusterResponse::builder).logger(LOG, "getComputeCluster").serviceDetails("Compute", "GetComputeCluster", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCluster/GetComputeCluster").method(Method.GET).requestBuilder(GetComputeClusterRequest::builder).basePath("/20160918").appendPathParam("computeClusters").appendPathParam(request.getComputeClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ComputeCluster.class, GetComputeClusterResponse.Builder::computeCluster).handleResponseHeaderString("etag", GetComputeClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetComputeClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetComputeGlobalImageCapabilitySchemaResponse getComputeGlobalImageCapabilitySchema(GetComputeGlobalImageCapabilitySchemaRequest request) {
        Validate.notBlank((String)request.getComputeGlobalImageCapabilitySchemaId(), (String)"computeGlobalImageCapabilitySchemaId must not be blank", (Object[])new Object[0]);
        return (GetComputeGlobalImageCapabilitySchemaResponse)this.clientCall(request, GetComputeGlobalImageCapabilitySchemaResponse::builder).logger(LOG, "getComputeGlobalImageCapabilitySchema").serviceDetails("Compute", "GetComputeGlobalImageCapabilitySchema", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGlobalImageCapabilitySchema/GetComputeGlobalImageCapabilitySchema").method(Method.GET).requestBuilder(GetComputeGlobalImageCapabilitySchemaRequest::builder).basePath("/20160918").appendPathParam("computeGlobalImageCapabilitySchemas").appendPathParam(request.getComputeGlobalImageCapabilitySchemaId()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(ComputeGlobalImageCapabilitySchema.class, GetComputeGlobalImageCapabilitySchemaResponse.Builder::computeGlobalImageCapabilitySchema).handleResponseHeaderString("etag", GetComputeGlobalImageCapabilitySchemaResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetComputeGlobalImageCapabilitySchemaResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetComputeGlobalImageCapabilitySchemaVersionResponse getComputeGlobalImageCapabilitySchemaVersion(GetComputeGlobalImageCapabilitySchemaVersionRequest request) {
        Validate.notBlank((String)request.getComputeGlobalImageCapabilitySchemaId(), (String)"computeGlobalImageCapabilitySchemaId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getComputeGlobalImageCapabilitySchemaVersionName(), (String)"computeGlobalImageCapabilitySchemaVersionName must not be blank", (Object[])new Object[0]);
        return (GetComputeGlobalImageCapabilitySchemaVersionResponse)this.clientCall(request, GetComputeGlobalImageCapabilitySchemaVersionResponse::builder).logger(LOG, "getComputeGlobalImageCapabilitySchemaVersion").serviceDetails("Compute", "GetComputeGlobalImageCapabilitySchemaVersion", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGlobalImageCapabilitySchemaVersion/GetComputeGlobalImageCapabilitySchemaVersion").method(Method.GET).requestBuilder(GetComputeGlobalImageCapabilitySchemaVersionRequest::builder).basePath("/20160918").appendPathParam("computeGlobalImageCapabilitySchemas").appendPathParam(request.getComputeGlobalImageCapabilitySchemaId()).appendPathParam("versions").appendPathParam(request.getComputeGlobalImageCapabilitySchemaVersionName()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(ComputeGlobalImageCapabilitySchemaVersion.class, GetComputeGlobalImageCapabilitySchemaVersionResponse.Builder::computeGlobalImageCapabilitySchemaVersion).handleResponseHeaderString("etag", GetComputeGlobalImageCapabilitySchemaVersionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetComputeGlobalImageCapabilitySchemaVersionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetComputeGpuMemoryClusterResponse getComputeGpuMemoryCluster(GetComputeGpuMemoryClusterRequest request) {
        Validate.notBlank((String)request.getComputeGpuMemoryClusterId(), (String)"computeGpuMemoryClusterId must not be blank", (Object[])new Object[0]);
        return (GetComputeGpuMemoryClusterResponse)this.clientCall(request, GetComputeGpuMemoryClusterResponse::builder).logger(LOG, "getComputeGpuMemoryCluster").serviceDetails("Compute", "GetComputeGpuMemoryCluster", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGpuMemoryCluster/GetComputeGpuMemoryCluster").method(Method.GET).requestBuilder(GetComputeGpuMemoryClusterRequest::builder).basePath("/20160918").appendPathParam("computeGpuMemoryClusters").appendPathParam(request.getComputeGpuMemoryClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ComputeGpuMemoryCluster.class, GetComputeGpuMemoryClusterResponse.Builder::computeGpuMemoryCluster).handleResponseHeaderString("etag", GetComputeGpuMemoryClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetComputeGpuMemoryClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetComputeGpuMemoryFabricResponse getComputeGpuMemoryFabric(GetComputeGpuMemoryFabricRequest request) {
        Validate.notBlank((String)request.getComputeGpuMemoryFabricId(), (String)"computeGpuMemoryFabricId must not be blank", (Object[])new Object[0]);
        return (GetComputeGpuMemoryFabricResponse)this.clientCall(request, GetComputeGpuMemoryFabricResponse::builder).logger(LOG, "getComputeGpuMemoryFabric").serviceDetails("Compute", "GetComputeGpuMemoryFabric", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGpuMemoryFabric/GetComputeGpuMemoryFabric").method(Method.GET).requestBuilder(GetComputeGpuMemoryFabricRequest::builder).basePath("/20160918").appendPathParam("computeGpuMemoryFabrics").appendPathParam(request.getComputeGpuMemoryFabricId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ComputeGpuMemoryFabric.class, GetComputeGpuMemoryFabricResponse.Builder::computeGpuMemoryFabric).handleResponseHeaderString("etag", GetComputeGpuMemoryFabricResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetComputeGpuMemoryFabricResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetComputeHostResponse getComputeHost(GetComputeHostRequest request) {
        Validate.notBlank((String)request.getComputeHostId(), (String)"computeHostId must not be blank", (Object[])new Object[0]);
        return (GetComputeHostResponse)this.clientCall(request, GetComputeHostResponse::builder).logger(LOG, "getComputeHost").serviceDetails("Compute", "GetComputeHost", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeHost/GetComputeHost").method(Method.GET).requestBuilder(GetComputeHostRequest::builder).basePath("/20160918").appendPathParam("computeHosts").appendPathParam(request.getComputeHostId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ComputeHost.class, GetComputeHostResponse.Builder::computeHost).handleResponseHeaderString("etag", GetComputeHostResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetComputeHostResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetComputeImageCapabilitySchemaResponse getComputeImageCapabilitySchema(GetComputeImageCapabilitySchemaRequest request) {
        Validate.notBlank((String)request.getComputeImageCapabilitySchemaId(), (String)"computeImageCapabilitySchemaId must not be blank", (Object[])new Object[0]);
        return (GetComputeImageCapabilitySchemaResponse)this.clientCall(request, GetComputeImageCapabilitySchemaResponse::builder).logger(LOG, "getComputeImageCapabilitySchema").serviceDetails("Compute", "GetComputeImageCapabilitySchema", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeImageCapabilitySchema/GetComputeImageCapabilitySchema").method(Method.GET).requestBuilder(GetComputeImageCapabilitySchemaRequest::builder).basePath("/20160918").appendPathParam("computeImageCapabilitySchemas").appendPathParam(request.getComputeImageCapabilitySchemaId()).appendQueryParam("isMergeEnabled", (Object)request.getIsMergeEnabled()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(ComputeImageCapabilitySchema.class, GetComputeImageCapabilitySchemaResponse.Builder::computeImageCapabilitySchema).handleResponseHeaderString("etag", GetComputeImageCapabilitySchemaResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetComputeImageCapabilitySchemaResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetConsoleHistoryResponse getConsoleHistory(GetConsoleHistoryRequest request) {
        Validate.notBlank((String)request.getInstanceConsoleHistoryId(), (String)"instanceConsoleHistoryId must not be blank", (Object[])new Object[0]);
        return (GetConsoleHistoryResponse)this.clientCall(request, GetConsoleHistoryResponse::builder).logger(LOG, "getConsoleHistory").serviceDetails("Compute", "GetConsoleHistory", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ConsoleHistory/GetConsoleHistory").method(Method.GET).requestBuilder(GetConsoleHistoryRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleHistories").appendPathParam(request.getInstanceConsoleHistoryId()).accept(new String[]{"application/json"}).handleBody(ConsoleHistory.class, GetConsoleHistoryResponse.Builder::consoleHistory).handleResponseHeaderString("etag", GetConsoleHistoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConsoleHistoryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetConsoleHistoryContentResponse getConsoleHistoryContent(GetConsoleHistoryContentRequest request) {
        Validate.notBlank((String)request.getInstanceConsoleHistoryId(), (String)"instanceConsoleHistoryId must not be blank", (Object[])new Object[0]);
        return (GetConsoleHistoryContentResponse)this.clientCall(request, GetConsoleHistoryContentResponse::builder).logger(LOG, "getConsoleHistoryContent").serviceDetails("Compute", "GetConsoleHistoryContent", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ConsoleHistory/GetConsoleHistoryContent").method(Method.GET).requestBuilder(GetConsoleHistoryContentRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleHistories").appendPathParam(request.getInstanceConsoleHistoryId()).appendPathParam("data").appendQueryParam("offset", (Object)request.getOffset()).appendQueryParam("length", (Object)request.getLength()).accept(new String[]{"application/json"}).handleBody(String.class, GetConsoleHistoryContentResponse.Builder::value).handleResponseHeaderInteger("opc-bytes-remaining", GetConsoleHistoryContentResponse.Builder::opcBytesRemaining).handleResponseHeaderString("opc-request-id", GetConsoleHistoryContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDedicatedVmHostResponse getDedicatedVmHost(GetDedicatedVmHostRequest request) {
        Validate.notBlank((String)request.getDedicatedVmHostId(), (String)"dedicatedVmHostId must not be blank", (Object[])new Object[0]);
        return (GetDedicatedVmHostResponse)this.clientCall(request, GetDedicatedVmHostResponse::builder).logger(LOG, "getDedicatedVmHost").serviceDetails("Compute", "GetDedicatedVmHost", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHost/GetDedicatedVmHost").method(Method.GET).requestBuilder(GetDedicatedVmHostRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHosts").appendPathParam(request.getDedicatedVmHostId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DedicatedVmHost.class, GetDedicatedVmHostResponse.Builder::dedicatedVmHost).handleResponseHeaderString("etag", GetDedicatedVmHostResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDedicatedVmHostResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetImageResponse getImage(GetImageRequest request) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        return (GetImageResponse)this.clientCall(request, GetImageResponse::builder).logger(LOG, "getImage").serviceDetails("Compute", "GetImage", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Image/GetImage").method(Method.GET).requestBuilder(GetImageRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBody(Image.class, GetImageResponse.Builder::image).handleResponseHeaderString("etag", GetImageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetImageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetImageShapeCompatibilityEntryResponse getImageShapeCompatibilityEntry(GetImageShapeCompatibilityEntryRequest request) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getShapeName(), (String)"shapeName must not be blank", (Object[])new Object[0]);
        return (GetImageShapeCompatibilityEntryResponse)this.clientCall(request, GetImageShapeCompatibilityEntryResponse::builder).logger(LOG, "getImageShapeCompatibilityEntry").serviceDetails("Compute", "GetImageShapeCompatibilityEntry", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ImageShapeCompatibilityEntry/GetImageShapeCompatibilityEntry").method(Method.GET).requestBuilder(GetImageShapeCompatibilityEntryRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).appendPathParam("shapes").appendPathParam(request.getShapeName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ImageShapeCompatibilityEntry.class, GetImageShapeCompatibilityEntryResponse.Builder::imageShapeCompatibilityEntry).handleResponseHeaderString("opc-request-id", GetImageShapeCompatibilityEntryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetInstanceResponse getInstance(GetInstanceRequest request) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        return (GetInstanceResponse)this.clientCall(request, GetInstanceResponse::builder).logger(LOG, "getInstance").serviceDetails("Compute", "GetInstance", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Instance/GetInstance").method(Method.GET).requestBuilder(GetInstanceRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).accept(new String[]{"application/json"}).handleBody(Instance.class, GetInstanceResponse.Builder::instance).handleResponseHeaderString("etag", GetInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetInstanceConsoleConnectionResponse getInstanceConsoleConnection(GetInstanceConsoleConnectionRequest request) {
        Validate.notBlank((String)request.getInstanceConsoleConnectionId(), (String)"instanceConsoleConnectionId must not be blank", (Object[])new Object[0]);
        return (GetInstanceConsoleConnectionResponse)this.clientCall(request, GetInstanceConsoleConnectionResponse::builder).logger(LOG, "getInstanceConsoleConnection").serviceDetails("Compute", "GetInstanceConsoleConnection", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceConsoleConnection/GetInstanceConsoleConnection").method(Method.GET).requestBuilder(GetInstanceConsoleConnectionRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleConnections").appendPathParam(request.getInstanceConsoleConnectionId()).accept(new String[]{"application/json"}).handleBody(InstanceConsoleConnection.class, GetInstanceConsoleConnectionResponse.Builder::instanceConsoleConnection).handleResponseHeaderString("opc-request-id", GetInstanceConsoleConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetInstanceMaintenanceEventResponse getInstanceMaintenanceEvent(GetInstanceMaintenanceEventRequest request) {
        Validate.notBlank((String)request.getInstanceMaintenanceEventId(), (String)"instanceMaintenanceEventId must not be blank", (Object[])new Object[0]);
        return (GetInstanceMaintenanceEventResponse)this.clientCall(request, GetInstanceMaintenanceEventResponse::builder).logger(LOG, "getInstanceMaintenanceEvent").serviceDetails("Compute", "GetInstanceMaintenanceEvent", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceMaintenanceEvent/GetInstanceMaintenanceEvent").method(Method.GET).requestBuilder(GetInstanceMaintenanceEventRequest::builder).basePath("/20160918").appendPathParam("instanceMaintenanceEvents").appendPathParam(request.getInstanceMaintenanceEventId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InstanceMaintenanceEvent.class, GetInstanceMaintenanceEventResponse.Builder::instanceMaintenanceEvent).handleResponseHeaderString("etag", GetInstanceMaintenanceEventResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetInstanceMaintenanceEventResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetInstanceMaintenanceRebootResponse getInstanceMaintenanceReboot(GetInstanceMaintenanceRebootRequest request) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        return (GetInstanceMaintenanceRebootResponse)this.clientCall(request, GetInstanceMaintenanceRebootResponse::builder).logger(LOG, "getInstanceMaintenanceReboot").serviceDetails("Compute", "GetInstanceMaintenanceReboot", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceMaintenanceReboot/GetInstanceMaintenanceReboot").method(Method.GET).requestBuilder(GetInstanceMaintenanceRebootRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).appendPathParam("maintenanceReboot").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InstanceMaintenanceReboot.class, GetInstanceMaintenanceRebootResponse.Builder::instanceMaintenanceReboot).handleResponseHeaderString("opc-request-id", GetInstanceMaintenanceRebootResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetMeasuredBootReportResponse getMeasuredBootReport(GetMeasuredBootReportRequest request) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        return (GetMeasuredBootReportResponse)this.clientCall(request, GetMeasuredBootReportResponse::builder).logger(LOG, "getMeasuredBootReport").serviceDetails("Compute", "GetMeasuredBootReport", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/MeasuredBootReport/GetMeasuredBootReport").method(Method.GET).requestBuilder(GetMeasuredBootReportRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).appendPathParam("measuredBootReport").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MeasuredBootReport.class, GetMeasuredBootReportResponse.Builder::measuredBootReport).handleResponseHeaderString("etag", GetMeasuredBootReportResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMeasuredBootReportResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVnicAttachmentResponse getVnicAttachment(GetVnicAttachmentRequest request) {
        Validate.notBlank((String)request.getVnicAttachmentId(), (String)"vnicAttachmentId must not be blank", (Object[])new Object[0]);
        return (GetVnicAttachmentResponse)this.clientCall(request, GetVnicAttachmentResponse::builder).logger(LOG, "getVnicAttachment").serviceDetails("Compute", "GetVnicAttachment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VnicAttachment/GetVnicAttachment").method(Method.GET).requestBuilder(GetVnicAttachmentRequest::builder).basePath("/20160918").appendPathParam("vnicAttachments").appendPathParam(request.getVnicAttachmentId()).accept(new String[]{"application/json"}).handleBody(VnicAttachment.class, GetVnicAttachmentResponse.Builder::vnicAttachment).handleResponseHeaderString("etag", GetVnicAttachmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVnicAttachmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVolumeAttachmentResponse getVolumeAttachment(GetVolumeAttachmentRequest request) {
        Validate.notBlank((String)request.getVolumeAttachmentId(), (String)"volumeAttachmentId must not be blank", (Object[])new Object[0]);
        return (GetVolumeAttachmentResponse)this.clientCall(request, GetVolumeAttachmentResponse::builder).logger(LOG, "getVolumeAttachment").serviceDetails("Compute", "GetVolumeAttachment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeAttachment/GetVolumeAttachment").method(Method.GET).requestBuilder(GetVolumeAttachmentRequest::builder).basePath("/20160918").appendPathParam("volumeAttachments").appendPathParam(request.getVolumeAttachmentId()).accept(new String[]{"application/json"}).handleBody(VolumeAttachment.class, GetVolumeAttachmentResponse.Builder::volumeAttachment).handleResponseHeaderString("etag", GetVolumeAttachmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVolumeAttachmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWindowsInstanceInitialCredentialsResponse getWindowsInstanceInitialCredentials(GetWindowsInstanceInitialCredentialsRequest request) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        return (GetWindowsInstanceInitialCredentialsResponse)this.clientCall(request, GetWindowsInstanceInitialCredentialsResponse::builder).logger(LOG, "getWindowsInstanceInitialCredentials").serviceDetails("Compute", "GetWindowsInstanceInitialCredentials", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceCredentials/GetWindowsInstanceInitialCredentials").method(Method.GET).requestBuilder(GetWindowsInstanceInitialCredentialsRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).appendPathParam("initialCredentials").accept(new String[]{"application/json"}).handleBody(InstanceCredentials.class, GetWindowsInstanceInitialCredentialsResponse.Builder::instanceCredentials).handleResponseHeaderString("opc-request-id", GetWindowsInstanceInitialCredentialsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public InstanceActionResponse instanceAction(InstanceActionRequest request) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAction(), "action is required");
        return (InstanceActionResponse)this.clientCall(request, InstanceActionResponse::builder).logger(LOG, "instanceAction").serviceDetails("Compute", "InstanceAction", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Instance/InstanceAction").method(Method.POST).requestBuilder(InstanceActionRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).appendQueryParam("action", (Object)request.getAction()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Instance.class, InstanceActionResponse.Builder::instance).handleResponseHeaderString("etag", InstanceActionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", InstanceActionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public LaunchInstanceResponse launchInstance(LaunchInstanceRequest request) {
        Objects.requireNonNull(request.getLaunchInstanceDetails(), "launchInstanceDetails is required");
        return (LaunchInstanceResponse)this.clientCall(request, LaunchInstanceResponse::builder).logger(LOG, "launchInstance").serviceDetails("Compute", "LaunchInstance", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Instance/LaunchInstance").method(Method.POST).requestBuilder(LaunchInstanceRequest::builder).basePath("/20160918").appendPathParam("instances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Instance.class, LaunchInstanceResponse.Builder::instance).handleResponseHeaderString("etag", LaunchInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", LaunchInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", LaunchInstanceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ListAppCatalogListingResourceVersionsResponse listAppCatalogListingResourceVersions(ListAppCatalogListingResourceVersionsRequest request) {
        Validate.notBlank((String)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        return (ListAppCatalogListingResourceVersionsResponse)this.clientCall(request, ListAppCatalogListingResourceVersionsResponse::builder).logger(LOG, "listAppCatalogListingResourceVersions").serviceDetails("Compute", "ListAppCatalogListingResourceVersions", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/AppCatalogListingResourceVersionSummary/ListAppCatalogListingResourceVersions").method(Method.GET).requestBuilder(ListAppCatalogListingResourceVersionsRequest::builder).basePath("/20160918").appendPathParam("appCatalogListings").appendPathParam(request.getListingId()).appendPathParam("resourceVersions").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(AppCatalogListingResourceVersionSummary.class, ListAppCatalogListingResourceVersionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAppCatalogListingResourceVersionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAppCatalogListingResourceVersionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListAppCatalogListingsResponse listAppCatalogListings(ListAppCatalogListingsRequest request) {
        return (ListAppCatalogListingsResponse)this.clientCall(request, ListAppCatalogListingsResponse::builder).logger(LOG, "listAppCatalogListings").serviceDetails("Compute", "ListAppCatalogListings", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/AppCatalogListingSummary/ListAppCatalogListings").method(Method.GET).requestBuilder(ListAppCatalogListingsRequest::builder).basePath("/20160918").appendPathParam("appCatalogListings").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("publisherName", (Object)request.getPublisherName()).appendQueryParam("publisherType", (Object)request.getPublisherType()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(AppCatalogListingSummary.class, ListAppCatalogListingsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAppCatalogListingsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAppCatalogListingsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListAppCatalogSubscriptionsResponse listAppCatalogSubscriptions(ListAppCatalogSubscriptionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAppCatalogSubscriptionsResponse)this.clientCall(request, ListAppCatalogSubscriptionsResponse::builder).logger(LOG, "listAppCatalogSubscriptions").serviceDetails("Compute", "ListAppCatalogSubscriptions", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/AppCatalogSubscriptionSummary/ListAppCatalogSubscriptions").method(Method.GET).requestBuilder(ListAppCatalogSubscriptionsRequest::builder).basePath("/20160918").appendPathParam("appCatalogSubscriptions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("listingId", (Object)request.getListingId()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(AppCatalogSubscriptionSummary.class, ListAppCatalogSubscriptionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAppCatalogSubscriptionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAppCatalogSubscriptionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListBootVolumeAttachmentsResponse listBootVolumeAttachments(ListBootVolumeAttachmentsRequest request) {
        Objects.requireNonNull(request.getAvailabilityDomain(), "availabilityDomain is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListBootVolumeAttachmentsResponse)this.clientCall(request, ListBootVolumeAttachmentsResponse::builder).logger(LOG, "listBootVolumeAttachments").serviceDetails("Compute", "ListBootVolumeAttachments", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolumeAttachment/ListBootVolumeAttachments").method(Method.GET).requestBuilder(ListBootVolumeAttachmentsRequest::builder).basePath("/20160918").appendPathParam("bootVolumeAttachments").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("instanceId", (Object)request.getInstanceId()).appendQueryParam("bootVolumeId", (Object)request.getBootVolumeId()).accept(new String[]{"application/json, application/x-json-stream"}).handleBodyList(BootVolumeAttachment.class, ListBootVolumeAttachmentsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListBootVolumeAttachmentsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListBootVolumeAttachmentsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListComputeCapacityReservationInstanceShapesResponse listComputeCapacityReservationInstanceShapes(ListComputeCapacityReservationInstanceShapesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListComputeCapacityReservationInstanceShapesResponse)this.clientCall(request, ListComputeCapacityReservationInstanceShapesResponse::builder).logger(LOG, "listComputeCapacityReservationInstanceShapes").serviceDetails("Compute", "ListComputeCapacityReservationInstanceShapes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityReservationInstanceShapeSummary/ListComputeCapacityReservationInstanceShapes").method(Method.GET).requestBuilder(ListComputeCapacityReservationInstanceShapesRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReservationInstanceShapes").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ComputeCapacityReservationInstanceShapeSummary.class, ListComputeCapacityReservationInstanceShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListComputeCapacityReservationInstanceShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeCapacityReservationInstanceShapesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListComputeCapacityReservationInstancesResponse listComputeCapacityReservationInstances(ListComputeCapacityReservationInstancesRequest request) {
        Validate.notBlank((String)request.getCapacityReservationId(), (String)"capacityReservationId must not be blank", (Object[])new Object[0]);
        return (ListComputeCapacityReservationInstancesResponse)this.clientCall(request, ListComputeCapacityReservationInstancesResponse::builder).logger(LOG, "listComputeCapacityReservationInstances").serviceDetails("Compute", "ListComputeCapacityReservationInstances", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CapacityReservationInstanceSummary/ListComputeCapacityReservationInstances").method(Method.GET).requestBuilder(ListComputeCapacityReservationInstancesRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReservations").appendPathParam(request.getCapacityReservationId()).appendPathParam("instances").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json, application/x-json-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(CapacityReservationInstanceSummary.class, ListComputeCapacityReservationInstancesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListComputeCapacityReservationInstancesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeCapacityReservationInstancesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListComputeCapacityReservationsResponse listComputeCapacityReservations(ListComputeCapacityReservationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListComputeCapacityReservationsResponse)this.clientCall(request, ListComputeCapacityReservationsResponse::builder).logger(LOG, "listComputeCapacityReservations").serviceDetails("Compute", "ListComputeCapacityReservations", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityReservation/ListComputeCapacityReservations").method(Method.GET).requestBuilder(ListComputeCapacityReservationsRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReservations").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json, application/x-json-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ComputeCapacityReservationSummary.class, ListComputeCapacityReservationsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListComputeCapacityReservationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeCapacityReservationsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListComputeCapacityTopologiesResponse listComputeCapacityTopologies(ListComputeCapacityTopologiesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListComputeCapacityTopologiesResponse)this.clientCall(request, ListComputeCapacityTopologiesResponse::builder).logger(LOG, "listComputeCapacityTopologies").serviceDetails("Compute", "ListComputeCapacityTopologies", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityTopology/ListComputeCapacityTopologies").method(Method.GET).requestBuilder(ListComputeCapacityTopologiesRequest::builder).basePath("/20160918").appendPathParam("computeCapacityTopologies").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ComputeCapacityTopologyCollection.class, ListComputeCapacityTopologiesResponse.Builder::computeCapacityTopologyCollection).handleResponseHeaderString("opc-next-page", ListComputeCapacityTopologiesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeCapacityTopologiesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListComputeCapacityTopologyComputeBareMetalHostsResponse listComputeCapacityTopologyComputeBareMetalHosts(ListComputeCapacityTopologyComputeBareMetalHostsRequest request) {
        Validate.notBlank((String)request.getComputeCapacityTopologyId(), (String)"computeCapacityTopologyId must not be blank", (Object[])new Object[0]);
        return (ListComputeCapacityTopologyComputeBareMetalHostsResponse)this.clientCall(request, ListComputeCapacityTopologyComputeBareMetalHostsResponse::builder).logger(LOG, "listComputeCapacityTopologyComputeBareMetalHosts").serviceDetails("Compute", "ListComputeCapacityTopologyComputeBareMetalHosts", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeBareMetalHost/ListComputeCapacityTopologyComputeBareMetalHosts").method(Method.GET).requestBuilder(ListComputeCapacityTopologyComputeBareMetalHostsRequest::builder).basePath("/20160918").appendPathParam("computeCapacityTopologies").appendPathParam(request.getComputeCapacityTopologyId()).appendPathParam("computeBareMetalHosts").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("computeHpcIslandId", (Object)request.getComputeHpcIslandId()).appendQueryParam("computeNetworkBlockId", (Object)request.getComputeNetworkBlockId()).appendQueryParam("computeLocalBlockId", (Object)request.getComputeLocalBlockId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ComputeBareMetalHostCollection.class, ListComputeCapacityTopologyComputeBareMetalHostsResponse.Builder::computeBareMetalHostCollection).handleResponseHeaderString("opc-next-page", ListComputeCapacityTopologyComputeBareMetalHostsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeCapacityTopologyComputeBareMetalHostsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListComputeCapacityTopologyComputeHpcIslandsResponse listComputeCapacityTopologyComputeHpcIslands(ListComputeCapacityTopologyComputeHpcIslandsRequest request) {
        Validate.notBlank((String)request.getComputeCapacityTopologyId(), (String)"computeCapacityTopologyId must not be blank", (Object[])new Object[0]);
        return (ListComputeCapacityTopologyComputeHpcIslandsResponse)this.clientCall(request, ListComputeCapacityTopologyComputeHpcIslandsResponse::builder).logger(LOG, "listComputeCapacityTopologyComputeHpcIslands").serviceDetails("Compute", "ListComputeCapacityTopologyComputeHpcIslands", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeHpcIsland/ListComputeCapacityTopologyComputeHpcIslands").method(Method.GET).requestBuilder(ListComputeCapacityTopologyComputeHpcIslandsRequest::builder).basePath("/20160918").appendPathParam("computeCapacityTopologies").appendPathParam(request.getComputeCapacityTopologyId()).appendPathParam("computeHpcIslands").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ComputeHpcIslandCollection.class, ListComputeCapacityTopologyComputeHpcIslandsResponse.Builder::computeHpcIslandCollection).handleResponseHeaderString("opc-next-page", ListComputeCapacityTopologyComputeHpcIslandsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeCapacityTopologyComputeHpcIslandsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListComputeCapacityTopologyComputeNetworkBlocksResponse listComputeCapacityTopologyComputeNetworkBlocks(ListComputeCapacityTopologyComputeNetworkBlocksRequest request) {
        Validate.notBlank((String)request.getComputeCapacityTopologyId(), (String)"computeCapacityTopologyId must not be blank", (Object[])new Object[0]);
        return (ListComputeCapacityTopologyComputeNetworkBlocksResponse)this.clientCall(request, ListComputeCapacityTopologyComputeNetworkBlocksResponse::builder).logger(LOG, "listComputeCapacityTopologyComputeNetworkBlocks").serviceDetails("Compute", "ListComputeCapacityTopologyComputeNetworkBlocks", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeNetworkBlock/ListComputeCapacityTopologyComputeNetworkBlocks").method(Method.GET).requestBuilder(ListComputeCapacityTopologyComputeNetworkBlocksRequest::builder).basePath("/20160918").appendPathParam("computeCapacityTopologies").appendPathParam(request.getComputeCapacityTopologyId()).appendPathParam("computeNetworkBlocks").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("computeHpcIslandId", (Object)request.getComputeHpcIslandId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ComputeNetworkBlockCollection.class, ListComputeCapacityTopologyComputeNetworkBlocksResponse.Builder::computeNetworkBlockCollection).handleResponseHeaderString("opc-next-page", ListComputeCapacityTopologyComputeNetworkBlocksResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeCapacityTopologyComputeNetworkBlocksResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListComputeClustersResponse listComputeClusters(ListComputeClustersRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListComputeClustersResponse)this.clientCall(request, ListComputeClustersResponse::builder).logger(LOG, "listComputeClusters").serviceDetails("Compute", "ListComputeClusters", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCluster/ListComputeClusters").method(Method.GET).requestBuilder(ListComputeClustersRequest::builder).basePath("/20160918").appendPathParam("computeClusters").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ComputeClusterCollection.class, ListComputeClustersResponse.Builder::computeClusterCollection).handleResponseHeaderString("opc-next-page", ListComputeClustersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeClustersResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListComputeGlobalImageCapabilitySchemaVersionsResponse listComputeGlobalImageCapabilitySchemaVersions(ListComputeGlobalImageCapabilitySchemaVersionsRequest request) {
        Validate.notBlank((String)request.getComputeGlobalImageCapabilitySchemaId(), (String)"computeGlobalImageCapabilitySchemaId must not be blank", (Object[])new Object[0]);
        return (ListComputeGlobalImageCapabilitySchemaVersionsResponse)this.clientCall(request, ListComputeGlobalImageCapabilitySchemaVersionsResponse::builder).logger(LOG, "listComputeGlobalImageCapabilitySchemaVersions").serviceDetails("Compute", "ListComputeGlobalImageCapabilitySchemaVersions", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGlobalImageCapabilitySchemaVersionSummary/ListComputeGlobalImageCapabilitySchemaVersions").method(Method.GET).requestBuilder(ListComputeGlobalImageCapabilitySchemaVersionsRequest::builder).basePath("/20160918").appendPathParam("computeGlobalImageCapabilitySchemas").appendPathParam(request.getComputeGlobalImageCapabilitySchemaId()).appendPathParam("versions").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(ComputeGlobalImageCapabilitySchemaVersionSummary.class, ListComputeGlobalImageCapabilitySchemaVersionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListComputeGlobalImageCapabilitySchemaVersionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeGlobalImageCapabilitySchemaVersionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListComputeGlobalImageCapabilitySchemasResponse listComputeGlobalImageCapabilitySchemas(ListComputeGlobalImageCapabilitySchemasRequest request) {
        return (ListComputeGlobalImageCapabilitySchemasResponse)this.clientCall(request, ListComputeGlobalImageCapabilitySchemasResponse::builder).logger(LOG, "listComputeGlobalImageCapabilitySchemas").serviceDetails("Compute", "ListComputeGlobalImageCapabilitySchemas", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGlobalImageCapabilitySchemaSummary/ListComputeGlobalImageCapabilitySchemas").method(Method.GET).requestBuilder(ListComputeGlobalImageCapabilitySchemasRequest::builder).basePath("/20160918").appendPathParam("computeGlobalImageCapabilitySchemas").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(ComputeGlobalImageCapabilitySchemaSummary.class, ListComputeGlobalImageCapabilitySchemasResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListComputeGlobalImageCapabilitySchemasResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeGlobalImageCapabilitySchemasResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListComputeGpuMemoryClusterInstancesResponse listComputeGpuMemoryClusterInstances(ListComputeGpuMemoryClusterInstancesRequest request) {
        Validate.notBlank((String)request.getComputeGpuMemoryClusterId(), (String)"computeGpuMemoryClusterId must not be blank", (Object[])new Object[0]);
        return (ListComputeGpuMemoryClusterInstancesResponse)this.clientCall(request, ListComputeGpuMemoryClusterInstancesResponse::builder).logger(LOG, "listComputeGpuMemoryClusterInstances").serviceDetails("Compute", "ListComputeGpuMemoryClusterInstances", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGpuMemoryClusterInstanceSummary/ListComputeGpuMemoryClusterInstances").method(Method.GET).requestBuilder(ListComputeGpuMemoryClusterInstancesRequest::builder).basePath("/20160918").appendPathParam("computeGpuMemoryClusters").appendPathParam(request.getComputeGpuMemoryClusterId()).appendPathParam("instances").appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json, application/x-json-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ComputeGpuMemoryClusterInstanceCollection.class, ListComputeGpuMemoryClusterInstancesResponse.Builder::computeGpuMemoryClusterInstanceCollection).handleResponseHeaderString("etag", ListComputeGpuMemoryClusterInstancesResponse.Builder::etag).handleResponseHeaderString("opc-next-page", ListComputeGpuMemoryClusterInstancesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeGpuMemoryClusterInstancesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListComputeGpuMemoryClustersResponse listComputeGpuMemoryClusters(ListComputeGpuMemoryClustersRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListComputeGpuMemoryClustersResponse)this.clientCall(request, ListComputeGpuMemoryClustersResponse::builder).logger(LOG, "listComputeGpuMemoryClusters").serviceDetails("Compute", "ListComputeGpuMemoryClusters", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGpuMemoryClusterCollection/ListComputeGpuMemoryClusters").method(Method.GET).requestBuilder(ListComputeGpuMemoryClustersRequest::builder).basePath("/20160918").appendPathParam("computeGpuMemoryClusters").appendQueryParam("computeGpuMemoryClusterId", (Object)request.getComputeGpuMemoryClusterId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("computeClusterId", (Object)request.getComputeClusterId()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json, application/x-json-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ComputeGpuMemoryClusterCollection.class, ListComputeGpuMemoryClustersResponse.Builder::computeGpuMemoryClusterCollection).handleResponseHeaderString("etag", ListComputeGpuMemoryClustersResponse.Builder::etag).handleResponseHeaderString("opc-next-page", ListComputeGpuMemoryClustersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeGpuMemoryClustersResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListComputeGpuMemoryFabricsResponse listComputeGpuMemoryFabrics(ListComputeGpuMemoryFabricsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListComputeGpuMemoryFabricsResponse)this.clientCall(request, ListComputeGpuMemoryFabricsResponse::builder).logger(LOG, "listComputeGpuMemoryFabrics").serviceDetails("Compute", "ListComputeGpuMemoryFabrics", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGpuMemoryFabric/ListComputeGpuMemoryFabrics").method(Method.GET).requestBuilder(ListComputeGpuMemoryFabricsRequest::builder).basePath("/20160918").appendPathParam("computeGpuMemoryFabrics").appendQueryParam("computeGpuMemoryFabricId", (Object)request.getComputeGpuMemoryFabricId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("computeHpcIslandId", (Object)request.getComputeHpcIslandId()).appendQueryParam("computeNetworkBlockId", (Object)request.getComputeNetworkBlockId()).appendEnumQueryParam("computeGpuMemoryFabricLifecycleState", (BmcEnum)request.getComputeGpuMemoryFabricLifecycleState()).appendEnumQueryParam("computeGpuMemoryFabricHealth", (BmcEnum)request.getComputeGpuMemoryFabricHealth()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json, application/x-json-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ComputeGpuMemoryFabricCollection.class, ListComputeGpuMemoryFabricsResponse.Builder::computeGpuMemoryFabricCollection).handleResponseHeaderString("opc-next-page", ListComputeGpuMemoryFabricsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeGpuMemoryFabricsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListComputeHostsResponse listComputeHosts(ListComputeHostsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListComputeHostsResponse)this.clientCall(request, ListComputeHostsResponse::builder).logger(LOG, "listComputeHosts").serviceDetails("Compute", "ListComputeHosts", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeHost/ListComputeHosts").method(Method.GET).requestBuilder(ListComputeHostsRequest::builder).basePath("/20160918").appendPathParam("computeHosts").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("networkResourceId", (Object)request.getNetworkResourceId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("computeHostLifecycleState", (Object)request.getComputeHostLifecycleState()).appendQueryParam("computeHostHealth", (Object)request.getComputeHostHealth()).accept(new String[]{"application/json, application/x-json-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ComputeHostCollection.class, ListComputeHostsResponse.Builder::computeHostCollection).handleResponseHeaderString("opc-next-page", ListComputeHostsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeHostsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListComputeImageCapabilitySchemasResponse listComputeImageCapabilitySchemas(ListComputeImageCapabilitySchemasRequest request) {
        return (ListComputeImageCapabilitySchemasResponse)this.clientCall(request, ListComputeImageCapabilitySchemasResponse::builder).logger(LOG, "listComputeImageCapabilitySchemas").serviceDetails("Compute", "ListComputeImageCapabilitySchemas", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeImageCapabilitySchemaSummary/ListComputeImageCapabilitySchemas").method(Method.GET).requestBuilder(ListComputeImageCapabilitySchemasRequest::builder).basePath("/20160918").appendPathParam("computeImageCapabilitySchemas").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("imageId", (Object)request.getImageId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(ComputeImageCapabilitySchemaSummary.class, ListComputeImageCapabilitySchemasResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListComputeImageCapabilitySchemasResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeImageCapabilitySchemasResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListConsoleHistoriesResponse listConsoleHistories(ListConsoleHistoriesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListConsoleHistoriesResponse)this.clientCall(request, ListConsoleHistoriesResponse::builder).logger(LOG, "listConsoleHistories").serviceDetails("Compute", "ListConsoleHistories", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ConsoleHistory/ListConsoleHistories").method(Method.GET).requestBuilder(ListConsoleHistoriesRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleHistories").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("instanceId", (Object)request.getInstanceId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(ConsoleHistory.class, ListConsoleHistoriesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListConsoleHistoriesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListConsoleHistoriesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDedicatedVmHostInstanceShapesResponse listDedicatedVmHostInstanceShapes(ListDedicatedVmHostInstanceShapesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDedicatedVmHostInstanceShapesResponse)this.clientCall(request, ListDedicatedVmHostInstanceShapesResponse::builder).logger(LOG, "listDedicatedVmHostInstanceShapes").serviceDetails("Compute", "ListDedicatedVmHostInstanceShapes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHostInstanceShapeSummary/ListDedicatedVmHostInstanceShapes").method(Method.GET).requestBuilder(ListDedicatedVmHostInstanceShapesRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHostInstanceShapes").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("dedicatedVmHostShape", (Object)request.getDedicatedVmHostShape()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(DedicatedVmHostInstanceShapeSummary.class, ListDedicatedVmHostInstanceShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListDedicatedVmHostInstanceShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDedicatedVmHostInstanceShapesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDedicatedVmHostInstancesResponse listDedicatedVmHostInstances(ListDedicatedVmHostInstancesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getDedicatedVmHostId(), (String)"dedicatedVmHostId must not be blank", (Object[])new Object[0]);
        return (ListDedicatedVmHostInstancesResponse)this.clientCall(request, ListDedicatedVmHostInstancesResponse::builder).logger(LOG, "listDedicatedVmHostInstances").serviceDetails("Compute", "ListDedicatedVmHostInstances", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHostInstanceSummary/ListDedicatedVmHostInstances").method(Method.GET).requestBuilder(ListDedicatedVmHostInstancesRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHosts").appendPathParam(request.getDedicatedVmHostId()).appendPathParam("instances").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json, application/x-json-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(DedicatedVmHostInstanceSummary.class, ListDedicatedVmHostInstancesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListDedicatedVmHostInstancesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDedicatedVmHostInstancesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDedicatedVmHostShapesResponse listDedicatedVmHostShapes(ListDedicatedVmHostShapesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDedicatedVmHostShapesResponse)this.clientCall(request, ListDedicatedVmHostShapesResponse::builder).logger(LOG, "listDedicatedVmHostShapes").serviceDetails("Compute", "ListDedicatedVmHostShapes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHostShapeSummary/ListDedicatedVmHostShapes").method(Method.GET).requestBuilder(ListDedicatedVmHostShapesRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHostShapes").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("instanceShapeName", (Object)request.getInstanceShapeName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(DedicatedVmHostShapeSummary.class, ListDedicatedVmHostShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListDedicatedVmHostShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDedicatedVmHostShapesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDedicatedVmHostsResponse listDedicatedVmHosts(ListDedicatedVmHostsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDedicatedVmHostsResponse)this.clientCall(request, ListDedicatedVmHostsResponse::builder).logger(LOG, "listDedicatedVmHosts").serviceDetails("Compute", "ListDedicatedVmHosts", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHostSummary/ListDedicatedVmHosts").method(Method.GET).requestBuilder(ListDedicatedVmHostsRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHosts").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("instanceShapeName", (Object)request.getInstanceShapeName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("remainingMemoryInGBsGreaterThanOrEqualTo", (Object)request.getRemainingMemoryInGBsGreaterThanOrEqualTo()).appendQueryParam("remainingOcpusGreaterThanOrEqualTo", (Object)request.getRemainingOcpusGreaterThanOrEqualTo()).accept(new String[]{"application/json, application/x-json-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(DedicatedVmHostSummary.class, ListDedicatedVmHostsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListDedicatedVmHostsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDedicatedVmHostsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListImageShapeCompatibilityEntriesResponse listImageShapeCompatibilityEntries(ListImageShapeCompatibilityEntriesRequest request) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        return (ListImageShapeCompatibilityEntriesResponse)this.clientCall(request, ListImageShapeCompatibilityEntriesResponse::builder).logger(LOG, "listImageShapeCompatibilityEntries").serviceDetails("Compute", "ListImageShapeCompatibilityEntries", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ImageShapeCompatibilityEntry/ListImageShapeCompatibilityEntries").method(Method.GET).requestBuilder(ListImageShapeCompatibilityEntriesRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).appendPathParam("shapes").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(ImageShapeCompatibilitySummary.class, ListImageShapeCompatibilityEntriesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListImageShapeCompatibilityEntriesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListImageShapeCompatibilityEntriesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListImagesResponse listImages(ListImagesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListImagesResponse)this.clientCall(request, ListImagesResponse::builder).logger(LOG, "listImages").serviceDetails("Compute", "ListImages", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Image/ListImages").method(Method.GET).requestBuilder(ListImagesRequest::builder).basePath("/20160918").appendPathParam("images").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("operatingSystem", (Object)request.getOperatingSystem()).appendQueryParam("operatingSystemVersion", (Object)request.getOperatingSystemVersion()).appendQueryParam("shape", (Object)request.getShape()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).operationUsesDefaultRetries().handleBodyList(Image.class, ListImagesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListImagesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListImagesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListInstanceConsoleConnectionsResponse listInstanceConsoleConnections(ListInstanceConsoleConnectionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListInstanceConsoleConnectionsResponse)this.clientCall(request, ListInstanceConsoleConnectionsResponse::builder).logger(LOG, "listInstanceConsoleConnections").serviceDetails("Compute", "ListInstanceConsoleConnections", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceConsoleConnection/ListInstanceConsoleConnections").method(Method.GET).requestBuilder(ListInstanceConsoleConnectionsRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleConnections").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("instanceId", (Object)request.getInstanceId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).handleBodyList(InstanceConsoleConnection.class, ListInstanceConsoleConnectionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInstanceConsoleConnectionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInstanceConsoleConnectionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListInstanceDevicesResponse listInstanceDevices(ListInstanceDevicesRequest request) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        return (ListInstanceDevicesResponse)this.clientCall(request, ListInstanceDevicesResponse::builder).logger(LOG, "listInstanceDevices").serviceDetails("Compute", "ListInstanceDevices", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Device/ListInstanceDevices").method(Method.GET).requestBuilder(ListInstanceDevicesRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).appendPathParam("devices").appendQueryParam("isAvailable", (Object)request.getIsAvailable()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(Device.class, ListInstanceDevicesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInstanceDevicesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInstanceDevicesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListInstanceMaintenanceEventsResponse listInstanceMaintenanceEvents(ListInstanceMaintenanceEventsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListInstanceMaintenanceEventsResponse)this.clientCall(request, ListInstanceMaintenanceEventsResponse::builder).logger(LOG, "listInstanceMaintenanceEvents").serviceDetails("Compute", "ListInstanceMaintenanceEvents", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceMaintenanceEventSummary/ListInstanceMaintenanceEvents").method(Method.GET).requestBuilder(ListInstanceMaintenanceEventsRequest::builder).basePath("/20160918").appendPathParam("instanceMaintenanceEvents").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("instanceId", (Object)request.getInstanceId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("correlationToken", (Object)request.getCorrelationToken()).appendQueryParam("instanceAction", (Object)request.getInstanceAction()).appendQueryParam("timeWindowStartGreaterThanOrEqualTo", (Object)request.getTimeWindowStartGreaterThanOrEqualTo()).appendQueryParam("timeWindowStartLessThanOrEqualTo", (Object)request.getTimeWindowStartLessThanOrEqualTo()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(InstanceMaintenanceEventSummary.class, ListInstanceMaintenanceEventsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInstanceMaintenanceEventsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInstanceMaintenanceEventsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListInstancesResponse listInstances(ListInstancesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListInstancesResponse)this.clientCall(request, ListInstancesResponse::builder).logger(LOG, "listInstances").serviceDetails("Compute", "ListInstances", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Instance/ListInstances").method(Method.GET).requestBuilder(ListInstancesRequest::builder).basePath("/20160918").appendPathParam("instances").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("capacityReservationId", (Object)request.getCapacityReservationId()).appendQueryParam("computeClusterId", (Object)request.getComputeClusterId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json, application/x-json-stream"}).handleBodyList(Instance.class, ListInstancesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInstancesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInstancesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListShapesResponse listShapes(ListShapesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListShapesResponse)this.clientCall(request, ListShapesResponse::builder).logger(LOG, "listShapes").serviceDetails("Compute", "ListShapes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Shape/ListShapes").method(Method.GET).requestBuilder(ListShapesRequest::builder).basePath("/20160918").appendPathParam("shapes").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("imageId", (Object)request.getImageId()).accept(new String[]{"application/json"}).handleBodyList(Shape.class, ListShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListShapesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListVnicAttachmentsResponse listVnicAttachments(ListVnicAttachmentsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVnicAttachmentsResponse)this.clientCall(request, ListVnicAttachmentsResponse::builder).logger(LOG, "listVnicAttachments").serviceDetails("Compute", "ListVnicAttachments", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VnicAttachment/ListVnicAttachments").method(Method.GET).requestBuilder(ListVnicAttachmentsRequest::builder).basePath("/20160918").appendPathParam("vnicAttachments").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("instanceId", (Object)request.getInstanceId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("vnicId", (Object)request.getVnicId()).accept(new String[]{"application/json, application/x-json-stream"}).handleBodyList(VnicAttachment.class, ListVnicAttachmentsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVnicAttachmentsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVnicAttachmentsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListVolumeAttachmentsResponse listVolumeAttachments(ListVolumeAttachmentsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVolumeAttachmentsResponse)this.clientCall(request, ListVolumeAttachmentsResponse::builder).logger(LOG, "listVolumeAttachments").serviceDetails("Compute", "ListVolumeAttachments", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeAttachment/ListVolumeAttachments").method(Method.GET).requestBuilder(ListVolumeAttachmentsRequest::builder).basePath("/20160918").appendPathParam("volumeAttachments").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("instanceId", (Object)request.getInstanceId()).appendQueryParam("volumeId", (Object)request.getVolumeId()).accept(new String[]{"application/json, application/x-json-stream"}).handleBodyList(VolumeAttachment.class, ListVolumeAttachmentsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVolumeAttachmentsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVolumeAttachmentsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RemoveImageShapeCompatibilityEntryResponse removeImageShapeCompatibilityEntry(RemoveImageShapeCompatibilityEntryRequest request) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getShapeName(), (String)"shapeName must not be blank", (Object[])new Object[0]);
        return (RemoveImageShapeCompatibilityEntryResponse)this.clientCall(request, RemoveImageShapeCompatibilityEntryResponse::builder).logger(LOG, "removeImageShapeCompatibilityEntry").serviceDetails("Compute", "RemoveImageShapeCompatibilityEntry", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ImageShapeCompatibilityEntry/RemoveImageShapeCompatibilityEntry").method(Method.DELETE).requestBuilder(RemoveImageShapeCompatibilityEntryRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).appendPathParam("shapes").appendPathParam(request.getShapeName()).accept(new String[]{"application/json"}).handleResponseHeaderString("opc-request-id", RemoveImageShapeCompatibilityEntryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public TerminateInstanceResponse terminateInstance(TerminateInstanceRequest request) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        return (TerminateInstanceResponse)this.clientCall(request, TerminateInstanceResponse::builder).logger(LOG, "terminateInstance").serviceDetails("Compute", "TerminateInstance", "").method(Method.DELETE).requestBuilder(TerminateInstanceRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).appendQueryParam("preserveBootVolume", (Object)request.getPreserveBootVolume()).appendQueryParam("preserveDataVolumesCreatedAtLaunch", (Object)request.getPreserveDataVolumesCreatedAtLaunch()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", TerminateInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateComputeCapacityReservationResponse updateComputeCapacityReservation(UpdateComputeCapacityReservationRequest request) {
        Validate.notBlank((String)request.getCapacityReservationId(), (String)"capacityReservationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateComputeCapacityReservationDetails(), "updateComputeCapacityReservationDetails is required");
        return (UpdateComputeCapacityReservationResponse)this.clientCall(request, UpdateComputeCapacityReservationResponse::builder).logger(LOG, "updateComputeCapacityReservation").serviceDetails("Compute", "UpdateComputeCapacityReservation", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityReservation/UpdateComputeCapacityReservation").method(Method.PUT).requestBuilder(UpdateComputeCapacityReservationRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReservations").appendPathParam(request.getCapacityReservationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateComputeCapacityReservationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateComputeCapacityReservationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateComputeCapacityTopologyResponse updateComputeCapacityTopology(UpdateComputeCapacityTopologyRequest request) {
        Validate.notBlank((String)request.getComputeCapacityTopologyId(), (String)"computeCapacityTopologyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateComputeCapacityTopologyDetails(), "updateComputeCapacityTopologyDetails is required");
        return (UpdateComputeCapacityTopologyResponse)this.clientCall(request, UpdateComputeCapacityTopologyResponse::builder).logger(LOG, "updateComputeCapacityTopology").serviceDetails("Compute", "UpdateComputeCapacityTopology", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityTopology/UpdateComputeCapacityTopology").method(Method.PUT).requestBuilder(UpdateComputeCapacityTopologyRequest::builder).basePath("/20160918").appendPathParam("computeCapacityTopologies").appendPathParam(request.getComputeCapacityTopologyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", UpdateComputeCapacityTopologyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateComputeCapacityTopologyResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateComputeClusterResponse updateComputeCluster(UpdateComputeClusterRequest request) {
        Validate.notBlank((String)request.getComputeClusterId(), (String)"computeClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateComputeClusterDetails(), "updateComputeClusterDetails is required");
        return (UpdateComputeClusterResponse)this.clientCall(request, UpdateComputeClusterResponse::builder).logger(LOG, "updateComputeCluster").serviceDetails("Compute", "UpdateComputeCluster", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCluster/UpdateComputeCluster").method(Method.PUT).requestBuilder(UpdateComputeClusterRequest::builder).basePath("/20160918").appendPathParam("computeClusters").appendPathParam(request.getComputeClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ComputeCluster.class, UpdateComputeClusterResponse.Builder::computeCluster).handleResponseHeaderString("etag", UpdateComputeClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateComputeClusterResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateComputeGpuMemoryClusterResponse updateComputeGpuMemoryCluster(UpdateComputeGpuMemoryClusterRequest request) {
        Validate.notBlank((String)request.getComputeGpuMemoryClusterId(), (String)"computeGpuMemoryClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateComputeGpuMemoryClusterDetails(), "updateComputeGpuMemoryClusterDetails is required");
        return (UpdateComputeGpuMemoryClusterResponse)this.clientCall(request, UpdateComputeGpuMemoryClusterResponse::builder).logger(LOG, "updateComputeGpuMemoryCluster").serviceDetails("Compute", "UpdateComputeGpuMemoryCluster", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGpuMemoryCluster/UpdateComputeGpuMemoryCluster").method(Method.PUT).requestBuilder(UpdateComputeGpuMemoryClusterRequest::builder).basePath("/20160918").appendPathParam("computeGpuMemoryClusters").appendPathParam(request.getComputeGpuMemoryClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(ComputeGpuMemoryCluster.class, UpdateComputeGpuMemoryClusterResponse.Builder::computeGpuMemoryCluster).handleResponseHeaderString("etag", UpdateComputeGpuMemoryClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateComputeGpuMemoryClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateComputeGpuMemoryClusterResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateComputeGpuMemoryFabricResponse updateComputeGpuMemoryFabric(UpdateComputeGpuMemoryFabricRequest request) {
        Validate.notBlank((String)request.getComputeGpuMemoryFabricId(), (String)"computeGpuMemoryFabricId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateComputeGpuMemoryFabricDetails(), "updateComputeGpuMemoryFabricDetails is required");
        return (UpdateComputeGpuMemoryFabricResponse)this.clientCall(request, UpdateComputeGpuMemoryFabricResponse::builder).logger(LOG, "updateComputeGpuMemoryFabric").serviceDetails("Compute", "UpdateComputeGpuMemoryFabric", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGpuMemoryFabric/UpdateComputeGpuMemoryFabric").method(Method.PUT).requestBuilder(UpdateComputeGpuMemoryFabricRequest::builder).basePath("/20160918").appendPathParam("computeGpuMemoryFabrics").appendPathParam(request.getComputeGpuMemoryFabricId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(ComputeGpuMemoryFabric.class, UpdateComputeGpuMemoryFabricResponse.Builder::computeGpuMemoryFabric).handleResponseHeaderString("etag", UpdateComputeGpuMemoryFabricResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateComputeGpuMemoryFabricResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateComputeHostResponse updateComputeHost(UpdateComputeHostRequest request) {
        Validate.notBlank((String)request.getComputeHostId(), (String)"computeHostId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateComputeHostDetails(), "updateComputeHostDetails is required");
        return (UpdateComputeHostResponse)this.clientCall(request, UpdateComputeHostResponse::builder).logger(LOG, "updateComputeHost").serviceDetails("Compute", "UpdateComputeHost", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeHost/UpdateComputeHost").method(Method.PUT).requestBuilder(UpdateComputeHostRequest::builder).basePath("/20160918").appendPathParam("computeHosts").appendPathParam(request.getComputeHostId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("etag", UpdateComputeHostResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateComputeHostResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateComputeHostResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateComputeImageCapabilitySchemaResponse updateComputeImageCapabilitySchema(UpdateComputeImageCapabilitySchemaRequest request) {
        Validate.notBlank((String)request.getComputeImageCapabilitySchemaId(), (String)"computeImageCapabilitySchemaId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateComputeImageCapabilitySchemaDetails(), "updateComputeImageCapabilitySchemaDetails is required");
        return (UpdateComputeImageCapabilitySchemaResponse)this.clientCall(request, UpdateComputeImageCapabilitySchemaResponse::builder).logger(LOG, "updateComputeImageCapabilitySchema").serviceDetails("Compute", "UpdateComputeImageCapabilitySchema", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeImageCapabilitySchema/UpdateComputeImageCapabilitySchema").method(Method.PUT).requestBuilder(UpdateComputeImageCapabilitySchemaRequest::builder).basePath("/20160918").appendPathParam("computeImageCapabilitySchemas").appendPathParam(request.getComputeImageCapabilitySchemaId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ComputeImageCapabilitySchema.class, UpdateComputeImageCapabilitySchemaResponse.Builder::computeImageCapabilitySchema).handleResponseHeaderString("etag", UpdateComputeImageCapabilitySchemaResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateComputeImageCapabilitySchemaResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateConsoleHistoryResponse updateConsoleHistory(UpdateConsoleHistoryRequest request) {
        Validate.notBlank((String)request.getInstanceConsoleHistoryId(), (String)"instanceConsoleHistoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConsoleHistoryDetails(), "updateConsoleHistoryDetails is required");
        return (UpdateConsoleHistoryResponse)this.clientCall(request, UpdateConsoleHistoryResponse::builder).logger(LOG, "updateConsoleHistory").serviceDetails("Compute", "UpdateConsoleHistory", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ConsoleHistory/UpdateConsoleHistory").method(Method.PUT).requestBuilder(UpdateConsoleHistoryRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleHistories").appendPathParam(request.getInstanceConsoleHistoryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ConsoleHistory.class, UpdateConsoleHistoryResponse.Builder::consoleHistory).handleResponseHeaderString("etag", UpdateConsoleHistoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateConsoleHistoryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDedicatedVmHostResponse updateDedicatedVmHost(UpdateDedicatedVmHostRequest request) {
        Validate.notBlank((String)request.getDedicatedVmHostId(), (String)"dedicatedVmHostId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDedicatedVmHostDetails(), "updateDedicatedVmHostDetails is required");
        return (UpdateDedicatedVmHostResponse)this.clientCall(request, UpdateDedicatedVmHostResponse::builder).logger(LOG, "updateDedicatedVmHost").serviceDetails("Compute", "UpdateDedicatedVmHost", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHost/UpdateDedicatedVmHost").method(Method.PUT).requestBuilder(UpdateDedicatedVmHostRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHosts").appendPathParam(request.getDedicatedVmHostId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DedicatedVmHost.class, UpdateDedicatedVmHostResponse.Builder::dedicatedVmHost).handleResponseHeaderString("etag", UpdateDedicatedVmHostResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDedicatedVmHostResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateImageResponse updateImage(UpdateImageRequest request) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateImageDetails(), "updateImageDetails is required");
        return (UpdateImageResponse)this.clientCall(request, UpdateImageResponse::builder).logger(LOG, "updateImage").serviceDetails("Compute", "UpdateImage", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Image/UpdateImage").method(Method.PUT).requestBuilder(UpdateImageRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Image.class, UpdateImageResponse.Builder::image).handleResponseHeaderString("etag", UpdateImageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateImageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateInstanceResponse updateInstance(UpdateInstanceRequest request) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateInstanceDetails(), "updateInstanceDetails is required");
        return (UpdateInstanceResponse)this.clientCall(request, UpdateInstanceResponse::builder).logger(LOG, "updateInstance").serviceDetails("Compute", "UpdateInstance", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Instance/UpdateInstance").method(Method.PUT).requestBuilder(UpdateInstanceRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Instance.class, UpdateInstanceResponse.Builder::instance).handleResponseHeaderString("etag", UpdateInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateInstanceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateInstanceConsoleConnectionResponse updateInstanceConsoleConnection(UpdateInstanceConsoleConnectionRequest request) {
        Validate.notBlank((String)request.getInstanceConsoleConnectionId(), (String)"instanceConsoleConnectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateInstanceConsoleConnectionDetails(), "updateInstanceConsoleConnectionDetails is required");
        return (UpdateInstanceConsoleConnectionResponse)this.clientCall(request, UpdateInstanceConsoleConnectionResponse::builder).logger(LOG, "updateInstanceConsoleConnection").serviceDetails("Compute", "UpdateInstanceConsoleConnection", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceConsoleConnection/UpdateInstanceConsoleConnection").method(Method.PUT).requestBuilder(UpdateInstanceConsoleConnectionRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleConnections").appendPathParam(request.getInstanceConsoleConnectionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(InstanceConsoleConnection.class, UpdateInstanceConsoleConnectionResponse.Builder::instanceConsoleConnection).handleResponseHeaderString("etag", UpdateInstanceConsoleConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateInstanceConsoleConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateInstanceMaintenanceEventResponse updateInstanceMaintenanceEvent(UpdateInstanceMaintenanceEventRequest request) {
        Validate.notBlank((String)request.getInstanceMaintenanceEventId(), (String)"instanceMaintenanceEventId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateInstanceMaintenanceEventDetails(), "updateInstanceMaintenanceEventDetails is required");
        return (UpdateInstanceMaintenanceEventResponse)this.clientCall(request, UpdateInstanceMaintenanceEventResponse::builder).logger(LOG, "updateInstanceMaintenanceEvent").serviceDetails("Compute", "UpdateInstanceMaintenanceEvent", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceMaintenanceEvent/UpdateInstanceMaintenanceEvent").method(Method.PUT).requestBuilder(UpdateInstanceMaintenanceEventRequest::builder).basePath("/20160918").appendPathParam("instanceMaintenanceEvents").appendPathParam(request.getInstanceMaintenanceEventId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", UpdateInstanceMaintenanceEventResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateInstanceMaintenanceEventResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateVolumeAttachmentResponse updateVolumeAttachment(UpdateVolumeAttachmentRequest request) {
        Validate.notBlank((String)request.getVolumeAttachmentId(), (String)"volumeAttachmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVolumeAttachmentDetails(), "updateVolumeAttachmentDetails is required");
        return (UpdateVolumeAttachmentResponse)this.clientCall(request, UpdateVolumeAttachmentResponse::builder).logger(LOG, "updateVolumeAttachment").serviceDetails("Compute", "UpdateVolumeAttachment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeAttachment/UpdateVolumeAttachment").method(Method.PUT).requestBuilder(UpdateVolumeAttachmentRequest::builder).basePath("/20160918").appendPathParam("volumeAttachments").appendPathParam(request.getVolumeAttachmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(VolumeAttachment.class, UpdateVolumeAttachmentResponse.Builder::volumeAttachment).handleResponseHeaderString("etag", UpdateVolumeAttachmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateVolumeAttachmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ComputeWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ComputeWaiters newWaiters(WorkRequest workRequestClient) {
        return new ComputeWaiters(this.executorService, this, workRequestClient);
    }

    @Override
    public ComputePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ComputeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ComputeClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ComputeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ComputeClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ComputeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ComputeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ComputeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ComputeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ComputeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ComputeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ComputeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ComputeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ComputeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ComputeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ComputeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ComputeClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ComputeClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "core";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"core");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ComputeClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ComputeClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

