/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import liquibase.Scope;
import liquibase.exception.LiquibaseException;
import liquibase.logging.LogService;
import liquibase.logging.core.JavaLogService;
import lombok.Generated;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.AbstractOracleStatement;
import oracle.dbtools.raptor.liquibase.generator.changesets.data.ChangeData;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;

public class LbFileUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final String ILLEGAL_CHARACTERS = "[/\\\\?%*:|\"<>.']";
    private static File log;
    private static FileHandler fileHandler;

    private LbFileUtils() {
    }

    public static String getSourceResourceParent(AbstractOracleStatement statement) throws LiquibaseException {
        if (statement.getSourceType().equalsIgnoreCase("FILE")) {
            return LbFileUtils.cleanPath(Paths.get(LbFileUtils.getSourceResource(statement), new String[0]).getParent().toString());
        }
        return LbFileUtils.cleanPath(Paths.get(LbFileUtils.getSourceResource(statement), new String[0]).toString());
    }

    public static String getSourceResource(AbstractOracleStatement statement) throws LiquibaseException {
        Path ret = Paths.get(LbFileUtils.getPath(statement), new String[0]);
        if (ret.getParent() == null && ret.toString().startsWith("/")) {
            return LbFileUtils.cleanPath(ret.getFileName().toString().substring(1));
        }
        return LbFileUtils.cleanPath(ret.toString());
    }

    private static void addFile(String file, ArrayList<String> recs) {
        if (!recs.contains(file)) {
            recs.add(file);
        }
    }

    public static String getPath(AbstractOracleStatement statement) throws LiquibaseException {
        Path filePath;
        ArrayList<String> tested = new ArrayList<String>();
        String cwd = LbUtils.getCWD();
        String changeLog = "";
        String sourceRef = "";
        String file = "";
        sourceRef = LbFileUtils.getSourceRefString();
        changeLog = LbFileUtils.getChangeLogString(statement);
        List<String> sps = LbFileUtils.getSearchPathList();
        file = LbFileUtils.getFileString(statement);
        for (String sp : sps) {
            if (Paths.get(sp, new String[0]).isAbsolute()) continue;
            if (statement.isRelative()) {
                filePath = Paths.get(cwd, sourceRef, sp, changeLog, file);
                if (filePath.toFile().exists()) {
                    return LbFileUtils.cleanPath(filePath.toString());
                }
                LbFileUtils.addFile(filePath.toString(), tested);
                continue;
            }
            filePath = Paths.get(cwd, sourceRef, sp, file);
            if (filePath.toFile().exists()) {
                return LbFileUtils.cleanPath(filePath.toString());
            }
            LbFileUtils.addFile(filePath.toString(), tested);
        }
        if (statement.isRelative()) {
            filePath = Paths.get(cwd, sourceRef, changeLog, file);
            if (filePath.toFile().exists()) {
                return LbFileUtils.cleanPath(filePath.toString());
            }
            LbFileUtils.addFile(filePath.toString(), tested);
        } else {
            filePath = Paths.get(cwd, sourceRef, file);
            if (filePath.toFile().exists()) {
                return LbFileUtils.cleanPath(filePath.toString());
            }
            LbFileUtils.addFile(filePath.toString(), tested);
        }
        filePath = Paths.get(cwd, file);
        if (filePath.toFile().exists()) {
            return LbFileUtils.cleanPath(filePath.toString());
        }
        LbFileUtils.addFile(filePath.toString(), tested);
        for (String path : sps) {
            if (!Paths.get(path, new String[0]).isAbsolute()) continue;
            filePath = Paths.get(path, file);
            if (filePath.toFile().exists()) {
                return LbFileUtils.cleanPath(filePath.toString());
            }
            LbFileUtils.addFile(filePath.toString(), tested);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Unable to locate file ").append(file).append("\n\tSearched Locations:");
        for (String loc : tested) {
            sb.append("\n\t").append(loc);
        }
        throw new LiquibaseException(sb.toString());
    }

    public static String cleanPath(String path) {
        int loc;
        if (PlatformUtils.isWindows() && path != null && !path.isEmpty() && (loc = (path = path.replace("\\", "/")).indexOf(":")) > 0) {
            StringBuilder sb = new StringBuilder(path);
            char c = Character.toLowerCase(path.charAt(loc - 1));
            sb.setCharAt(loc - 1, c);
            return sb.toString();
        }
        return path;
    }

    public static String getFileString(boolean ovf, String fileName) throws IOException {
        return LbFileUtils.cleanPath(LbFileUtils.getFile(ovf, fileName, LbUtils.getContext()).toString());
    }

    public static File getFile(boolean ovf, String fileName, ScriptRunnerContext ctx) throws IOException {
        Path fpath;
        Path filePath = fpath = Paths.get(fileName, new String[0]);
        int parts = fpath.getNameCount();
        if (1 == parts) {
            boolean result;
            String[] pcs = fileName.split("\\.");
            pcs[0] = LbFileUtils.removeIllegalCharacters(pcs[0], true);
            String front = 1 < pcs.length ? pcs[0] : fileName;
            Path out = fileName.contains(LbUtils.getCWD(ctx)) ? fpath : Paths.get(LbUtils.getCWD(ctx), fileName);
            if (!ovf) {
                int i = 1;
                Object oldfront = front;
                String newfront = (String)oldfront + "_" + i;
                String newFileName = fileName;
                while (Files.exists(out, new LinkOption[0])) {
                    newFileName = newFileName.replace((CharSequence)oldfront, newfront);
                    out = Paths.get(LbUtils.getCWD(ctx), newFileName);
                    oldfront = newfront;
                    newfront = front + "_" + ++i;
                }
            }
            if (null != out.toFile().getParentFile() && out.toFile().getParentFile().isDirectory() && !out.toFile().getParentFile().exists()) {
                Files.createDirectories(out.toFile().toPath().getParent(), new FileAttribute[0]);
            }
            if (result = out.toFile().createNewFile()) {
                return out.toFile();
            }
        }
        if (!ovf) {
            String front = fpath.getName(0).toString();
            int i = 1;
            while (Files.exists(Paths.get(LbUtils.getCWD(), filePath.toString()), new LinkOption[0])) {
                String newFront = front + "_" + i;
                ++i;
                filePath = Paths.get(fpath.toString().replaceFirst(front, newFront), new String[0]);
            }
        }
        if (!filePath.toString().contains(LbUtils.getCWD(ctx))) {
            filePath = Paths.get(LbUtils.getCWD(ctx), filePath.toString());
        }
        if (null != filePath.toFile().getParentFile()) {
            Files.createDirectories(filePath.toFile().toPath().getParent(), new FileAttribute[0]);
        }
        if (!filePath.toFile().createNewFile()) {
            if (ovf && filePath.toFile().delete() && filePath.toFile().createNewFile()) {
                return filePath.toFile();
            }
            throw new IOException("Unable to create file " + String.valueOf(filePath));
        }
        return filePath.toFile();
    }

    public static String sanitizeFileName(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("File name cannot be null");
        }
        return fileName.replaceAll(ILLEGAL_CHARACTERS, "_");
    }

    public static String removeIllegalCharacters(String name, boolean singleSpaces) {
        String safe = name.trim();
        if ((safe = LbFileUtils.sanitizeFileName(safe)).endsWith("_")) {
            safe = safe.substring(0, safe.length() - 1);
        }
        safe = safe.replaceAll("\\s+", "_");
        if (singleSpaces) {
            safe = safe.replaceAll("_{2,}", "_");
        }
        return safe;
    }

    public static Path getPath(boolean ovf, String fileName) throws IOException {
        return Paths.get(LbFileUtils.getFile(ovf, fileName, LbUtils.getContext()).toString(), new String[0]);
    }

    public static void setCwd(String path, ScriptRunnerContext ctx) {
        Path newPath;
        String osName = "os.name";
        String windoz = "Windows";
        String cdPath = path.trim();
        if ((cdPath.startsWith("'") && cdPath.endsWith("'") || cdPath.startsWith("\"") && cdPath.endsWith("\"")) && 2 < cdPath.length()) {
            cdPath = cdPath.substring(1, cdPath.length() - 1);
        }
        if (System.getProperty(osName).startsWith(windoz) && cdPath.startsWith("/") && 3 < cdPath.length() && ":".equals(cdPath.substring(2, 3))) {
            cdPath = cdPath.substring(1);
        }
        if (System.getProperty(osName).startsWith(windoz)) {
            cdPath = cdPath.replace("/", "\\");
        }
        if (!System.getProperty(osName).startsWith(windoz) && cdPath.startsWith("~")) {
            cdPath = cdPath.replaceFirst("~", System.getProperty("user.home"));
        }
        Path currentDir = Paths.get((String)ctx.getMap().get(ScriptRunnerContext.SqlplusVariable._PWD.toString()), new String[0]);
        ctx.putProperty("script.runner.previous_dir", (Object)currentDir);
        try {
            newPath = currentDir.resolve(cdPath);
        }
        catch (Exception e) {
            ctx.write(MessageFormat.format(oracle.dbtools.raptor.scriptrunner.commands.Messages.getString((String)"CDNOTFOUND"), cdPath) + "\n");
            return;
        }
        try {
            newPath = newPath.toRealPath(new LinkOption[0]);
        }
        catch (IOException ignored) {
            return;
        }
        File f = newPath.toFile();
        if (f.isDirectory()) {
            String cPath;
            try {
                cPath = f.getCanonicalPath();
            }
            catch (IOException ignored) {
                return;
            }
            ctx.putProperty("script.runner.cd_command", (Object)cPath);
            ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._PWD.toString(), cPath);
        } else {
            ctx.write(MessageFormat.format(oracle.dbtools.raptor.scriptrunner.commands.Messages.getString((String)"CDNOTFOUND"), cdPath) + "\n");
        }
    }

    public static String writeErrorLog(String data) throws IOException {
        File file = LbFileUtils.getLogFile(true);
        if (!file.exists()) {
            throw new IOException("Unable to create log file.");
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(data);
            String string = Paths.get(file.toString(), new String[0]).getFileName().toString();
            return string;
        }
    }

    public static File getLogFile(boolean errorLog) throws IOException {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String logPath = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.LOG_PATH);
        if (logPath == null || logPath.isEmpty()) {
            logPath = LbUtils.getCWD();
        } else if (!Paths.get(logPath, new String[0]).toFile().isAbsolute()) {
            logPath = Paths.get(LbUtils.getCWD(), logPath).toString();
        }
        if (errorLog) {
            File log = Paths.get(logPath, "sqlcl-lb-error" + timestamp.getTime() + ".log").toFile();
            boolean newFile = log.createNewFile();
            if (newFile) {
                return log;
            }
            throw new IOException(Messages.getString("UNABLE_CREATE_LOGFILE"));
        }
        File log = Paths.get(logPath, "sqlcl-lb-" + timestamp.getTime() + ".log").toFile();
        boolean newFile = log.createNewFile();
        if (newFile) {
            LbFileUtils.log = log;
            return log;
        }
        throw new IOException(Messages.getString("UNABLE_CREATE_LOGFILE"));
    }

    public static String writeFile(String filename, String changelog) throws IOException {
        File file = LbFileUtils.getFile((Boolean)LbUtils.getCommand().getOptionValue(LBOptions.Options.OVERWRITE_FILES), filename, LbUtils.getContext());
        BufferedWriter writer = LbFileUtils.getWriter(file);
        if (writer == null) {
            throw new IOException("Unable to create and write to file " + file.toString());
        }
        writer.write(changelog);
        writer.close();
        return file.toString();
    }

    public static void writeFile(ChangeData data) throws IOException {
        File file = data.getFILE();
        BufferedWriter writer = LbFileUtils.getWriter(file);
        if (writer == null) {
            throw new IOException("Unable to create and write to file " + data.getFILENAME());
        }
        writer.write(data.getCHANGELOG());
        writer.close();
    }

    public static void writeSqlFile(ChangeData data, Connection conn) throws LiquibaseException, IOException, SQLException {
        String ddl;
        String oType = data.getOTYPE();
        String oName = data.getONAME();
        String sql = null;
        sql = "COMMENT".equals(oType) ? data.getDDL().substring(data.getDDL().indexOf("COMMENT")) : ("SYNONYM".equals(oType) ? ((ddl = data.getDDL()) != null && ddl.contains("PUBLIC SYNONYM") ? ddl : DbmsMetaUtils.getDdlFromDb(conn, oType, oName)) : DbmsMetaUtils.getDdlFromDb(conn, oType, oName));
        if (sql == null) {
            throw new LiquibaseException("Unable to generate DDL for object type: " + oType + "  named: " + oName);
        }
        BufferedWriter sqlwriter = LbFileUtils.getWriter(data.getSQLFILE());
        if (sqlwriter == null) {
            throw new LiquibaseException("Unable to generate DDL for object type: " + oType + "  named: " + oName);
        }
        sql = LbUtils.replaceUserSchema(sql, conn.getSchema(), data);
        sqlwriter.write(sql);
        sqlwriter.close();
    }

    public static BufferedWriter getWriter(File file) {
        try {
            Path path = Paths.get(file.toString(), new String[0]);
            return new BufferedWriter(new FileWriter(path.toString()));
        }
        catch (Exception e) {
            LbUtils.report("unable to get file path for :" + file.toString());
            oracle.dbtools.util.Logger.warn(LbFileUtils.class, (Throwable)e);
            return null;
        }
    }

    public static void writeInputStreamToFile(InputStream inputStream, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file, false);){
            int read;
            byte[] bytes = new byte[8192];
            while (-1 != (read = inputStream.read(bytes))) {
                outputStream.write(bytes, 0, read);
            }
        }
    }

    public static void configureLogging(Level level, File logFile) throws IOException {
        log = logFile;
        JavaLogService logService = (JavaLogService)Scope.getCurrentScope().get((Enum)Scope.Attr.logService, LogService.class);
        Logger liquibaseLogger = Logger.getLogger("liquibase");
        logService.setParent(liquibaseLogger);
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT] %4$s [%2$s] %5$s%6$s%n");
        Logger rootLogger = Logger.getLogger("");
        Level cliLogLevel = level;
        if (null != log) {
            if (null == fileHandler) {
                fileHandler = new FileHandler(log.toString(), true);
                fileHandler.setFormatter(new SimpleFormatter());
                rootLogger.addHandler(fileHandler);
            }
            fileHandler.setLevel(level);
            cliLogLevel = Level.OFF;
        }
        ArrayList<String> channels = new ArrayList<String>(Arrays.asList("", "liquibase"));
        for (String channel : channels) {
            String s = channel;
            if ("all".equalsIgnoreCase(s)) {
                s = "";
            }
            Logger.getLogger(s).setLevel(level);
        }
        for (Handler handler : rootLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            handler.setLevel(cliLogLevel);
        }
    }

    public static void cleanup() {
        if (null != fileHandler) {
            fileHandler.flush();
            fileHandler.close();
        }
        if (LbUtils.getCommand() != null) {
            LbUtils.getCommand().close();
            LbUtils.setCommand(null);
            fileHandler = null;
            LbUtils.resetErrors();
        }
    }

    public static String getSchema(String objectOwner, String schemaOwner) {
        String schema = LbUtils.getCommand().isFlagSet(LBOptions.Options.OUTPUT_DEFAULT_SCHEMA) ? (null != LbUtils.getCommand().getOptionValue(LBOptions.Options.DEFAULT_SCHEMA_NAME) ? (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.DEFAULT_SCHEMA_NAME) : objectOwner) : schemaOwner;
        return schema;
    }

    public static boolean isSameFileAs(Path path, Path path2) {
        try {
            return Files.isSameFile(path, path2);
        }
        catch (IOException ioe) {
            return path.toAbsolutePath().normalize().equals(path2.toAbsolutePath().normalize());
        }
    }

    public static String writeApexInstallFile(String fileName, String data) throws IOException, LiquibaseException {
        File file;
        BufferedWriter writer;
        String tempfile = null;
        if (null != LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.DIR) && !LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.DIR).toString().isEmpty()) {
            Path path = Paths.get((String)LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.DIR), fileName);
            tempfile = path.normalize().toString();
        }
        ChangeData chData = new ChangeData(LbUtils.getCommand());
        if (null == tempfile || tempfile.isEmpty()) {
            tempfile = fileName;
        }
        if (null == (writer = LbFileUtils.getWriter(file = LbFileUtils.getFile(chData.isOVERWRITEFILES(), tempfile, LbUtils.getContext())))) {
            throw new LiquibaseException("Unable to write Apex install file.");
        }
        writer.write(data);
        writer.close();
        return Paths.get(file.toString(), new String[0]).getFileName().toString();
    }

    private static String getChangeLogString(AbstractOracleStatement statement) {
        String cwd = LbUtils.getCWD();
        String clogString = statement.getFile();
        if (clogString == null || clogString.isEmpty()) {
            return "";
        }
        Path clogPath = Paths.get(clogString, new String[0]);
        if (clogPath.getParent() != null) {
            clogString = LbFileUtils.cleanPath(clogPath.getParent().toString());
            if (clogString != null && clogString.startsWith(cwd)) {
                if ((clogString = clogString.replace(cwd, "")).startsWith("\\") || clogString.startsWith("/")) {
                    return clogString.substring(1);
                }
            } else if (clogString != null && cwd.startsWith(clogString)) {
                return "";
            }
            return LbFileUtils.cleanPath(clogString);
        }
        return "";
    }

    public static String getSourceRefString() throws LiquibaseException {
        String cwd = LbUtils.getCWD();
        String ret = "";
        String sourceString = LbUtils.getContext().getSourceRef();
        if (sourceString == null || sourceString.isEmpty()) {
            return "";
        }
        if (sourceString.startsWith("file:")) {
            URI uri = null;
            try {
                uri = new URI(sourceString);
            }
            catch (URISyntaxException e) {
                throw new LiquibaseException((Throwable)e);
            }
            sourceString = Paths.get(uri).toString();
        }
        if ((sourceString = LbFileUtils.cleanPath(sourceString)) != null && sourceString.startsWith(cwd)) {
            if ((sourceString = sourceString.replace(cwd, "")).startsWith("\\") || sourceString.startsWith("/")) {
                sourceString = sourceString.substring(1);
            }
        } else if (sourceString != null && cwd.startsWith(sourceString)) {
            return "";
        }
        if (sourceString == null || sourceString.isEmpty()) {
            return "";
        }
        Path sourcePath = Paths.get(sourceString, new String[0]);
        if (sourcePath.getParent() == null) {
            return "";
        }
        sourcePath = sourcePath.getParent();
        return LbFileUtils.cleanPath(sourcePath.toString());
    }

    private static String getFileString(AbstractOracleStatement statement) {
        if (statement.getSourceType().equalsIgnoreCase("FILE")) {
            return statement.getSource();
        }
        return "";
    }

    private static List<String> getSearchPathList() {
        List sps = (List)LbUtils.getCommand().getParsedCommand().getOptionValue((Id)LBOptions.Options.SEARCH_PATH);
        if (sps != null) {
            return sps;
        }
        return new ArrayList<String>();
    }

    @Generated
    public static File getLog() {
        return log;
    }

    @Generated
    public static void setLog(File log) {
        LbFileUtils.log = log;
    }
}

