/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.service;

import com.google.common.base.Throwables;
import java.sql.SQLException;
import java.util.concurrent.RejectedExecutionException;
import oracle.dbtools.raptor.liquibase.service.LbThread;

public abstract class LbRunnable
implements Runnable {
    public abstract void runJob() throws RejectedExecutionException;

    private void checkConnection() {
        block4: {
            if (Thread.currentThread() instanceof LbThread) {
                try {
                    if (((LbThread)Thread.currentThread()).getConnection() == null || ((LbThread)Thread.currentThread()).getConnection().isClosed()) {
                        throw new RejectedExecutionException("No connection available to run job");
                    }
                    break block4;
                }
                catch (SQLException e) {
                    throw new RejectedExecutionException(Throwables.getStackTraceAsString((Throwable)e), e);
                }
            }
            throw new RejectedExecutionException("LbRunnable can only run with an LbThread!!?!?");
        }
    }

    @Override
    public void run() {
        this.checkConnection();
        this.runJob();
    }
}

