/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator.changesets.data;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.sql.RowId;
import liquibase.exception.LiquibaseException;
import lombok.Generated;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.raptor.liquibase.core.ActiveCommand;
import oracle.dbtools.raptor.liquibase.util.LbFileUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import org.apache.commons.io.FilenameUtils;

public class ChangeData {
    public static final boolean isDISABLETRANS = false;
    private static final String SQL_EXT = ".sql";
    private String OTYPE;
    private String ONAME;
    private String DDL;
    private String FILENAME;
    private String SQLFILENAME;
    private boolean OVERWRITEFILES = false;
    private File FILE;
    private String CHANGELOG;
    private File SQLFILE;
    private boolean OUTPUTDEFAULTSCHEMA;
    private String SCHEMA;
    private String DEFAULTSCHEMANAME;
    private String CHANGETYPE = "XML";
    private boolean isSQL = false;
    private String CONTEXT;
    private String LABEL;
    private ScriptRunnerContext ctx;
    private boolean isSPLIT = false;
    private boolean isFAIL = false;
    private boolean isREPLACE = false;
    private boolean isRUNONCHANGE = false;
    private boolean isRUNALWAYS = false;
    private RowId rowId = null;

    public ChangeData(ActiveCommand ac) throws LiquibaseException {
        this.OTYPE = (String)ac.getOptionValue(LBOptions.Options.OBJECT_TYPE);
        this.ONAME = (String)ac.getOptionValue(LBOptions.Options.OBJECT_NAME);
        this.DDL = (String)ac.getOptionValue(LBOptions.Options.DDL);
        if (this.ONAME != null) {
            this.ONAME = this.ONAME.replace(".", "_").replace("/", "_").toUpperCase();
        }
        this.OVERWRITEFILES = (Boolean)ac.getOptionValue(LBOptions.Options.OVERWRITE_FILES);
        this.CHANGELOG = (String)ac.getOptionValue(LBOptions.Options.CHANGELOG_FILE);
        this.CHANGETYPE = (String)ac.getOptionValue(LBOptions.Options.CHANGE_TYPE);
        this.isSPLIT = ac.isFlagSet((Id)ApexOptions.Symbol.SPLIT);
        this.isSQL = ac.isFlagSet(LBOptions.Options.SQL);
        this.ctx = ac.getContext();
        this.OUTPUTDEFAULTSCHEMA = ac.isFlagSet(LBOptions.Options.OUTPUT_DEFAULT_SCHEMA);
        this.SCHEMA = ac.getActiveConn().getConnectionUserName();
        this.DEFAULTSCHEMANAME = (String)ac.getOptionValue(LBOptions.Options.DEFAULT_SCHEMA_NAME);
        this.CONTEXT = (String)ac.getOptionValue(LBOptions.Options.CONTEXTS);
        this.LABEL = (String)ac.getOptionValue(LBOptions.Options.LABELS);
        this.isFAIL = ac.isFlagSet(LBOptions.Options.FAIL_ON_ERROR);
        this.isREPLACE = ac.isFlagSet(LBOptions.Options.REPLACE);
        this.isRUNONCHANGE = ac.isFlagSet(LBOptions.Options.RUNONCHANGE);
        this.isRUNALWAYS = ac.isFlagSet(LBOptions.Options.RUNALWAYS);
        this.setFileNames();
    }

    public ChangeData() {
    }

    public void setObject(String name, String type) throws LiquibaseException {
        if (name == null || type == null) {
            throw new LiquibaseException("Object name and type must be specified.");
        }
        this.ONAME = name.replace(".", "_").replace("/", "_").replace("|", "_").replace("'", "_");
        this.OTYPE = type;
        this.setFileNames();
    }

    private void setFileNames() throws LiquibaseException {
        if (this.OTYPE == null || this.ONAME == null) {
            return;
        }
        try {
            boolean shorten;
            if (this.CHANGETYPE == null) {
                this.CHANGETYPE = "XML";
            }
            Object cleanName = this.removeSpecialChars((this.ONAME + (String)((shorten = LbUtils.getParameter("SHORTEN_SPLIT").equalsIgnoreCase("ON")) ? "" : "_" + this.OTYPE)).toLowerCase() + "." + this.CHANGETYPE.toLowerCase());
            if (this.isSPLIT) {
                cleanName = this.OTYPE.toLowerCase() + File.separator + (String)cleanName;
            }
            this.FILENAME = (String)cleanName + "." + this.CHANGETYPE.toLowerCase();
            this.FILE = LbFileUtils.getFile(this.OVERWRITEFILES, this.FILENAME, this.ctx);
            this.FILENAME = this.FILE.toString().replace(LbUtils.getCWD() + File.separator, "");
            if (this.isSQL) {
                this.SQLFILENAME = this.FILE.toString().replace("." + this.CHANGETYPE.toLowerCase(), this.CHANGETYPE.equalsIgnoreCase("SQL") ? "_sql.sql" : SQL_EXT);
                this.SQLFILE = LbFileUtils.getFile(this.OVERWRITEFILES, this.SQLFILENAME, this.ctx);
                this.SQLFILENAME = FilenameUtils.getName((String)this.SQLFILE.toString());
            }
        }
        catch (IOException e) {
            throw new LiquibaseException(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private String removeSpecialChars(String FileName) {
        if (FileName == null) {
            return null;
        }
        if (FilenameUtils.getExtension((String)FileName) != null && !FilenameUtils.getExtension((String)FileName).isEmpty()) {
            String extension = "." + FilenameUtils.getExtension((String)FileName);
            return this.cleanString(FileName.replace(extension, ""));
        }
        return this.cleanString(FileName);
    }

    private String cleanString(String name) {
        return name.replace(".", "_").replace("/", "_").replace("|", "_").replace("'", "_");
    }

    @Generated
    public String getOTYPE() {
        return this.OTYPE;
    }

    @Generated
    public String getONAME() {
        return this.ONAME;
    }

    @Generated
    public String getDDL() {
        return this.DDL;
    }

    @Generated
    public String getFILENAME() {
        return this.FILENAME;
    }

    @Generated
    public String getSQLFILENAME() {
        return this.SQLFILENAME;
    }

    @Generated
    public boolean isOVERWRITEFILES() {
        return this.OVERWRITEFILES;
    }

    @Generated
    public File getFILE() {
        return this.FILE;
    }

    @Generated
    public String getCHANGELOG() {
        return this.CHANGELOG;
    }

    @Generated
    public File getSQLFILE() {
        return this.SQLFILE;
    }

    @Generated
    public boolean isOUTPUTDEFAULTSCHEMA() {
        return this.OUTPUTDEFAULTSCHEMA;
    }

    @Generated
    public String getSCHEMA() {
        return this.SCHEMA;
    }

    @Generated
    public String getDEFAULTSCHEMANAME() {
        return this.DEFAULTSCHEMANAME;
    }

    @Generated
    public String getCHANGETYPE() {
        return this.CHANGETYPE;
    }

    @Generated
    public boolean isSQL() {
        return this.isSQL;
    }

    @Generated
    public String getCONTEXT() {
        return this.CONTEXT;
    }

    @Generated
    public String getLABEL() {
        return this.LABEL;
    }

    @Generated
    public ScriptRunnerContext getCtx() {
        return this.ctx;
    }

    @Generated
    public boolean isSPLIT() {
        return this.isSPLIT;
    }

    @Generated
    public boolean isFAIL() {
        return this.isFAIL;
    }

    @Generated
    public boolean isREPLACE() {
        return this.isREPLACE;
    }

    @Generated
    public boolean isRUNONCHANGE() {
        return this.isRUNONCHANGE;
    }

    @Generated
    public boolean isRUNALWAYS() {
        return this.isRUNALWAYS;
    }

    @Generated
    public RowId getRowId() {
        return this.rowId;
    }

    @Generated
    public void setDDL(String DDL) {
        this.DDL = DDL;
    }

    @Generated
    public void setFILENAME(String FILENAME) {
        this.FILENAME = FILENAME;
    }

    @Generated
    public void setSQLFILENAME(String SQLFILENAME) {
        this.SQLFILENAME = SQLFILENAME;
    }

    @Generated
    public void setOVERWRITEFILES(boolean OVERWRITEFILES) {
        this.OVERWRITEFILES = OVERWRITEFILES;
    }

    @Generated
    public void setFILE(File FILE) {
        this.FILE = FILE;
    }

    @Generated
    public void setCHANGELOG(String CHANGELOG) {
        this.CHANGELOG = CHANGELOG;
    }

    @Generated
    public void setSQLFILE(File SQLFILE) {
        this.SQLFILE = SQLFILE;
    }

    @Generated
    public void setOUTPUTDEFAULTSCHEMA(boolean OUTPUTDEFAULTSCHEMA) {
        this.OUTPUTDEFAULTSCHEMA = OUTPUTDEFAULTSCHEMA;
    }

    @Generated
    public void setSCHEMA(String SCHEMA) {
        this.SCHEMA = SCHEMA;
    }

    @Generated
    public void setDEFAULTSCHEMANAME(String DEFAULTSCHEMANAME) {
        this.DEFAULTSCHEMANAME = DEFAULTSCHEMANAME;
    }

    @Generated
    public void setCHANGETYPE(String CHANGETYPE) {
        this.CHANGETYPE = CHANGETYPE;
    }

    @Generated
    public void setSQL(boolean isSQL) {
        this.isSQL = isSQL;
    }

    @Generated
    public void setCONTEXT(String CONTEXT) {
        this.CONTEXT = CONTEXT;
    }

    @Generated
    public void setLABEL(String LABEL) {
        this.LABEL = LABEL;
    }

    @Generated
    public void setCtx(ScriptRunnerContext ctx) {
        this.ctx = ctx;
    }

    @Generated
    public void setSPLIT(boolean isSPLIT) {
        this.isSPLIT = isSPLIT;
    }

    @Generated
    public void setFAIL(boolean isFAIL) {
        this.isFAIL = isFAIL;
    }

    @Generated
    public void setREPLACE(boolean isREPLACE) {
        this.isREPLACE = isREPLACE;
    }

    @Generated
    public void setRUNONCHANGE(boolean isRUNONCHANGE) {
        this.isRUNONCHANGE = isRUNONCHANGE;
    }

    @Generated
    public void setRUNALWAYS(boolean isRUNALWAYS) {
        this.isRUNALWAYS = isRUNALWAYS;
    }

    @Generated
    public void setRowId(RowId rowId) {
        this.rowId = rowId;
    }
}

