/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.task;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.transfer.task.TransferTaskProgressListener;
import oracle.dbtools.util.Logger;

public class TransferTaskProgressMonitor
implements TransferTaskProgressListener {
    private TransferTaskProgressMonitor parent;
    private int op;
    private String source;
    private String destination;
    private long max;
    private volatile long count;
    private volatile long prevReportedCount;
    private boolean maxIsSet;
    private boolean taskCancelled;
    public long start;
    public volatile long prevReportedTime;
    public long reportByteInterval;
    protected DecimalFormat df = new DecimalFormat("#00.0000");
    private List<TransferTaskProgressListener> listeners = new ArrayList<TransferTaskProgressListener>();
    private long progressOffset;

    public TransferTaskProgressMonitor(TransferTaskProgressMonitor parent) {
        this.parent = parent;
    }

    public TransferTaskProgressMonitor getParent() {
        return this.parent;
    }

    public void addListener(TransferTaskProgressListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(TransferTaskProgressListener listener) {
        this.listeners.remove(listener);
    }

    public int getOp() {
        return this.op;
    }

    public String getOpAsString() {
        return 0 == this.op ? "put" : "get";
    }

    public String getSource() {
        return this.source;
    }

    public String getDestination() {
        return this.destination;
    }

    public long getMax() {
        return this.max;
    }

    public void setMax(long max) {
        this.max += max;
        this.maxIsSet = true;
        if (this.parent != null) {
            this.parent.setMax(max);
        }
    }

    public long getCount() {
        return this.progressOffset + this.count;
    }

    public boolean isTaskCancelled() {
        return this.taskCancelled;
    }

    public void setTaskCancelled(boolean taskCancelled) {
        this.taskCancelled = taskCancelled;
    }

    public void stateChanged(RaptorTaskEvent event) {
        switch (event.getTaskDescriptor().getStatus()) {
            case PAUSED: {
                break;
            }
            case RUNNABLE: {
                break;
            }
            case FINISHED: {
                if (!event.getTaskDescriptor().isCancelled()) break;
                this.taskCancelled(event);
                break;
            }
            case NEW: {
                break;
            }
            case FAILED: {
                if (!event.getTaskDescriptor().isCancelled()) break;
                this.taskCancelled(event);
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(event.getTaskDescriptor().getStatus()));
            }
        }
        for (TransferTaskProgressListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    private void taskCancelled(RaptorTaskEvent event) {
        this.setTaskCancelled(true);
    }

    public void progressChanged(RaptorTaskEvent event) {
        for (TransferTaskProgressListener listener : this.listeners) {
            listener.progressChanged(event);
        }
    }

    public void messageChanged(RaptorTaskEvent event) {
        for (TransferTaskProgressListener listener : this.listeners) {
            listener.messageChanged(event);
        }
    }

    @Override
    public void init(int op, String src, String dest, long max) {
        if (this.parent != null) {
            this.parent.init(op, src, dest, max);
            Logger.finer(this.getClass(), (String)(this.getOpAsString() + ", " + src + ", " + dest + ", " + max));
        } else {
            Logger.fine(this.getClass(), (String)(this.getOpAsString() + ", " + src + ", " + dest + ", " + max));
        }
        if (!this.maxIsSet) {
            this.max += max;
        }
        for (TransferTaskProgressListener listener : this.listeners) {
            listener.init(op, src, dest, max);
        }
        if (this.start == 0L) {
            this.op = op;
            this.source = src;
            this.destination = dest;
            this.prevReportedTime = this.start = System.nanoTime();
            this.prevReportedCount = this.count;
        }
    }

    @Override
    public synchronized boolean count(long count) {
        boolean ok = true;
        this.count += count;
        if (this.parent != null) {
            ok = this.parent.count(count, "TransferTaskTotal");
        }
        for (TransferTaskProgressListener listener : this.listeners) {
            listener.count(count);
        }
        if (null == this.parent && this.reportByteInterval > 0L && this.count > this.prevReportedCount + this.reportByteInterval) {
            Logger.info(this.getClass(), (String)this.logStatus());
        }
        return ok && !this.isTaskCancelled();
    }

    private boolean count(long childCount, String childDestination) {
        String myDestination = this.destination;
        this.destination = childDestination;
        boolean ok = this.count(childCount);
        this.destination = myDestination;
        return ok;
    }

    @Override
    public synchronized void end() {
        if (null == this.parent) {
            if (0L == this.reportByteInterval) {
                Logger.info(this.getClass(), (String)this.logStatus());
            } else {
                long maxTransferCount = this.max - 2L * this.progressOffset;
                long nextReportCount = this.prevReportedCount + this.reportByteInterval;
                if (maxTransferCount < nextReportCount) {
                    Logger.info(this.getClass(), (String)this.logStatus());
                }
            }
            Logger.fine(this.getClass(), (String)(this.getOpAsString() + ", " + this.source + ", " + this.destination + ", " + this.max));
        } else {
            Logger.finer(this.getClass(), (String)(this.getOpAsString() + ", " + this.source + ", " + this.destination + ", " + this.max));
            this.parent.end("TransferTaskTotal");
        }
        for (TransferTaskProgressListener listener : this.listeners) {
            listener.end();
        }
    }

    private void end(String childDestination) {
        String myDestination = this.destination;
        this.destination = childDestination;
        this.end();
        this.destination = myDestination;
    }

    private synchronized String logStatus() {
        long now = System.nanoTime();
        double elapsed = (double)(now - this.prevReportedTime) / 1.0E9;
        long sent = this.count - this.prevReportedCount;
        if (0L == sent) {
            return "";
        }
        double size = (double)sent / 1048576.0;
        double rate = size / elapsed;
        double elapsedT = (double)(now - this.start) / 1.0E9;
        double sizeT = (double)this.count / 1048576.0;
        double rateT = sizeT / elapsedT;
        String format = "%s %s %s + %sMiB / %ss = %s MiB/s Total: %sMiB / %ss = %s MiB/s";
        String msg = String.format(format, Integer.toHexString(this.hashCode()), this.parent == null ? "0" : Integer.toHexString(this.parent.hashCode()), this.destination, this.df.format(size), this.df.format(elapsed), this.df.format(rate), this.df.format(sizeT), this.df.format(elapsedT), this.df.format(rateT));
        this.prevReportedTime = now;
        this.prevReportedCount = this.count;
        return msg;
    }

    public void setProgressOffset(long theProgressOffset) {
        this.progressOffset = theProgressOffset;
        if (this.parent != null) {
            this.parent.setProgressOffset(theProgressOffset);
        }
    }
}

