/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.net.commands.objectstorage;

import java.nio.file.Path;
import oracle.dbtools.core.oci.AuthenticationProvider;
import oracle.dbtools.core.oci.OCIUtils;
import oracle.dbtools.core.oci.objectstorage.OCIObjectStorageClient;
import oracle.dbtools.core.oci.objectstorage.ObjectDetails;
import oracle.dbtools.core.oci.objectstorage.ObjectPutOptions;
import oracle.dbtools.core.oci.objectstorage.ObjectPutResult;
import oracle.dbtools.core.oci.objectstorage.ObjectStorageException;
import oracle.dbtools.net.commands.objectstorage.ObjectStorageCommandException;
import oracle.dbtools.net.commands.objectstorage.ObjectStorageMessages;
import oracle.dbtools.net.commands.objectstorage.ObjectStorageModel;
import oracle.dbtools.net.commands.objectstorage.ObjectStorageOptions;

public class ObjectPut {
    private final ObjectStorageModel model;
    private static final String NEW_LINE = System.getProperty("line.separator");

    public ObjectPut(ObjectStorageModel model) throws ObjectStorageCommandException {
        this.validate(model);
        this.model = model;
    }

    public void execute() {
        try {
            OCIObjectStorageClient client = OCIObjectStorageClient.builder((AuthenticationProvider)this.model.profile()).build();
            Path filePath = this.model.filePath();
            String objectName = this.model.optionValue(ObjectStorageOptions.Symbol.OBJECT_NAME);
            ObjectPutOptions options = this.getOptions();
            ObjectPutResult result = client.putObject(options);
            if (result != null) {
                int httpStatusCode = result.getStatusCode();
                if (httpStatusCode == 200) {
                    this.model.context().writeln(ObjectStorageMessages.format("OBJECT_PUT_SUCCESS", filePath, result.getObjectName()));
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append(ObjectStorageMessages.format("ERR_UPLOAD_FILE", filePath, objectName));
                    sb.append(NEW_LINE);
                    sb.append(ObjectStorageMessages.format("STATUS_CODE", httpStatusCode));
                    this.model.context().writeln(sb.toString());
                }
            }
        }
        catch (ObjectStorageException e) {
            this.model.context().writeln(e.getLocalizedMessage());
        }
    }

    private ObjectPutOptions getOptions() {
        Path filePath = this.model.filePath();
        ObjectPutOptions.Builder options = (ObjectPutOptions.Builder)((ObjectPutOptions.Builder)((ObjectPutOptions.Builder)((ObjectPutOptions.Builder)((ObjectPutOptions.Builder)((ObjectPutOptions.Builder)((ObjectPutOptions.Builder)((ObjectPutOptions.Builder)ObjectPutOptions.builder((String)this.model.namespace(), (String)this.model.bucketName(), (Path)filePath).cacheControl(this.model.optionValue(ObjectStorageOptions.Symbol.CACHE_CONTROL))).contentDisposition(this.model.optionValue(ObjectStorageOptions.Symbol.CONTENT_DISPOSITION))).contentEncoding(this.model.optionValue(ObjectStorageOptions.Symbol.CONTENT_ENCODING))).contentLanguage(this.model.optionValue(ObjectStorageOptions.Symbol.CONTENT_LANGUAGE))).contentMD5(this.model.optionValue(ObjectStorageOptions.Symbol.CONTENT_MD5))).contentType(this.model.optionValue(ObjectStorageOptions.Symbol.CONTENT_TYPE))).eTag(this.model.optionValue(ObjectStorageOptions.Symbol.ETAG))).objectName(this.model.optionValue(ObjectStorageOptions.Symbol.OBJECT_NAME)).opcClientRequestId(this.model.optionValue(ObjectStorageOptions.Symbol.CLIENT_REQUEST_ID));
        boolean overwrite = this.model.optionBooleanValue(ObjectStorageOptions.Symbol.OVERWRITE);
        boolean noOverWrite = !overwrite;
        options.noOverwrite(noOverWrite);
        String checksumAlg = this.model.optionValue(ObjectStorageOptions.Symbol.CHECKSUM_ALGORITHM);
        String checksumContent = this.model.optionValue(ObjectStorageOptions.Symbol.CHECKSUM_CONTENT);
        ObjectDetails.ChecksumAlgorithm checksumAlgorithm = null;
        if (!OCIUtils.isEmpty((String)checksumAlg) && !OCIUtils.isEmpty((String)checksumContent)) {
            checksumAlg = checksumAlg.toUpperCase();
            try {
                checksumAlgorithm = ObjectDetails.ChecksumAlgorithm.valueOf((String)checksumAlg);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (checksumAlgorithm != null) {
                options.checksumAlgorithm(checksumAlgorithm).checksumContent(checksumContent);
            }
        }
        String storTier = this.model.optionValue(ObjectStorageOptions.Symbol.STORAGE_TIER);
        ObjectDetails.StorageTier storageTier = null;
        if (!OCIUtils.isEmpty((String)storTier)) {
            if (ObjectDetails.StorageTier.Standard.toString().equalsIgnoreCase(storTier)) {
                storageTier = ObjectDetails.StorageTier.Standard;
            } else if (ObjectDetails.StorageTier.InfrequentAccess.toString().equalsIgnoreCase(storTier)) {
                storageTier = ObjectDetails.StorageTier.InfrequentAccess;
            } else if (ObjectDetails.StorageTier.Archive.toString().equalsIgnoreCase(storTier)) {
                storageTier = ObjectDetails.StorageTier.Archive;
            }
            options.storageTier(storageTier);
        }
        return options.build();
    }

    private void validate(ObjectStorageModel model) throws ObjectStorageCommandException {
        StringBuilder sb = new StringBuilder();
        if (OCIUtils.isEmpty((String)model.namespace())) {
            sb.append(ObjectStorageMessages.get("ERR_REQUIRE_OPTION_NAMESPACE")).append(NEW_LINE);
        }
        if (OCIUtils.isEmpty((String)model.bucketName())) {
            sb.append(ObjectStorageMessages.get("ERR_REQUIRE_OPTION_BUCKETNAME")).append(NEW_LINE);
        }
        if (OCIUtils.isEmpty((String)model.optionValue(ObjectStorageOptions.Symbol.FILE))) {
            sb.append(ObjectStorageMessages.get("ERR_REQUIRE_OPTION_FILE")).append(NEW_LINE);
        }
        if (!OCIUtils.isEmpty((String)model.optionValue(ObjectStorageOptions.Symbol.CHECKSUM_ALGORITHM)) && OCIUtils.isEmpty((String)model.optionValue(ObjectStorageOptions.Symbol.CHECKSUM_CONTENT))) {
            sb.append(ObjectStorageMessages.get("ERR_CHECKSUM_CONTENT_MISSING")).append(NEW_LINE);
        }
        if (!OCIUtils.isEmpty((String)model.optionValue(ObjectStorageOptions.Symbol.CHECKSUM_CONTENT)) && OCIUtils.isEmpty((String)model.optionValue(ObjectStorageOptions.Symbol.CHECKSUM_ALGORITHM))) {
            sb.append(ObjectStorageMessages.get("ERR_CHECKSUM_ALGORITHM_MISSING")).append(NEW_LINE);
        }
        boolean overwrite = model.optionBooleanValue(ObjectStorageOptions.Symbol.OVERWRITE);
        String eTag = model.optionValue(ObjectStorageOptions.Symbol.ETAG);
        if (!overwrite && !OCIUtils.isEmpty((String)eTag)) {
            sb.append(ObjectStorageMessages.format("ERR_ETAG_NO_OVERWRITE", eTag)).append(NEW_LINE);
        }
        if (sb.length() > 0) {
            throw new ObjectStorageCommandException(sb.toString());
        }
    }
}

