/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.net.commands;

import java.io.IOException;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;
import javax.sql.DataSource;
import oracle.dbtools.core.jdbc.DataSourceBuilder;
import oracle.dbtools.core.jdbc.OracleDataSources;
import oracle.dbtools.core.oci.AuthenticationProvider;
import oracle.dbtools.core.oci.OCIDBToolsConnection;
import oracle.dbtools.core.oci.OCIDatabaseClient;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.OCIProfiles;
import oracle.dbtools.core.oci.search.OCISearchClient;
import oracle.dbtools.core.oci.search.ResourceQuery;
import oracle.dbtools.core.oci.search.SearchResult;
import oracle.dbtools.core.proxy.ProxyChecker;
import oracle.dbtools.net.commands.CommandMessages;
import oracle.dbtools.net.commands.OCICommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.FlagValue;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.AbstractConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.ProxyProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.RestProperty;

public class OCIConnector
extends AbstractConnector {
    private static final String OCI_REGION_NAME = "oci.region.name";
    private static final String OCI_SQLCL_CONFIG_FILE = "OCI_SQLCL_CONFIG_FILE";

    public OCIConnector(ConnectorArgs args) {
        super(args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection connect() {
        Connection conn = null;
        try {
            boolean isRest;
            ScriptExecutor sqlcl = (ScriptExecutor)this.ctx.getProperty("runner");
            if (sqlcl != null && sqlcl.getConn() != null) {
                this.OCIConnClear(this.ctx);
            }
            OCIProfiles profiles = OCIProfiles.builder().build();
            String profile = (String)this.ctx.getProperty("oci.profile.name");
            if (profile == null) {
                throw new IllegalStateException(CommandMessages.getString("OCI_PROFILE_NOT_SET"));
            }
            OCIProfile ociProfile = profiles.getProfile(profile);
            if (ociProfile == null) {
                throw new IllegalStateException(CommandMessages.format("OCI_PROFILE_NOT_VALID", profile));
            }
            String region = (String)this.ctx.getProperty(OCI_REGION_NAME);
            if (region == null) {
                region = OCICommand.set_region_home(ociProfile, this.ctx);
            }
            String spec = this.connectionSpec.toLowerCase();
            boolean bl = isRest = this.properties.getValueOf((Property)RestProperty.REST) == FlagValue.PRESENT;
            if (!isRest) {
                String ocid;
                if (this.isOCID(spec, this.ctx)) {
                    this.validateDatabaseToolsConnectionOCID(spec, this.ctx);
                    ocid = spec;
                } else {
                    Collection connections;
                    OCISearchClient searchClient = ((OCISearchClient.Builder)OCISearchClient.builder((OCIProfile)ociProfile).region(region)).build();
                    try {
                        connections = searchClient.listResources(ResourceQuery.databaseToolsQuery((ResourceQuery.ResourceQueryConstraint)ResourceQuery.matchConstraint((String)"displayName", (String)spec)));
                        if (connections.isEmpty()) {
                            throw new IllegalStateException(CommandMessages.getString("OCI_INCORRENT_OCID_OR_DISPLAY_NAME"));
                        }
                        if (connections.size() > 1) {
                            throw new IllegalStateException(CommandMessages.getString("OCI_DUPLICATE_DISPLAY_NAME"));
                        }
                    }
                    catch (RuntimeException e) {
                        throw new IllegalStateException(e.getLocalizedMessage());
                    }
                    ocid = ((SearchResult)connections.stream().findFirst().get()).getResourceId();
                }
                OCIDatabaseClient.Builder dbClientBuilder = (OCIDatabaseClient.Builder)OCIDatabaseClient.builder((AuthenticationProvider)ociProfile).region(region);
                ProxyChecker.Builder proxyBuilder = ProxyChecker.builder();
                URI proxy = (URI)this.properties.getValueOf((Property)ProxyProperty.PROXY);
                if (proxy != null) {
                    proxyBuilder.proxy(proxy);
                    proxyBuilder.nonProxyHosts(System.getProperty("dbtools.system_http_non_proxy_hosts"));
                }
                dbClientBuilder.proxy(proxyBuilder.build());
                OCIDatabaseClient dbClient = dbClientBuilder.build();
                OCIDBToolsConnection dbToolsConn = dbClient.createDBToolsConnection(ocid);
                if (dbToolsConn.getDatabaseType() != OCIDBToolsConnection.DatabaseType.ORACLE) throw new IllegalStateException("Unsupported database type: " + String.valueOf(dbToolsConn.getDatabaseType()));
                DataSource dataSource = dbClient.createDataSource((DataSourceBuilder)OracleDataSources.instance().builder(), dbToolsConn).build();
                return dataSource.getConnection();
            }
            if (!this.isOCID(spec, this.ctx)) return conn;
            this.validateDatabaseToolsConnectionOCID(spec, this.ctx);
            String ocid = spec;
            String config_filepath = this.ctx.getProperty(OCI_SQLCL_CONFIG_FILE) != null ? (String)this.ctx.getProperty(OCI_SQLCL_CONFIG_FILE) : "~/.oci/config";
            Properties props = new Properties();
            props.put("oci_config_filepath", config_filepath);
            props.put("oci_profile", profile);
            props.put("region", region);
            Connection restConnection = DriverManager.getConnection(ocid, props);
            this.setConnection(this.ctx, props, restConnection);
            return restConnection;
        }
        catch (IOException | IllegalStateException | SQLException e) {
            this.ctx.write(e.getLocalizedMessage());
            return conn;
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            this.ctx.write(t.getLocalizedMessage());
        }
        return conn;
    }

    private void OCIConnClear(ScriptRunnerContext ctx) {
        ScriptExecutor sqlcl = (ScriptExecutor)ctx.getProperty("runner");
        sqlcl.setConn(null);
        ctx.setCurrentConnection(null);
        ctx.setBaseConnection(null);
        ctx.putProperty("script.runner.sqlplus.nolog", (Object)Boolean.TRUE);
        ctx.putProperty("cli.conn.props", null);
    }

    private boolean isOCID(String spec, ScriptRunnerContext ctx) {
        String[] parts = spec.replace("\n", "").split("\\.");
        return parts[0].contains("ocid");
    }

    private void validateDatabaseToolsConnectionOCID(String ocid, ScriptRunnerContext ctx) throws IllegalStateException {
        if (ocid.contains(":") && ocid.substring(0, 4).equalsIgnoreCase("ocid")) {
            throw new IllegalStateException(CommandMessages.getString("OCI_INCORRECT_OCID"));
        }
        String[] parts = ocid.replace("\n", "").split("\\.");
        if (!parts[1].equalsIgnoreCase("databasetoolsconnection")) {
            throw new IllegalStateException(CommandMessages.getString("OCI_INCORRECT_OCID") + CommandMessages.format("OCI_INCORRECT_PROVIDED_OCID", parts[1]));
        }
    }

    private void setConnection(ScriptRunnerContext ctx, Properties props, Connection conn) throws SQLException {
        ScriptExecutor sqlcl = (ScriptExecutor)ctx.getProperty("runner");
        if (sqlcl != null) {
            if (conn != null) {
                sqlcl.setConn(conn);
                sqlcl.getScriptRunnerContext().setCurrentConnection(conn);
                sqlcl.getScriptRunnerContext().setBaseConnection(conn);
                sqlcl.getScriptRunnerContext().putProperty("script.runner.sqlplus.nolog", (Object)Boolean.FALSE);
                ctx.putProperty("cli.conn.props", (Object)props);
            } else {
                ctx.write(CommandMessages.getString("OCI_CONN_FAILED"));
            }
        }
    }
}

