/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.extension.mcp.exceptions.ArgumentException;
import oracle.dbtools.extension.mcp.exceptions.AuditTableException;
import oracle.dbtools.extension.mcp.schemas.Schemas;
import oracle.dbtools.extension.mcp.tools.McpTool;
import oracle.dbtools.extension.mcp.utils.McpUtils;
import oracle.dbtools.extension.mcp.utils.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.runner.SqlClCommandsRunner;

public class RunSqlCLTool
implements McpTool {
    private final String toolName = "run-sqlcl";

    @Override
    public McpServerFeatures.SyncToolSpecification create(ScriptRunnerContext ctx) {
        return new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool("run-sqlcl", "This tool executes SQLcl commands in the SQLcl CLI. If the given command requires a database connection, it prompts the user to connect using the connect tool.\nYou should:\n\n\tExecute the provided SQLcl command.\n\n\tReturn the results.\n\nArgs:\n\n\tsql: The SQLcl command to execute.\n\nReturns:\n\n\tCommand results.\n" + McpUtils.MCP_FIXED_ARGS_PROMPT + "\n" + McpUtils.MCP_MESSAGE_NOTE, Schemas.getSchema(Schemas.SchemaName.RUN_SQL_CL_SCHEMA)), (exchange, arguments) -> {
            ArrayList<McpSchema.TextContent> contents = new ArrayList<McpSchema.TextContent>();
            try {
                String sql = McpUtils.requiredArgument(arguments, "sqlcl");
                String model = McpUtils.optionalArgument(arguments, "model", McpUtils.MODEL_DEFAULT_VALUE);
                String mcp_client = exchange.getClientInfo().name();
                SqlClCommandsRunner sqlcl = SqlClCommandsRunner.builder().context(ctx).connection(ctx.getCurrentConnection()).build();
                if (ctx.getCurrentConnection() != null && !ctx.getCurrentConnection().isClosed()) {
                    try {
                        this.createMcpLogTable(ctx.getCurrentConnection());
                    }
                    catch (AuditTableException e) {
                        contents.add(new McpSchema.TextContent(e.getLocalizedMessage()));
                    }
                    QueryUtils.insertSessionInfo(ctx.getCurrentConnection(), "run-sqlcl", model);
                    QueryUtils.insertClientInfo(ctx.getCurrentConnection(), mcp_client);
                    QueryUtils.insertIntoDbtoolsMcpLog(ctx.getCurrentConnection(), mcp_client, model, "tool", "run-sqlcl", SqlRecognizer.reductPwd((String)sql));
                }
                ctx.putProperty("sql.format", (Object)McpUtils.MCP_RETURN_FORMAT);
                contents.add(new McpSchema.TextContent(sqlcl.run(sql)));
            }
            catch (SQLException | ArgumentException e) {
                return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("ERROR: " + ((Throwable)e).getLocalizedMessage()), new McpSchema.TextContent("\nBased on the error thrown, provide the user with a clear explanation of what went wrong. If possible, correct the issue and retry the request")), Boolean.valueOf(true));
            }
            return new McpSchema.CallToolResult(contents, Boolean.valueOf(false));
        });
    }
}

