/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.extension.mcp.schemas.Schemas;
import oracle.dbtools.extension.mcp.tools.McpTool;
import oracle.dbtools.extension.mcp.utils.ConnectionUtils;
import oracle.dbtools.extension.mcp.utils.McpUtils;
import oracle.dbtools.extension.mcp.utils.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ListConnectionsTool
implements McpTool {
    private final String toolName = "list-connections";

    @Override
    public McpServerFeatures.SyncToolSpecification create(ScriptRunnerContext ctx) {
        return new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool("list-connections", "List all available oracle named/saved connections in the connections storage" + McpUtils.MCP_FIXED_ARGS_PROMPT, Schemas.getSchema(Schemas.SchemaName.LIST_CONNECTIONS_SCHEMA)), (exchange, arguments) -> {
            McpSchema.TextContent content;
            try {
                String filter = McpUtils.optionalArgument(arguments, "filter", "");
                String model = McpUtils.optionalArgument(arguments, "model", McpUtils.MODEL_DEFAULT_VALUE);
                String mcp_client = exchange.getClientInfo().name();
                List connections = filter.isEmpty() ? ConnectionUtils.listAllConnectionNames().keySet().stream().toList() : this.subList(ConnectionUtils.listAllConnectionNames(), filter).keySet().stream().toList();
                if (ctx.getCurrentConnection() != null) {
                    QueryUtils.insertSessionInfo(ctx.getCurrentConnection(), "list-connections", model);
                    QueryUtils.insertClientInfo(ctx.getCurrentConnection(), mcp_client);
                    QueryUtils.insertIntoDbtoolsMcpLog(ctx.getCurrentConnection(), mcp_client, model, "tool", "list-connections", "Connect to " + ctx.getCurrentConnection().getSchema());
                }
                content = new McpSchema.TextContent(String.join((CharSequence)",", connections));
            }
            catch (SQLException e) {
                return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("ERROR: " + e.getLocalizedMessage()), new McpSchema.TextContent("\nBased on the error thrown, provide the user with a clear explanation of what went wrong. If possible, correct the issue and retry the request")), Boolean.valueOf(true));
            }
            return new McpSchema.CallToolResult(Collections.singletonList(content), Boolean.valueOf(false));
        });
    }

    private Map<String, String> subList(Map<String, String> list, String filter) {
        HashMap<String, String> out = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : list.entrySet()) {
            if (!entry.getKey().toLowerCase().contains(filter.toLowerCase()) && !entry.getValue().equalsIgnoreCase(filter)) continue;
            out.put(entry.getKey(), entry.getValue());
        }
        return out;
    }
}

