/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.extension.mcp.exceptions.ArgumentException;
import oracle.dbtools.extension.mcp.exceptions.AuditTableException;
import oracle.dbtools.extension.mcp.schemas.Schemas;
import oracle.dbtools.extension.mcp.tools.McpTool;
import oracle.dbtools.extension.mcp.utils.McpUtils;
import oracle.dbtools.extension.mcp.utils.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class DisconnectTool
implements McpTool {
    private final String toolName = "disconnect";

    @Override
    public McpServerFeatures.SyncToolSpecification create(ScriptRunnerContext ctx) {
        return new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool("disconnect", "This tool performs a disconnection from the current session in an Oracle database. If a user is connected, it logs out cleanly and returns to the SQL prompt without an active database connection." + McpUtils.MCP_FIXED_ARGS_PROMPT, Schemas.getSchema(Schemas.SchemaName.DISCONNECT_SCHEMA)), (exchange, arguments) -> {
            ArrayList<McpSchema.TextContent> contents;
            block7: {
                contents = new ArrayList<McpSchema.TextContent>();
                try {
                    String model = McpUtils.optionalArgument(arguments, "model", McpUtils.MODEL_DEFAULT_VALUE);
                    String mcp_client = exchange.getClientInfo().name();
                    if (model.isEmpty()) {
                        throw new ArgumentException("Model name argument is required");
                    }
                    if (mcp_client.isEmpty()) {
                        throw new ArgumentException("MCP Client name argument is required");
                    }
                    if (ctx.getCurrentConnection() != null && !ctx.getCurrentConnection().isClosed()) {
                        try {
                            this.createMcpLogTable(ctx.getCurrentConnection());
                        }
                        catch (AuditTableException e) {
                            contents.add(new McpSchema.TextContent(e.getLocalizedMessage()));
                        }
                        QueryUtils.insertSessionInfo(ctx.getCurrentConnection(), "disconnect", model);
                        QueryUtils.insertClientInfo(ctx.getCurrentConnection(), mcp_client);
                        QueryUtils.insertIntoDbtoolsMcpLog(ctx.getCurrentConnection(), mcp_client, model, "tool", "disconnect", "Disconnect from " + ctx.getCurrentConnection().getSchema());
                        ctx.getCurrentConnection().close();
                        ctx.setCurrentConnection(null);
                        contents.add(new McpSchema.TextContent("Successfully disconnected from database"));
                        break block7;
                    }
                    contents.add(new McpSchema.TextContent("No active database connection found"));
                }
                catch (SQLException | ArgumentException e) {
                    return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("ERROR: " + ((Throwable)e).getLocalizedMessage()), new McpSchema.TextContent("\nBased on the error thrown, provide the user with a clear explanation of what went wrong. If possible, correct the issue and retry the request")), Boolean.valueOf(true));
                }
            }
            return new McpSchema.CallToolResult(contents, Boolean.valueOf(false));
        });
    }
}

