/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FileUtils
extends Enum<FileUtils> {
    static final boolean IS_OS_WINDOWS;
    private static final /* synthetic */ FileUtils[] $VALUES;

    public static FileUtils[] values() {
        return (FileUtils[])$VALUES.clone();
    }

    public static FileUtils valueOf(String name) {
        return Enum.valueOf(FileUtils.class, name);
    }

    public static String expandUserHome(String path) {
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            return System.getProperty("user.home") + FileUtils.correctPath(IS_OS_WINDOWS, path.substring(1));
        }
        return path;
    }

    static String correctPath(boolean isWindows, String path) {
        if (isWindows) {
            path = path.replace('/', '\\');
        }
        return path;
    }

    public static boolean contentEquals(File f1, File f2) throws IOException {
        try (FileInputStream is1 = new FileInputStream(f1);){
            boolean bl;
            try (FileInputStream is2 = new FileInputStream(f2);){
                bl = FileUtils.contentEquals(is1, is2);
            }
            return bl;
        }
    }

    public static boolean contentEquals(InputStream is1, InputStream is2) throws IOException {
        int ch;
        if (!(is1 instanceof BufferedInputStream)) {
            is1 = new BufferedInputStream(is1);
        }
        if (!(is2 instanceof BufferedInputStream)) {
            is2 = new BufferedInputStream(is2);
        }
        while ((ch = is1.read()) != -1) {
            if (ch == is2.read()) continue;
            return false;
        }
        return is2.read() == -1;
    }

    public static long copy(InputStream source, OutputStream destination) throws IOException {
        int bytesRead;
        byte[] buf = new byte[8192];
        long totalBytes = 0L;
        while ((bytesRead = source.read(buf)) > 0) {
            destination.write(buf, 0, bytesRead);
            totalBytes += (long)bytesRead;
        }
        return totalBytes;
    }

    private static /* synthetic */ FileUtils[] $values() {
        return new FileUtils[0];
    }

    static {
        $VALUES = FileUtils.$values();
        boolean isOsWindows = false;
        try {
            isOsWindows = System.getProperty("os.name").startsWith("Windows");
        }
        catch (SecurityException e) {
            isOsWindows = false;
        }
        IS_OS_WINDOWS = isOsWindows;
    }
}

