/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.langdata.core.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.langdata.core.LangDataConfig;
import oracle.dbtools.extension.langdata.core.utils.LangDataQueryUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class LangUtils {
    public static final String ENV_OH = "ORACLE_HOME";
    protected static List<String> configParams;

    public static List<String> getConfigParams() {
        return configParams;
    }

    public static long getTimeInMilliSeconds(long startTime, long endTime) {
        return endTime - startTime;
    }

    public static void writeFile(String filename, String content, String directory) {
        try {
            boolean created;
            File dir = new File(directory);
            if (!dir.exists() && !(created = dir.mkdirs())) {
                LangDataConfig.getCurrentContext().writeln("Failed to create directory: " + directory);
                return;
            }
            File file = new File(dir, filename);
            try (FileWriter writer = new FileWriter(file);){
                writer.write(content);
                if (LangDataConfig.isVerbose()) {
                    LangDataConfig.getCurrentContext().writeln("File written to: " + file.getAbsolutePath());
                }
            }
        }
        catch (IOException e) {
            if (LangDataConfig.isDebug()) {
                LangDataConfig.getCurrentContext().writeln(Arrays.toString(e.getStackTrace()));
            }
            LangDataConfig.getCurrentContext().writeln(e.getLocalizedMessage());
        }
    }

    public static String getConfigNames(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String names = dbUtil.executeReturnOneCol(LangDataQueryUtils.getXMLQueries().getQuery("langdata.getconfignames", conn).getSql());
        return names;
    }

    public static void updateConfigParams(Connection conn) {
        String namesCsv = LangUtils.getConfigNames(conn);
        if (namesCsv != null && !namesCsv.trim().isEmpty()) {
            List dbNames = Arrays.stream(namesCsv.split(",")).map(String::trim).collect(Collectors.toList());
            configParams = dbNames;
        }
    }

    public static String getLangdataVersion(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("param_name", "LANG_DATA_SCHEMA_VERSION");
        String version = dbUtil.executeReturnOneCol(LangDataQueryUtils.getXMLQueries().getQuery("langdata.getconfigparam", conn).getSql(), binds);
        return version;
    }

    public static void moveResourceFolderToTemp(Class clazz, String resourceFolder, Path tempDir) throws IOException, URISyntaxException {
        ClassLoader classLoader = clazz.getClassLoader();
        URI resourceUri = classLoader.getResource(resourceFolder).toURI();
        if (resourceUri.getScheme().equals("jar")) {
            LangUtils.extractFolderFromJar(resourceUri, resourceFolder, tempDir);
        } else {
            LangUtils.copyFolderFromClasspath(Paths.get(resourceUri), tempDir);
        }
    }

    public static void storeToLogFile(String fileName, String fileOutput, String logDirectory) {
        if (logDirectory != null && !logDirectory.isEmpty()) {
            LangUtils.writeFile(fileName.substring(0, fileName.length() - 4) + ".log", fileOutput, logDirectory);
        }
    }

    public static boolean nameExtensionEquals(Path path, String ... extensions) {
        String fileName = path.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex > 0) {
            String extension = fileName.substring(dotIndex + 1);
            for (String ext : extensions) {
                if (!extension.equalsIgnoreCase(ext)) continue;
                return true;
            }
        }
        return false;
    }

    private static Path zipSlipCheck(ArchiveEntry entry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(entry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Bad entry: " + entry.getName());
        }
        return normalizePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decompressGz(Path source, Path target) throws IOException {
        if (Files.notExists(source, new LinkOption[0])) {
            throw new IOException("File doesn't exists!");
        }
        try (InputStream fi = Files.newInputStream(source, new OpenOption[0]);
             BufferedInputStream bi = new BufferedInputStream(fi);
             ZipArchiveInputStream ai = LangUtils.nameExtensionEquals(source, "zip") ? new ZipArchiveInputStream((InputStream)bi) : new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)bi));){
            ArchiveEntry entry;
            block20: while ((entry = ai.getNextEntry()) != null) {
                Path newPath = LangUtils.zipSlipCheck(entry, target);
                if (entry.isDirectory()) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                    continue;
                }
                Path parent = newPath.getParent();
                if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                OutputStream out = Files.newOutputStream(newPath, new OpenOption[0]);
                try {
                    byte[] buffer = new byte[8192];
                    while (true) {
                        int len;
                        if ((len = ai.read(buffer)) == -1) continue block20;
                        out.write(buffer, 0, len);
                    }
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
            return;
        }
    }

    private static void extractFolderFromJar(URI jarUri, String resourceFolder, Path tempDir) throws IOException {
        String[] jarPathParts = jarUri.toString().split("!");
        String jarFilePath = jarPathParts[0].substring("jar:file:".length());
        try (JarFile jarFile = new JarFile(jarFilePath);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                Path path;
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(resourceFolder) || entry.isDirectory()) continue;
                Path outputPath = tempDir.resolve(entry.getName().substring(resourceFolder.length()));
                if (!tempDir.toFile().exists()) {
                    Files.createDirectories(tempDir, new FileAttribute[0]);
                }
                if (!(path = Paths.get(String.valueOf(tempDir), String.valueOf(outputPath))).getParent().toFile().exists()) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                InputStream is = jarFile.getInputStream(entry);
                try {
                    OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
                    try {
                        is.transferTo(os);
                    }
                    finally {
                        if (os == null) continue;
                        os.close();
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
    }

    private static void copyFolderFromClasspath(Path source, Path destination) throws IOException {
        Files.walk(source, new FileVisitOption[0]).forEach(sourcePath -> {
            try {
                Path targetPath = destination.resolve(source.relativize((Path)sourcePath).toString());
                if (Files.isDirectory(sourcePath, new LinkOption[0])) {
                    Files.createDirectories(targetPath, new FileAttribute[0]);
                } else {
                    Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static String getTempDir() {
        String temp = System.getProperty("java.io.tmpdir");
        if (!temp.isEmpty() && '/' == temp.charAt(temp.length() - 1)) {
            return temp;
        }
        return temp + "/";
    }

    public static String getMountDir(String mountDir) {
        if (mountDir.endsWith("/")) {
            return mountDir.substring(0, mountDir.length() - 1);
        }
        return mountDir;
    }

    public static String getResourcesFileContent(Path filePath) throws IOException {
        String resourcePath = String.valueOf(filePath);
        if (System.getProperty("os.name").startsWith("Windows")) {
            resourcePath = resourcePath.replace("\\", "/");
        }
        try (InputStream installReleasesStream = LangUtils.class.getClassLoader().getResourceAsStream(resourcePath);){
            assert (installReleasesStream != null);
            String string = new String(installReleasesStream.readAllBytes());
            return string;
        }
    }

    public static void copyDirectoryContents(Path sourceDir, Path targetDir) throws IOException {
        if (!Files.exists(sourceDir, new LinkOption[0]) || !Files.isDirectory(sourceDir, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(sourceDir);){
            for (Path sourcePath : stream) {
                Path targetPath = targetDir.resolve(sourcePath.getFileName());
                if (Files.isDirectory(sourcePath, new LinkOption[0])) {
                    if (!Files.exists(targetPath, new LinkOption[0])) {
                        Files.createDirectories(targetPath, new FileAttribute[0]);
                    }
                    LangUtils.copyDirectoryContents(sourcePath, targetPath);
                    continue;
                }
                Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    static {
        try {
            configParams = Arrays.asList("LANG_DATA_REPORT_SIMILARITY_K", "LANG_DATA_VECTOR_TABLE_ENUMERATION_LIMIT", "LANG_DATA_SCHEMA_VERSION", "LANG_DATA_USING_CENTROID", "LANG_DATA_POST_VALIDATION_FUZZY_MATCH_THRESHOLD", "LANG_DATA_SEARCH_TYPE", "LANG_DATA_TESTING", "LANG_DATA_PREV_CONTEXT_LEN", "LANG_DATA_AUGMENT_QUERY_FUZZY_MATCH_THRESHOLD", "LANG_DATA_SAMPLE_QUERY_WEIGHT", "LANG_DATA_POST_CONTEXT_LEN", "LANG_DATA_CPU_LIMIT", "LANG_DATA_CPU_LIMIT_OTHER_GROUPS", "LANG_DATA_TABLESPACE_MIN_SIZE", "LANG_DATA_VALUE_VECTOR_TABLE_K", "LANG_DATA_NER_AUGMENTATION_ENABLED", "LANG_DATA_TABLESPACE_MAX_SIZE", "LANG_DATA_DRILLDOWN_SIMILARITY_K");
        }
        catch (Exception e) {
            LangDataConfig.getCurrentContext().writeln(e.getLocalizedMessage());
        }
    }
}

