/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.langdata.core.messages;

import java.io.IOException;
import oracle.dbtools.extension.langdata.core.LangDataConfig;
import oracle.dbtools.extension.langdata.core.messages.ConsoleColors;

public class GeneralMessages {
    static boolean flush = true;

    public static void errorMessage(ConsoleColors color, String message) {
        GeneralMessages.generalMessage(color, "ERROR: " + message);
        if (flush) {
            try {
                LangDataConfig.getCurrentContext().getOutputStream().getMainStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void errorMessage(String message) {
        GeneralMessages.errorMessage(ConsoleColors.RED, message);
    }

    public static void successMessage(ConsoleColors color, String message) {
        GeneralMessages.generalMessage(color, message);
    }

    public static void successMessage(String message) {
        GeneralMessages.successMessage(ConsoleColors.GREEN, message);
    }

    public static void progressMessage(ConsoleColors color, String message) {
        GeneralMessages.generalMessage(color, message);
    }

    public static void progressMessage(String message) {
        GeneralMessages.successMessage(ConsoleColors.WHITE_BOLD_BRIGHT, message);
    }

    public static void generalMessage(ConsoleColors color, String message) {
        LangDataConfig.getCurrentContext().writeln(color.code + message + ConsoleColors.RESET.code);
        if (flush) {
            try {
                LangDataConfig.getCurrentContext().getOutputStream().getMainStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void generalMessage(String message) {
        GeneralMessages.generalMessage(ConsoleColors.WHITE, message);
    }

    public static void printSuccessStatus(String step, String message, String status, long duration) {
        String dots2 = ".".repeat(50 - message.length());
        String formattedPart1 = String.format("%-6s", step);
        String formattedPart2 = String.format("%-50s", message + " " + dots2);
        String formattedPart3 = String.format("%-5s", status);
        String formattedPart4 = String.format("%-10s", "[ " + String.valueOf((double)duration / 1000.0) + "s ]");
        String formattedMessage = ConsoleColors.CYAN.code + formattedPart1 + ConsoleColors.RESET.code + " " + ConsoleColors.WHITE.code + formattedPart2 + ConsoleColors.RESET.code + " " + ConsoleColors.GREEN_BOLD_BRIGHT.code + formattedPart3 + ConsoleColors.RESET.code + " " + ConsoleColors.WHITE.code + formattedPart4;
        GeneralMessages.generalMessage(formattedMessage);
    }

    public static void printErrorStatus(String step, String message, String status) {
        String dots2 = ".".repeat(50 - message.length());
        String formattedPart1 = String.format("%-6s", step);
        String formattedPart2 = String.format("%-50s", message + " " + dots2);
        String formattedPart3 = String.format("%-5s", status);
        String formattedMessage = ConsoleColors.CYAN.code + formattedPart1 + ConsoleColors.RESET.code + " " + ConsoleColors.WHITE.code + formattedPart2 + ConsoleColors.RESET.code + " " + ConsoleColors.RED_BOLD_BRIGHT.code + formattedPart3;
        GeneralMessages.generalMessage(formattedMessage);
    }

    public static void printSkippedStatus(String step, String message, String status) {
        String dots2 = ".".repeat(50 - message.length());
        String formattedPart1 = String.format("%-6s", step);
        String formattedPart2 = String.format("%-50s", message + " " + dots2);
        String formattedPart3 = String.format("%-5s", status);
        String formattedMessage = ConsoleColors.CYAN.code + formattedPart1 + ConsoleColors.RESET.code + " " + ConsoleColors.WHITE.code + formattedPart2 + ConsoleColors.RESET.code + " " + ConsoleColors.YELLOW_BOLD_BRIGHT.code + formattedPart3;
        GeneralMessages.generalMessage(formattedMessage);
    }
}

