/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.xml.navigator;

import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.xml.navigator.IconElement;
import oracle.dbtools.xml.navigator.ItemDescriptor;
import oracle.dbtools.xml.navigator.LabelElement;
import oracle.xml.parser.v2.XMLNode;

public class ChildTypeElement
extends ItemDescriptor {
    private static final String FOLDER_ATTRIBUTE = "folder";
    private static final String SHOW_FOLDER = "showFolder";
    private static final String PROV_IMPL_CLASS = "provImplClass";
    private static final String NODE_TYPE = "nodeType";
    private ObjectQueries queries;
    private String nodeType;
    private String providerImplementationClass;
    private boolean showFolder;
    private LabelElement folderLabel;
    private IconElement folderIcon;

    ChildTypeElement(XMLNode node) {
        super(node);
        this.queries = new ObjectQueries(ChildTypeElement.getSingleElement("queries", node));
        this.nodeType = ChildTypeElement.getAttributeValue("", NODE_TYPE, node);
        this.providerImplementationClass = ChildTypeElement.getAttributeValue("", PROV_IMPL_CLASS, node);
        this.showFolder = ChildTypeElement.getBooleanValue("", SHOW_FOLDER, node);
        XMLNode folder = ChildTypeElement.getSingleElement(FOLDER_ATTRIBUTE, node);
        if (folder != null) {
            this.folderLabel = new LabelElement(folder);
            this.folderIcon = new IconElement(folder);
        }
    }

    public String getName() {
        return this.getID();
    }

    public ObjectQueries getQueries() {
        return this.queries;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String getProviderImplementationClass() {
        return this.providerImplementationClass;
    }

    public boolean isShowFolder() {
        return this.showFolder;
    }

    public LabelElement getFolderLabel() {
        return this.folderLabel;
    }

    public IconElement getFolderIcon() {
        return this.folderIcon;
    }
}

