/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.print;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import oracle.dbtools.util.print.AnsiUtils;
import oracle.dbtools.util.print.FormattedTable;
import oracle.dbtools.util.print.PrintTheme;

public class TerminalTableFormatter {
    private final List<List<String>> data;
    private final PrintTheme theme;
    private final boolean colorSupport;
    private final int terminalWidth;
    private static final int TAB_WIDTH = 8;
    private static final String SPACES_FOR_TAB = " ".repeat(8);

    public TerminalTableFormatter(List<List<String>> data, PrintTheme theme, boolean colorSupport, int terminalWidth) {
        this.data = data;
        this.theme = theme;
        this.colorSupport = colorSupport;
        this.terminalWidth = terminalWidth;
    }

    public TerminalTableFormatter(List<List<String>> data, boolean colorSupport, int terminalWidth) {
        this.data = data;
        this.theme = PrintTheme.HEAVY;
        this.colorSupport = colorSupport;
        this.terminalWidth = terminalWidth;
    }

    private String expandTabs(String content) {
        if (content == null || !content.contains("\t")) {
            return content;
        }
        return content.replace("\t", SPACES_FOR_TAB);
    }

    public FormattedTable format() {
        if (this.data == null || this.data.isEmpty()) {
            return new FormattedTable(new ArrayList<List<List<String>>>(), new int[0]);
        }
        List<List<String>> processedData = this.preprocessData();
        int numColumns = this.data.get(0).size();
        int[] columnWidths = this.calculateOptimalColumnWidths(processedData, numColumns);
        List<List<List<String>>> groupedRows = this.generateGroupedWrappedRows(processedData, columnWidths);
        return new FormattedTable(groupedRows, columnWidths);
    }

    private List<List<List<String>>> generateGroupedWrappedRows(List<List<String>> processedData, int[] columnWidths) {
        ArrayList<List<List<String>>> finalGroupedTable = new ArrayList<List<List<String>>>();
        for (List<String> originalRow : processedData) {
            ArrayList wrappedLinesForOriginalRow = new ArrayList();
            ArrayList<List<String>> wrappedCells = new ArrayList<List<String>>();
            int maxLinesInRow = 0;
            for (int col = 0; col < originalRow.size(); ++col) {
                String cellContent = originalRow.get(col);
                int width = columnWidths[col];
                List<String> wrappedLines = this.wrapCell(cellContent, width);
                wrappedCells.add(wrappedLines);
                maxLinesInRow = Math.max(maxLinesInRow, wrappedLines.size());
            }
            for (int line = 0; line < maxLinesInRow; ++line) {
                ArrayList<String> newSubRow = new ArrayList<String>();
                for (int col = 0; col < originalRow.size(); ++col) {
                    List cellLines = (List)wrappedCells.get(col);
                    if (line < cellLines.size()) {
                        newSubRow.add((String)cellLines.get(line));
                        continue;
                    }
                    newSubRow.add("");
                }
                wrappedLinesForOriginalRow.add(newSubRow);
            }
            finalGroupedTable.add(wrappedLinesForOriginalRow);
        }
        return finalGroupedTable;
    }

    public List<List<String>> preprocessData() {
        if (this.colorSupport) {
            return this.data;
        }
        return this.data.stream().map(row -> row.stream().map(AnsiUtils::stripAnsi).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public int[] calculateOptimalColumnWidths(List<List<String>> processedData, int numColumns) {
        int padding = 1;
        int bordersWidth = numColumns + 1;
        int availableWidth = this.terminalWidth - bordersWidth - numColumns * padding * 2;
        int[] maxWordWidths = new int[numColumns];
        int[] idealWidths = new int[numColumns];
        for (int col = 0; col < numColumns; ++col) {
            int maxWord = 0;
            int ideal = 0;
            for (List<String> row : processedData) {
                String[] lines;
                if (col >= row.size()) continue;
                String cellContent = row.get(col);
                cellContent = this.expandTabs(cellContent);
                for (String line : lines = AnsiUtils.stripAnsi(cellContent).split("\n")) {
                    ideal = Math.max(ideal, line.length());
                    for (String word : line.split("\\s+")) {
                        maxWord = Math.max(maxWord, word.length());
                    }
                }
            }
            maxWordWidths[col] = maxWord;
            idealWidths[col] = ideal;
        }
        int[] finalWidths = Arrays.copyOf(idealWidths, numColumns);
        for (int totalWidth = Arrays.stream(finalWidths).sum(); totalWidth > availableWidth; --totalWidth) {
            int widestCol = -1;
            int maxW = -1;
            for (int i = 0; i < numColumns; ++i) {
                if (finalWidths[i] <= maxWordWidths[i] || finalWidths[i] <= maxW) continue;
                maxW = finalWidths[i];
                widestCol = i;
            }
            if (widestCol == -1) break;
            int n = widestCol;
            finalWidths[n] = finalWidths[n] - 1;
        }
        return finalWidths;
    }

    private List<List<String>> generateWrappedRows(List<List<String>> processedData, int[] columnWidths) {
        ArrayList<List<String>> finalTable = new ArrayList<List<String>>();
        for (List<String> row : processedData) {
            int numColumns = row.size();
            ArrayList<List<String>> wrappedCells = new ArrayList<List<String>>();
            int maxLinesInRow = 0;
            for (int col = 0; col < numColumns; ++col) {
                String cellContent = row.get(col);
                int width = columnWidths[col];
                List<String> wrappedLines = this.wrapCell(cellContent, width);
                wrappedCells.add(wrappedLines);
                maxLinesInRow = Math.max(maxLinesInRow, wrappedLines.size());
            }
            for (int line = 0; line < maxLinesInRow; ++line) {
                ArrayList<String> newRow = new ArrayList<String>();
                for (int col = 0; col < numColumns; ++col) {
                    List cellLines = (List)wrappedCells.get(col);
                    if (line < cellLines.size()) {
                        newRow.add((String)cellLines.get(line));
                        continue;
                    }
                    newRow.add("");
                }
                finalTable.add(newRow);
            }
        }
        return finalTable;
    }

    private List<String> wrapCell(String content, int maxWidth) {
        String[] hardLines;
        content = this.expandTabs(content);
        ArrayList<String> finalLines = new ArrayList<String>();
        if (content == null || content.isEmpty()) {
            finalLines.add("");
            return finalLines;
        }
        for (String line : hardLines = content.split("\n", -1)) {
            String[] words;
            if (AnsiUtils.visibleLength(line) <= maxWidth) {
                finalLines.add(line);
                continue;
            }
            StringBuilder currentWrappedLine = new StringBuilder();
            for (String word : words = line.split("(?<=\\s)|(?=\\s)")) {
                if (AnsiUtils.visibleLength(currentWrappedLine.toString() + word) > maxWidth) {
                    finalLines.add(currentWrappedLine.toString().trim());
                    currentWrappedLine.setLength(0);
                }
                currentWrappedLine.append(word);
            }
            if (currentWrappedLine.length() <= 0) continue;
            finalLines.add(currentWrappedLine.toString().trim());
        }
        return finalLines;
    }

    public String renderToString(FormattedTable formattedTable) {
        StringBuilder sb = new StringBuilder();
        int[] columnWidths = formattedTable.getColumnWidths();
        List<List<List<String>>> groupedData = formattedTable.getTableData();
        if (columnWidths.length == 0) {
            return "";
        }
        int numColumns = columnWidths.length;
        String borderLine = this.buildBorderLine(this.theme.topLeft, this.theme.topRight, this.theme.topCross, this.theme.headerHorizontal, columnWidths);
        String headerSeparatorLine = this.buildBorderLine(this.theme.headerLeftCross, this.theme.headerRightCross, this.theme.headerMiddleCross, this.theme.headerHorizontal, columnWidths);
        String bodySeparatorLine = this.buildBorderLine(this.theme.leftCross, this.theme.rightCross, this.theme.middleCross, this.theme.horizontal, columnWidths);
        String footerLine = this.buildBorderLine(this.theme.bottomLeft, this.theme.bottomRight, this.theme.bottomCross, this.theme.horizontal, columnWidths);
        sb.append(borderLine).append("\n");
        for (int i = 0; i < groupedData.size(); ++i) {
            List<List<String>> originalRowGroup = groupedData.get(i);
            for (List<String> subLine : originalRowGroup) {
                if (i == 0) {
                    sb.append(this.theme.headerVertical);
                } else {
                    sb.append(this.theme.vertical);
                }
                for (int j = 0; j < numColumns; ++j) {
                    String cell = subLine.get(j);
                    int width = columnWidths[j];
                    int visibleLength = AnsiUtils.visibleLength(cell);
                    sb.append(" ").append(cell);
                    for (int k = 0; k < width - visibleLength + 1; ++k) {
                        sb.append(" ");
                    }
                    if (i == 0) {
                        sb.append(this.theme.headerVertical);
                        continue;
                    }
                    sb.append(this.theme.vertical);
                }
                sb.append("\n");
            }
            if (i >= groupedData.size() - 1) continue;
            if (i == 0) {
                sb.append(headerSeparatorLine).append("\n");
                continue;
            }
            sb.append(bodySeparatorLine).append("\n");
        }
        sb.append(footerLine).append("\n");
        return sb.toString();
    }

    private String buildBorderLine(char left, char right, char cross, char horizontal, int[] widths) {
        StringBuilder line = new StringBuilder();
        line.append(left);
        for (int i = 0; i < widths.length; ++i) {
            for (int j = 0; j < widths[i] + 2; ++j) {
                line.append(horizontal);
            }
            if (i >= widths.length - 1) continue;
            line.append(cross);
        }
        line.append(right);
        return line.toString();
    }
}

