/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.transformer.database;

import java.text.MessageFormat;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.database.Messages;

public class SavedConnectionExists
implements Transformer<String, String> {
    @Override
    public String transform(String rawValue, TransformContext context, Environment environment) {
        String[] connNames = ConnectionResolver.getConnectionNames();
        boolean found = false;
        if (connNames != null) {
            for (String name : connNames) {
                if (!name.equalsIgnoreCase(rawValue)) continue;
                found = true;
            }
        }
        if (!found) {
            context.addError(MessageFormat.format(Messages.getString(Messages.Key.SAVED_CONN_NOT_EXISTS, environment.getLocale()), rawValue));
            return null;
        }
        return rawValue;
    }
}

