/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Expression;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Messages;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParseError;
import oracle.dbtools.raptor.newscriptrunner.util.parser.SemanticError;
import oracle.dbtools.raptor.newscriptrunner.util.parser.TransformContextImpl;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.Token;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;

public class Node {
    private final Node parent;
    private final List<Token> tokens;
    private final Environment environment;
    private final Id ruleId;
    private final Expression expression;
    private final int start;
    private final List<Node> childNodes = new ArrayList<Node>();
    private final Set<String> completions = new TreeSet<String>();
    private final Set<SemanticError> semanticErrors = new LinkedHashSet<SemanticError>();
    private ParseError parseError;
    private int current;
    private boolean matched;
    private Object value;

    public static Node createRootNode(Expression expression, List<Token> tokens, Environment environment) {
        return new Node(null, null, expression, tokens, 0, environment);
    }

    public Id getRuleId() {
        return this.ruleId;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public int getStart() {
        return this.start;
    }

    public int getCurrent() {
        return this.current;
    }

    public boolean isMatched() {
        return this.matched;
    }

    public boolean isEmpty() {
        return this.current == this.start;
    }

    public Collection<String> getCompletions() {
        return this.completions;
    }

    public ParseError getParseError() {
        return this.parseError;
    }

    public Collection<SemanticError> getSemanticErrors() {
        return this.semanticErrors;
    }

    public List<Node> getChildNodes() {
        return this.childNodes;
    }

    public Node getFirstChild() {
        return this.childNodes.isEmpty() ? null : this.childNodes.get(0);
    }

    public Node getParentNode() {
        return this.parent;
    }

    public List<Token> getTokens() {
        return this.tokens.subList(this.start, this.current);
    }

    public Token getFirstToken() {
        return this.tokens.get(this.start);
    }

    public String getRawValue() {
        ArrayList<String> values = new ArrayList<String>();
        for (Token token : this.getTokens()) {
            values.add(token.getValue());
        }
        return String.join((CharSequence)" ", values);
    }

    public <T> T getValue() {
        return (T)this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public String treeAsString() {
        StringBuilder buff = new StringBuilder();
        this.buildStringRep(buff, this, 0);
        return buff.toString();
    }

    void setMatched() {
        this.matched = true;
    }

    Node createChildContext(Expression expression) {
        return new Node(this, this.ruleId, expression, this.tokens, this.current, this.environment);
    }

    Node createChildContext(Id ruleId, Expression expression) {
        return new Node(this, ruleId, expression, this.tokens, this.current, this.environment);
    }

    Token next() {
        return this.hasMoreTokens() ? this.tokens.get(this.current++) : null;
    }

    boolean hasMoreTokens() {
        return this.current < this.tokens.size();
    }

    Token firstUnconsumedToken() {
        if (this.tokens.size() > this.current) {
            return this.tokens.get(this.current);
        }
        return null;
    }

    boolean hasTrailingWhiteSpace() {
        int numTokens = this.tokens.size();
        return numTokens == 0 || numTokens > 0 && this.tokens.get(numTokens - 1).getEnd() < this.tokens.get(numTokens - 1).getLine().length();
    }

    void addChildNode(Node childNode) {
        this.childNodes.add(childNode);
        this.current = childNode.current;
    }

    void mergeCompletions(Collection<String> completions) {
        this.completions.addAll(completions);
    }

    void addCompletion(String completion) {
        this.completions.add(completion);
    }

    void setParseErrorUsing(Token token) {
        this.parseError = new ParseErrorImpl(token);
    }

    void setParseError(ParseError error) {
        this.parseError = error;
    }

    void mergeParseError(ParseError newError) {
        Token newToken;
        Token token;
        if (this.parseError == null) {
            this.parseError = newError;
        } else if (newError != null && (token = this.parseError.getToken()) != null && ((newToken = newError.getToken()) == null || newToken.getStart() > token.getStart())) {
            this.parseError = newError;
        }
    }

    void addSemanticError(String message) {
        this.semanticErrors.add(new SemanticErrorImpl(message));
    }

    void mergeSemanticErrors(Collection<SemanticError> errors) {
        this.semanticErrors.addAll(errors);
    }

    void setValueFrom(Node childNode, Transformer<Node, ?> transformer) {
        this.value = transformer != null ? transformer.transform(childNode, new TransformContextImpl(this::addSemanticError, this::addCompletion), this.environment) : childNode.getValue();
    }

    void setValueFrom(List<Node> childNodes, Transformer<List<Node>, ?> transformer) {
        if (transformer != null) {
            this.value = transformer.transform(childNodes, new TransformContextImpl(this::addSemanticError, this::addCompletion), this.environment);
        } else {
            ArrayList childValues = new ArrayList();
            for (Node childNode : childNodes) {
                childValues.add(childNode.getValue());
            }
            this.value = childValues;
        }
    }

    void setValue(Object value) {
        this.value = value;
    }

    Environment getEnvironment() {
        return this.environment;
    }

    private void buildStringRep(StringBuilder buff, Node node, int indentCount) {
        for (int i = 0; i < indentCount; ++i) {
            buff.append("  ");
        }
        buff.append(node.getExpression().toString()).append(" [").append(node.value != null ? node.value.getClass().getSimpleName() : "").append("] ").append(this.asString(node.getRawValue())).append("\n");
        if (!node.getChildNodes().isEmpty()) {
            for (Node childNode : node.getChildNodes()) {
                this.buildStringRep(buff, childNode, indentCount + 1);
            }
        }
    }

    private String asString(Object obj) {
        return obj != null ? obj.toString() : "";
    }

    private Node(Node parent, Id ruleId, Expression expression, List<Token> tokens, int start, Environment environment) {
        this.parent = parent;
        this.ruleId = ruleId;
        this.expression = expression;
        this.tokens = tokens;
        this.environment = environment;
        this.current = this.start = start;
    }

    private class ParseErrorImpl
    implements ParseError {
        private final Token token;

        ParseErrorImpl(Token token) {
            this.token = token;
        }

        @Override
        public Token getToken() {
            return this.token;
        }

        @Override
        public String getMessage() {
            if (this.token == null) {
                return MessageFormat.format(Messages.getString(Messages.Key.MISSING_TOKEN, Node.this.environment.getLocale()), Node.this.tokens.isEmpty() ? 0 : Node.this.tokens.get(Node.this.tokens.size() - 1).getEnd());
            }
            return MessageFormat.format(Messages.getString(Messages.Key.INVALID_TOKEN, Node.this.environment.getLocale()), this.token.getRawValue(), this.token.getStart());
        }
    }

    private class SemanticErrorImpl
    implements SemanticError {
        private final String message;

        SemanticErrorImpl(String message) {
            this.message = message;
        }

        @Override
        public Node getNode() {
            return Node.this;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

