/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.NONE)
public class ShowEcho
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWECHO = new String[]{"echo"};

    @Override
    public String[] getShowAliases() {
        return SHOWECHO;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.doShowEcho(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowEcho(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.isEchoOn()) {
            ctx.write("echo ON\n");
        } else {
            ctx.write("echo OFF\n");
        }
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        if (ctx.isEchoOn()) {
            return "set echo ON\n";
        }
        return "set echo OFF\n";
    }
}

