/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connect.save;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import oracle.dbtools.core.connections.ConnectionIdentifiers;
import oracle.dbtools.core.connections.folder.Folder;

class FolderProxy {
    private volatile String name;
    private List<FolderProxy> folders = new ArrayList<FolderProxy>();
    private List<String> connections = new ArrayList<String>();

    FolderProxy() {
    }

    public Folder toFolder() {
        Map subFolders = this.folders.stream().map(FolderProxy::toFolder).collect(Collectors.toConcurrentMap(Folder::getName, folder -> folder));
        List connIds = this.connections.stream().map(ConnectionIdentifiers::createIdentifier).collect(Collectors.toList());
        return Folder.builder((String)this.name).subFolders(subFolders).connections(connIds).build();
    }

    public static Map<String, Object> fromFolder(Folder folder) {
        LinkedHashMap<String, Object> folderMap = new LinkedHashMap<String, Object>();
        if (folder.getName() != null) {
            folderMap.put("name", folder.getName());
            folderMap.put("connections", folder.getConnections().stream().map(Objects::toString).collect(Collectors.toUnmodifiableList()));
        }
        if (!folder.getSubFolders().isEmpty()) {
            ArrayList<Map<String, Object>> nestedFolderMaps = new ArrayList<Map<String, Object>>();
            for (Folder nestedFolder : folder.getSubFolders().values()) {
                nestedFolderMaps.add(FolderProxy.fromFolder(nestedFolder));
            }
            folderMap.put("folders", nestedFolderMaps);
        } else {
            folderMap.put("folders", new ArrayList());
        }
        return folderMap;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<FolderProxy> getFolders() {
        return this.folders;
    }

    public void setFolders(List<FolderProxy> folders) {
        this.folders = folders;
    }

    public List<String> getConnections() {
        return this.connections;
    }

    public void setConnections(List<String> connections) {
        this.connections = connections;
    }
}

