/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connect;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.core.connections.folder.FolderOperationException;
import oracle.dbtools.core.connections.folder.utils.PathsUtils;
import oracle.dbtools.db.ConnectionDetails;
import oracle.dbtools.db.ConnectionSaveHandler;
import oracle.dbtools.db.ConnectionStoreBridge;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.SetAppinfo;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.AbstractConnectionProcessor;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Connector;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorTypeCache;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.DisconnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.NoSuchConnectionFolderException;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ParseConnectionSpecArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.RawPropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.TextId;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.save.ConnectionsFolderManager;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.NameProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowLogin;
import oracle.dbtools.raptor.newscriptrunner.util.completer.SemanticCompleter;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpContainer;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.OptionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.newscriptrunner.util.parser.TypeBuilder;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;

public class ConnectCommand
extends CommandListener
implements IHelp {
    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        Parser parser = new Parser(this.createType(ctx.getService(ConnectorTypeCache.class)), ctx.getEnvironment());
        Optional<ParsedCommand> parsedCommand = parser.parse(SQLPLUSUtil.cleanCommand(cmd).getSql(), errorMessages::add);
        if (parsedCommand.isPresent()) {
            ConnectCommandProcessor processor = new ConnectCommandProcessor(parsedCommand.get(), ctx, cmd, errorMessages);
            processor.connect(conn, cmd);
        }
        for (String errorMessage : errorMessages) {
            ctx.write(errorMessage + "\n");
        }
        return true;
    }

    @Override
    public Type getParserType() {
        return this.createType(ScriptRunnerContext.getCurrentContext().getService(ConnectorTypeCache.class));
    }

    @Override
    public String getCommand() {
        return "CONNECT";
    }

    @Override
    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        ConnectorTypeCache cache = ctx.getService(ConnectorTypeCache.class);
        HelpPagesBuilder helpPagesBuilder = new HelpPagesBuilder(ctx.getEnvironment()).enableColorCode(ctx.isCommandLine());
        for (HelpContainer helpContainer : cache.getHelpContainers()) {
            helpPagesBuilder.addHelpContainer(helpContainer);
        }
        helpPagesBuilder.addPages(new CommandPageAssemblers(this.createType(ctx.getService(ConnectorTypeCache.class)), new Type[0]));
        for (ConnectorType connectorType : cache.getConnectorTypes()) {
            Type rootType = this.createType(connectorType);
            helpPagesBuilder.addPages(new CommandPageAssemblers(rootType, rootType));
        }
        HelpPages helpPages = helpPagesBuilder.build();
        return helpPages.get(pagePath);
    }

    @Override
    public boolean isSqlPlus() {
        return true;
    }

    private Type createType(ConnectorTypeCache cache) {
        TypeBuilder typeBuilder = Factory.type(TypeId.CONNECT).name("conn'ect");
        for (String propertyName : cache.getPropertyNames()) {
            Property property = cache.getProperty(propertyName);
            OptionBuilder optionBuilder = property.isFlag() ? Factory.option(new TextId(propertyName)).flag().helpId(property.getHelpId()) : Factory.option(new TextId(propertyName)).helpId(property.getHelpId());
            if (property.getShortName() != null) {
                optionBuilder.abbrevs(property.getShortName());
            }
            if (!property.getCompleters().isEmpty()) {
                optionBuilder.completer(property.getCompleters().toArray(new SemanticCompleter[0]));
            }
            typeBuilder.add(optionBuilder.build());
        }
        this.addVerboseOption(typeBuilder);
        this.addConnectionSpecParameter(typeBuilder);
        return typeBuilder.build();
    }

    private Type createType(ConnectorType connectorType) {
        TypeBuilder typeBuilder = Factory.type(new TextId(connectorType.getName())).base().helpId(connectorType.getHelpId());
        for (Property<?> property : connectorType.getProperties()) {
            Class propertyType = property.isFlag() ? Boolean.class : String.class;
            OptionBuilder optionBuilder = ((OptionBuilder)Factory.option(new TextId(property.getName())).dataType(propertyType)).helpId(property.getHelpId());
            if (property.getShortName() != null) {
                optionBuilder.abbrevs(property.getShortName());
            }
            typeBuilder.add(optionBuilder.build());
        }
        this.addVerboseOption(typeBuilder);
        return Factory.type(TypeId.CONNECT).name("conn'ect").add(typeBuilder.build()).build();
    }

    private void addVerboseOption(TypeBuilder typeBuilder) {
        typeBuilder.add(Factory.option(TypeId.VERBOSE).flag().name("VERBOSE").abbrevs("V").build());
    }

    private void addConnectionSpecParameter(TypeBuilder typeBuilder) {
        typeBuilder.setLiteralGrammar(TypeId.CONNECTIONSPEC);
    }

    private class ConnectCommandProcessor
    extends AbstractConnectionProcessor {
        private final List<String> errorMessages;
        private final ParsedCommand parsedCommand;
        private final ConnectionContext connectionContext;
        private final ConnectorTypeCache connectorTypeCache;
        private Set<Property<?>> commandProperties;
        private PropertyValues propertyValues;
        private ScriptExecutor scriptExecutor;

        ConnectCommandProcessor(ParsedCommand parsedCommand, ScriptRunnerContext ctx, ISQLCommand cmd, List<String> errorMessages) {
            super(ctx, cmd);
            this.scriptExecutor = null;
            this.connectionContext = ctx.getService(ConnectionContext.class);
            this.connectorTypeCache = ctx.getService(ConnectorTypeCache.class);
            this.parsedCommand = parsedCommand;
            this.errorMessages = errorMessages;
        }

        void connect(Connection currentConnection, ISQLCommand cmd) {
            this.commandProperties = this.getCommandProperties();
            this.propertyValues = this.getPropertyValues();
            String connectionSpec = (String)this.parsedCommand.getGrammarValue();
            if (this.propertyValues != null) {
                boolean hasSpecOrUrl;
                String url = this.propertyValues.getValueOf(URLProperty.URL);
                String name = ConnectionSaveHandler.getName(this.propertyValues);
                String path = null;
                if (name != null && name.contains(File.separator)) {
                    String connName = PathsUtils.getLastElement((String)name);
                    path = name.substring(0, name.lastIndexOf(File.separator));
                    if (connName != null) {
                        this.propertyValues.setValueOf(NameProperty.SAVE, connName);
                        name = connName;
                    }
                }
                boolean bl = hasSpecOrUrl = ModelUtil.hasLength(connectionSpec) || ModelUtil.hasLength(url);
                if (!hasSpecOrUrl && name != null) {
                    if (currentConnection == null) {
                        ScriptUtils.report(this.ctx, oracle.dbtools.raptor.newscriptrunner.commands.connect.Messages.getString(Messages.Key.NO_CONNECTION_TO_SAVE));
                    } else {
                        ConnectionSaveHandler persistor = ConnectionStoreBridge.getBridge(this.ctx).createSaveHandler(this.ctx, this.propertyValues, this.connectionContext.getCurrentConnectorType());
                        EnumMap<ConnectionProperty, String> connectProperties = new EnumMap<ConnectionProperty, String>(ConnectionProperty.class);
                        persistor.validateProperties(this.connectionContext.getCurrentPropertyValues(), connectProperties);
                        if (connectProperties.get((Object)ConnectionProperty.ERROR_MESSAGE) != null) {
                            ScriptUtils.report(this.ctx, (String)connectProperties.get((Object)ConnectionProperty.ERROR_MESSAGE));
                        } else {
                            boolean isConnectionsFolderSupportEnabled;
                            persistor.saveConnectionDetails(this.connectionContext.getCurrentPropertyValues(), currentConnection);
                            Object connectionSupportProperty = this.ctx.getProperty("IS_CONNECTIONS_FOLDER_SUPPORT_ENABLED");
                            boolean bl2 = isConnectionsFolderSupportEnabled = connectionSupportProperty != null && (Boolean)connectionSupportProperty != false;
                            if (isConnectionsFolderSupportEnabled) {
                                try {
                                    ConnectionsFolderManager connectionsManager = new ConnectionsFolderManager();
                                    connectionsManager.addConnection(path, name);
                                }
                                catch (IllegalArgumentException | FolderOperationException | NoSuchConnectionFolderException e) {
                                    oracle.dbtools.util.Logger.warn(this.getClass(), e.getMessage());
                                }
                            }
                        }
                    }
                } else {
                    ConnectorInfo connectorInfo = this.findMatchedConnector();
                    if (connectorInfo != null) {
                        Connection newConnection = this.processConnect(currentConnection, this.connectionContext.getCurrentConnectorType(), connectionSpec, connectorInfo.connectorPropertyValues, connectorInfo.connectorType);
                        this.ctx.setCurrentConnection(newConnection);
                        this.ctx.getMap().put("connectionSpec", connectionSpec);
                    }
                }
            }
        }

        private Set<Property<?>> getCommandProperties() {
            HashSet result = new HashSet();
            TreeSet<String> validNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (Property<?> property : this.connectorTypeCache.getProperties()) {
                String name = property.getName();
                if (this.parsedCommand.getOptionValue(new TextId(name)) == null) continue;
                result.add(property);
                validNames.add(name);
            }
            return result;
        }

        private PropertyValues getPropertyValues() {
            PropertyValues result = this.connectionContext.getContextPropertyValues().createCopy();
            RawPropertyValues rawValues = RawPropertyValues.create(this.parsedCommand);
            for (Property<?> property : this.commandProperties) {
                Object value = property.createValue(this.ctx, rawValues, this.errorMessages::add);
                result.setValueOf(property, value);
            }
            if (!this.errorMessages.isEmpty()) {
                return null;
            }
            return result;
        }

        private ConnectorInfo findMatchedConnector() {
            ArrayList<ConnectorInfo> matchCandidates = new ArrayList<ConnectorInfo>();
            for (ConnectorType connectorType : this.connectorTypeCache.getConnectorTypes()) {
                if (!this.validCommandPropertiesFor(connectorType)) continue;
                ConnectorInfo matchInfo = new ConnectorInfo(connectorType);
                matchCandidates.add(matchInfo);
                this.parseConnectionSpecFor(matchInfo);
            }
            HashMap matchSetMap = new HashMap();
            for (ConnectorInfo matchCandidate : matchCandidates) {
                Set<Property<?>> matchPropertySet = this.matchByPropertyValues(matchCandidate);
                if (matchPropertySet == null) continue;
                matchSetMap.put(matchCandidate, matchPropertySet);
            }
            if (matchSetMap.size() == 1) {
                for (ConnectorInfo matchCandidate : matchSetMap.keySet()) {
                    matchCandidate.matches = true;
                }
            } else {
                for (ConnectorInfo matchCandidate : matchSetMap.keySet()) {
                    boolean superset = true;
                    Set matchPropertySet = (Set)matchSetMap.get(matchCandidate);
                    for (Set otherMatchSet : matchSetMap.values()) {
                        if (matchPropertySet == otherMatchSet || matchPropertySet.containsAll(otherMatchSet)) continue;
                        superset = false;
                        break;
                    }
                    if (!superset) continue;
                    matchCandidate.matches = true;
                }
                if (!this.existMatchesWithoutError(matchCandidates)) {
                    for (ConnectorInfo matchCandidate : matchSetMap.keySet()) {
                        matchCandidate.matches = true;
                    }
                }
            }
            List<ConnectorInfo> list = this.findMatchesWithoutError(matchCandidates);
            ConnectorInfo result = null;
            if (!list.isEmpty()) {
                if (list.size() == 1) {
                    result = list.get(0);
                } else {
                    for (ConnectorInfo match : list) {
                        if (match.connectorType.getClass() != OracleConnectorType.class) continue;
                        result = match;
                        break;
                    }
                    if (result == null) {
                        this.errorMessages.add(oracle.dbtools.raptor.newscriptrunner.commands.connect.Messages.getString(Messages.Key.AMBIGUOUS_CONNECT_REQUEST));
                    }
                }
            } else {
                List<ConnectorInfo> errorMatches = this.findMatchesWithError(matchCandidates);
                if (errorMatches.size() == 1) {
                    ConnectorInfo matchInfo = errorMatches.get(0);
                    this.errorMessages.addAll(matchInfo.connectorErrorMessages);
                } else {
                    this.errorMessages.add(oracle.dbtools.raptor.newscriptrunner.commands.connect.Messages.getString(Messages.Key.UNRECOGNIZED_CONNECT_REQUEST));
                }
            }
            return result;
        }

        private boolean existMatchesWithoutError(List<ConnectorInfo> matchCandidates) {
            for (ConnectorInfo matchCandidate : matchCandidates) {
                if (!matchCandidate.matches || !matchCandidate.connectorErrorMessages.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private List<ConnectorInfo> findMatchesWithoutError(List<ConnectorInfo> matchCandidates) {
            ArrayList<ConnectorInfo> matches = new ArrayList<ConnectorInfo>();
            for (ConnectorInfo matchCandidate : matchCandidates) {
                if (!matchCandidate.matches || !matchCandidate.connectorErrorMessages.isEmpty()) continue;
                matches.add(matchCandidate);
            }
            return matches;
        }

        private List<ConnectorInfo> findMatchesWithError(List<ConnectorInfo> matchCandidates) {
            ArrayList<ConnectorInfo> matches = new ArrayList<ConnectorInfo>();
            for (ConnectorInfo matchCandidate : matchCandidates) {
                if (!matchCandidate.matches || matchCandidate.connectorErrorMessages.isEmpty()) continue;
                matches.add(matchCandidate);
            }
            return matches;
        }

        private boolean validCommandPropertiesFor(ConnectorType connectorType) {
            List<Property<?>> connectorProperties = connectorType.getProperties();
            for (Property<?> commandProperty : this.commandProperties) {
                if (connectorProperties.contains(commandProperty)) continue;
                return false;
            }
            return true;
        }

        private void parseConnectionSpecFor(final ConnectorInfo connectorInfo) {
            connectorInfo.connectorType.parseConnectionSpec(new ParseConnectionSpecArgs(){

                @Override
                public String getConnectionSpec() {
                    return (String)ConnectCommandProcessor.this.parsedCommand.getGrammarValue();
                }

                @Override
                public <T> T getPropertyValue(Property<T> property) {
                    return connectorInfo.connectorPropertyValues.getValueOf(property);
                }

                @Override
                public void setPropertyValue(Property<?> property, Object value) {
                    if (connectorInfo.connectorCommandProperties.contains(property)) {
                        connectorInfo.connectorErrorMessages.add(MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.connect.Messages.getString(Messages.Key.OPTION_OVERRIDE), property.getName()));
                    } else {
                        connectorInfo.connectorPropertyValues.setValueOf(property, value);
                    }
                }

                @Override
                public ScriptRunnerContext getScriptRunnerContext() {
                    return ConnectCommandProcessor.this.ctx;
                }

                @Override
                public ConnectorTypeCache getConnectorTypeCache() {
                    return ConnectCommandProcessor.this.connectorTypeCache;
                }

                @Override
                public void addError(String message) {
                    connectorInfo.connectorErrorMessages.add(message);
                }
            });
        }

        private Set<Property<?>> matchByPropertyValues(ConnectorInfo connectorInfo) {
            HashSet result = new HashSet();
            List<Property<?>> connectorProperties = connectorInfo.connectorType.getProperties();
            for (Property property : connectorProperties) {
                if (property.matchesNull()) continue;
                if (connectorInfo.connectorPropertyValues.getValueOf(property) == null) {
                    return null;
                }
                result.add(property);
            }
            return result;
        }

        private Connection processConnect(Connection currentConnection, ConnectorType currentConnectorType, String connectionSpec, PropertyValues connectorProperties, ConnectorType newConnectorType) {
            if (this.parsedCommand.isFlagSet(TypeId.VERBOSE)) {
                this.ctx.write(connectorProperties.asStringFor(newConnectorType, "\n") + "\n\n");
            }
            EnumMap<ConnectionProperty, String> connectProperties = new EnumMap<ConnectionProperty, String>(ConnectionProperty.class);
            Connection newConnection = null;
            ConnectionStoreBridge connResolver = ConnectionStoreBridge.getBridge(this.ctx);
            ConnectionSaveHandler saveHandler = connResolver.createSaveHandler(this.ctx, connectorProperties, newConnectorType);
            Connector connector = newConnectorType.createConnector(ConnectorArgs.create(connectionSpec, connectorProperties, this.ctx, this.cmd, connectProperties::put));
            saveHandler.validateProperties(connectorProperties, connectProperties);
            if (connectProperties.get((Object)ConnectionProperty.ERROR_MESSAGE) == null) {
                newConnection = connector.connect();
            }
            this.initNewConnection(currentConnection, currentConnectorType, newConnection, connectProperties);
            this.postProcessConnection(newConnection);
            if (newConnection != null) {
                this.connectionContext.setCurrentConnectorType(newConnectorType);
                this.connectionContext.setCurrentConnectionSpec(connectionSpec);
                this.connectionContext.setCurrentPropertyValues(connectorProperties);
                this.connectionContext.setCurrentCommand(this.cmd);
            }
            this.processLoginScripts(newConnection);
            if (newConnection != null && connectProperties.get((Object)ConnectionProperty.ERROR_MESSAGE) == null) {
                saveHandler.saveConnectionDetails(connectorProperties, newConnection);
            }
            this.reportConnection(newConnection, connectProperties);
            return newConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initNewConnection(Connection currentConnection, ConnectorType currentConnectorType, Connection newConnection, Map<ConnectionProperty, String> connectProperties) {
            if (!this.ctx.getExited()) {
                if (newConnection != null) {
                    if (currentConnection != null && this.ctx.getBaseConnection() != null && currentConnection.equals(this.ctx.getBaseConnection()) && !"".equals(this.ctx.getMap().get(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString()))) {
                        this.ctx.putProperty("script.runner.connection.id", this.ctx.doPromptReplaceSqlplusVar(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER));
                    }
                    String privilege = connectProperties.get((Object)ConnectionProperty.DEF_PRIVILEGE);
                    this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString(), Objects.requireNonNullElse(privilege, "NOTSYSDBA"));
                    String connectIdent = connectProperties.get((Object)ConnectionProperty.DEF_CONNECT_IDENTIFIER);
                    if (connectIdent != null && connectIdent.length() > 1 && connectIdent.length() < 81) {
                        this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), connectIdent);
                    } else {
                        this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), "");
                        this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._SQL_ID.toString(), "");
                        this.ctx.doPromptReplaceSqlplusVar(newConnection, ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER);
                    }
                    Boolean getCommit = (Boolean)this.ctx.getProperty("script.runner.autocommit.checkbox");
                    try {
                        newConnection.setAutoCommit(getCommit != null && !getCommit.equals(Boolean.FALSE));
                    }
                    catch (SQLException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                    }
                } else {
                    Object failed = connectProperties.get((Object)ConnectionProperty.ERROR_MESSAGE);
                    if (failed == null) {
                        failed = "Unable to establish connection";
                    }
                    if (this.ctx.isCommandLine() && (this.ctx.getTopLevel() || this.ctx.isSQLPlusClassic())) {
                        if (!(this.ctx.getSqlError() != 0 || this.ctx.getOsError() != 0 || this.ctx.getProperty("script.runner.sqlplus.nolog") != null && this.ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE))) {
                            failed = !((String)failed).equals("") ? (String)failed + "\n" + ScriptRunnerDbArb.getString("NO_LONGER_CONNECTED") : ScriptRunnerDbArb.getString("NO_LONGER_CONNECTED");
                        }
                        SQLPLUSUtil.report(this.ctx, (String)failed);
                    } else {
                        failed = !((String)failed).equals("") ? ScriptRunnerDbArb.getString("CONNECTION_FAILED") + "\n" + (String)failed : ScriptRunnerDbArb.getString("CONNECTION_FAILED");
                        SQLPLUSUtil.report(this.ctx, ScriptRunnerContext.lineErr(SQLPLUSUtil.cleanCommand(this.cmd).getStartLine() + 1, "  connect ...", failed, this.ctx).trim());
                    }
                    SQLPLUSUtil.doWhenever(this.ctx, this.cmd, currentConnection, true);
                    if (currentConnection != null && !SQLPLUSUtil.isConnectionClosed(currentConnection) && LockManager.lock(currentConnection)) {
                        try {
                            if (!(this.ctx.isCommandLine() && this.ctx.getTopLevel() || this.ctx.isSQLPlusClassic())) {
                                SQLPLUSUtil.report(this.ctx, "Commit");
                            }
                        }
                        finally {
                            LockManager.unlock(currentConnection);
                        }
                    }
                    this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString(), "");
                    this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), "");
                    this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._USER.toString(), "");
                    this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._SQL_ID.toString(), "");
                    this.ctx.setCurrentConnection(currentConnection);
                    this.ctx.putProperty("script.runner.sqlplus.nolog", true);
                }
                this.ctx.putProperty("AUTOTRACE_STATE", false);
                this.ctx.putProperty("AUTOTRACE_TYPE", "NONE");
                if (LockManager.lock(currentConnection)) {
                    try {
                        if (currentConnection != null) {
                            SQLPLUSUtil.commitConnection(currentConnection);
                            this.disposeConnection(currentConnection, currentConnectorType == null ? null : currentConnectorType.createDisconnector(DisconnectorArgs.create(currentConnection, this.ctx, this.cmd)));
                        } else if (this.ctx.getBaseConnection() == null) {
                            this.ctx.setBaseConnection(newConnection);
                        }
                        this.ctx.setCurrentConnection(newConnection);
                    }
                    finally {
                        LockManager.unlock(currentConnection);
                    }
                }
            }
        }

        private void postProcessConnection(Connection newConnection) {
            if (this.ctx.getProperty("script.runner.PRELIM_AUTH") == null) {
                this.ctx.putProperty("script.runner.PRELIM_AUTH", Boolean.FALSE);
            }
            if (!this.ctx.getExited() && newConnection != null) {
                try {
                    ConnectionDetails cdFinal = new ConnectionDetails(newConnection.getMetaData().getURL());
                    cdFinal.setConn(newConnection);
                    ConnectionStoreBridge connResolver = ConnectionStoreBridge.getBridge(this.ctx);
                    connResolver.addConnection(cdFinal);
                    this.ctx.putProperty("cli.conn.name", cdFinal.getUrl());
                    SQLWarning sw = newConnection.getWarnings();
                    if (sw != null) {
                        ScriptUtils.report(this.ctx, oracle.dbtools.raptor.newscriptrunner.commands.connect.Messages.getString(Messages.Key.CONNECTION_WARNINGS));
                    }
                    while (sw != null) {
                        String w = sw.getLocalizedMessage();
                        if (w != null) {
                            ScriptUtils.report(this.ctx, w);
                        }
                        sw = sw.getNextWarning();
                    }
                    newConnection.clearWarnings();
                }
                catch (SQLException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
                this.ctx.putProperty("script.runner.sqlplus.nolog", false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processLoginScripts(Connection newConnection) {
            if (newConnection != null) {
                Boolean oldEcho = this.ctx.isEchoOn();
                try {
                    SQLPLUSUtil.forceEcho(this.ctx, false, false);
                    Boolean resetToDefault = (Boolean)this.ctx.getProperty("script.runner.commandlineconnect");
                    if (resetToDefault != null && resetToDefault.equals(Boolean.TRUE)) {
                        this.ctx.putProperty("script.runner.commandlineconnect", Boolean.FALSE);
                        this.ctx.setSubstitutionOn(true);
                    }
                    this.ctx.putProperty("script.runner.sqlplus.nolog", false);
                    Object glogin = this.ctx.getProperty("DBConfig.GLOGIN");
                    if (glogin != null && ((Boolean)glogin).equals(Boolean.valueOf("true"))) {
                        this.runGLoginSQL(newConnection);
                        this.runUserLoginSQL(newConnection);
                    }
                }
                finally {
                    SQLPLUSUtil.forceEcho(this.ctx, oldEcho, true);
                }
            }
        }

        private void reportConnection(Connection newConnection, Map<ConnectionProperty, String> connectProperties) {
            if (this.ctx.getProperty("script.runner.PRELIM_AUTH") == null) {
                this.ctx.putProperty("script.runner.PRELIM_AUTH", Boolean.FALSE);
            }
            if (!this.ctx.getExited() && newConnection != null) {
                if (this.ctx.getProperty("script.runner.cmdline.login") != null) {
                    if (this.ctx.getProperty("script.runner.sqlcl.optionx") == null && this.ctx.getProperty("script.runner.sqlplus.silent") == null && (this.ctx.getProperty("script.runner.PRELIM_AUTH") == null || this.ctx.getProperty("script.runner.PRELIM_AUTH").equals(Boolean.FALSE))) {
                        String lastLogin;
                        if (this.ctx.getProperty("sqlcl.last.login.time") == null && (lastLogin = connectProperties.get((Object)ConnectionProperty.LAST_LOGIN_TIME)) != null && !lastLogin.isEmpty()) {
                            ScriptUtils.report(this.ctx, MessageFormat.format("Last Successful login time: {0}\n", lastLogin));
                        }
                        String x = this.ctx.doPromptReplaceSqlplusVar(ScriptRunnerContext.SqlplusVariable._O_VERSION.toString(), ScriptRunnerContext.SqlplusVariable._O_VERSION);
                        ScriptUtils.report(this.ctx, MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.connect.Messages.getString(Messages.Key.CONNECTED_TO), x) + "\n");
                    }
                    this.ctx.getProperties().remove("script.runner.cmdline.login");
                } else if (this.ctx.getProperty("script.runner.PRELIM_AUTH") != null && this.ctx.getProperty("script.runner.PRELIM_AUTH").equals(Boolean.FALSE) && this.ctx.getProperty("script.runner.sqlplus.silent") == null) {
                    ScriptUtils.report(this.ctx, MessageFormat.format("{0}.", ScriptRunnerDbArb.getString("CONNECTED")));
                }
            }
        }

        private void runUserLoginSQL(Connection conn) {
            File f;
            ArrayList<String> logins = ShowLogin.getLocations(this.ctx, "login.sql", true);
            String loginFile = ShowLogin.firstOrNull(logins);
            if (loginFile != null && (f = new File(loginFile)).exists()) {
                this.ctx.putProperty("sqlcli.login.sql", Boolean.TRUE);
                if (FileUtils.isFileOnCWD(f, this.ctx) && !FileUtils.isFileOnSQLPATH(f, this.ctx)) {
                    this.ctx.write(Messages.getString("SQLPLUS.24"));
                    this.ctx.errorLog(this.ctx.getSourceRef(), Messages.getString("SQLPLUS.24"), "");
                }
                this.runLoginSQLFile(f, conn);
                this.ctx.putProperty("sqlcli.login.sql", Boolean.FALSE);
            }
        }

        private void runGLoginSQL(Connection conn) {
            File file;
            String gloginFile = ShowLogin.firstOrNull(ShowLogin.getLocations(this.ctx, "glogin.sql", false));
            if (gloginFile != null && (file = new File(gloginFile)).exists() && file.canRead()) {
                this.ctx.putProperty("sqlcli.glogin.sql", Boolean.TRUE);
                this.runLoginSQLFile(file, conn);
                this.ctx.putProperty("sqlcli.glogin.sql", Boolean.FALSE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runLoginSQLFile(File file, Connection conn) {
            block23: {
                String directoryRemoved = file.getName();
                String gloginFile = "login.sql";
                try {
                    gloginFile = file.getCanonicalPath();
                }
                catch (IOException ioe) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ioe.getStackTrace()[0].toString(), ioe);
                }
                if (FileUtils.isFileOnCWD(file, this.ctx) && !FileUtils.isFileOnSQLPATH(file, this.ctx)) {
                    this.ctx.putProperty("LOGIN_FILE_ON_CWD", Boolean.TRUE);
                }
                String prevFile = this.ctx.getSourceRef();
                Integer localDepth = 0;
                try {
                    localDepth = this.ctx.getTopLevel() || this.ctx.getProperty("script.runner.script_depth") == null ? Integer.valueOf(1) : (Integer)this.ctx.getProperty("script.runner.script_depth");
                    int oneOff = 0;
                    String theName = "";
                    String theGLogin = ShowLogin.firstOrNull(ShowLogin.getLocations(this.ctx, "glogin.sql", false));
                    if (theGLogin != null) {
                        int bslash;
                        int slash = theGLogin.lastIndexOf("/");
                        if (slash > (bslash = theGLogin.lastIndexOf("\\"))) {
                            bslash = slash;
                        }
                        theName = bslash != -1 ? theGLogin.substring(bslash + 1) : theGLogin;
                    }
                    if (directoryRemoved != null && directoryRemoved.equals(theName)) {
                        oneOff = 1;
                    }
                    if (localDepth + oneOff < 20) {
                        ArrayList scrArrayList;
                        this.ctx.putProperty("sqlplus.login.file", Boolean.TRUE);
                        this.scriptExecutor = new ScriptExecutor(new FileInputStream(file), conn);
                        this.ctx.putProperty("runner", this.scriptExecutor);
                        this.scriptExecutor.setOut(this.out);
                        boolean localTopLevel = this.ctx.getTopLevel();
                        this.ctx.setTopLevel(false);
                        this.ctx.putProperty("script.runner.script_depth", localDepth + 1);
                        this.scriptExecutor.setScriptRunnerContext(this.ctx);
                        String pathval = file.getCanonicalPath();
                        this.ctx.setSourceRef(pathval);
                        int ii = pathval.lastIndexOf(File.separator);
                        pathval = pathval.substring(0, ii);
                        this.scriptExecutor.setDirectory(pathval);
                        try {
                            scrArrayList = (ArrayList)this.ctx.getProperty("script.runner.appinfo.arraylist");
                            scrArrayList.add(directoryRemoved);
                            this.ctx.putProperty("script.runner.appinfo.arraylist", scrArrayList);
                            if (!scrArrayList.isEmpty()) {
                                SetAppinfo.setAppinfo(this.ctx, this.ctx.getCurrentConnection(), (String)scrArrayList.get(scrArrayList.size() - 1), scrArrayList.size());
                            }
                            this.scriptExecutor.run();
                            break block23;
                        }
                        finally {
                            this.ctx.setTopLevel(localTopLevel);
                            conn = this.scriptExecutor.getScriptRunnerContext().getCurrentConnection();
                            scrArrayList = (ArrayList)this.ctx.getProperty("script.runner.appinfo.arraylist");
                            if (!scrArrayList.isEmpty()) {
                                scrArrayList.remove(scrArrayList.size() - 1);
                            }
                            this.ctx.putProperty("script.runner.appinfo.arraylist", scrArrayList);
                            if (!scrArrayList.isEmpty()) {
                                SetAppinfo.setAppinfo(this.ctx, this.ctx.getCurrentConnection(), (String)scrArrayList.get(scrArrayList.size() - 1), scrArrayList.size());
                            } else {
                                SetAppinfo.setAppinfo(this.ctx, this.ctx.getCurrentConnection(), SQLPLUSUtil.getProductName(), 0);
                            }
                        }
                    }
                    if (this.ctx.getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.ctx.getProperty("sqlplus.classic.mode").toString())) {
                        SQLPLUSUtil.report(this.ctx, ScriptRunnerDbArb.getString("MAX_NEST_CLASSIC"));
                    } else {
                        SQLPLUSUtil.report(this.ctx, ScriptRunnerContext.lineErr(this.cmd.getStartLine() + 1, this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString("MAX_NEST"), this.ctx));
                    }
                }
                catch (FileNotFoundException e) {
                    SQLPLUSUtil.report(this.ctx, "No " + gloginFile + " found");
                }
                catch (IOException e) {
                    SQLPLUSUtil.report(this.ctx, "No " + gloginFile + " found");
                }
                finally {
                    this.ctx.setSourceRef(prevFile);
                    this.ctx.removeProperty("sqlplus.login.file");
                    this.ctx.putProperty("script.runner.script_depth", localDepth);
                }
            }
        }

        private class ConnectorInfo {
            ConnectorType connectorType;
            PropertyValues connectorPropertyValues;
            Set<Property<?>> connectorCommandProperties;
            List<String> connectorErrorMessages;
            boolean matches;

            ConnectorInfo(ConnectorType connectorType) {
                this.connectorPropertyValues = ConnectCommandProcessor.this.propertyValues.createCopy();
                this.connectorCommandProperties = new HashSet(ConnectCommandProcessor.this.commandProperties);
                this.connectorErrorMessages = new ArrayList<String>();
                this.matches = false;
                this.connectorType = connectorType;
            }
        }
    }

    public static enum TypeId implements Id
    {
        CONNECT,
        CONNECTIONSPEC,
        VERBOSE;

    }
}

