/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.alias;

import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.query.Query;

public class Alias {
    private String name = null;
    private String desc = null;
    private ObjectQueries queries = new ObjectQueries(null);
    private boolean _nullDefaults = false;
    private boolean _predefined = false;
    private String _group = null;
    protected static Logger LOGGER = Logger.getLogger(Alias.class.getName());
    public static final String GROUP_SYSTEM = "system";
    public static final String GROUP_REPORT = "report";
    public static final String GROUP_PSQL = "psql";
    public static final String GROUP_DEFAULT = "default";
    public static final String MINVERSION = "8";

    public Alias(String aliasName, String description, ObjectQueries preBuiltQueries, String group, boolean nullDefaults) {
        this.name = aliasName;
        this.desc = description;
        this.queries = preBuiltQueries;
        this._group = group;
        this._nullDefaults = nullDefaults;
    }

    public Alias(String aliasName, Query query, String description, String group, boolean nullDefaults) {
        this.name = aliasName;
        this.desc = description;
        this._group = group;
        this._nullDefaults = nullDefaults;
        this.queries.initQueries(query);
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public ObjectQueries getQueries() {
        return this.queries;
    }

    public String getQuery(ConnectionIdentifier id) {
        Query q;
        String result = null;
        if (this.queries != null && (q = this.queries.getQuery(id)) != null) {
            result = q.getSql();
        }
        return result;
    }

    public String getQuery(Version version) {
        Query q;
        String result = null;
        if (this.queries != null && (q = this.queries.getQuery(version)) != null) {
            result = q.getSql();
        }
        return result;
    }

    public static boolean isPredefinedGroup(String group) {
        return GROUP_DEFAULT.equalsIgnoreCase(group) || GROUP_SYSTEM.equalsIgnoreCase(group) || GROUP_PSQL.equalsIgnoreCase(group) || GROUP_REPORT.equalsIgnoreCase(group);
    }

    public static boolean isHostCommand(String cmd) {
        return cmd.toLowerCase().startsWith("!") || cmd.toLowerCase().startsWith("ho ") || cmd.toLowerCase().startsWith("hos ") || cmd.toLowerCase().startsWith("host ");
    }

    public boolean isNullDefaults() {
        return this._nullDefaults;
    }

    public boolean isPredefined() {
        return this._predefined;
    }

    public void setPredefined() {
        this._predefined = true;
    }

    public String getGroup() {
        return this._group;
    }
}

