/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class SetXQuery
extends CommandListener {
    public static final String XQUERY_BASEURI = "xquery.baseuri";
    public static final String XQUERY_ORDERING = "xquery.ordering";
    public static final String XQUERY_NODE = "xquery.node";
    public static final String XQUERY_CONTEXT = "xquery.context";
    public static final String help = "Usage: SET XQUERY {BASEURI text | CONTEXT text |\n NODE {BYVALUE | BYREFERENCE | DEFAULT} |\n ORDERING {UNORDERED | ORDERED | DEFAULT}}\n";

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String lastProperty;
        Handling lastHandling;
        block12: {
            if (!cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setxquery")) {
                return false;
            }
            String[] parts = ScriptParser.getTokens(cmd.getSql().trim());
            if (parts.length < 2) {
                return false;
            }
            if (parts.length >= 2 && !(parts[0] + parts[1]).trim().toLowerCase().equals("setxquery")) {
                return false;
            }
            lastHandling = Handling.NOOPTIONS;
            lastProperty = "";
            if (parts.length > 2) {
                int i = 2;
                lastHandling = Handling.BADOPTION;
                while (i + 1 < parts.length) {
                    String value;
                    lastProperty = parts[i];
                    if ((lastHandling = this.handleProperty(ctx, lastProperty, value = parts[++i])) == Handling.OK) {
                        ++i;
                        continue;
                    }
                    break block12;
                }
                if (i != parts.length) {
                    lastProperty = parts[i];
                    lastHandling = this.handleProperty(ctx, lastProperty, null);
                }
            }
        }
        switch (lastHandling.ordinal()) {
            case 2: {
                ctx.write(MessageFormat.format(Messages.getString("SETUNKNOWNOPTION"), lastProperty));
                break;
            }
            case 1: {
                ctx.write(Messages.getString("SetXQuery.1"));
            }
            case 3: {
                ctx.write(help);
            }
        }
        return true;
    }

    private Handling handleProperty(ScriptRunnerContext ctx, String property, String value) {
        Handling result = Handling.BADVALUE;
        String lowerValue = value != null ? value.toLowerCase() : "";
        if ("baseuri".equals(property = property.toLowerCase())) {
            ctx.putProperty(XQUERY_BASEURI, this.unQuote(value));
            result = Handling.OK;
        } else if ("context".equals(property)) {
            ctx.putProperty(XQUERY_CONTEXT, this.unQuote(value));
            result = Handling.OK;
        } else if ("node".equals(property)) {
            if ("byvalue".equals(lowerValue) || "byreference".equals(lowerValue) || "default".equals(lowerValue)) {
                ctx.putProperty(XQUERY_NODE, value.toUpperCase());
                result = Handling.OK;
            }
        } else if ("ordering".equals(property)) {
            if ("unordered".equals(lowerValue) || "ordered".equals(lowerValue) || "default".equals(lowerValue)) {
                ctx.putProperty(XQUERY_ORDERING, value.toUpperCase());
                result = Handling.OK;
            }
        } else {
            result = Handling.BADOPTION;
        }
        return result == Handling.OK && value == null ? Handling.BADVALUE : result;
    }

    private String unQuote(String str) {
        StringBuilder sb;
        if (str == null || str.length() == 0) {
            sb = new StringBuilder();
        } else {
            sb = new StringBuilder(str);
            char firstChar = sb.charAt(0);
            if (firstChar == '\'' || firstChar == '\"') {
                sb.deleteCharAt(0);
                for (int i = 0; i < sb.length(); ++i) {
                    if (sb.charAt(i) != firstChar || i != sb.length() - 1 && sb.charAt(i + 1) != firstChar) continue;
                    sb.deleteCharAt(i);
                }
            }
        }
        return sb.toString();
    }

    private static enum Handling {
        OK,
        NOOPTIONS,
        BADOPTION,
        BADVALUE;

    }
}

