/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.core.jdbc.tns.TNSEntry;
import oracle.dbtools.core.jdbc.tns.TNSNames;
import oracle.dbtools.core.jdbc.wallet.OracleWalletArchive;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.CloudConfigProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.WalletValue;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.jdbc.pool.OracleDataSource;

@Restricted(level=Restricted.Level.R4)
public class SetTNSAdmin
extends CommandListener
implements IShowCommand {
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("settns")) {
            String[] parts = cmd.getSQLOrig().split(" ");
            if (parts.length < 3) {
                ctx.write(Messages.getString("TNS_USAGE"));
                return true;
            }
            if (parts[2].equalsIgnoreCase("off")) {
                System.setProperty("oracle.net.tns_admin", "");
            } else {
                StringBuilder sb = new StringBuilder();
                for (int i = 2; i < parts.length; ++i) {
                    sb.append(parts[i]).append(" ");
                }
                File f = new File(sb.toString().trim());
                if (f.exists() && f.isDirectory()) {
                    ctx.write(MessageFormat.format(Messages.getString("TNS_LOCATION"), sb.toString().trim()) + "\n");
                    System.setProperty("oracle.net.tns_admin", sb.toString().trim());
                } else {
                    ctx.write(MessageFormat.format(Messages.getString("TNS_INVALID"), f.getAbsolutePath()) + "\n");
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String tnsAdminLocation;
        String[] bits = cmd.getSql().trim().split("\\s");
        boolean pingDB = bits.length == 2 && bits[1].equalsIgnoreCase("tnsping");
        ArrayList<TCPTNSEntry> entries = TNSHelper.getTNSEntries();
        ArrayList<String> usedLocations = new ArrayList<String>();
        TNSNames tnsNames = null;
        PropertyValues properties = ctx.getService(ConnectionContext.class).getContextPropertyValues();
        WalletValue cloudWallet = (WalletValue)CloudConfigProperty.CLOUDCONFIG.getValue(properties);
        if (cloudWallet != null) {
            OracleWalletArchive walletArchive = cloudWallet.getArchive();
            TNSNames tNSNames = tnsNames = walletArchive != null ? walletArchive.getTNSNames() : null;
            if (tnsNames != null) {
                String archiveLocation = cloudWallet.getLocation();
                String message = MessageFormat.format(Messages.getString("CLOUD_LOCATION"), archiveLocation);
                ctx.write(message);
                usedLocations.add(archiveLocation);
            }
        }
        if ((tnsAdminLocation = System.getProperty("oracle.net.tns_admin")) != null && tnsAdminLocation.length() > 0) {
            String message = MessageFormat.format(Messages.getString("TNS_LOCATION"), tnsAdminLocation);
            ctx.write(message);
            usedLocations.add(tnsAdminLocation);
        } else {
            Iterator<String> it = TNSHelper.getTNSLookupLocations().keySet().iterator();
            ctx.write("\n");
            ctx.write(this.underline(Messages.getString("TNS_LOOKUP_LOCATIONS"), "\n"));
            ctx.write("\n");
            int i = 1;
            while (it.hasNext()) {
                String key = it.next();
                if (it.hasNext()) {
                    ctx.write(MessageFormat.format("{0}.  {1}\n\t{2}\n", i, key, TNSHelper.getTNSLookupLocations().get(key)));
                    ++i;
                    continue;
                }
                usedLocations.add(TNSHelper.getTNSLookupLocations().get(key));
            }
        }
        ctx.write("\n");
        ctx.write(this.underline(Messages.getString(usedLocations.size() != 1 ? "TNS_LOOKUP_LOCATIONS_USED" : "TNS_LOOKUP_LOCATION_USED"), "\n"));
        ctx.write("\n");
        int i = 1;
        for (String location : usedLocations) {
            ctx.write(MessageFormat.format("{0}.  {1}\n", i, location));
            ++i;
        }
        this.writeEntries(ctx, entries, tnsNames, pingDB);
        return true;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"tns", "tnsadmin", "tns_admin", "tnsping"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    public static String test(String entry_name) {
        return SetTNSAdmin.testURL(TNSHelper.getEntry(entry_name).getJDBCUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String testURL(String url) {
        StringBuilder sb = new StringBuilder();
        Connection pconnection = null;
        long ping = 0L;
        long start = 0L;
        try {
            OracleDataSource ods = new OracleDataSource();
            ods.setURL(url);
            start = System.currentTimeMillis();
            pconnection = ods.getConnection();
            ping = System.currentTimeMillis() - start;
            return sb.toString();
        }
        catch (SQLException e) {
            int errorCode = e.getErrorCode();
            switch (errorCode) {
                case 12514: {
                    sb.append("\t");
                    sb.append(Messages.getString("TNS_PING_DATABASE_DOWN"));
                    return sb.toString();
                }
                case 17002: {
                    sb.append("\t");
                    sb.append(Messages.getString("TNS_PING_LISTENER_DOWN"));
                    return sb.toString();
                }
                case 1017: {
                    sb.append("\t");
                    sb.append(Messages.getString("TNS_PING_DATABASE_UP"));
                    sb.append("\n\t");
                    sb.append(MessageFormat.format(Messages.getString("TNS_PING_LATENCY"), ping));
                    return sb.toString();
                }
                case 17067: {
                    sb.append("\t");
                    sb.append(MessageFormat.format(Messages.getString("TNS_PING_INVALID_CONNECT_URL"), url));
                    return sb.toString();
                }
                default: {
                    sb.append("\t");
                    sb.append(MessageFormat.format(Messages.getString("TNS_PING_CONNECT_ERROR"), errorCode, url));
                    return sb.toString();
                }
            }
        }
        finally {
            try {
                if (pconnection != null) {
                    pconnection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void writeEntries(ScriptRunnerContext ctx, ArrayList<TCPTNSEntry> entries, TNSNames walletTNSNames, boolean pingDB) {
        ctx.write("\n");
        ctx.write(this.underline(Messages.getString("TNS_LOOKUP_AVAILABLE"), "\n"));
        ctx.write("\n");
        TreeMap<String, Object> availableEntries = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        if (walletTNSNames != null) {
            for (String string : walletTNSNames.nsNames()) {
                TNSEntry tnsEntry = walletTNSNames.getTNSEntry(string);
                availableEntries.put(string, tnsEntry);
            }
        }
        for (TCPTNSEntry tCPTNSEntry : entries) {
            String tnsName = tCPTNSEntry.getName();
            if (availableEntries.containsKey(tnsName)) continue;
            availableEntries.put(tnsName, tCPTNSEntry);
        }
        for (Map.Entry entry : availableEntries.entrySet()) {
            ctx.write((String)entry.getKey() + "\n");
            if (!pingDB || !(entry.getValue() instanceof TCPTNSEntry)) continue;
            ctx.write(SetTNSAdmin.testURL(((TCPTNSEntry)entry.getValue()).getJDBCUrl()) + "\n");
        }
    }

    private String underline(String text, String alignment) {
        StringBuilder sb = new StringBuilder(text);
        sb.append(alignment);
        char[] array = new char[text.length()];
        Arrays.fill(array, '-');
        sb.append(new String(array));
        return sb.toString();
    }
}

