/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.raptor.datatypes.PLSQLBlockComponent;

public class PLSQLBlockBuilder {
    public static final String IDENT = " ";
    protected ArrayList<LinkedList<String>> components;

    public PLSQLBlockBuilder() {
        int len = PLSQLBlockComponent.values().length;
        this.components = new ArrayList(len);
        for (int i = 0; i < len; ++i) {
            this.components.add(null);
        }
    }

    public void setComponent(PLSQLBlockComponent component, List<String> value) {
        LinkedList<String> newComponent = null;
        if (value != null) {
            newComponent = PLSQLBlockBuilder.addLists(component.getPrepend(), component.getUnique(), newComponent, value);
        }
        this.components.set(component.getSequence(), newComponent);
    }

    public void setComponent(PLSQLBlockComponent component, String[] value) {
        LinkedList<String> newComponent = null;
        if (value != null) {
            newComponent = PLSQLBlockBuilder.addLists(component.getPrepend(), component.getUnique(), newComponent, value);
        }
        this.components.set(component.getSequence(), newComponent);
    }

    public List<String> getComponent(PLSQLBlockComponent component) {
        return this.components.get(component.getSequence());
    }

    public List<String> addComponent(PLSQLBlockComponent component, List<String> value) {
        LinkedList<String> target = this.components.get(component.getSequence());
        target = PLSQLBlockBuilder.addLists(component.getPrepend(), component.getUnique(), target, value);
        this.components.set(component.getSequence(), target);
        return target;
    }

    public List<String> addComponent(PLSQLBlockComponent component, String[] value) {
        LinkedList<String> target = this.components.get(component.getSequence());
        target = PLSQLBlockBuilder.addLists(component.getPrepend(), component.getUnique(), target, value);
        this.components.set(component.getSequence(), target);
        return target;
    }

    public List<String> addComponent(PLSQLBlockComponent component, String value) {
        LinkedList<String> target = this.components.get(component.getSequence());
        if (value != null) {
            if (target == null) {
                target = new LinkedList();
                this.components.set(component.getSequence(), target);
            }
            if (!component.getUnique() || !target.contains(value)) {
                if (component.getPrepend()) {
                    target.addFirst(value);
                } else {
                    target.add(value);
                }
            }
        }
        return target;
    }

    public List<String> addComponent(PLSQLBlockComponent component, StringBuffer value) {
        return this.addComponent(component, value != null ? value.toString() : null);
    }

    public PLSQLBlockBuilder addBuilder(PLSQLBlockBuilder source) {
        for (PLSQLBlockComponent component : PLSQLBlockComponent.values()) {
            int sequence = component.getSequence();
            boolean prepend = component.getPrepend();
            boolean unique = component.getUnique();
            this.components.set(sequence, PLSQLBlockBuilder.addLists(prepend, unique, this.components.get(sequence), (List<String>)source.components.get(sequence)));
        }
        return this;
    }

    private static LinkedList<String> addLists(boolean prepend, boolean unique, LinkedList<String> target, String[] source) {
        LinkedList<String> ret = target;
        if (source != null) {
            int i = 0;
            for (String text : source) {
                if (unique && PLSQLBlockBuilder.contains(ret, text)) continue;
                if (prepend) {
                    ret = PLSQLBlockBuilder.add(ret, i, text);
                    ++i;
                    continue;
                }
                ret = PLSQLBlockBuilder.add(ret, text);
            }
        }
        return ret;
    }

    private static LinkedList<String> addLists(boolean prepend, boolean unique, LinkedList<String> target, List<String> source) {
        LinkedList<String> ret = target;
        if (source != null) {
            if (!unique) {
                ret = prepend ? PLSQLBlockBuilder.addAll(ret, 0, source) : PLSQLBlockBuilder.addAll(ret, source);
            } else {
                int i = 0;
                for (String text : source) {
                    if (PLSQLBlockBuilder.contains(ret, text)) continue;
                    if (prepend) {
                        ret = PLSQLBlockBuilder.add(ret, i, text);
                        ++i;
                        continue;
                    }
                    ret = PLSQLBlockBuilder.add(ret, text);
                }
            }
        }
        return ret;
    }

    private static boolean contains(LinkedList<String> list, String value) {
        return list != null && list.contains(value);
    }

    private static LinkedList<String> add(LinkedList<String> list, String value) {
        LinkedList<String> ret = list == null ? new LinkedList<String>() : list;
        ret.add(value);
        return ret;
    }

    private static LinkedList<String> add(LinkedList<String> list, int index, String value) {
        LinkedList<String> ret = list == null ? new LinkedList<String>() : list;
        ret.add(index, value);
        return ret;
    }

    private static LinkedList<String> addAll(LinkedList<String> list, Collection<String> value) {
        LinkedList<String> ret = list == null ? new LinkedList<String>() : list;
        ret.addAll(value);
        return ret;
    }

    private static LinkedList<String> addAll(LinkedList<String> list, int index, Collection<String> value) {
        LinkedList<String> ret = list == null ? new LinkedList<String>() : list;
        ret.addAll(index, value);
        return ret;
    }

    public String generateSql() {
        StringBuilder sb = new StringBuilder();
        List<String> Prototype = this.getComponent(PLSQLBlockComponent.Prototype);
        List<String> dataDecls = this.getComponent(PLSQLBlockComponent.DataDecls);
        List<String> stdProcDecls = this.getComponent(PLSQLBlockComponent.StdProcDecls);
        List<String> procDecls = this.getComponent(PLSQLBlockComponent.ProcDecls);
        List<String> dataInitBlocks = this.getComponent(PLSQLBlockComponent.DataInitBlocks);
        List<String> preCallBlocks = this.getComponent(PLSQLBlockComponent.PreCallBlocks);
        List<String> preCallWrapper = this.getComponent(PLSQLBlockComponent.PreCallWrapper);
        List<String> call = this.getComponent(PLSQLBlockComponent.Call);
        List<String> paramBinding = this.getComponent(PLSQLBlockComponent.ParamBinding);
        List<String> postCallWrapper = this.getComponent(PLSQLBlockComponent.PostCallWrapper);
        List<String> postCallBlocks = this.getComponent(PLSQLBlockComponent.PostCallBlocks);
        List<String> otherBlocks = this.getComponent(PLSQLBlockComponent.OthersBlocks);
        int identLevel = 0;
        if (Prototype != null) {
            this.formatStatement(sb, identLevel++, Prototype);
            this.formatStatement(sb, identLevel, dataDecls);
            this.formatStatement(sb, identLevel, stdProcDecls);
            this.formatStatement(sb, identLevel--, procDecls);
        } else if (dataDecls != null || stdProcDecls != null || procDecls != null) {
            this.formatStatement(sb, identLevel++, "DECLARE");
            this.formatStatement(sb, identLevel, dataDecls);
            this.formatStatement(sb, identLevel, stdProcDecls);
            this.formatStatement(sb, identLevel--, procDecls);
        }
        this.formatStatement(sb, identLevel++, "BEGIN");
        this.formatStatement(sb, identLevel, dataInitBlocks);
        if (otherBlocks != null) {
            this.formatStatement(sb, identLevel++, "BEGIN");
        }
        this.formatStatement(sb, identLevel, preCallBlocks);
        if (preCallWrapper != null) {
            this.formatText(sb, identLevel, preCallWrapper);
        } else {
            this.formatText(sb, identLevel, "");
        }
        this.formatText(sb, 0, call);
        if (paramBinding != null) {
            this.formatText(sb, 0, "(");
            this.formatParameters(sb, identLevel + 1, paramBinding);
            this.formatText(sb, 0, ")");
        }
        if (postCallWrapper != null) {
            this.formatText(sb, 0, postCallWrapper);
        }
        if (preCallWrapper != null || call != null || paramBinding != null || postCallWrapper != null) {
            this.formatStatement(sb, 0, ";");
        }
        this.formatStatement(sb, identLevel, postCallBlocks);
        if (otherBlocks != null) {
            this.formatStatement(sb, --identLevel, "EXCEPTION");
            this.formatStatement(sb, ++identLevel, "WHEN OTHERS");
            this.formatStatement(sb, identLevel++, "THEN");
            this.formatStatement(sb, identLevel, otherBlocks);
            this.formatStatement(sb, --identLevel, "END;");
        }
        this.formatStatement(sb, --identLevel, "END;");
        return sb.toString();
    }

    protected StringBuilder formatStatement(StringBuilder sb, int identLevel, List<String> blocks) {
        StringBuilder retBuffer = sb;
        if (blocks != null) {
            for (String block : blocks) {
                retBuffer = this.formatStatement(retBuffer, identLevel, block);
            }
        }
        return retBuffer;
    }

    private StringBuilder formatStatement(StringBuilder sb, int identLevel, String block) {
        if (block != null) {
            this.formatText(sb, identLevel, block);
            sb.append('\n');
        }
        return sb;
    }

    protected StringBuilder formatText(StringBuilder sb, int identLevel, List<String> blocks) {
        StringBuilder retBuffer = sb;
        if (blocks != null) {
            for (String block : blocks) {
                retBuffer = this.formatText(retBuffer, identLevel, block);
            }
        }
        return retBuffer;
    }

    protected StringBuilder formatText(StringBuilder sb, int identLevel, String block) {
        if (block != null) {
            this.formatIdent(sb, identLevel);
            sb.append(block);
        }
        return sb;
    }

    protected StringBuilder formatParameters(StringBuilder sb, int identLevel, List<String> parameters) {
        if (parameters != null) {
            int i = 0;
            for (String parameter : parameters) {
                if (parameter == null) continue;
                if (i > 0) {
                    sb.append(",");
                    if (identLevel > 0) {
                        sb.append('\n');
                        this.formatIdent(sb, identLevel);
                    } else {
                        sb.append(' ');
                    }
                }
                sb.append(parameter);
                ++i;
            }
        }
        return sb;
    }

    protected StringBuilder formatIdent(StringBuilder sb, int identLevel) {
        for (int i = 0; i < identLevel; ++i) {
            sb.append(IDENT);
        }
        return sb;
    }
}

