/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import oracle.dbtools.data.common.HasSize;
import oracle.dbtools.data.common.Iterators;

public class Iterables {
    private Iterables() {
    }

    public static <T> void add(Collection<T> collection, Iterable<? extends T> items) {
        Iterables.add(collection, items, false);
    }

    public static <T> void add(Collection<T> collection, Iterable<? extends T> items, boolean ignoreNulls) {
        Iterators.add(collection, items == null ? null : items.iterator(), ignoreNulls);
    }

    public static String asString(Iterable<?> items) {
        StringBuilder b = new StringBuilder("[");
        b.append(Iterables.join(items, ", "));
        b.append("]");
        return b.toString();
    }

    public static <T> int compare(Iterable<? extends T> i1, Iterable<? extends T> i2) {
        return Iterators.compare(i1.iterator(), i2.iterator());
    }

    public static <T> int compare(Iterable<T> i1, Iterable<T> i2, Comparator<T> comparator) {
        return Iterators.compare(i1.iterator(), i2.iterator(), comparator);
    }

    public static <T> Iterable<T> empty() {
        return Collections.emptyList();
    }

    public static <T> boolean equals(Iterable<? extends T> i1, Iterable<? extends T> i2) {
        return Iterators.equals(i1.iterator(), i2.iterator());
    }

    public static final <T> T first(Iterable<T> items) {
        if (items == null) {
            return null;
        }
        return Iterators.nextOrNull(items.iterator());
    }

    public static final <T> Iterable<T> iterable(Iterator<? extends T> items) {
        ArrayList values = new ArrayList();
        Iterators.add(values, items);
        return values;
    }

    public static final <T> Iterable<T> iterable(T ... items) {
        return new ArrayIterable<T>(items);
    }

    public static String join(Iterable<?> items, String separator) {
        return Iterators.join(items.iterator(), separator);
    }

    public static <T> Iterable<T> merge(Iterable<? extends T> existingItems, Iterable<? extends T> items) {
        ArrayList newItems = new ArrayList();
        Iterables.add(newItems, items);
        LinkedHashSet mergedItems = new LinkedHashSet();
        Iterables.add(mergedItems, existingItems);
        for (T existing : existingItems) {
            Iterator n = newItems.iterator();
            while (n.hasNext()) {
                Object newItem = n.next();
                boolean matched = existing == newItem || existing.equals(newItem);
                if (!matched) continue;
                n.remove();
            }
        }
        mergedItems.addAll(newItems);
        return mergedItems;
    }

    public static int size(Iterable<?> items) {
        if (items instanceof Collection) {
            return ((Collection)items).size();
        }
        if (items instanceof HasSize) {
            return ((HasSize)((Object)items)).size();
        }
        int count = 0;
        for (Object item : items) {
            ++count;
        }
        return count;
    }

    public static final <T> Iterable<T> sort(Iterable<T> items, Comparator<T> sortOrder) {
        ArrayList tosort = new ArrayList();
        Iterables.add(tosort, items);
        Collections.sort(tosort, sortOrder);
        return tosort;
    }

    private static final class ArrayIterable<T>
    implements Iterable<T>,
    HasSize {
        private final T[] items;

        private ArrayIterable(T[] items) {
            this.items = items;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Iterable) {
                Iterable other = (Iterable)obj;
                return Iterables.equals(this, other);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return Arrays.hashCode(this.items);
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.iterator(this.items);
        }

        @Override
        public int size() {
            return this.items.length;
        }

        public String toString() {
            return Arrays.toString(this.items);
        }
    }
}

