/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.security;

public abstract class SecureReferenceData<T> {
    private final T value;

    static SecureReferenceData<char[]> buildCredentialReference(char[] data) {
        return new CredentialsReferenceData(data != null ? (char[])data.clone() : null);
    }

    static SecureReferenceData<Void> buildNullReference() {
        return NullReferenceData.INSTANCE;
    }

    private SecureReferenceData(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public abstract String toString();

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static final class CredentialsReferenceData
    extends SecureReferenceData<char[]> {
        CredentialsReferenceData(char[] data) {
            super(data);
        }

        @Override
        public String toString() {
            return new String((char[])this.getValue());
        }
    }

    private static final class NullReferenceData
    extends SecureReferenceData<Void> {
        static final NullReferenceData INSTANCE = new NullReferenceData();

        private NullReferenceData() {
            super(null);
        }

        @Override
        public String toString() {
            return "null";
        }
    }
}

