/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.db.ora.auth;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.connections.ConnectionConstants;
import oracle.dbtools.connections.db.ora.OracleConnectionUtils;
import oracle.dbtools.core.jdbc.DataSourceBuilder;
import oracle.dbtools.core.jdbc.DataSourceConfigurator;
import oracle.dbtools.core.jdbc.configurators.SimpleCredentialsConfiguration;
import oracle.dbtools.raptor.utils.WindowsUtility;

public final class OracleAuthenticationConfiguration
implements DataSourceConfigurator,
ConnectionConstants {
    private final DataSourceConfigurator authenticationConfig;
    private final String osuser;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Properties props) {
        return new Builder().properties(props);
    }

    private OracleAuthenticationConfiguration(SimpleCredentialsConfiguration baseAuth, String osuser) {
        this.authenticationConfig = baseAuth;
        this.osuser = osuser;
    }

    public void configure(DataSourceBuilder<?> dsBuilder) throws SQLException, IOException {
        String url;
        String driverType;
        this.authenticationConfig.configure(dsBuilder);
        if (this.osuser != null && "thin".equalsIgnoreCase(driverType = OracleConnectionUtils.scrubOraDriverType(url = dsBuilder.url()))) {
            Properties props = new Properties();
            props.setProperty("v$session.osuser", this.osuser);
            dsBuilder.connectionProperties(props);
        }
    }

    public static final class Builder {
        private SimpleCredentialsConfiguration.Builder basicBuilder;
        private String osuser;

        private Builder() {
        }

        public Builder properties(Properties props) {
            this.basicBuilder = SimpleCredentialsConfiguration.builder((Properties)props);
            if (Boolean.parseBoolean(props.getProperty("OS_AUTHENTICATION")) && PlatformUtils.isWindows()) {
                this.osuser = WindowsUtility.getUserWithDomain();
            }
            return this;
        }

        public OracleAuthenticationConfiguration build() {
            return new OracleAuthenticationConfiguration(this.basicBuilder.build(), this.osuser);
        }
    }
}

