/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.db.ora;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import oracle.dbtools.connections.db.DBAdapterBundle;
import oracle.dbtools.connections.db.ora.AbstractOracleConnCreator;

public class LegacyOracleConnectionCreator
extends AbstractOracleConnCreator {
    public static final String ORACLE_DRIVER_CLASS = "oracle.jdbc.OracleDriver";
    public static final String OLD_ORACLE_DRIVER_CLASS = "oracle.jdbc.driver.OracleDriver";
    public static final String SUBTYPE_ORA_JDBC = "oraJDBC";
    public static final String ORA_DRIVER_TYPE_CLASS_REFTYPE = "oraDriverType";
    public static final String ORA_DRIVER_THIN = "thin";
    public static final String ORA_DRIVER_OCI8 = "oci8";

    @Override
    public String getConnectionURL(Properties props) throws SQLException {
        String customURL = super.getConnectionURL(props);
        if (this.hasLength(customURL)) {
            return customURL;
        }
        String hostname = this.getPropertyOrThrow(props, "hostname");
        String port = this.getPropertyOrThrow(props, "port");
        String sid = props.getProperty("sid");
        String servicename = props.getProperty("serviceName");
        String oraDriverType = this.getPropertyOrThrow(props, ORA_DRIVER_TYPE_CLASS_REFTYPE);
        if (ORA_DRIVER_THIN.equals(oraDriverType)) {
            if (sid != null) {
                return "jdbc:oracle:thin:@" + hostname + ":" + port + ":" + sid;
            }
            if (servicename != null) {
                return "jdbc:oracle:thin:@//" + hostname + ":" + port + "/" + servicename;
            }
            throw new SQLException(DBAdapterBundle.get("ERROR_SID_SERVICE_NAME"));
        }
        if (ORA_DRIVER_OCI8.equals(oraDriverType)) {
            StringBuilder url = new StringBuilder();
            url.append("jdbc:oracle:oci8:@");
            url.append("(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=");
            url.append(hostname);
            url.append(")(PORT=");
            url.append(port);
            url.append("))(CONNECT_DATA=(");
            if (sid != null) {
                url.append("SID=").append(sid);
            } else if (servicename != null) {
                url.append("SERVICE_NAME=").append(servicename);
            } else {
                throw new SQLException(DBAdapterBundle.get("ERROR_SID_SERVICE_NAME"));
            }
            url.append(")))");
            return url.toString();
        }
        throw new SQLException("Unrecognized Oracle JDBC driver type: " + oraDriverType);
    }

    @Override
    public String getDriverClassName(Properties props) throws SQLException {
        String driverClassName = super.getDriverClassName(props);
        if (this.hasLength(driverClassName) && !driverClassName.equals(OLD_ORACLE_DRIVER_CLASS)) {
            return driverClassName;
        }
        return ORACLE_DRIVER_CLASS;
    }

    @Override
    public Collection<String> listAllowedProperties() {
        Collection<String> retval = super.listAllowedProperties();
        retval.add("serviceName");
        return retval;
    }

    @Override
    public Collection<String> listRequiredProperties() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("hostname");
        retval.add("port");
        retval.add(ORA_DRIVER_TYPE_CLASS_REFTYPE);
        return retval;
    }
}

