/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.connections.Location;
import oracle.dbtools.connections.Storage;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.connections.impl.ConnectionsList;
import oracle.dbtools.util.Logger;

public final class StorageManager {
    public static final String DEFAULT_CONNECTIONS_FILENAME = "connections.json";
    private static final String CONNECTIONS_PROPERTY = "connections";
    static final String NAME_PROPERTY = "name";
    static final String TYPE_PROPERTY = "type";
    static final String INFO_PROPERTY = "info";
    private static final ChangeProcessor NCP = new ChangeProcessor(){

        @Override
        public void processChange(ChangeProcessor.Change change) {
        }
    };
    private final Location mLocation;
    private final ConnectionsList mRoot;
    private final Map<String, Object> mEnvironment;
    private final ChangeProcessor mChangeProcessor;

    public static Builder builder() {
        return new Builder();
    }

    private StorageManager(Location location, ConnectionsList root, boolean autoSave, Map<String, Object> env) {
        this.mLocation = location;
        this.mRoot = root;
        this.mEnvironment = Collections.unmodifiableMap(env);
        this.mChangeProcessor = autoSave ? new ChangeProcessor(){

            @Override
            public void processChange(ChangeProcessor.Change change) throws StorageException {
                StorageManager.this.save();
            }
        } : NCP;
    }

    private static ConnectionsList getRoot(Location location) throws StorageException {
        ConnectionsList root = null;
        if (location == null) {
            Logger.warn(StorageManager.class, "StorageManager created with null location");
            root = new ConnectionsList();
        } else {
            try {
                if (location.exists()) {
                    root = (ConnectionsList)JSON.std.beanFrom(ConnectionsList.class, (Object)location.getInputStream());
                }
                if (root == null) {
                    root = new ConnectionsList();
                }
            }
            catch (JsonParseException e) {
                Logger.warn(StorageManager.class, "Unexpected error encountered loading " + String.valueOf(location));
                throw new StorageException(e);
            }
            catch (IOException e) {
                Logger.severe(StorageManager.class, "Unexpected error encountered loading " + String.valueOf(location), e);
                throw new StorageException(e);
            }
        }
        return root;
    }

    public void save() throws StorageException {
        this.saveImpl(this.mLocation);
    }

    public void saveAs(Location location) throws StorageException {
        this.saveImpl(location);
    }

    public <T> Storage<T> getStorage(String type) {
        return Storage.createStorage(type, this);
    }

    private void saveImpl(Location location) throws StorageException {
        if (location == null) {
            Logger.warn(StorageManager.class, "Attempt to save to null location");
            throw new StorageException("Storage location is null");
        }
        try (OutputStream os = location.getOutputStream();){
            JSON.std.write((Object)this.mRoot, os);
        }
        catch (IOException e) {
            Logger.severe(StorageManager.class, e);
            throw new StorageException(e);
        }
    }

    ConnectionsList getStorageData(String connType) {
        return this.mRoot;
    }

    Map<String, Object> getEnv() {
        return this.mEnvironment;
    }

    ChangeProcessor getChangeProcessor() {
        return this.mChangeProcessor;
    }

    public static class Builder {
        private Location mLocation;
        private ConnectionsList mRoot;
        private Map<String, Object> mEnv;
        private boolean mAutosave;

        Builder() {
        }

        public Builder addEnvValue(String key, Object value) {
            if (this.mEnv == null) {
                this.mEnv = new HashMap<String, Object>();
            }
            this.mEnv.put(key, value);
            return this;
        }

        public Builder location(Location location) throws StorageException {
            this.mLocation = location;
            this.mRoot = StorageManager.getRoot(this.mLocation);
            if (this.mLocation != null) {
                URI relativeRoot = this.mLocation.getRelativeRoot();
                this.addEnvValue("Location.Root", relativeRoot);
            }
            return this;
        }

        public Builder autosave(boolean autosave) {
            this.mAutosave = autosave;
            return this;
        }

        public StorageManager build() {
            ConnectionsList root = this.mRoot != null ? this.mRoot : new ConnectionsList();
            return new StorageManager(this.mLocation, root, this.mAutosave, this.mEnv != null ? this.mEnv : Collections.emptyMap());
        }
    }

    static interface ChangeProcessor {
        public void processChange(Change var1) throws StorageException;

        public static enum Change {
            ADD,
            REMOVE,
            UPDATE;

        }
    }
}

