/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection0;

import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import oracle.dbtools.app.injection0.DependencyLink;
import oracle.dbtools.app.injection0.SqlInjection;
import oracle.dbtools.app.injection0.SqlInjectionGraph;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.SqlEarley;

public class SqlInjectionWarningTest {
    private static final boolean DEBUG = false;
    private static final String TEXT = "FUNCTION sample1 (d1 VARCHAR2)" + System.lineSeparator() + "RETURN NUMBER IS" + System.lineSeparator() + "  val NUMBER;" + System.lineSeparator() + "BEGIN'" + System.lineSeparator() + " execute immediate 'SELECT count(1) FROM ' || d1  INTO val;" + System.lineSeparator() + " RETURN val;" + System.lineSeparator() + "END;" + System.lineSeparator();

    public static void main(String[] args) throws Exception {
        String text = TEXT;
        List fragment = Lexer.parse((String)text);
        Parsed target = new Parsed(text, fragment, (Earley)SqlEarley.getInstance(), new String[]{"parse with errors"});
        ParseNode root = target.getRoot();
        int begin = 100;
        int caret = 150;
        TreeSet<SqlInjectionAdvice> wiggleRangesNew = new TreeSet<SqlInjectionAdvice>();
        TreeSet<SqlInjectionAdvice> wiggleRangesOld = new TreeSet<SqlInjectionAdvice>();
        String connection = "cosmic";
        try {
            SqlInjectionGraph sig = new SqlInjectionGraph(text, fragment, root);
            List<List<DependencyLink>> injections = sig.getInjections(text);
            for (List<DependencyLink> inj : injections) {
                System.out.println("Editor warning: " + SqlInjectionGraph.getEditorWarningText(inj));
                System.out.println("   " + String.valueOf(inj));
                wiggleRangesNew.add(new SqlInjectionAdvice(begin + inj.get(inj.size() - 1).getBegin(), begin + inj.get(inj.size() - 1).getEnd(), SqlInjectionGraph.getEditorWarningText(inj)));
            }
        }
        catch (Exception ex) {
            System.out.println("BOOM!  ...ooops");
            System.out.println(ex);
        }
        SqlInjection inject = SqlInjection.findDependencies(text);
        for (int n : inject.params) {
            for (int e : inject.execs) {
                String vars;
                ParseNode se;
                ParseNode ss = inject.parseNode2Scope.get(n);
                if (ss != (se = inject.parseNode2Scope.get(e)) || (vars = inject.dependencyStr(n, e)) == null) continue;
                LinkedList<Integer> dependencyChain = inject.dependencyChain(n, e);
                wiggleRangesOld.add(new SqlInjectionAdvice(begin + ((LexerToken)fragment.get((int)dependencyChain.getLast().intValue())).begin, begin + ((LexerToken)fragment.get((int)dependencyChain.getLast().intValue())).end, "SQL Injection dependency: " + vars.toString()));
            }
        }
        System.out.println(wiggleRangesNew.size() + "wiggles NEW");
        for (Issue issue : wiggleRangesNew) {
            System.out.println(issue);
        }
        System.out.println(wiggleRangesOld.size() + "wiggles OLD");
        for (Issue issue : wiggleRangesOld) {
            System.out.println(issue);
        }
        System.out.println(TEXT);
    }

    private static class SqlInjectionAdvice
    extends Issue {
        SqlInjectionAdvice(int from, int to, String message) {
            super(from, to, message, Issue.Type.ADVISORY);
        }
    }

    private static class Issue {
        private int line;
        private int offset;
        private String msg;
        private Type type;

        boolean isError() {
            return this.type == Type.ERROR;
        }

        Issue(int line, int offset, String message, Type type) {
            this.line = line;
            this.offset = offset;
            this.msg = message;
            this.type = type;
        }

        static enum Type {
            ERROR(0),
            WARNING(1),
            ADVISORY(2);

            int id;

            private Type(int i) {
                this.id = i;
            }

            public int toInt() {
                return this.id;
            }
        }
    }
}

