/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.dg;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.sqlcl.commands.dg.DgCmdBase;
import oracle.dbtools.sqlcl.commands.dg.DgConfig;
import oracle.dbtools.sqlcl.commands.dg.DgConfigInst;
import oracle.dbtools.sqlcl.commands.dg.DgConfigMember;
import oracle.dbtools.sqlcl.commands.dg.DgConstants;
import oracle.dbtools.sqlcl.commands.dg.DgDBUtils;
import oracle.dbtools.sqlcl.commands.dg.DgDBVersion;
import oracle.dbtools.sqlcl.commands.dg.DgOpTable;
import oracle.dbtools.sqlcl.commands.dg.DgResult;
import oracle.dbtools.sqlcl.commands.dg.DgUtils;
import oracle.dbtools.sqlcl.commands.dg.DgXmlObject;
import oracle.dbtools.sqlcl.commands.dg.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DgCmdConfig
extends DgCmdBase {
    protected static final Logger LOGGER = Logger.getLogger(DgCmdConfig.class.getName());
    protected static final int CFG_OBJID = 4096;

    public DgCmdConfig(ScriptRunnerContext scriptCtx, Connection sqlConn) {
        super(scriptCtx, sqlConn);
    }

    public void runShowConfig(boolean verbose) {
        boolean refresh = verbose;
        if (!this.checkConnection()) {
            return;
        }
        try {
            DgConfig cfg = DgConfig.readConfig(this.sqlConn, true);
            if (cfg == null) {
                this.scriptCtx.write(Messages.getString("DGCmd.NODRC"));
            } else {
                boolean header = false;
                if (refresh) {
                    cfg.refresh(this.sqlConn, true);
                }
                if (cfg.memberMap.size() == 0) {
                    String drc_status_st = DgDBUtils.queryOneRow(this.sqlConn, "SELECT drc_status FROM x$rfmp");
                    int drc_status = 0;
                    if (drc_status_st != null) {
                        drc_status = Integer.valueOf(drc_status_st);
                    }
                    if (drc_status != 0) {
                        this.printOraError(drc_status);
                        return;
                    }
                }
                ShowConfigContext scCtx = new ShowConfigContext();
                this.scriptCtx.write("\n");
                this.scriptCtx.write(String.format("Configuration - %s\n", cfg.name));
                String prot = "";
                if (cfg.protectMode == 2) {
                    prot = "MaxProtection";
                } else if (cfg.protectMode == 1) {
                    prot = "MaxAvailability";
                } else if (cfg.protectMode == 0) {
                    prot = "MaxPeformance";
                }
                this.scriptCtx.write("\n");
                this.scriptCtx.write(DgUtils.indent(1));
                this.scriptCtx.write(String.format("Protection Mode: %s\n", prot));
                this.scriptCtx.write(DgUtils.indent(1));
                this.scriptCtx.write("Members:\n");
                DgConfigMember primary = cfg.getPrimary();
                if (primary != null) {
                    this.printDRCmember(this.sqlConn, cfg, primary, 1, scCtx);
                }
                for (DgConfigMember member : cfg.memberMap.values()) {
                    if (scCtx.printed.contains(member)) continue;
                    if (!header) {
                        this.scriptCtx.write("\n" + DgUtils.indent(1));
                        this.scriptCtx.write("Members Not Receiving Redo:\n");
                        header = true;
                    }
                    this.printDRCmember(this.sqlConn, cfg, member, 1, scCtx);
                }
                this.scriptCtx.write("\n");
                if (verbose) {
                    DgUtils.indent(1);
                    this.scriptCtx.write("Properties:\n");
                    if (this.getDBVersion().lessThan(DgConstants.VERSION_21_0)) {
                        this.printMemberProps19(null, 4096, 2);
                    } else {
                        this.printMemberProps(null, 2);
                    }
                    this.scriptCtx.write("\n");
                }
                this.scriptCtx.write(String.format("Fast-Start Failover: %s\n", cfg.fsfoMode == 0 ? "Disabled" : "Enabled"));
                this.scriptCtx.write("\n");
                this.scriptCtx.write(Messages.getString("DGCmd.5000"));
                if (!cfg.enabled) {
                    this.scriptCtx.write(Messages.getString("DGCmd.16958"));
                } else {
                    this.scriptCtx.write(scCtx.overall_status);
                    if (!refresh) {
                        this.scriptCtx.write(" (");
                        if (scCtx.updated_time == 1) {
                            this.scriptCtx.write(Messages.getString("DGCmd.5167"));
                        } else {
                            this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.5168"), scCtx.updated_time));
                        }
                        this.scriptCtx.write(")");
                    }
                }
                this.scriptCtx.write("\n");
            }
        }
        catch (SQLException ex) {
            this.printException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runShowConfigProp(String prop) {
        if (!this.checkConnection()) {
            return;
        }
        DgDBVersion dbVersion = this.getDBVersion();
        int status = 0;
        if (dbVersion.lessThan(DgConstants.VERSION_21_0)) {
            this.printProp19(this.sqlConn, null, prop);
            return;
        }
        String sql = "begin ? := dbms_drs.get_configuration_property(?, ?); end;";
        CallableStatement cstmt = null;
        if (LockManager.lock((Connection)this.sqlConn)) {
            try {
                cstmt = this.sqlConn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.setString(2, prop);
                cstmt.registerOutParameter(3, 12);
                cstmt.executeUpdate();
                status = cstmt.getInt(1);
                if (status == 0) {
                    this.scriptCtx.write(String.format("  %s = '%s'\n", prop, cstmt.getString(3)));
                }
                this.printOraError(status);
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)this.sqlConn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    public void runShowMember(String mname, boolean verbose) {
        String statusStr = "";
        if (!this.checkConnection()) {
            return;
        }
        DgConfig cfg = DgConfig.readConfig(this.sqlConn, true);
        DgConfigMember member = cfg.getMember(mname);
        if (member == null) {
            this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.NOOBJ"), mname));
            return;
        }
        int objectid = DgDBUtils.getObjectIdMember(this.sqlConn, member.name);
        this.scriptCtx.write(String.format("Database - %s\n", mname));
        this.scriptCtx.write("\n");
        this.scriptCtx.write(String.format("  %-20s %s\n", Messages.getString("DGCmd.5023"), this.roleToString(member.role)));
        this.scriptCtx.write(String.format("  %-20s %s\n", Messages.getString("DGCmd.5024"), this.getMemberIntendedSate(member.istate)));
        if (member.enabled) {
            this.printLags(this.sqlConn, member, 1, verbose, true);
            this.scriptCtx.write(String.format("  %-20s\n", Messages.getString("DGCmd.5026")));
            for (DgConfigInst inst : member.instMap.values()) {
                this.scriptCtx.write(String.format("    %s\n", inst.name));
            }
            this.scriptCtx.write("\n");
            String outdoc = this.getMonitorProperty(this.sqlConn, objectid, "StatusReport");
            DgXmlObject outObj = DgXmlObject.create(outdoc);
            int status = this.printMemberStatus(member, outObj, 1);
            statusStr = status == 16501 ? Messages.getString("DGCmd.5001") : (status == 16502 ? Messages.getString("DGCmd.16911") : Messages.getString("DGCmd.16955"));
        } else {
            statusStr = Messages.getString("DGCmd.16958");
        }
        if (verbose) {
            DgUtils.indent(1);
            this.scriptCtx.write(Messages.getString("DGCmd.5032") + "\n");
            if (this.getDBVersion().lessThan(DgConstants.VERSION_21_0)) {
                this.printMemberProps19(member, objectid, 2);
            } else {
                this.printMemberProps(member, 2);
            }
            this.scriptCtx.write("\n");
        }
        if (member.role == 5) {
            this.scriptCtx.write(Messages.getString("DGCmd.5138"));
        } else {
            this.scriptCtx.write(Messages.getString("DGCmd.5010"));
        }
        this.scriptCtx.write("\n" + statusStr + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runShowMemberProp(String mname, String prop) {
        if (!this.checkConnection()) {
            return;
        }
        DgDBVersion dbVersion = this.getDBVersion();
        int status = 0;
        if (dbVersion.lessThan(DgConstants.VERSION_21_0)) {
            this.printProp19(this.sqlConn, mname, prop);
        } else {
            String sql = "begin ? := dbms_drs.get_property2(?, ?, ?); end;";
            CallableStatement cstmt = null;
            if (LockManager.lock((Connection)this.sqlConn)) {
                try {
                    cstmt = this.sqlConn.prepareCall("begin ? := dbms_drs.get_property2(?, ?, ?); end;");
                    cstmt.registerOutParameter(1, 4);
                    cstmt.setString(2, mname);
                    cstmt.setString(3, prop);
                    cstmt.registerOutParameter(4, 12);
                    cstmt.executeUpdate();
                    status = cstmt.getInt(1);
                    if (status == 0) {
                        this.scriptCtx.write(String.format("  %s = '%s'\n", prop, cstmt.getString(4)));
                    }
                    this.printOraError(status);
                }
                catch (SQLException ex) {
                    this.printException(ex);
                }
                finally {
                    DgDBUtils.cleanup(cstmt, null);
                    LockManager.unlock((Connection)this.sqlConn);
                }
            } else {
                LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
            }
        }
    }

    public void runShowAllMemberProp(String prop) {
        if (!this.checkConnection()) {
            return;
        }
        try {
            ArrayList<String> members = DgDBUtils.getAllMembers(this.sqlConn);
            for (String member : members) {
                this.scriptCtx.write(String.format("  %s:", member));
                this.runShowMemberProp(member, prop);
            }
        }
        catch (SQLException ex) {
            this.printException(ex);
        }
    }

    public void printProp19(Connection conn, String mname, String prop) {
        int objid = 0;
        if (mname != null) {
            DgDBUtils.getObjectIdMember(conn, mname);
        } else {
            objid = 4096;
        }
        if (objid > 0) {
            String propValue = DgDBUtils.queryProperty19(conn, objid, prop);
            LOGGER.info("Property: " + propValue);
            if (propValue == null) {
                propValue = "";
            }
            if (propValue.startsWith("<RESULT >")) {
                DgResult result = (DgResult)DgXmlObject.create(propValue);
                this.printResultAll(result, null);
            } else {
                this.scriptCtx.write(String.format("  %s = '%s'\n", prop, propValue));
            }
        } else {
            this.printOraError(16596);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAddMember(String mname, String ci, String mtype) {
        block18: {
            block19: {
                if (!this.checkConnection()) {
                    return;
                }
                String SQL_DB = "begin ? := dbms_drs.add_database(?, ?); end;";
                String SQL_FS = "begin ? := dbms_drs.add_far_sync(?, ?); end;";
                String SQL_RA = "begin ? := dbms_drs.add_recovery_appliance(?, ?); end;";
                CallableStatement cstmt = null;
                if (!LockManager.lock((Connection)this.sqlConn)) break block19;
                try {
                    String sql = null;
                    if (mtype.equalsIgnoreCase("database")) {
                        sql = "begin ? := dbms_drs.add_database(?, ?); end;";
                    } else if (mtype.equalsIgnoreCase("far_sync")) {
                        sql = "begin ? := dbms_drs.add_far_sync(?, ?); end;";
                    } else if (mtype.equalsIgnoreCase("recovery_appliance")) {
                        sql = "begin ? := dbms_drs.add_recovery_appliance(?, ?); end;";
                    } else {
                        throw new RuntimeException("Unkown member type: " + mtype);
                    }
                    cstmt = this.sqlConn.prepareCall(sql);
                    cstmt.registerOutParameter(1, 4);
                    cstmt.setString(2, mname);
                    cstmt.setString(3, ci);
                    cstmt.executeUpdate();
                    int status = cstmt.getInt(1);
                    if (status == 0) {
                        if (sql == "begin ? := dbms_drs.add_far_sync(?, ?); end;") {
                            this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.17024"), mname));
                        } else if (sql == "begin ? := dbms_drs.add_recovery_appliance(?, ?); end;") {
                            this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.17029"), mname));
                        } else {
                            this.scriptCtx.write(String.format("Database \"%s\" added\n", mname));
                        }
                    } else {
                        this.printOraError(status);
                    }
                    DgDBUtils.cleanup(cstmt, null);
                }
                catch (SQLException ex) {
                    this.printException(ex);
                    break block18;
                }
                finally {
                    DgDBUtils.cleanup(cstmt, null);
                    LockManager.unlock((Connection)this.sqlConn);
                }
                LockManager.unlock((Connection)this.sqlConn);
                break block18;
            }
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAddFarSync(String name, String ci) {
        if (!this.checkConnection()) {
            return;
        }
        String sql = "begin ? := dbms_drs.add_far_sync(?, ?); end;";
        CallableStatement cstmt = null;
        if (LockManager.lock((Connection)this.sqlConn)) {
            try {
                cstmt = this.sqlConn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.setString(1, name);
                cstmt.setString(2, ci);
                cstmt.executeUpdate();
                int status = cstmt.getInt(1);
                if (status == 0) {
                    this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.17009"), name));
                }
                this.printOraError(status);
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)this.sqlConn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAddRA(String name, String ci) {
        if (!this.checkConnection()) {
            return;
        }
        String sql = "begin ? := dbms_drs.add_recovery_appliance(?, ?); end;";
        CallableStatement cstmt = null;
        if (LockManager.lock((Connection)this.sqlConn)) {
            try {
                cstmt = this.sqlConn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.setString(1, name);
                cstmt.setString(2, ci);
                cstmt.executeUpdate();
                int status = cstmt.getInt(1);
                if (status == 0) {
                    this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.17029"), name));
                }
                this.printOraError(status);
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)this.sqlConn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runRemoveMember(String mname, int p_dest) {
        if (!this.checkConnection()) {
            return;
        }
        String sql = "begin ? := dbms_drs.remove2(?, ?); end;";
        CallableStatement cstmt = null;
        if (LockManager.lock((Connection)this.sqlConn)) {
            try {
                cstmt = this.sqlConn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.setString(2, mname);
                cstmt.setInt(3, p_dest);
                cstmt.executeUpdate();
                int status = cstmt.getInt(1);
                if (status == 0) {
                    this.scriptCtx.write(String.format("Removed database \"%s\" from the configuration\n", mname));
                }
                this.printOraError(status);
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)this.sqlConn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runEnableConfig() {
        if (!this.checkConnection()) {
            return;
        }
        DgDBVersion dbVersion = this.getDBVersion();
        if (dbVersion.lessThan(DgConstants.VERSION_21_0)) {
            this.runEnableConfig19(this.sqlConn);
            return;
        }
        String sql = "begin ? := dbms_drs.enable_configuration(); end;";
        CallableStatement cstmt = null;
        if (LockManager.lock((Connection)this.sqlConn)) {
            try {
                cstmt = this.sqlConn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.executeUpdate();
                int status = cstmt.getInt(1);
                if (status == 0) {
                    this.scriptCtx.write("Enabled.\n");
                }
                this.printOraError(status);
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)this.sqlConn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    private void runEnableConfig19(Connection conn) {
        String indoc = String.format("<DO_CONTROL version=\"%s\"><DO_COMMAND type=\"Enable\" object_id=\"%d\"/></DO_CONTROL>", "23.1.0.0.0", 4096);
        LOGGER.info("indoc: " + indoc);
        String outdoc = DgDBUtils.doControl(conn, indoc, null);
        if (outdoc != null) {
            DgResult result = (DgResult)DgXmlObject.create(outdoc);
            this.printResultAll(result, "Enabled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runEnableMember(String mname) {
        if (!this.checkConnection()) {
            return;
        }
        DgDBVersion dbVersion = this.getDBVersion();
        if (dbVersion.lessThan(DgConstants.VERSION_21_0)) {
            this.runEnableMember19(this.sqlConn, mname);
            return;
        }
        String sql = "begin ? := dbms_drs.enable(?); end;";
        CallableStatement cstmt = null;
        if (LockManager.lock((Connection)this.sqlConn)) {
            try {
                cstmt = this.sqlConn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.setString(2, mname);
                cstmt.executeUpdate();
                int status = cstmt.getInt(1);
                if (status == 0) {
                    this.scriptCtx.write("Enabled.\n");
                }
                this.printOraError(status);
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)this.sqlConn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    private void runEnableMember19(Connection conn, String mname) {
        int objid = DgDBUtils.getObjectIdMember(conn, mname);
        LOGGER.info("objectid: " + objid);
        if (objid == 0) {
            this.printOraError(16596);
            return;
        }
        String indoc = String.format("<DO_CONTROL version=\"%s\"><DO_COMMAND type=\"Enable\" object_id=\"%d\"/></DO_CONTROL>", "23.1.0.0.0", objid);
        LOGGER.info("indoc: " + indoc);
        String outdoc = DgDBUtils.doControl(conn, indoc, null);
        if (outdoc != null) {
            DgResult result = (DgResult)DgXmlObject.create(outdoc);
            this.printResultAll(result, "Enabled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDisableConfig() {
        if (!this.checkConnection()) {
            return;
        }
        DgDBVersion dbVersion = this.getDBVersion();
        if (dbVersion.lessThan(DgConstants.VERSION_21_0)) {
            this.runDisableConfig19(this.sqlConn);
            return;
        }
        String sql = "begin ? := dbms_drs.disable_configuration(); end;";
        CallableStatement cstmt = null;
        if (LockManager.lock((Connection)this.sqlConn)) {
            try {
                cstmt = this.sqlConn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.execute();
                int status = cstmt.getInt(1);
                if (status == 0) {
                    this.scriptCtx.write("Disabled.\n");
                }
                this.printOraError(status);
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)this.sqlConn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    private void runDisableConfig19(Connection conn) {
        String indoc = String.format("<DO_CONTROL version=\"%s\"><DO_COMMAND type=\"Disable\" object_id=\"%d\"/></DO_CONTROL>", "23.1.0.0.0", 4096);
        LOGGER.info("indoc: " + indoc);
        String outdoc = DgDBUtils.doControl(conn, indoc, null);
        if (outdoc != null) {
            DgResult result = (DgResult)DgXmlObject.create(outdoc);
            this.printResultAll(result, "Disabled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDisableMember(String mname) {
        if (!this.checkConnection()) {
            return;
        }
        DgDBVersion dbVersion = this.getDBVersion();
        if (dbVersion.lessThan(DgConstants.VERSION_21_0)) {
            this.runDisableMember19(this.sqlConn, mname);
            return;
        }
        String sql = "begin  ? := dbms_drs.disable(?); end;";
        CallableStatement cstmt = null;
        if (LockManager.lock((Connection)this.sqlConn)) {
            try {
                cstmt = this.sqlConn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.setString(2, mname);
                cstmt.executeUpdate();
                int status = cstmt.getInt(1);
                if (status == 0) {
                    this.scriptCtx.write("Disabled.\n");
                }
                this.printOraError(status);
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)this.sqlConn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    private void runDisableMember19(Connection conn, String mname) {
        int objid = DgDBUtils.getObjectIdMember(conn, mname);
        LOGGER.info("objectid: " + objid);
        String indoc = String.format("<DO_CONTROL version=\"%s\"><DO_COMMAND type=\"Disable\" object_id=\"%d\"/></DO_CONTROL>", "23.1.0.0.0", objid);
        LOGGER.info("indoc: " + indoc);
        String outdoc = DgDBUtils.doControl(conn, indoc, null);
        if (outdoc != null) {
            DgResult result = (DgResult)DgXmlObject.create(outdoc);
            this.printResultAll(result, "Disabled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runRemoveConfig(boolean pdest) {
        if (!this.checkConnection()) {
            return;
        }
        String sql = "begin ? := dbms_drs.remove_configuration(); end;";
        CallableStatement cstmt = null;
        if (LockManager.lock((Connection)this.sqlConn)) {
            try {
                cstmt = this.sqlConn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.executeUpdate();
                int status = cstmt.getInt(1);
                if (status != 0) {
                    this.printOraError(status);
                }
                this.scriptCtx.write("Removed.\n");
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)this.sqlConn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runEditConfigProp(String prop, String value) {
        if (!this.checkConnection()) {
            return;
        }
        String sql = "begin ? := dbms_drs.set_configuration_property(?, ?); end;";
        CallableStatement cstmt = null;
        if (LockManager.lock((Connection)this.sqlConn)) {
            try {
                cstmt = this.sqlConn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.setString(2, prop);
                cstmt.setString(3, value);
                cstmt.executeUpdate();
                int status = cstmt.getInt(1);
                if (status == 0) {
                    this.scriptCtx.write("Edited.\n");
                }
                this.printOraError(status);
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)this.sqlConn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runEditMemberProp(String mname, String prop, String value) {
        if (!this.checkConnection()) {
            return;
        }
        DgDBVersion dbVersion = this.getDBVersion();
        if (dbVersion.lessThan(DgConstants.VERSION_21_0)) {
            this.runEditMemberProp19(this.sqlConn, mname, prop, value);
            return;
        }
        String sql = "begin ? := dbms_drs.set_property(?, ?, ?); end;";
        CallableStatement cstmt = null;
        if (LockManager.lock((Connection)this.sqlConn)) {
            try {
                cstmt = this.sqlConn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.setString(2, mname);
                cstmt.setString(3, prop);
                cstmt.setString(4, value);
                cstmt.executeUpdate();
                int status = cstmt.getInt(1);
                if (status == 0) {
                    this.scriptCtx.write(String.format("Property \"%s\" updated for member \"%s\"\n", prop, mname));
                }
                this.printOraError(status);
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)this.sqlConn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    public void runEditAllMemberProp(String prop, String value) {
        try {
            ArrayList<String> members = DgDBUtils.getAllMembers(this.sqlConn);
            for (String member : members) {
                this.runEditMemberProp(member, prop, value);
            }
        }
        catch (SQLException ex) {
            this.printException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runEditMemberState(String mname, String value) {
        if (!this.checkConnection()) {
            return;
        }
        DgConfig cfg = DgConfig.readConfig(this.sqlConn, true);
        DgConfigMember member = cfg.getMember(mname);
        CallableStatement cstmt = null;
        if (member == null) {
            this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.NOOBJ"), mname));
            return;
        }
        if ("apply-on".equalsIgnoreCase(value) || "apply-off".equalsIgnoreCase(value)) {
            if (member.role != 2 && member.role != 3) {
                this.printOraError(16516);
                return;
            }
            String sql = "apply-on".equalsIgnoreCase(value) ? "begin ? := dbms_drs.set_state_apply_on(?); end;" : "begin ? := dbms_drs.set_state_apply_off(?); end;";
            if (LockManager.lock((Connection)this.sqlConn)) {
                try {
                    cstmt = this.sqlConn.prepareCall(sql);
                    cstmt.registerOutParameter(1, 4);
                    cstmt.setString(2, mname);
                    cstmt.executeUpdate();
                    int status = cstmt.getInt(1);
                    if (status == 0) {
                        this.scriptCtx.write("Edited.\n");
                    }
                    this.printOraError(status);
                }
                catch (SQLException ex) {
                    this.printException(ex);
                }
                finally {
                    DgDBUtils.cleanup(cstmt, null);
                    LockManager.unlock((Connection)this.sqlConn);
                }
            } else {
                LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
            }
        } else if ("transport-on".equalsIgnoreCase(value) || "transport-off".equalsIgnoreCase(value)) {
            if (member.role != 1) {
                this.printOraError(16516);
                return;
            }
            String sql = "transport-on".equalsIgnoreCase(value) ? "begin ? := dbms_drs.set_state_transport_on(?); end;" : "begin ? := dbms_drs.set_state_transport_off(?); end;";
            if (LockManager.lock((Connection)this.sqlConn)) {
                try {
                    cstmt = this.sqlConn.prepareCall(sql);
                    cstmt.registerOutParameter(1, 4);
                    cstmt.setString(2, mname);
                    cstmt.executeUpdate();
                    int status = cstmt.getInt(1);
                    if (status == 0) {
                        this.scriptCtx.write("Edited.\n");
                    }
                    this.printOraError(status);
                }
                catch (SQLException ex) {
                    this.printException(ex);
                }
                finally {
                    DgDBUtils.cleanup(cstmt, null);
                    LockManager.unlock((Connection)this.sqlConn);
                }
            } else {
                LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runEditMemberProp19(Connection conn, String mname, String prop, String value) {
        String sql = "begin ? := dbms_drs.set_database_property(?, ?, ?); end;";
        String fs_sql = "begin ? := dbms_drs.set_far_sync_property(?, ?, ?); end;";
        CallableStatement cstmt = null;
        DgConfig cfg = DgConfig.readConfig(conn, true);
        DgConfigMember member = cfg.getMember(mname);
        if (member.role == 5) {
            sql = "begin ? := dbms_drs.set_far_sync_property(?, ?, ?); end;";
        }
        if (LockManager.lock((Connection)conn)) {
            try {
                cstmt = conn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.setString(2, mname);
                cstmt.setString(3, prop);
                cstmt.setString(4, value);
                cstmt.executeUpdate();
                int status = cstmt.getInt(1);
                if (status == 0) {
                    this.scriptCtx.write(String.format("Property \"%s\" updated for member \"%s\"\n", prop, mname));
                }
                this.printOraError(status);
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)conn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCreateConfig(String name, String dbun, String dgci, boolean incl_dest) {
        if (!this.checkConnection()) {
            return;
        }
        String sql = "begin ? := dbms_drs.create_configuration(?, ?, ?); end;";
        CallableStatement cstmt = null;
        if (LockManager.lock((Connection)this.sqlConn)) {
            try {
                cstmt = this.sqlConn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.setString(2, name);
                cstmt.setString(3, dgci);
                cstmt.registerOutParameter(4, 4);
                cstmt.executeUpdate();
                int status = cstmt.getInt(1);
                int severity = cstmt.getInt(4);
                if (severity == 16501) {
                    this.printOraError(status);
                }
                this.scriptCtx.write("Created.\n");
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)this.sqlConn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runEnableFSFO() {
        if (!this.checkConnection()) {
            return;
        }
        String sql = "begin ? := dbms_drs.enable_fs_failover(); end;";
        CallableStatement cstmt = null;
        if (LockManager.lock((Connection)this.sqlConn)) {
            try {
                cstmt = this.sqlConn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.executeUpdate();
                int status = cstmt.getInt(1);
                if (status == 0) {
                    this.scriptCtx.write("Enabled.\n");
                }
                this.printOraError(status);
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)this.sqlConn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDisableFSFO() {
        if (!this.checkConnection()) {
            return;
        }
        String sql = "begin ? := dbms_drs.disable_fs_failover(); end;";
        CallableStatement cstmt = null;
        if (LockManager.lock((Connection)this.sqlConn)) {
            try {
                cstmt = this.sqlConn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.executeUpdate();
                int status = cstmt.getInt(1);
                if (status == 0) {
                    this.scriptCtx.write("Disabled.\n");
                }
                this.printOraError(status);
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)this.sqlConn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    private void printDRCmember(Connection conn, DgConfig cfg, DgConfigMember member, int ind, ShowConfigContext scCtx) throws SQLException {
        if (scCtx.printed.contains(member)) {
            return;
        }
        scCtx.printed.add(member);
        String role = "Unknown";
        if (member.role == 1) {
            role = "Primary database";
        } else if (member.role == 2) {
            role = "Physical standby database";
        } else if (member.role == 3) {
            role = "Logical standby database";
        } else if (member.role == 5) {
            role = "Far sync instance";
        } else if (member.role == 4) {
            role = "Snapshot standby database";
        } else if (member.role == 6) {
            role = "Recovery appliance";
        } else {
            LOGGER.info("Unkown role: " + member.role);
        }
        String memSt = "";
        if (!member.enabled) {
            memSt = "(disabled)";
        }
        this.scriptCtx.write(String.format("%s%s - %s\n", DgUtils.indent(ind), member.name, role + memSt));
        if ("FAILURE".equalsIgnoreCase(member.status)) {
            this.scriptCtx.write(String.format("%s%s\n\n", DgUtils.indent(ind + 1), this.getORAMessage(member.errnum, Messages.getString("DGCmd.ERROR"))));
            scCtx.overall_status = "ERROR";
        } else if ("WARNING".equalsIgnoreCase(member.status)) {
            this.scriptCtx.write(String.format("%s%s\n\n", DgUtils.indent(ind + 1), this.getORAMessage(member.errnum, Messages.getString("DGCmd.WARNING"))));
            if (!scCtx.overall_status.equalsIgnoreCase("FAILURE")) {
                scCtx.overall_status = "WARNING";
            }
        }
        if (scCtx.updated_time == 0 || scCtx.updated_time > member.errtime) {
            scCtx.updated_time = member.errtime;
        }
        if (member.shipTo != null && !member.shipTo.equalsIgnoreCase("-N/A-")) {
            String[] dests = member.shipTo.split("[,;: ]");
            for (int i = 0; i < dests.length; ++i) {
                String dest = dests[i].trim();
                DgConfigMember child = cfg.getMember(dest);
                if (child != null) {
                    this.printDRCmember(conn, cfg, child, ind + 1, scCtx);
                    continue;
                }
                this.scriptCtx.write(String.format("Unknown ship_to member: %s\n", dest));
            }
        }
    }

    private String roleToString(int role) {
        if (role == 1) {
            return "Primary database";
        }
        if (role == 2) {
            return "Physical standby database";
        }
        if (role == 3) {
            return "Logical standby database";
        }
        if (role == 5) {
            return "Far sync instance";
        }
        if (role == 4) {
            return "Snapshot standby database";
        }
        if (role == 6) {
            return "Recovery appliance";
        }
        return "Unknown";
    }

    private String getMemberIntendedSate(String istate) {
        if (istate.equalsIgnoreCase("READ-WRITE-XPTON")) {
            return "TRANSPORT-ON";
        }
        if (istate.equalsIgnoreCase("READ-WRITE")) {
            return "TRANSPORT-OFF";
        }
        if (istate.equalsIgnoreCase("PHYSICAL-APPLY-ON")) {
            return "APPLY-ON";
        }
        if (istate.equalsIgnoreCase("PHYSICAL-APPLY-READY")) {
            return "APPLY-OFF";
        }
        if (istate.equalsIgnoreCase("LOGICAL-APPLY-ON")) {
            return "APPLY-ON";
        }
        if (istate.equalsIgnoreCase("LOGICAL-APPLY-READY")) {
            return "APPLY-OFF";
        }
        return istate;
    }

    private void printLags(Connection conn, DgConfigMember member, int indent, boolean verbose, boolean applyrate) {
        int objectid = DgDBUtils.getObjectIdMember(conn, member.name);
        String fmt = "%s%-20s %s\n";
        String unknown = "(unknown)";
        if (member.role != 1 && member.role != 6) {
            String gap;
            String[] lagvals;
            String lagText = "(unknown)";
            String propValue = this.getMonitorPropValueStr(conn, objectid, "TransportLag");
            if (propValue != null && (lagvals = propValue.split(" ")).length > 1) {
                gap = DgUtils.toGapString(lagvals[0]);
                lagText = String.format("%s (computed %s %s ago)", gap != null ? gap : "(unknown)", lagvals[1], "1".equals(lagvals[1]) ? "second" : "seconds");
            }
            this.scriptCtx.write(String.format("%s%-20s %s\n", DgUtils.indent(indent), Messages.getString("DGCmd.5016"), DgUtils.nvl(lagText, "(unknown)")));
            lagText = "(unknown)";
            propValue = this.getMonitorPropValueStr(conn, objectid, "ApplyLag");
            if (propValue != null && (lagvals = propValue.split(" ")).length > 1) {
                gap = DgUtils.toGapString(lagvals[0]);
                lagText = String.format("%s (computed %s %s ago)", gap != null ? gap : "(unknown)", lagvals[1], "1".equals(lagvals[1]) ? "second" : "seconds");
            }
            this.scriptCtx.write(String.format("%s%-20s %s\n", DgUtils.indent(indent), Messages.getString("DGCmd.5017"), DgUtils.nvl(lagText, "(unknown)")));
            if (applyrate && member.role != 4) {
                String avgAR = "(unknown)";
                String actAR = "(unknown)";
                String maxAR = "(unknown)";
                propValue = this.getMonitorPropValueStr(conn, objectid, "ApplyRate");
                if (propValue != null) {
                    String[] arvals = propValue.split(" ");
                    if (arvals.length > 0) {
                        avgAR = DgUtils.toRate(arvals[0]);
                    }
                    if (verbose) {
                        if (arvals.length > 1) {
                            actAR = DgUtils.toRate(arvals[1]);
                        }
                        if (arvals.length > 2) {
                            maxAR = DgUtils.toRate(arvals[2]);
                        }
                    }
                }
                this.scriptCtx.write(String.format("%s%-20s %s\n", DgUtils.indent(indent), Messages.getString("DGCmd.5171"), DgUtils.nvl(avgAR, "(unknown)")));
                if (verbose) {
                    this.scriptCtx.write(String.format("%s%-20s %s\n", DgUtils.indent(indent), Messages.getString("DGCmd.5170"), DgUtils.nvl(actAR, "(unknown)")));
                    this.scriptCtx.write(String.format("%s%-20s %s\n", DgUtils.indent(indent), Messages.getString("DGCmd.5169"), DgUtils.nvl(maxAR, "(unknown)")));
                }
            }
        }
    }

    private void print_all_props(DgConfigMember member, int indent) {
        Connection conn = this.sqlConn;
        String sql = "select property, value, ptype, stype from x$rfmprop where upper(scope) = upper(:SCOPE)  and upper(member) like upper(:MEMBER) order by property asc";
        List props = null;
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("SCOPE", member != null ? "MEMBER" : "CONFIGURATION");
        binds.put("MEMBER", member != null ? member.name : "%");
        props = DBUtil.getInstance((Connection)conn).executeReturnList(sql, binds);
        for (Map prop : props) {
            int stype = ((BigDecimal)prop.get("STYPE")).intValue();
            if (!this.is_visible_prop(member, stype)) continue;
            this.scriptCtx.write(DgUtils.indent(indent));
            this.scriptCtx.write(String.format("%-32s = '%s'\n", DgUtils.nvl((String)prop.get("PROPERTY")), DgUtils.nvl((String)prop.get("VALUE"))));
        }
    }

    private void printMemberProps(DgConfigMember member, int indent) {
        Connection conn = this.sqlConn;
        String sql = "select property, value, ptype, stype from x$rfmprop where upper(scope) = upper(:SCOPE)  and upper(member) like upper(:MEMBER) order by property asc";
        List props = null;
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("SCOPE", member != null ? "MEMBER" : "CONFIGURATION");
        binds.put("MEMBER", member != null ? member.name : "%");
        props = DBUtil.getInstance((Connection)conn).executeReturnList(sql, binds);
        for (Map prop : props) {
            int stype = ((BigDecimal)prop.get("STYPE")).intValue();
            if (!this.is_visible_prop(member, stype)) continue;
            this.scriptCtx.write(DgUtils.indent(indent));
            this.scriptCtx.write(String.format("%-32s = '%s'\n", DgUtils.nvl((String)prop.get("PROPERTY")), DgUtils.nvl((String)prop.get("VALUE"))));
        }
    }

    private void printMemberProps19(DgConfigMember member, int objectid, int indent) {
        String indoc = String.format("<DO_CONFIGURE_SITE version=\"%s\"><GET_RESOURCE res_id=\"%d\"/></DO_CONFIGURE_SITE>", "23.1.0.0.0", objectid);
        String outdoc = DgDBUtils.doControl(this.sqlConn, indoc, null);
        Document doc = DgXmlObject.parse(outdoc);
        Element pl = (Element)doc.getElementsByTagName("PROPERTY_LIST").item(0);
        if (pl != null) {
            NodeList valList = pl.getElementsByTagName("VALUE");
            for (int i = 0; i < valList.getLength(); ++i) {
                Element val = (Element)valList.item(i);
                int stype = 0;
                try {
                    stype = Integer.valueOf(val.getAttribute("subtype"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!"configuration".equalsIgnoreCase(val.getAttribute("property_type")) || stype <= 0 || !this.is_visible_prop(member, stype)) continue;
                this.scriptCtx.write(DgUtils.indent(indent));
                this.scriptCtx.write(String.format("%-32s = '%s'\n", val.getAttribute("name"), val.getAttribute("value")));
            }
        } else {
            LOGGER.info("outdoc: " + outdoc);
        }
    }

    private boolean is_visible_prop(DgConfigMember member, int stype) {
        if ((stype & 0x200) != 0) {
            return false;
        }
        if (member == null) {
            return true;
        }
        if (member.role == 5) {
            return (stype & 0x1000000) != 0;
        }
        if (member.role == 6) {
            return (stype & 0x2000000) != 0;
        }
        if (member.role == 7) {
            return (stype & 0x20000000) != 0;
        }
        if (member.role != 3 && (stype & 0x10) != 0 && (stype & 8) == 0 && (stype & 0x200000) == 0) {
            return false;
        }
        return member.role == 2 || member.role == 4 || (stype & 8) == 0 && (stype & 0x200000) == 0 || (stype & 0x10) != 0;
    }

    private int printMemberStatus(DgConfigMember member, DgXmlObject xmlObj, int indent) {
        int status = 0;
        if (xmlObj instanceof DgResult) {
            this.scriptCtx.write(DgUtils.indent(indent));
            if (member.role == 5) {
                this.scriptCtx.write(Messages.getString("DGCmd.5136"));
            } else {
                this.scriptCtx.write(Messages.getString("DGCmd.5011"));
            }
            this.scriptCtx.write("\n");
            this.printResultAll((DgResult)xmlObj, null);
            this.scriptCtx.write("\n");
            return 16501;
        }
        if (!(xmlObj instanceof DgOpTable)) {
            LOGGER.info("Unknown class");
            return 16501;
        }
        DgOpTable table = (DgOpTable)xmlObj;
        ArrayList<String> ss = new ArrayList<String>();
        ss.add("Error");
        ss.add("Warning");
        for (String s : ss) {
            boolean header = false;
            for (List<String> tr : table.trList) {
                String instnm = tr.get(0);
                String severity = tr.get(4);
                if (!"*".equals(instnm) || !s.equalsIgnoreCase(severity)) continue;
                String errnumStr = tr.get(1);
                String arg1Str = tr.get(2);
                String arg2Str = tr.get(3);
                int errnum = Integer.valueOf(errnumStr);
                String arg1 = null;
                String arg2 = null;
                if (arg1Str != null && arg1Str.trim().length() == 0) {
                    arg1 = null;
                }
                if (arg2Str != null && arg2Str.trim().length() == 0) {
                    arg2 = null;
                }
                if (!header) {
                    this.scriptCtx.write(DgUtils.indent(indent));
                    if ("Warning".equalsIgnoreCase(s)) {
                        if (member.role == 5) {
                            this.scriptCtx.write(Messages.getString("DGCmd.5137"));
                        } else {
                            this.scriptCtx.write(Messages.getString("DGCmd.5012"));
                        }
                    } else if (member.role == 5) {
                        this.scriptCtx.write(Messages.getString("DGCmd.5136"));
                    } else {
                        this.scriptCtx.write(Messages.getString("DGCmd.5011"));
                    }
                    this.scriptCtx.write("\n");
                    header = true;
                }
                if ("Warning".equalsIgnoreCase(s)) {
                    this.printOraWarn(errnum, arg1, arg2);
                    if (status != 0) continue;
                    status = 16502;
                    continue;
                }
                this.printOraError(errnum, arg1, arg2);
                status = 16501;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runEditTag(String member, String tag, String value) {
        if (!this.checkConnection()) {
            return;
        }
        String sql = "begin ? := dbms_drs.edit_tag(?, NULL, ?, ?, ?, ?); end;";
        CallableStatement cstmt = null;
        String opcode = value == null ? (tag == null ? "REMOVE_ALL" : "REMOVE_TAG") : "SET_TAG";
        LOGGER.info(String.format("editTag: '%s', '%s', '%s' opcode=%s\n", member, tag, value, opcode));
        if (LockManager.lock((Connection)this.sqlConn)) {
            try {
                cstmt = this.sqlConn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.setString(2, opcode);
                cstmt.setString(3, member);
                cstmt.setString(4, tag);
                cstmt.setString(5, value);
                cstmt.registerOutParameter(6, 4);
                cstmt.executeUpdate();
                int status = cstmt.getInt(1);
                if (status == 0) {
                    this.scriptCtx.write("Edited.\n");
                }
                this.printOraError(status);
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)this.sqlConn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runShowTag(String member, String tag) {
        if (!this.checkConnection()) {
            return;
        }
        String sql = "begin ? := dbms_drs.show_tag(?, NULL, ?, ?, ?, ?); end;";
        CallableStatement cstmt = null;
        String opcode = tag != null ? "SHOW_TAG" : "SHOW_XML";
        LOGGER.info(String.format("showTag: '%s', '%s', opcode=%s\n", member, tag, opcode));
        if (LockManager.lock((Connection)this.sqlConn)) {
            try {
                cstmt = this.sqlConn.prepareCall(sql);
                cstmt.registerOutParameter(1, 4);
                cstmt.setString(2, opcode);
                cstmt.setString(3, member);
                cstmt.setString(4, tag);
                cstmt.registerOutParameter(5, 12);
                cstmt.registerOutParameter(6, 4);
                cstmt.executeUpdate();
                int status = cstmt.getInt(1);
                if (status == 0) {
                    String value = cstmt.getString(5);
                    if (value == null) {
                        value = "";
                    }
                    if (tag != null) {
                        this.scriptCtx.write(String.format("  %s = '%s'\n", tag, value));
                    }
                    this.scriptCtx.write(String.format("%s\n", value));
                }
                this.printOraError(status);
            }
            catch (SQLException ex) {
                this.printException(ex);
            }
            finally {
                DgDBUtils.cleanup(cstmt, null);
                LockManager.unlock((Connection)this.sqlConn);
            }
        } else {
            LOGGER.severe(Messages.getString("DGCmd.LOCK_FAIL"));
        }
    }

    protected class ShowConfigContext {
        public HashSet<DgConfigMember> printed = new HashSet();
        public String overall_status = "SUCCESS";
        public int updated_time = 0;

        protected ShowConfigContext() {
        }
    }
}

