/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sdks.installer.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class CommandLineTableGenerator {
    private final ScriptRunnerContext ctx;
    private static final String HORIZONTAL_SEP = "-";
    private String verticalSep;
    private String joinSep;
    private String[] headers;
    private List<String[]> rows = new ArrayList<String[]>();
    private boolean rightAlign;

    public CommandLineTableGenerator(ScriptRunnerContext ctx) {
        this.ctx = ctx;
        this.setShowVerticalLines(false);
    }

    public void setRightAlign(boolean rightAlign) {
        this.rightAlign = rightAlign;
    }

    public void setShowVerticalLines(boolean showVerticalLines) {
        this.verticalSep = showVerticalLines ? "|" : "";
        this.joinSep = showVerticalLines ? "+" : " ";
    }

    public void setHeaders(String ... headers) {
        this.headers = headers;
    }

    public void addRow(String ... cells) {
        this.rows.add(cells);
    }

    public void print() {
        int[] maxWidths = this.headers != null ? Arrays.stream(this.headers).mapToInt(String::length).toArray() : null;
        for (String[] cells : this.rows) {
            if (maxWidths == null) {
                maxWidths = new int[cells.length];
            }
            if (cells.length != maxWidths.length) {
                throw new IllegalArgumentException("Number of row-cells and headers should be consistent");
            }
            for (int i = 0; i < cells.length; ++i) {
                maxWidths[i] = Math.max(maxWidths[i], cells[i].length());
            }
        }
        if (this.headers != null) {
            this.printLine(maxWidths);
            this.printRow(this.headers, maxWidths);
            this.printLine(maxWidths);
        }
        for (String[] cells : this.rows) {
            this.printRow(cells, maxWidths);
        }
        if (this.headers != null) {
            this.printLine(maxWidths);
        }
    }

    private void printLine(int[] columnWidths) {
        for (int i = 0; i < columnWidths.length; ++i) {
            String line = String.join((CharSequence)"", Collections.nCopies(columnWidths[i] + this.verticalSep.length() + 1, HORIZONTAL_SEP));
            this.ctx.write(this.joinSep + line + (i == columnWidths.length - 1 ? this.joinSep : ""));
        }
        this.ctx.write("\n");
    }

    private void printRow(String[] cells, int[] maxWidths) {
        for (int i = 0; i < cells.length; ++i) {
            int m;
            String verStrTemp;
            String s = cells[i];
            String string = verStrTemp = i == cells.length - 1 ? this.verticalSep : "";
            if (this.rightAlign) {
                this.ctx.write(this.verticalSep + " ");
                for (m = 0; m < maxWidths[i] - s.length(); ++m) {
                    this.ctx.write(" ");
                }
                this.ctx.write(s + " " + verStrTemp);
                continue;
            }
            this.ctx.write(this.verticalSep + " " + s);
            for (m = 0; m < maxWidths[i] - s.length(); ++m) {
                this.ctx.write(" ");
            }
            this.ctx.write(" " + verStrTemp);
        }
        this.ctx.write("\n");
    }
}

