/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.responses.BmcResponse;
import java.io.IOException;
import oracle.dbtools.core.oci.AuthenticationProvider;
import oracle.dbtools.core.oci.OCIClientException;

public abstract class OCIClient {
    private final AuthenticationProvider authenticationProvider;
    private final String region;
    private final String endpoint;
    private final ClientConfiguration clientConfiguration;

    protected OCIClient(Builder builder) {
        this.authenticationProvider = builder.authenticationProvider;
        this.region = builder.region;
        this.endpoint = builder.endpoint;
        this.clientConfiguration = ClientConfiguration.builder().connectionTimeoutMillis(Integer.valueOf(builder.connectionTimeMillis)).build();
    }

    protected <T extends RegionalClientBuilder, C> C createClient(RegionalClientBuilder<T, C> builder) {
        Object client = this.configureClient(builder).build(this.getAuthenticationProvider().getAuthenticationProvider());
        String endpoint = this.getEndpoint();
        if (endpoint != null && client instanceof BaseSyncClient) {
            ((BaseSyncClient)client).setEndpoint(endpoint);
        }
        return (C)client;
    }

    protected <T extends RegionalClientBuilder> T configureClient(T builderBase) {
        if (this.region != null) {
            builderBase = builderBase.region(this.region);
        }
        if (this.endpoint != null) {
            builderBase = (RegionalClientBuilder)builderBase.endpoint(this.endpoint);
        }
        return (T)((RegionalClientBuilder)builderBase.configuration(this.clientConfiguration));
    }

    protected <T extends Builder> T createChildClient(BuilderCreator<T> builderCreator) {
        T builder = builderCreator.create(this.authenticationProvider);
        if (this.region != null) {
            builder = ((Builder)builder).region(this.region);
        }
        return ((Builder)builder).sessionTimeout(this.clientConfiguration.getConnectionTimeoutMillis());
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getRegion() {
        return this.region;
    }

    protected static <T extends BmcResponse> T executeRequest(Request<T> request) {
        try {
            return request.executeRequest();
        }
        catch (BmcException be) {
            Throwable cause = be.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw OCIClient.wrap(be);
        }
    }

    protected static RuntimeException wrap(BmcException ex) {
        Throwable cause = ex.getCause();
        if (cause == null) {
            return OCIClientException.of(ex);
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        IOException io = OCIClient.unwrap(cause, IOException.class);
        return OCIClientException.of(io != null ? io : cause);
    }

    protected static <T extends Exception> T unwrap(Throwable t, Class<T> exceptionClass) {
        Exception result = null;
        if (exceptionClass.isAssignableFrom(t.getClass())) {
            result = (Exception)t;
        } else {
            Throwable cause = t.getCause();
            if (cause != null) {
                result = OCIClient.unwrap((Exception)cause, exceptionClass);
            }
        }
        return (T)result;
    }

    public <T extends Builder, C> C createFrom(T builder) {
        builder.region(this.region);
        return builder.build();
    }

    public static abstract class Builder<T extends Builder, C> {
        private AuthenticationProvider authenticationProvider;
        private String endpoint;
        private String region;
        private int connectionTimeMillis = 30000;

        protected Builder(AuthenticationProvider authenticationProvider) {
            this.authenticationProvider = authenticationProvider;
        }

        public T region(String region) {
            this.region = region;
            return (T)this;
        }

        public T endpoint(String endpoint) {
            this.endpoint = endpoint;
            return (T)this;
        }

        public T sessionTimeout(int timeout) {
            this.connectionTimeMillis = timeout;
            return (T)this;
        }

        public abstract C build();
    }

    public static interface BuilderCreator<T extends Builder> {
        public T create(AuthenticationProvider var1);
    }

    protected static interface Request<T extends BmcResponse> {
        public T executeRequest();
    }
}

