/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci;

import com.oracle.bmc.databasetools.model.DatabaseToolsConnection;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnectionGenericJdbc;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnectionMySql;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnectionOracleDatabase;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnectionPostgresql;
import com.oracle.bmc.databasetools.model.DatabaseToolsUserPasswordSecretId;
import oracle.dbtools.core.oci.OCIClientException;
import oracle.dbtools.core.oci.OCIDBToolsConnection;

public final class DatabaseDetails {
    private final OCIDBToolsConnection connection;
    private final DatabaseWrapper delegate;

    public static DatabaseDetails of(OCIDBToolsConnection connection) {
        DatabaseWrapper wrapper;
        DatabaseToolsConnection dbToolsConnection = connection.getDbtoolsConnection();
        switch (connection.getDatabaseType()) {
            case ORACLE: {
                wrapper = new OracleDatabaseWrapper(dbToolsConnection);
                break;
            }
            case MYSQL: {
                wrapper = new MySqlDatabaseWrapper(dbToolsConnection);
                break;
            }
            case POSTGRESS: {
                wrapper = new PostgressDatabaseWrapper(dbToolsConnection);
                break;
            }
            case UNKNOWN: {
                wrapper = new GenericJdbcDatabaseWrapper(dbToolsConnection);
                break;
            }
            default: {
                throw OCIClientException.of("Unknown connection type");
            }
        }
        return new DatabaseDetails(connection, wrapper);
    }

    private DatabaseDetails(OCIDBToolsConnection connection, DatabaseWrapper wrapper) {
        this.connection = connection;
        this.delegate = wrapper;
    }

    protected DatabaseToolsConnection getDatabaseToolsConnection() {
        return this.connection.getDbtoolsConnection();
    }

    public String getId() {
        return this.getDatabaseToolsConnection().getId();
    }

    public String getDisplayName() {
        return this.getDatabaseToolsConnection().getDisplayName();
    }

    public String getType() {
        return this.delegate.getDatabaseType();
    }

    public String getUserName() {
        return this.delegate.getUserName();
    }

    public boolean hasPassword() {
        return this.delegate.hasPassword();
    }

    public String getConnectString() {
        return this.delegate.getConnectString();
    }

    public String getURL() {
        return this.delegate.getUrl();
    }

    private static final class OracleDatabaseWrapper
    extends DatabaseWrapper {
        private final DatabaseToolsConnectionOracleDatabase database;

        private OracleDatabaseWrapper(DatabaseToolsConnection conn) {
            this.database = (DatabaseToolsConnectionOracleDatabase)conn;
        }

        @Override
        public String getDatabaseType() {
            return OCIDBToolsConnection.DatabaseType.ORACLE.name();
        }

        @Override
        public String getConnectString() {
            return this.database.getConnectionString();
        }

        @Override
        public String getUrl() {
            return "jdbc:oracle:thin:@" + this.getConnectString();
        }

        @Override
        public String getUserName() {
            return this.database.getUserName();
        }

        @Override
        public boolean hasPassword() {
            return this.database.getUserPassword() instanceof DatabaseToolsUserPasswordSecretId;
        }
    }

    private static final class MySqlDatabaseWrapper
    extends DatabaseWrapper {
        private final DatabaseToolsConnectionMySql database;

        private MySqlDatabaseWrapper(DatabaseToolsConnection conn) {
            this.database = (DatabaseToolsConnectionMySql)conn;
        }

        @Override
        public String getDatabaseType() {
            return OCIDBToolsConnection.DatabaseType.MYSQL.name();
        }

        @Override
        public String getConnectString() {
            return this.database.getConnectionString();
        }

        @Override
        public String getUrl() {
            return "jdbc:oracle:thin:@" + this.getConnectString();
        }

        @Override
        public String getUserName() {
            return this.database.getUserName();
        }
    }

    private static final class PostgressDatabaseWrapper
    extends DatabaseWrapper {
        private final DatabaseToolsConnectionPostgresql database;

        private PostgressDatabaseWrapper(DatabaseToolsConnection conn) {
            this.database = (DatabaseToolsConnectionPostgresql)conn;
        }

        @Override
        public String getDatabaseType() {
            return OCIDBToolsConnection.DatabaseType.POSTGRESS.name();
        }

        @Override
        public String getConnectString() {
            return this.database.getConnectionString();
        }

        @Override
        public String getUrl() {
            return "jdbc:oracle:thin:@" + this.getConnectString();
        }

        @Override
        public String getUserName() {
            return this.database.getUserName();
        }
    }

    private static final class GenericJdbcDatabaseWrapper
    extends DatabaseWrapper {
        private final DatabaseToolsConnectionGenericJdbc database;

        private GenericJdbcDatabaseWrapper(DatabaseToolsConnection conn) {
            this.database = (DatabaseToolsConnectionGenericJdbc)conn;
        }

        @Override
        public String getDatabaseType() {
            return OCIDBToolsConnection.DatabaseType.UNKNOWN.name();
        }

        @Override
        public String getConnectString() {
            return "";
        }

        @Override
        public String getUrl() {
            return this.database.getUrl();
        }

        @Override
        public String getUserName() {
            return this.database.getUserName();
        }
    }

    private static abstract class DatabaseWrapper {
        private DatabaseWrapper() {
        }

        public abstract String getDatabaseType();

        public abstract String getConnectString();

        public abstract String getUrl();

        public abstract String getUserName();

        public boolean hasPassword() {
            return false;
        }
    }
}

