/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.awrash.command;

import java.sql.Connection;
import java.util.function.BiConsumer;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.extension.awrash.command.AWRGrammar;
import oracle.dbtools.extension.awrash.command.AWRMessages;
import oracle.dbtools.extension.awrash.command.AWRSymbols;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.command.ParsedCommandListener;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class AWR2Command
extends ParsedCommandListener
implements SQLCLService {
    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return "Creates and retrieves AWR reports for the currently connected instance";
    }

    public String getExtensionName() {
        return "AWR";
    }

    public String getExtensionVersion() {
        return AWRMessages.getString("SQLclVersion.VERSION");
    }

    protected boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        Id command = parsedCommand.getType().getId();
        if (command == AWRSymbols.AWR) {
            BiConsumer consumer = (BiConsumer)parsedCommand.getGrammarValue();
            if (consumer != null) {
                consumer.accept(ctx, conn);
            }
            return true;
        }
        return false;
    }

    protected Type createType() {
        return AWRGrammar.createType();
    }
}

