/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.datapump.common;

import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.extension.datapump.common.DataPumpArguments;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.ToolLogger;

public class DataPumpModel {
    private static final String NL = "\n";
    private static final String SPACE = " ";
    private Connection _conn;
    private String _schema;
    private ScriptRunnerContext _ctx;
    private ISQLCommand _cmd;
    private DataPumpArguments _args;
    private ToolLogger _tLogger;
    private String _genSql = "";
    private Map<String, String> _genBinds = new HashMap<String, String>();
    private String _cloudService;
    private boolean _isExport = false;
    private boolean _isImport = false;
    private boolean _isValid = true;
    private boolean _isDebug = false;
    private boolean _isSetCommand = false;

    public DataPumpModel(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, DataPumpArguments args) {
        this._conn = conn;
        this._ctx = ctx;
        this._cmd = cmd;
        this._args = args;
        try {
            this._schema = this._conn.getSchema();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._tLogger = new ToolLogger((OutputStream)ctx.getOutputStream());
    }

    public Connection getConn() {
        return this._conn;
    }

    public ScriptRunnerContext getCtx() {
        return this._ctx;
    }

    public DataPumpArguments getArgs() {
        return this._args;
    }

    public String getSchema() {
        return this._schema;
    }

    public ISQLCommand getSQLCommand() {
        return this._cmd;
    }

    public ToolLogger getToolLogger() {
        return this._tLogger;
    }

    public boolean ToolLoggerFlushLog() {
        if (!this._ctx.isInterrupted()) {
            this._tLogger.flushLog();
            return true;
        }
        return false;
    }

    public String getGenSql() {
        return this._genSql;
    }

    public void setGenSql(String genSql) {
        this._genSql = genSql;
    }

    public void appendGenSql(String genSql) {
        this._genSql = this._genSql + genSql;
    }

    public Map<String, String> getGenBinds() {
        return this._genBinds;
    }

    public void setGenSql(Map<String, String> genBinds) {
        this._genBinds = genBinds;
    }

    public void isValid(boolean isValid) {
        this._isValid = isValid;
    }

    public boolean isValid() {
        return this._isValid;
    }

    public void isExport(boolean isExport) {
        this._isExport = isExport;
    }

    public boolean isExport() {
        return this._isExport;
    }

    public void isImport(boolean isImport) {
        this._isImport = isImport;
    }

    public boolean isImport() {
        return this._isImport;
    }

    public boolean isDebug() {
        return this.isArgTrue("debug");
    }

    public boolean isVerbose() {
        return this.isArgTrue("verbose");
    }

    public boolean isNoExec() {
        return this.isArgTrue("noexec");
    }

    public boolean isArgTrue(String arg) {
        Object valObj = this._args.get(arg);
        if (valObj == null) {
            return this._args.contains(arg);
        }
        if (valObj instanceof Boolean) {
            return (Boolean)valObj;
        }
        String value = (String)valObj;
        return "true".equalsIgnoreCase(value) || value.isEmpty();
    }

    public void isSetCommand(boolean isSetCommand) {
        this._isSetCommand = isSetCommand;
    }

    public boolean isSetCommand() {
        return this._isSetCommand;
    }

    public void showBinds(String tag) {
        this.getToolLogger().flushLog();
        if (!this.ToolLoggerFlushLog()) {
            return;
        }
        Map<String, String> genBinds = this.getGenBinds();
        Set<String> keys = genBinds.keySet();
        ArrayList<String> al = new ArrayList<String>(keys);
        Collections.sort(al);
        for (String key : al) {
            this.getToolLogger().log(tag + SPACE + key + ": " + genBinds.get(key));
        }
        if (!this.ToolLoggerFlushLog()) {
            return;
        }
    }

    public void setCloudService(String cloudService) {
        this._cloudService = cloudService;
    }

    public boolean isCloudService() {
        return this._cloudService != null;
    }

    public boolean isDWCS() {
        return this._cloudService != null && this._cloudService.equals("DWCS");
    }

    public boolean isOLTP() {
        return this._cloudService != null && this._cloudService.equals("OLTP");
    }
}

