/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.recovery.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.recovery.model.UpdateProtectionPolicyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateProtectionPolicyRequest
extends BmcRequest<UpdateProtectionPolicyDetails> {
    private String protectionPolicyId;
    private UpdateProtectionPolicyDetails updateProtectionPolicyDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getProtectionPolicyId() {
        return this.protectionPolicyId;
    }

    public UpdateProtectionPolicyDetails getUpdateProtectionPolicyDetails() {
        return this.updateProtectionPolicyDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateProtectionPolicyDetails getBody$() {
        return this.updateProtectionPolicyDetails;
    }

    public Builder toBuilder() {
        return new Builder().protectionPolicyId(this.protectionPolicyId).updateProtectionPolicyDetails(this.updateProtectionPolicyDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",protectionPolicyId=").append(String.valueOf(this.protectionPolicyId));
        sb.append(",updateProtectionPolicyDetails=").append(String.valueOf((Object)this.updateProtectionPolicyDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateProtectionPolicyRequest)) {
            return false;
        }
        UpdateProtectionPolicyRequest other = (UpdateProtectionPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.protectionPolicyId, other.protectionPolicyId) && Objects.equals((Object)this.updateProtectionPolicyDetails, (Object)other.updateProtectionPolicyDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.protectionPolicyId == null ? 43 : this.protectionPolicyId.hashCode());
        result = result * 59 + (this.updateProtectionPolicyDetails == null ? 43 : this.updateProtectionPolicyDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateProtectionPolicyRequest, UpdateProtectionPolicyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String protectionPolicyId = null;
        private UpdateProtectionPolicyDetails updateProtectionPolicyDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder protectionPolicyId(String protectionPolicyId) {
            this.protectionPolicyId = protectionPolicyId;
            return this;
        }

        public Builder updateProtectionPolicyDetails(UpdateProtectionPolicyDetails updateProtectionPolicyDetails) {
            this.updateProtectionPolicyDetails = updateProtectionPolicyDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateProtectionPolicyRequest o) {
            this.protectionPolicyId(o.getProtectionPolicyId());
            this.updateProtectionPolicyDetails(o.getUpdateProtectionPolicyDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateProtectionPolicyRequest build() {
            UpdateProtectionPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateProtectionPolicyDetails body) {
            this.updateProtectionPolicyDetails(body);
            return this;
        }

        public UpdateProtectionPolicyRequest buildWithoutInvocationCallback() {
            UpdateProtectionPolicyRequest request = new UpdateProtectionPolicyRequest();
            request.protectionPolicyId = this.protectionPolicyId;
            request.updateProtectionPolicyDetails = this.updateProtectionPolicyDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

