/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.recovery.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetProtectedDatabaseRequest
extends BmcRequest<Void> {
    private String protectedDatabaseId;
    private String opcRequestId;

    public String getProtectedDatabaseId() {
        return this.protectedDatabaseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().protectedDatabaseId(this.protectedDatabaseId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",protectedDatabaseId=").append(String.valueOf(this.protectedDatabaseId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetProtectedDatabaseRequest)) {
            return false;
        }
        GetProtectedDatabaseRequest other = (GetProtectedDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.protectedDatabaseId, other.protectedDatabaseId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.protectedDatabaseId == null ? 43 : this.protectedDatabaseId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetProtectedDatabaseRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String protectedDatabaseId = null;
        private String opcRequestId = null;

        public Builder protectedDatabaseId(String protectedDatabaseId) {
            this.protectedDatabaseId = protectedDatabaseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetProtectedDatabaseRequest o) {
            this.protectedDatabaseId(o.getProtectedDatabaseId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetProtectedDatabaseRequest build() {
            GetProtectedDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetProtectedDatabaseRequest buildWithoutInvocationCallback() {
            GetProtectedDatabaseRequest request = new GetProtectedDatabaseRequest();
            request.protectedDatabaseId = this.protectedDatabaseId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

