/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.recovery.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.recovery.model.DeletionSchedule;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteProtectedDatabaseRequest
extends BmcRequest<Void> {
    private String protectedDatabaseId;
    private DeletionSchedule deletionSchedule;
    private String ifMatch;
    private String opcRequestId;

    public String getProtectedDatabaseId() {
        return this.protectedDatabaseId;
    }

    public DeletionSchedule getDeletionSchedule() {
        return this.deletionSchedule;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().protectedDatabaseId(this.protectedDatabaseId).deletionSchedule(this.deletionSchedule).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",protectedDatabaseId=").append(String.valueOf(this.protectedDatabaseId));
        sb.append(",deletionSchedule=").append(String.valueOf((Object)this.deletionSchedule));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteProtectedDatabaseRequest)) {
            return false;
        }
        DeleteProtectedDatabaseRequest other = (DeleteProtectedDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.protectedDatabaseId, other.protectedDatabaseId) && Objects.equals((Object)this.deletionSchedule, (Object)other.deletionSchedule) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.protectedDatabaseId == null ? 43 : this.protectedDatabaseId.hashCode());
        result = result * 59 + (this.deletionSchedule == null ? 43 : this.deletionSchedule.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteProtectedDatabaseRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String protectedDatabaseId = null;
        private DeletionSchedule deletionSchedule = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder protectedDatabaseId(String protectedDatabaseId) {
            this.protectedDatabaseId = protectedDatabaseId;
            return this;
        }

        public Builder deletionSchedule(DeletionSchedule deletionSchedule) {
            this.deletionSchedule = deletionSchedule;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteProtectedDatabaseRequest o) {
            this.protectedDatabaseId(o.getProtectedDatabaseId());
            this.deletionSchedule(o.getDeletionSchedule());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteProtectedDatabaseRequest build() {
            DeleteProtectedDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteProtectedDatabaseRequest buildWithoutInvocationCallback() {
            DeleteProtectedDatabaseRequest request = new DeleteProtectedDatabaseRequest();
            request.protectedDatabaseId = this.protectedDatabaseId;
            request.deletionSchedule = this.deletionSchedule;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

