/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.diff;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import oracle.arbori.util.DbObjNames;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.ScriptException;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Substitutions;
import oracle.dbtools.parser.plsql.SqlEarley;

public class ColProperties {
    Parsed target;
    ParseNode definition;
    private String name;
    ParseNode type;
    private ParseNode constraint;
    private static SqlEarley earley = null;
    private static Program program = new Program((Earley)ColProperties.getEarley());

    String getType() {
        if (this.type == null) {
            return "";
        }
        String t = this.type.content(this.target.getSrc()).toUpperCase();
        return t;
    }

    String getConstraint() {
        if (this.constraint == null) {
            return "";
        }
        String c = this.constraint.content(this.target.getSrc()).toUpperCase();
        return c;
    }

    String getName() {
        return this.name;
    }

    public ColProperties(Parsed target, ParseNode def) {
        this.target = target;
        this.definition = def;
        for (ParseNode candidate : def.children()) {
            if (!candidate.contains("datatype")) continue;
            this.type = candidate;
            break;
        }
        if (this.type == null) {
            this.name = ((LexerToken)target.getSrc().get((int)(def.from + 1))).content;
            this.name = DbObjNames.handleMixedCase((String)this.name);
            Iterator iterator = def.children().iterator();
            while (iterator.hasNext()) {
                ParseNode tmp;
                this.constraint = tmp = (ParseNode)iterator.next();
            }
        } else {
            this.name = ((LexerToken)target.getSrc().get((int)def.from)).content;
            this.name = DbObjNames.handleMixedCase((String)this.name);
            for (ParseNode candidate : def.children()) {
                if (!candidate.contains("inline_constraint")) continue;
                this.constraint = candidate;
                break;
            }
        }
    }

    public static boolean sameName(ColProperties c1, ColProperties c2) {
        return c1.getName().equals(c2.getName());
    }

    public static boolean sameType(ColProperties c1, ColProperties c2) {
        return c1.getType().equalsIgnoreCase(c2.getType());
    }

    public static boolean sameConstraint(ColProperties c1, ColProperties c2) {
        return c1.getConstraint().equalsIgnoreCase(c2.getConstraint());
    }

    public String reduce(ColProperties cmp) {
        Parsed t1 = new Parsed(this.target.content(this.definition), (Earley)ColProperties.getEarley(), "col_properties");
        final Substitutions replace = new Substitutions(t1);
        try {
            program.eval(t1, new Object(){

                public void delete(Parsed target, Map<String, ParseNode> tuple) {
                    ParseNode node = tuple.get("node");
                    replace.replace(node, "");
                }
            });
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        Substitutions ret = replace;
        if (cmp != null && this.constraint != null && ColProperties.sameConstraint(this, cmp)) {
            ret = new Substitutions(t1);
            int offset = ((LexerToken)this.target.getSrc().get((int)this.definition.from)).begin;
            int begin = ((LexerToken)this.target.getSrc().get((int)this.constraint.from)).begin - offset;
            int end = ((LexerToken)this.target.getSrc().get((int)(this.constraint.to - 1))).end - offset;
            ret.replace(begin, end, "");
        }
        return ret.transformInput();
    }

    private static SqlEarley getEarley() {
        if (earley != null) {
            return earley;
        }
        earley = new SqlEarley(){};
        TreeSet additionalRules = new TreeSet();
        earley.nullifySymbol2Recognize();
        earley.addSymbol2Recognize("col_properties");
        return earley;
    }

    static {
        String prg = "delete: [node) precheck_state \n| [node) XML_types -- ? OK for test 31 \n->";
        try {
            program.compile(prg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

