/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.stage;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Pattern;
import oracle.dbtools.extension.project.commands.verify.utils.VerifyUtils;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;
import org.apache.commons.io.FileUtils;

public class StageChangeLogComplete
implements VerifyServiceInterface {
    private static final Pattern apex_yaml_pattern = Pattern.compile(".*\\/apex_apps\\/.*\\/readable");
    private static final String[] fileTypes = new String[]{"sql", "pks", "pkb", "pls"};
    private static File codeCl;
    private static File stageCl;
    private String softObjectIsolation = "";

    @Override
    public String getName() {
        return "StageChangeLogComplete";
    }

    @Override
    public String getGroup() {
        return "Stage";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        try {
            StringBuilder message = new StringBuilder();
            this.softObjectIsolation = ProjectSettings.getSettingAsString("stage.softObjectIsolation");
            Path projectRoot = ProjectConfig.getCurrentWorkingProjectRoot();
            boolean preProcessError = false;
            if (this.softObjectIsolation.equals("change")) {
                stageCl = Paths.get(VerifyUtils.makeStageClog(projectRoot).toString(), new String[0]).toFile();
                if (!stageCl.exists()) {
                    preProcessError = true;
                    message.append("stage.changelog file not found: \n").append(projectRoot.relativize(stageCl.toPath()));
                }
            } else if (this.softObjectIsolation.equals("release")) {
                codeCl = Paths.get(VerifyUtils.makeCodeClog(projectRoot).toString(), new String[0]).toFile();
                stageCl = Paths.get(VerifyUtils.makeStageClog(projectRoot).toString(), new String[0]).toFile();
                if (!stageCl.exists()) {
                    preProcessError = true;
                    message.append("stage.changelog file not found: \n").append(projectRoot.relativize(stageCl.toPath()));
                }
                if (!codeCl.exists()) {
                    preProcessError = true;
                    message.append("code.changelog file not found: \n").append(projectRoot.relativize(stageCl.toPath()));
                }
            } else {
                preProcessError = true;
                message.append("softObjectIsolation config property has an invalid value");
            }
            if (preProcessError) {
                this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, message.toString());
                return false;
            }
            Path root = projectRoot.resolve("src").resolve("database");
            boolean processError = this.processFiles(FileUtils.listFiles((File)root.toFile(), (String[])fileTypes, (boolean)true), message);
            if (processError) {
                this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, message.toString());
                return false;
            }
            this.addMessage(VerifyServiceInterface.MessageLevel.INFO, "Stage Changelog validation found no issues.");
            return true;
        }
        catch (Exception e) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, e.getMessage(), "exception", e);
            return false;
        }
    }

    private boolean processFiles(Collection<File> files, StringBuilder message) throws IOException {
        boolean processError = false;
        for (File file : files) {
            if (file.isDirectory()) {
                return this.processFiles(FileUtils.listFiles((File)file, (String[])fileTypes, (boolean)true), message);
            }
            if (apex_yaml_pattern.matcher(file.getParent()).find()) {
                this.addMessage(VerifyServiceInterface.MessageLevel.HIDDEN, "SKIPPING_FILE", "file", file);
                continue;
            }
            Path fileRelativePath = ProjectConfig.getCurrentWorkingProjectRoot().relativize(file.toPath());
            if (this.softObjectIsolation.equals("release")) {
                if (FileUtils.readFileToString((File)stageCl, (Charset)StandardCharsets.UTF_8).contains(file.getName()) || FileUtils.readFileToString((File)codeCl, (Charset)StandardCharsets.UTF_8).contains(file.getName())) continue;
                message.append("File not found in any changelog : ").append(fileRelativePath).append("\n");
                processError = true;
                continue;
            }
            if (!this.softObjectIsolation.equals("change") || FileUtils.readFileToString((File)stageCl, (Charset)StandardCharsets.UTF_8).contains(file.getName())) continue;
            message.append("File not found in stage.changelog : ").append(fileRelativePath).append("\n");
            processError = true;
        }
        return processError;
    }
}

