/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.settings;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.settings.Settings;

public class SettingSerializer
extends JsonSerializer<Settings> {
    private String key = "";

    public void serialize(Settings entity, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        this.serializeEntity(gen, entity);
        gen.writeEndObject();
    }

    private void serializeEntity(JsonGenerator jsonGenerator, Settings entity) throws IOException {
        jsonGenerator.writeFieldName(entity.getName());
        if (entity.getChildren() != null && !entity.getChildren().isEmpty()) {
            jsonGenerator.writeStartObject();
            for (Settings child : entity.getChildren()) {
                if (child.getPub() == null || !child.getPub().equals("Y")) continue;
                this.key = this.key.isEmpty() ? child.getName() : this.key + "." + child.getName();
                this.serializeEntity(jsonGenerator, child);
                this.key = this.key.replace("." + child.getName(), "");
            }
            jsonGenerator.writeEndObject();
        } else {
            Settings set = ProjectSettings.getSystemConfigMap().get(this.key.replace("root.", ""));
            String userValue = set != null ? set.getDefaultVal() : null;
            String defValue = entity.getDefaultVal();
            String useValue = userValue != null && !userValue.equals(defValue) ? userValue : defValue;
            switch (entity.getType()) {
                case INTEGER: {
                    jsonGenerator.writeNumber(Integer.parseInt(useValue));
                    break;
                }
                case BOOLEAN: {
                    jsonGenerator.writeBoolean(Boolean.parseBoolean(useValue));
                    break;
                }
                case ARRAY: {
                    this.serializeArray(jsonGenerator, useValue);
                    break;
                }
                default: {
                    jsonGenerator.writeString(useValue);
                }
            }
        }
        this.key = this.key.replace("." + entity.getName(), "");
    }

    private void serializeArray(JsonGenerator jsonGenerator, String arrayStr) throws IOException {
        jsonGenerator.writeStartArray();
        if (arrayStr != null) {
            String[] values;
            for (String value : values = arrayStr.replaceAll("[\\[\\]\"]", "").split(",")) {
                value = value.trim();
                try {
                    jsonGenerator.writeNumber(Integer.parseInt(value));
                }
                catch (NumberFormatException e1) {
                    try {
                        jsonGenerator.writeNumber(Double.parseDouble(value));
                    }
                    catch (NumberFormatException e2) {
                        if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                            jsonGenerator.writeBoolean(Boolean.parseBoolean(value));
                            continue;
                        }
                        jsonGenerator.writeString(value);
                    }
                }
            }
        }
        jsonGenerator.writeEndArray();
    }
}

