/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.arbori.util.Pair;
import oracle.dbtools.extension.project.commands.export.DbObj;
import oracle.dbtools.extension.project.commands.stage.transforms.ObjectTypes;
import oracle.dbtools.extension.project.commands.stage.utils.interfaces.AbstractChangeLogSorter;

public class SqlChangeLogSorter
extends AbstractChangeLogSorter {
    private static final String AT_SYMBOL = "@";
    String regex = "action=\"(.*)\"";

    @Override
    protected void buildLists(String logContents) throws IOException {
        boolean beforeIncludeTag = true;
        try (BufferedReader reader = new BufferedReader(new StringReader(logContents));){
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith(AT_SYMBOL)) {
                    if (line.contains("_custom") && beforeIncludeTag) {
                        this.getStartLines().add(line);
                    } else {
                        try {
                            beforeIncludeTag = false;
                            Pair<DbObj, String> pair = this.processLine(line);
                            this.getIncludedLines().put((DbObj)pair.first(), (String)pair.second());
                        }
                        catch (Exception e) {
                            this.getEndLines().add(line);
                        }
                    }
                } else if (beforeIncludeTag) {
                    this.getStartLines().add(line);
                } else {
                    this.getEndLines().add(line);
                }
                line = reader.readLine();
            }
        }
    }

    @Override
    protected String stripAction(String line) {
        return line.replaceAll("\\s*--\\s*action=\"[^\"]+\"\\s*$", "");
    }

    private Pair<DbObj, String> processLine(String line) {
        String cleanedLine = line.replace(AT_SYMBOL, "");
        String[] vals = cleanedLine.split("/");
        Pattern pattern = Pattern.compile(this.regex);
        Matcher matcher = pattern.matcher(line);
        DbObj dbobj = new DbObj(vals[0].toUpperCase(), vals[2].substring(0, vals[2].indexOf(".")), ObjectTypes.singular(vals[1]), line);
        if (matcher.find()) {
            String action = matcher.group(1);
            return new Pair((Object)dbobj, (Object)action);
        }
        return new Pair((Object)dbobj, (Object)"unknown");
    }
}

