/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scheduler.job;

import oracle.dbtools.raptor.scheduler.SchedulerMessages;
import oracle.dbtools.raptor.scheduler.exceptions.InvalidJobException;
import oracle.dbtools.raptor.scheduler.job.Job;

public class JobValidator {
    private static final String NEW_LINE = System.lineSeparator();

    public void validate(Job job) {
        String payload;
        String cron;
        if (job == null) {
            throw new InvalidJobException(SchedulerMessages.getString("JOB_IS_NULL"));
        }
        StringBuilder errors = new StringBuilder();
        String name = job.getName();
        if (name == null || name.isBlank()) {
            errors.append(SchedulerMessages.format("REQUIRED_JOB_FIELD", job, "name")).append(NEW_LINE);
        }
        if ((cron = job.getCron()) == null || cron.isBlank()) {
            errors.append(SchedulerMessages.format("REQUIRED_JOB_FIELD", job, "cron")).append(NEW_LINE);
        }
        if ((payload = job.getPayload()) == null || payload.isBlank()) {
            errors.append(SchedulerMessages.format("REQUIRED_JOB_FIELD", job, "payload")).append(NEW_LINE);
        }
        if (errors.length() > 0) {
            throw new InvalidJobException(errors.toString());
        }
    }
}

