/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scheduler;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import oracle.dbtools.core.io.file.HomeFolder;
import oracle.dbtools.raptor.scheduler.SchedulerMessages;
import oracle.dbtools.raptor.scheduler.exceptions.InvalidJobException;
import oracle.dbtools.raptor.scheduler.job.Job;
import oracle.dbtools.raptor.scheduler.job.JobValidator;
import oracle.dbtools.raptor.scheduler.job.JobsList;
import oracle.dbtools.raptor.scheduler.reporting.ReportLine;
import oracle.dbtools.raptor.scheduler.reporting.Reporter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class SchedulerFile {
    private static final String DEFAULT_SCHEDULER_DIR_NAME = "schedules";
    private static final String DEFAULT_SCHEDULER_FILE_NAME = "scheduler";
    public static final Path DEFAULT_SCHEDULER_FILE_PATH = HomeFolder.ofSystem().path().resolve("schedules").resolve("scheduler.yaml");
    private static final Map<String, Job> jobs = new ConcurrentSkipListMap<String, Job>();
    private final Path filePath;
    private final Yaml yaml;
    private final JobValidator jobValidator = new JobValidator();
    private final Reporter reporter = new Reporter();

    public SchedulerFile() {
        this(DEFAULT_SCHEDULER_FILE_PATH);
    }

    public SchedulerFile(Path filePath) {
        this.filePath = this.getOrCreateSchedulerFile(filePath);
        this.yaml = new Yaml();
        this.loadJobs();
    }

    private Path getOrCreateSchedulerFile(Path schedulerFilePath) {
        try {
            Path schedulerFileDir = schedulerFilePath.getParent();
            if (Files.notExists(schedulerFileDir, new LinkOption[0])) {
                Files.createDirectories(schedulerFileDir, new FileAttribute[0]);
            }
            if (Files.notExists(schedulerFilePath, new LinkOption[0])) {
                Files.createFile(schedulerFilePath, new FileAttribute[0]);
                Files.write(schedulerFilePath, this.getSampleJobCommentedOut().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            return schedulerFilePath;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Job> loadJobs() {
        jobs.clear();
        try (InputStream inputStream = Files.newInputStream(this.filePath, new OpenOption[0]);){
            JobsList jobsList = (JobsList)this.yaml.loadAs(inputStream, JobsList.class);
            this.reporter.reportForAllJobs(ReportLine.ofNow(FileStatus.SCHEDULE_FILE_LOADED, ReportLine.Token.of("SCHEDULE_FILE", this.filePath.toString())));
            if (jobsList == null) {
                ArrayList<Job> arrayList2 = new ArrayList<Job>();
                return arrayList2;
            }
            List<Job> jbs = jobsList.getJobs();
            for (Job job : jbs) {
                this.jobValidator.validate(job);
                String name = job.getName();
                if (jobs.containsKey(name)) {
                    throw new InvalidJobException(SchedulerMessages.format("DUPLICATE_JOB_NAME", name, job));
                }
                jobs.put(name, job);
            }
            this.reporter.reportForAllJobs(ReportLine.ofNow(FileStatus.SCHEDULE_FILE_VALIDATED, ReportLine.Token.of("SCHEDULE_FILE", this.filePath.toString())));
            ArrayList<Job> arrayList = new ArrayList<Job>(jbs);
            return arrayList;
        }
        catch (IOException | RuntimeException e) {
            this.reporter.reportForAllJobs(ReportLine.ofNow(FileStatus.SCHEDULE_FILE_ERROR, ReportLine.Token.error(e.getMessage())));
            throw new IllegalStateException(SchedulerMessages.getString("ERROR_LOADING_FILE"), e);
        }
    }

    public void addJob(Job job) throws IOException {
        this.jobValidator.validate(job);
        jobs.put(job.getName(), job);
        this.save();
    }

    public void editJob(String name, Job newJob) throws IOException {
        this.jobValidator.validate(newJob);
        if (!jobs.containsKey(name)) {
            throw new IllegalStateException("Could not found a job with name: " + name);
        }
        jobs.remove(name);
        jobs.put(newJob.getName(), newJob);
        this.save();
    }

    public void removeJob(String name) throws IOException {
        if (jobs.containsKey(name)) {
            jobs.remove(name);
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() throws IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setIndent(2);
        options.setIndicatorIndent(0);
        options.setPrettyFlow(true);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        SkipNullRepresenter representer = new SkipNullRepresenter(options);
        representer.addClassTag(Job.class, Tag.MAP);
        SchedulerFile schedulerFile = this;
        synchronized (schedulerFile) {
            try (FileWriter writer = new FileWriter(this.filePath.toString());){
                Yaml yml = new Yaml((Representer)representer, options);
                yml.dump(Map.of("jobs", jobs.values().toArray()), (Writer)writer);
            }
        }
    }

    private String getSampleJobCommentedOut() {
        return "jobs:" + System.lineSeparator() + "# - name: job-example" + System.lineSeparator() + "#   cron: 0/2 * * * * ? *" + System.lineSeparator() + "#   connection: named-conn-example" + System.lineSeparator() + "#   payload: desc employees" + System.lineSeparator();
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public static enum FileStatus implements ReportLine.Status
    {
        SCHEDULE_FILE_VALIDATED,
        SCHEDULE_FILE_LOADED,
        SCHEDULE_FILE_ERROR;

    }

    private static class SkipNullRepresenter
    extends Representer {
        public SkipNullRepresenter(DumperOptions options) {
            super(options);
        }

        protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            if (propertyValue == null) {
                return null;
            }
            return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        }
    }
}

