/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.io.IOException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.core.connections.ConnectionsResources;
import oracle.dbtools.core.connections.api.Connections;
import oracle.dbtools.core.connections.folder.FolderOperationException;
import oracle.dbtools.core.connections.helpers.ConnectionHelper;
import oracle.dbtools.core.connections.helpers.ConnectionHelperContext;
import oracle.dbtools.core.connections.helpers.ConnectionHelperFactory;
import oracle.dbtools.core.connections.storage.ConnectionCloner;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.oci.connections.OCIHelperFactory;
import oracle.dbtools.core.oci.connections.OCIStoredConnectionSupport;
import oracle.dbtools.core.oci.search.ResourceQuery;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.core.util.DbtoolsException;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.net.commands.CommandMessages;
import oracle.dbtools.net.commands.OCICommand;
import oracle.dbtools.plusplus.connections.db.ConnectionDetailDisplay;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreOptions;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.connections.db.ConnectionTester;
import oracle.dbtools.plusplus.connections.db.DisplayFormatter;
import oracle.dbtools.plusplus.connections.db.NamedConnections;
import oracle.dbtools.plusplus.connections.db.imp.ImportedConnectionResult;
import oracle.dbtools.plusplus.connections.db.imp.Importer;
import oracle.dbtools.plusplus.connections.db.imp.OCIImporter;
import oracle.dbtools.plusplus.connections.db.imp.PathImporterFactory;
import oracle.dbtools.plusplus.connections.db.storage.SQLclConnectionCloner;
import oracle.dbtools.plusplus.secret.SecretCache;
import oracle.dbtools.plusplus.util.CommandContext;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.save.ConnectionsFolderManager;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.NamedConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.newscriptrunner.util.command.ParsedCommandListener;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

@Restricted(level=Restricted.Level.R4)
public class ConnectionStoreCommand
extends ParsedCommandListener {
    public final boolean isConnectionsFolderSupportEnabled = true;
    private final Map<Type, SubCommand> subcommands = new HashMap<Type, SubCommand>();

    public ConnectionStoreCommand() {
        this.subcommands.put(ConnectionStoreOptions.IMPORT_COMMAND, this::handleImportCommand);
        this.subcommands.put(ConnectionStoreOptions.LIST_COMMAND, this::handleListCommand);
        this.subcommands.put(ConnectionStoreOptions.SHOW_COMMAND, this::handleShowCommand);
        this.subcommands.put(ConnectionStoreOptions.TEST_COMMAND, this::handleTestCommand);
        this.subcommands.put(ConnectionStoreOptions.CLONE_COMMAND, this::handleCloneCommand);
    }

    private void registerFolderCommandsHandlers() {
        this.subcommands.put(ConnectionStoreOptions.ADD_COMMAND, this::handleAddCommand);
        this.subcommands.put(ConnectionStoreOptions.DELETE_COMMAND, this::handleDeleteCommand);
        this.subcommands.put(ConnectionStoreOptions.MOVE_COMMAND, this::handleMoveCommand);
        this.subcommands.put(ConnectionStoreOptions.RENAME_COMMAND, this::handleRenameCommand);
    }

    private void handleRenameCommand(CommandContext commandContext, ParsedCommand parsedCommand) {
        String folderPath = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.FOLDER);
        String connName = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.CONN);
        String destPath = (String)parsedCommand.getParameterValue(ConnectionStoreOptions.Symbol.DEST_PATH);
        MessageLogger logger = commandContext.getMessageLogger();
        ConnectionsFolderManager connectionsFolderManager = new ConnectionsFolderManager();
        if (folderPath != null) {
            connectionsFolderManager.renameFolder(folderPath, destPath);
            logger.logUserMessage(ConnectionStoreResources.format("FOLDER_RENAMED_SUCCESSFULLY", folderPath));
        } else if (connName != null) {
            connectionsFolderManager.renameConnection(connName, destPath);
            logger.logUserMessage(ConnectionStoreResources.format("CONNECTION_RENAMED_SUCCESSFULLY", connName));
        } else {
            logger.logUserMessage(ConnectionStoreResources.format("INVALID_OPTIONS_COMBINATION", "rename"));
        }
    }

    private void handleMoveCommand(CommandContext commandContext, ParsedCommand parsedCommand) {
        String folderPath = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.FOLDER);
        String connName = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.CONN);
        String destFolderPath = (String)parsedCommand.getParameterValue(ConnectionStoreOptions.Symbol.DEST_PATH);
        MessageLogger logger = commandContext.getMessageLogger();
        ConnectionsFolderManager connectionsFolderManager = new ConnectionsFolderManager();
        if (folderPath != null) {
            connectionsFolderManager.moveFolder(folderPath, destFolderPath);
            logger.logUserMessage(ConnectionStoreResources.format("FOLDER_MOVED", folderPath, destFolderPath));
        } else if (connName != null) {
            connectionsFolderManager.moveConnection(connName, destFolderPath);
            logger.logUserMessage(ConnectionStoreResources.format("CONNECTION_MOVED", connName, destFolderPath));
        } else {
            logger.logUserMessage(ConnectionStoreResources.format("INVALID_OPTIONS_COMBINATION", "move"));
        }
    }

    private void handleDeleteCommand(CommandContext commandContext, ParsedCommand parsedCommand) {
        String folderPath = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.FOLDER);
        String connName = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.CONN);
        boolean isForceDelete = (Boolean)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.FORCE);
        MessageLogger logger = commandContext.getMessageLogger();
        ConnectionsFolderManager connectionsFolderManager = new ConnectionsFolderManager();
        if (folderPath != null) {
            connectionsFolderManager.deleteFolder(folderPath, isForceDelete);
            logger.logUserMessage(ConnectionStoreResources.format("FOLDER_DELETED_SUCCESSFULLY", folderPath));
        } else if (connName != null) {
            ConnectionContext connectionContext = commandContext.getScriptRunnerContext().getService(ConnectionContext.class);
            String currentConnection = connectionContext.getCurrentPropertyValues().getValueOf(NamedConnectionProperty.NAME);
            if (connName.equals(currentConnection)) {
                throw new FolderOperationException(ConnectionsResources.format((String)"UNAUTHORIZED_ACTION", (Object[])new Object[]{connName}));
            }
            connectionsFolderManager.deleteConnection(connName);
            NamedConnections.refresh();
            logger.logUserMessage(ConnectionStoreResources.format("CONNECTION_DELETED_SUCCESSFULLY", connName));
        } else {
            logger.logUserMessage(ConnectionStoreResources.format("INVALID_OPTIONS_COMBINATION", "delete"));
        }
    }

    private void handleAddCommand(CommandContext commandContext, ParsedCommand parsedCommand) {
        String folderPath = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.FOLDER);
        MessageLogger logger = commandContext.getMessageLogger();
        ConnectionsFolderManager connectionsFolderManager = new ConnectionsFolderManager();
        connectionsFolderManager.addFolder(folderPath);
        logger.logUserMessage(ConnectionStoreResources.format("FOLDER_ADDED_SUCCESSFULLY", folderPath));
    }

    private SubCommand getSubcommand(Type command) {
        return this.subcommands.get(command);
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        CommandContext cmdCtx = CommandContext.of(ctx, ConnectionStoreCommand.class);
        Type type = parsedCommand.getType();
        ctx.putProperty("IS_CONNECTIONS_FOLDER_SUPPORT_ENABLED", true);
        this.registerFolderCommandsHandlers();
        SubCommand subCommand = this.getSubcommand(type);
        if (subCommand == null) {
            return false;
        }
        try {
            subCommand.handleSubcommand(cmdCtx, parsedCommand);
        }
        catch (Exception e) {
            cmdCtx.getMessageLogger().logUserMessage(e.getCause() == null ? e.getMessage() : e.getCause().getMessage());
        }
        return true;
    }

    private void handleImportCommand(CommandContext ctx, ParsedCommand parsedCommand) {
        Importer importer;
        ctx.getMessageLogger().traceMessage("CONNECTIONS IMPORT");
        String duplicates = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.DUPLICATES);
        ctx.getMessageLogger().traceMessage("Duplicate options = " + duplicates);
        ConnectionStoreOptions.DuplicatesPolicy duplicatesPolicy = ConnectionStoreOptions.DuplicatesPolicy.valueOf(duplicates.toUpperCase());
        Collection<String> existingConnections = NamedConnections.instance().listConnections();
        String secretName = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.KEY);
        boolean stripPwd = parsedCommand.isFlagSet(ConnectionStoreOptions.Symbol.STRIP_PASSWORDS);
        if (parsedCommand.isFlagSet(ConnectionStoreOptions.Symbol.OCI)) {
            if (secretName != null || stripPwd) {
                throw new DbtoolsException(ConnectionStoreResources.getString("OCI_INVALID_OPTIONS_COMBINATION"));
            }
            importer = OCIImporter.builder().displayName((String)parsedCommand.getParameterValue(ConnectionStoreOptions.Symbol.IMPORT_LOCATION)).connectionSupport(ConnectionStoreCommand.createOciSupport(ctx.getScriptRunnerContext())).duplicatesPolicy(duplicatesPolicy).existingConnections(existingConnections).commandContext(ctx).build();
        } else {
            String path = (String)parsedCommand.getParameterValue(ConnectionStoreOptions.Symbol.IMPORT_LOCATION);
            ctx.getMessageLogger().traceMessage("import path = " + path);
            Path importPath = FileUtils.getFilePath(ctx.getScriptRunnerContext(), path);
            if (importPath == null) {
                ctx.getMessageLogger().logUserMessage(ConnectionStoreResources.format("FAILURE_FILE_NOT_FOUND", path));
                return;
            }
            TextSecret secret = null;
            if (stripPwd) {
                secret = TextSecret.none();
                if (secretName != null) {
                    ctx.getMessageLogger().logUserMessage("Warning: password stripping overrides provided key");
                }
            } else if (secretName != null) {
                secret = SecretCache.getInstance().findSecret(secretName);
            }
            importer = PathImporterFactory.getImporter(importPath, duplicatesPolicy, existingConnections, ctx, secret);
        }
        Collection<ImportedConnectionResult> connections = importer.importConnections();
        connections.forEach(p -> p.logResult(ctx.getMessageLogger()));
        ctx.getMessageLogger().logUserMessage(ConnectionStoreResources.format("IMPORT_CONNECTIONS_COUNT", connections.size()));
        NamedConnections.refresh();
    }

    private void handleListCommand(CommandContext ctx, ParsedCommand parsedCommand) {
        String path = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.FOLDER);
        Boolean isFlatOption = (Boolean)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.FLAT);
        boolean isFlat = Boolean.TRUE.equals(isFlatOption);
        DisplayFormatter formatter = parsedCommand.isFlagSet(ConnectionStoreOptions.Symbol.OCI) ? DisplayFormatter.createOCIDisplay(ctx, path, isFlat) : DisplayFormatter.createStoredConnectionDisplay(ctx, path, isFlat);
        formatter.listConnections();
    }

    public static OCIStoredConnectionSupport createOciSupport(ScriptRunnerContext ctx) {
        String profileName = (String)ctx.getProperty("oci.profile.name");
        if (profileName == null) {
            throw new DbtoolsException(CommandMessages.getString((String)"OCI_PROFILE_NOT_SET"));
        }
        String region = (String)ctx.getProperty("oci.region.name");
        return OCIStoredConnectionSupport.builder().ociProfile(profileName).ociRegion(region).build();
    }

    private void handleShowCommand(CommandContext ctx, ParsedCommand parsedCommand) {
        String cName = (String)parsedCommand.getParameterValue(ConnectionStoreOptions.Symbol.CONNECTION_NAME);
        ctx.getMessageLogger().traceMessage("Connection name: " + cName);
        if (parsedCommand.isFlagSet(ConnectionStoreOptions.Symbol.OCI)) {
            this.displayOciConnectionDetails(ctx, cName);
        } else {
            ConnectionDetailDisplay.instance().displayConnectionDetails(ctx, cName);
        }
    }

    private void displayOciConnectionDetails(CommandContext cmdCtx, String cName) {
        ResourceQuery.ResourceQueryConstraint constraint;
        ScriptRunnerContext ctx = cmdCtx.getScriptRunnerContext();
        OCIStoredConnectionSupport support = ConnectionStoreCommand.createOciSupport(ctx);
        Collection connections = support.listConnections(constraint = ResourceQuery.matchConstraint((String)"displayName", (String)cName));
        if (connections.isEmpty()) {
            ctx.writeln(ConnectionStoreResources.format("ERROR_UNKNOWN_CONNECTION", cName));
        } else {
            List<ConnectionDefinition> definitions = connections.stream().map(arg_0 -> ((OCIStoredConnectionSupport)support).createConnectionDefinition(arg_0)).collect(Collectors.toList());
            definitions.forEach(p -> {
                ConnectionHelper connectionHelper = OCIHelperFactory.createOciConnectionHelper((ConnectionHelperContext)ConnectionHelperContext.of((ConnectionDefinition)p, (MessageLogger)CommandContext.of(ctx, OCICommand.class).getMessageLogger()));
                Collection props = connectionHelper.getDisplayProperties();
                for (ConnectionHelper.DisplayEntry entry : props) {
                    ctx.writeln(entry.getDisplayOutput());
                }
            });
        }
    }

    private void handleTestCommand(CommandContext ctx, ParsedCommand parsedCommand) {
        ConnectionDefinition definition;
        String cName = (String)parsedCommand.getParameterValue(ConnectionStoreOptions.Symbol.CONNECTION_NAME);
        ctx.getMessageLogger().traceMessage("Connection name: " + cName);
        String user = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.USERNAME);
        if (user != null) {
            ctx.getMessageLogger().traceMessage("Override username with " + user);
        }
        if ((definition = ConnectionStoreCommand.getConnectionDefinition(cName, ctx)) == null) {
            return;
        }
        try {
            ConnectionTester tester = ConnectionTester.builder(definition).messageLogger(ctx.getMessageLogger()).scriptRunnerContext(ctx.getScriptRunnerContext()).build();
            tester.testConnection(user);
            ctx.getMessageLogger().logUserMessage(ConnectionStoreResources.getString("TEST_SUCCESS"));
        }
        catch (SQLException ex) {
            ctx.getMessageLogger().logUserMessage(ConnectionStoreResources.format("TEST_FAILURE", ex.getLocalizedMessage()));
        }
    }

    private void handleCloneCommand(CommandContext ctx, ParsedCommand parsedCommand) {
        block9: {
            try {
                Collection<String> existingConnections = NamedConnections.instance().listConnections();
                SQLclConnectionCloner.Builder builder = SQLclConnectionCloner.builder(ctx);
                String origName = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.ORIGINAL);
                ConnectionDefinition origDef = ConnectionStoreCommand.getConnectionDefinition(origName, ctx);
                if (origDef == null) {
                    return;
                }
                builder.origin(origDef);
                String dest = (String)parsedCommand.getParameterValue(ConnectionStoreOptions.Symbol.CONNECTION_NAME);
                if (existingConnections.contains(dest)) {
                    ctx.getMessageLogger().logUserMessage(ConnectionStoreResources.format("ERROR_EXISTING_CONNECTION", dest));
                    return;
                }
                builder.destination(dest);
                ConnectionCloner.CloneCredentials credentials = ConnectionCloner.CloneCredentials.from((ConnectionDefinition)origDef);
                String username = (String)parsedCommand.getOptionValue(ConnectionStoreOptions.Symbol.USERNAME);
                boolean skipPwd = parsedCommand.isFlagSet(ConnectionStoreOptions.Symbol.NOPWD);
                if (username != null) {
                    TextSecret newPwd = TextSecret.none();
                    if (!skipPwd) {
                        ConnectionHelper helper = ConnectionHelperFactory.findHelper((ConnectionHelperContext)ConnectionHelperContext.of((ConnectionDefinition)origDef, (MessageLogger)ctx.getMessageLogger()));
                        String spec = helper.getConnectionSpec();
                        String url = helper.getURL();
                        ConnectionDetails cd = new ConnectionDetails(spec, false, username, null, spec, null, false, -1, -1, null);
                        cd.setConnectDB(url);
                        ScriptRunnerContext scriptRunnerContext = ctx.getScriptRunnerContext();
                        ConnectionDetails updatedDetails = scriptRunnerContext.getConnectFieldsProvider().get3Fields(scriptRunnerContext, cd, false);
                        if (updatedDetails != null) {
                            newPwd = updatedDetails.getConnectPassword();
                        }
                    }
                    credentials = ConnectionCloner.CloneCredentials.of((String)username, (TextSecret)newPwd);
                } else if (skipPwd) {
                    credentials = ConnectionCloner.CloneCredentials.of((String)credentials.getUsername(), (TextSecret)TextSecret.none());
                }
                builder.credentials(credentials);
                SQLclConnectionCloner cloner = builder.build();
                cloner.cloneConnection();
                cloner.saveConnection();
                NamedConnections.refresh();
                ctx.getMessageLogger().logUserMessage(ConnectionStoreResources.format("CONNECTION_CLONNED_SUCCESSFULLY", dest));
            }
            catch (IOException ex) {
                ctx.getMessageLogger().logUserMessage(ex.getLocalizedMessage());
                Throwable cause = ex.getCause();
                if (cause == null) break block9;
                ctx.getMessageLogger().logUserMessage(cause.toString());
            }
        }
    }

    static ConnectionDefinition getConnectionDefinition(String cName, CommandContext cmdCtx) {
        Connections.Identifier ci = NamedConnections.instance().lookupConnectionIdentifier(cName);
        if (ci == null) {
            cmdCtx.getMessageLogger().logUserMessage(ConnectionStoreResources.format("ERROR_UNKNOWN_CONNECTION", cName));
            return null;
        }
        ConnectionDefinition definition = NamedConnections.instance().getConnectionDefinition(ci);
        if (definition == null) {
            cmdCtx.getMessageLogger().logUserMessage(ConnectionStoreResources.format("ERROR_LOADING_CONNECTION", cName));
            return null;
        }
        return definition;
    }

    @Override
    protected Type createType() {
        return ConnectionStoreOptions.COMMAND;
    }

    private static interface SubCommand {
        public void handleSubcommand(CommandContext var1, ParsedCommand var2);
    }
}

