/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.win32;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import oracle.dbtools.win32.WindowsSupport;

public class WindowsSupportProvider
implements WindowsSupport {
    public static final int REG_SUCCESS = 0;
    public static final int REG_NOTFOUND = 2;
    public static final int REG_ACCESSDENIED = 5;
    private static final int KEY_ALL_ACCESS = 983103;
    private static final int KEY_WOW64_64KEY = 256;
    private static final int KEY_READ32 = 131353;
    private static final int KEY_READ64 = 131097;
    private static Preferences userRoot = Preferences.userRoot();
    private static Class<? extends Preferences> userClass = userRoot.getClass();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regEnumValue = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;
    private static boolean jdk11Style = false;
    private final Registry registry = new Registry();
    private static Preferences systemRoot = WindowsSupportProvider.systemRoot();
    private static final String NT_SYSTEM_CLASS = "com.sun.security.auth.module.NTSystem";
    private static String domain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Preferences systemRoot() {
        Logger l = Logger.getLogger("");
        Level level = l.getLevel();
        try {
            Preferences systemRoot;
            l.setLevel(Level.OFF);
            Preferences preferences = systemRoot = Preferences.systemRoot();
            return preferences;
        }
        finally {
            l.setLevel(level);
        }
    }

    private static Object[] toJdk11(Object[] inParams) {
        if (inParams == null) {
            return null;
        }
        if (!jdk11Style) {
            if (inParams[0] instanceof Long) {
                inParams[0] = new Integer(((Long)inParams[0]).intValue());
            }
            return inParams;
        }
        if (inParams[0] instanceof Integer) {
            inParams[0] = new Long(((Integer)inParams[0]).intValue());
        }
        return inParams;
    }

    private static Long[] longArrayToInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof int[]) {
            ArrayList<Long> allL = new ArrayList<Long>();
            int[] nArray = (int[])o;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                long l = nArray[i];
                allL.add(new Long(l));
            }
            return allL.toArray(new Long[allL.size()]);
        }
        if (o instanceof long[]) {
            ArrayList<Long> allL = new ArrayList<Long>();
            for (long l : (long[])o) {
                allL.add(new Long(l));
            }
            return allL.toArray(new Long[allL.size()]);
        }
        new Exception().printStackTrace();
        return null;
    }

    private static String readString(int hkey, String key, String valueName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646) {
            return WindowsSupportProvider.readString(systemRoot, hkey, key, valueName);
        }
        if (hkey == -2147483647) {
            return WindowsSupportProvider.readString(userRoot, hkey, key, valueName);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    private static List<String> readStringSubKeys(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646) {
            return WindowsSupportProvider.readStringSubKeys(systemRoot, hkey, key);
        }
        if (hkey == -2147483647) {
            return WindowsSupportProvider.readStringSubKeys(userRoot, hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    private static String readString(Preferences root, int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Long[] handles = WindowsSupportProvider.longArrayToInt(regOpenKey.invoke((Object)root, WindowsSupportProvider.toJdk11(new Object[]{new Long(hkey), WindowsSupportProvider.toCstr(key), new Integer(131353)})));
        if (handles[1] != 0L && (handles = WindowsSupportProvider.longArrayToInt(regOpenKey.invoke((Object)root, WindowsSupportProvider.toJdk11(new Object[]{new Long(hkey), WindowsSupportProvider.toCstr(key), new Integer(131097)}))))[1] != 0L) {
            return null;
        }
        byte[] valb = (byte[])regQueryValueEx.invoke((Object)root, WindowsSupportProvider.toJdk11(new Object[]{new Long(handles[0]), WindowsSupportProvider.toCstr(value)}));
        regCloseKey.invoke((Object)root, WindowsSupportProvider.toJdk11(new Object[]{new Long(handles[0])}));
        return valb != null ? new String(valb).trim() : null;
    }

    private static Map<String, String> readStringValues(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap<String, String> results = new HashMap<String, String>();
        Long[] handles = WindowsSupportProvider.longArrayToInt(regOpenKey.invoke((Object)root, WindowsSupportProvider.toJdk11(new Object[]{new Long(hkey), WindowsSupportProvider.toCstr(key), new Integer(131353)})));
        if (handles[1] != 0L && (handles = WindowsSupportProvider.longArrayToInt(regOpenKey.invoke((Object)root, WindowsSupportProvider.toJdk11(new Object[]{new Long(hkey), WindowsSupportProvider.toCstr(key), new Integer(131097)}))))[1] != 0L) {
            return null;
        }
        Long[] info = WindowsSupportProvider.longArrayToInt(regQueryInfoKey.invoke((Object)root, WindowsSupportProvider.toJdk11(new Object[]{new Long(handles[0])})));
        long count = info[0];
        long maxlen = info[3];
        int index = 0;
        while ((long)index < count) {
            byte[] name = (byte[])regEnumValue.invoke((Object)root, WindowsSupportProvider.toJdk11(new Object[]{new Long(handles[0]), new Integer(index), new Integer(new Long(maxlen + 1L).intValue())}));
            String value = WindowsSupportProvider.readString(hkey, key, new String(name));
            results.put(new String(name).trim(), value);
            ++index;
        }
        regCloseKey.invoke((Object)root, WindowsSupportProvider.toJdk11(new Object[]{new Long(handles[0])}));
        return results;
    }

    private static List<String> readStringSubKeys(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> results = new ArrayList<String>();
        Long[] handles1 = WindowsSupportProvider.longArrayToInt(regOpenKey.invoke((Object)root, WindowsSupportProvider.toJdk11(new Object[]{new Long(hkey), WindowsSupportProvider.toCstr(key), new Integer(131353)})));
        Long[] handles2 = WindowsSupportProvider.longArrayToInt(regOpenKey.invoke((Object)root, WindowsSupportProvider.toJdk11(new Object[]{new Long(hkey), WindowsSupportProvider.toCstr(key), new Integer(131097)})));
        if (handles1[1] != 0L && handles2[1] != 0L) {
            return null;
        }
        results.addAll(WindowsSupportProvider.getResults(root, handles1));
        results.addAll(WindowsSupportProvider.getResults(root, handles2));
        return results;
    }

    private static List<String> getResults(Preferences root, Long[] handles) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<String> results = new ArrayList<String>();
        Long[] info = WindowsSupportProvider.longArrayToInt(regQueryInfoKey.invoke((Object)root, WindowsSupportProvider.toJdk11(new Object[]{new Long(handles[0])})));
        long count = info[0];
        long maxlen = info[3];
        int index = 0;
        while ((long)index < count) {
            byte[] name = (byte[])regEnumKeyEx.invoke((Object)root, WindowsSupportProvider.toJdk11(new Object[]{new Long(handles[0]), new Integer(index), new Integer(new Long(maxlen + 1L).intValue())}));
            results.add(new String(name).trim());
            ++index;
        }
        regCloseKey.invoke((Object)root, WindowsSupportProvider.toJdk11(new Object[]{new Long(handles[0])}));
        return results;
    }

    private static byte[] toCstr(String str) {
        byte[] result = new byte[str.length() + 1];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = (byte)str.charAt(i);
        }
        result[str.length()] = 0;
        return result;
    }

    @Override
    public String domain() {
        return domain;
    }

    @Override
    public WindowsSupport.Registry registry() {
        return this.registry;
    }

    static {
        Class<Number> hkeyType = Integer.TYPE;
        try {
            try {
                regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", hkeyType, byte[].class, Integer.TYPE);
            }
            catch (NoSuchMethodException ex) {
                hkeyType = Long.TYPE;
                jdk11Style = true;
                regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", hkeyType, byte[].class, Integer.TYPE);
            }
            regOpenKey.setAccessible(true);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", hkeyType);
            regCloseKey.setAccessible(true);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", hkeyType, byte[].class);
            regQueryValueEx.setAccessible(true);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", hkeyType, Integer.TYPE, Integer.TYPE);
            regEnumValue.setAccessible(true);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", hkeyType);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", hkeyType, Integer.TYPE, Integer.TYPE);
            regEnumKeyEx.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ("\\".equals(File.separator)) {
            try {
                Class<?> ntsystem = Class.forName(NT_SYSTEM_CLASS);
                Object obj = ntsystem.newInstance();
                Method meth = ntsystem.getMethod("getDomain", new Class[0]);
                Object domainName = meth.invoke(obj, new Object[0]);
                domain = domainName.toString();
            }
            catch (Exception ex) {
                domain = "";
            }
        } else {
            domain = "";
        }
    }

    private static class Registry
    implements WindowsSupport.Registry {
        private Registry() {
        }

        @Override
        public String readString(int hkey, String key, String valueName) {
            try {
                return WindowsSupportProvider.readString(hkey, key, valueName);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public List<String> readStringSubKeys(int hkey, String key) {
            try {
                return WindowsSupportProvider.readStringSubKeys(hkey, key);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

