/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.apexlang.core.FilePathComponentType;
import oracle.apexlang.metametadata.Metametadata;

public class SortedFilePaths {
    static final String extIdentifierWithPluginType = "#plugin_type#/#external_identifier#";
    static final String extIdentifier = "#external_identifier#";
    private String filePath;
    private String componentTypeId;
    private List<SortedFilePaths> childrenFiles;
    private String relativeDirectory;
    private Map<String, FilePathComponentType> filePathComponentType;

    public SortedFilePaths() {
        this.filePath = "";
        this.componentTypeId = "";
        this.childrenFiles = new ArrayList<SortedFilePaths>();
        this.relativeDirectory = "";
        this.filePathComponentType = Map.of();
    }

    public SortedFilePaths(String filePath, String componentTypeId, String relativeDirectory, Map<String, FilePathComponentType> filePathComponentType) {
        this.filePath = filePath;
        this.componentTypeId = componentTypeId;
        this.relativeDirectory = relativeDirectory;
        this.filePathComponentType = filePathComponentType;
        this.childrenFiles = new ArrayList<SortedFilePaths>();
    }

    public List<SortedFilePaths> getChildrenFiles() {
        return this.childrenFiles;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getComponentTypeId() {
        return this.componentTypeId;
    }

    public String getRelativeDirectory() {
        return this.relativeDirectory;
    }

    public Map<String, FilePathComponentType> getFilePathComponentType() {
        return this.filePathComponentType;
    }

    public static SortedFilePathsResult createSortedFilePathsFromList(List<String> fileList, Metametadata metametadata, Map<String, FilePathComponentType> filenameComponentTypeMap, String relativeDirectory, String componentTypeParentId) {
        ArrayList<SortedFilePaths> sortedFilePaths = new ArrayList<SortedFilePaths>();
        HashSet<String> filesDetected = new HashSet<String>();
        for (String currentComponentTypeId : filenameComponentTypeMap.keySet()) {
            FilePathComponentType currentFilePathComponentType = filenameComponentTypeMap.get(currentComponentTypeId);
            if (componentTypeParentId == null ? currentFilePathComponentType.getParentComponentTypeId() != null : !componentTypeParentId.equals(currentFilePathComponentType.getParentComponentTypeId())) continue;
            for (String filePath : fileList) {
                if (currentFilePathComponentType.getFilepath().endsWith(".apex")) {
                    String relativeFilePath = filePath;
                    if (relativeDirectory.length() > 0 && filePath.startsWith(relativeDirectory)) {
                        relativeFilePath = filePath.substring(relativeDirectory.length());
                    }
                    if (relativeFilePath.equals(currentFilePathComponentType.getFilepath())) {
                        int lastDirectoryIndex = currentFilePathComponentType.getFilepath().lastIndexOf("/");
                        String currentRelativeDirectory = lastDirectoryIndex > 0 ? currentFilePathComponentType.getFilepath().substring(0, lastDirectoryIndex + 1) : "";
                        filesDetected.add(filePath);
                        SortedFilePaths newSortedFilePaths = new SortedFilePaths(filePath, currentComponentTypeId, relativeDirectory + currentRelativeDirectory, filenameComponentTypeMap);
                        sortedFilePaths.add(newSortedFilePaths);
                        continue;
                    }
                }
                if (currentFilePathComponentType.getFilepath().endsWith("/")) {
                    String pathAfterPrefix;
                    if (!filePath.startsWith(relativeDirectory + currentFilePathComponentType.getFilepath()) || (pathAfterPrefix = filePath.substring((relativeDirectory + currentFilePathComponentType.getFilepath()).length())).indexOf("/") >= 0 || !pathAfterPrefix.endsWith(".apex")) continue;
                    filesDetected.add(filePath);
                    SortedFilePaths newSortedFilePaths = new SortedFilePaths(filePath, currentComponentTypeId, relativeDirectory + currentFilePathComponentType.getFilepath(), filenameComponentTypeMap);
                    sortedFilePaths.add(newSortedFilePaths);
                    continue;
                }
                int extIdentifierWithPluginTypeIndex = currentFilePathComponentType.getFilepath().indexOf(extIdentifierWithPluginType);
                if (extIdentifierWithPluginTypeIndex > 0) {
                    String pathPrefixComponentType = currentFilePathComponentType.getFilepath().substring(0, extIdentifierWithPluginTypeIndex);
                    String pathSuffixComponentType = currentFilePathComponentType.getFilepath().substring(extIdentifierWithPluginTypeIndex + extIdentifierWithPluginType.length());
                    if (!filePath.startsWith(pathPrefixComponentType)) continue;
                    String pathAfterPrefix = filePath.substring(pathPrefixComponentType.length());
                    String[] chunksFile = pathAfterPrefix.split("/");
                    String[] chunksFilePathComponent = pathSuffixComponentType.split("/");
                    if (chunksFile.length != 3 || chunksFilePathComponent.length != 2 || !filePath.endsWith(chunksFilePathComponent[1])) continue;
                    filesDetected.add(filePath);
                    SortedFilePaths newSortedFilePaths = new SortedFilePaths(filePath, currentComponentTypeId, relativeDirectory + pathPrefixComponentType + chunksFile[0] + "/" + chunksFile[1] + "/", currentFilePathComponentType.getFilenameComponentTypeMap());
                    sortedFilePaths.add(newSortedFilePaths);
                    continue;
                }
                int externalIdentifierIndex = currentFilePathComponentType.getFilepath().indexOf(extIdentifier);
                if (externalIdentifierIndex <= 0) continue;
                String pathPrefixComponentType = currentFilePathComponentType.getFilepath().substring(0, externalIdentifierIndex);
                String pathSuffixComponentType = currentFilePathComponentType.getFilepath().substring(externalIdentifierIndex + extIdentifier.length());
                if (!filePath.startsWith(pathPrefixComponentType)) continue;
                String pathAfterPrefix = filePath.substring(pathPrefixComponentType.length());
                String[] chunksFile = pathAfterPrefix.split("/");
                String[] chunksFilePathComponent = pathSuffixComponentType.split("/");
                if (chunksFile.length != 2 || chunksFilePathComponent.length != 2 || !filePath.endsWith(chunksFilePathComponent[1])) continue;
                filesDetected.add(filePath);
                SortedFilePaths newSortedFilePaths = new SortedFilePaths(filePath, currentComponentTypeId, relativeDirectory + pathPrefixComponentType + chunksFile[0] + "/", currentFilePathComponentType.getFilenameComponentTypeMap());
                sortedFilePaths.add(newSortedFilePaths);
            }
        }
        for (SortedFilePaths sortedFilePath : sortedFilePaths) {
            ArrayList<String> currentFileList = new ArrayList<String>();
            for (String filePath : fileList) {
                if (filesDetected.contains(filePath)) continue;
                currentFileList.add(filePath);
            }
            if (currentFileList.size() == 0) break;
            SortedFilePathsResult childrenFilePaths = SortedFilePaths.createSortedFilePathsFromList(currentFileList, metametadata, sortedFilePath.getFilePathComponentType(), sortedFilePath.relativeDirectory, sortedFilePath.componentTypeId);
            List<SortedFilePaths> sharedComponentsFirstList = SortedFilePaths.putSharedComponentsFirst(childrenFilePaths.sortedFilePaths);
            sortedFilePath.getChildrenFiles().addAll(sharedComponentsFirstList);
            filesDetected.addAll(childrenFilePaths.getFilesIdentified());
        }
        return new SortedFilePathsResult(sortedFilePaths, List.copyOf(filesDetected));
    }

    private static List<SortedFilePaths> putSharedComponentsFirst(List<SortedFilePaths> childrenFilePaths) {
        ArrayList<SortedFilePaths> sharedComponentsFirstList = new ArrayList<SortedFilePaths>();
        ArrayList<SortedFilePaths> notSharedComponentsList = new ArrayList<SortedFilePaths>();
        for (SortedFilePaths currentFile : childrenFilePaths) {
            if (currentFile.filePath.startsWith("shared-components/")) {
                sharedComponentsFirstList.add(currentFile);
                continue;
            }
            notSharedComponentsList.add(currentFile);
        }
        sharedComponentsFirstList.addAll(notSharedComponentsList);
        return sharedComponentsFirstList;
    }

    public static class SortedFilePathsResult {
        private List<SortedFilePaths> sortedFilePaths;
        private List<String> filesIdentified;

        public SortedFilePathsResult(List<SortedFilePaths> sortedFilePaths, List<String> filesIdentified) {
            this.sortedFilePaths = sortedFilePaths;
            this.filesIdentified = filesIdentified;
        }

        public List<String> getFilesIdentified() {
            return this.filesIdentified;
        }

        public List<SortedFilePaths> getSortedFilePaths() {
            return this.sortedFilePaths;
        }
    }
}

