/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.apexlang.APEXAppFile;
import oracle.apexlang.APEXLangCompiler;
import oracle.apexlang.core.APEXLangCompilationResult;
import oracle.apexlang.core.APEXLangCompilerContext;
import oracle.apexlang.core.APEXLangMissingRequiredPropertyError;
import oracle.apexlang.core.APEXLangNativePluginsLoader;
import oracle.apexlang.core.APEXLangSuggestion;
import oracle.apexlang.core.APEXLangSyntaxError;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.ComponentGroup;
import oracle.apexlang.core.ComponentParameter;
import oracle.apexlang.metametadata.ComponentType;
import oracle.apexlang.metametadata.LOV;
import oracle.apexlang.metametadata.Metametadata;
import oracle.apexlang.metametadata.Property;
import oracle.apexlang.metametadata.PropertyType;

public class APEXLangSuggestionProvider {
    private APEXLangCompiler compiler;
    private final Map<String, APEXAppFile> fileMap;
    private final APEXLangCompilerContext appCtx;
    private final String filePath;
    private final int offset;
    private final APEXLangCompilationResult compilationResult;
    private final Metametadata metametadata;
    private final BiFunction<Component, ComponentType, Boolean> isValidCheck;
    private final APEXLangNativePluginsLoader pluginsLoader;

    public APEXLangSuggestionProvider(APEXLangCompiler compiler, Map<String, APEXAppFile> fileMap, APEXLangCompilerContext appCtx, String fileName, int offset, BiFunction<Component, ComponentType, Boolean> isValidCheck, APEXLangNativePluginsLoader pluginsLoader) {
        this.compiler = compiler;
        this.filePath = fileName;
        this.offset = offset;
        this.metametadata = compiler.getMetametadata();
        this.isValidCheck = isValidCheck;
        this.pluginsLoader = pluginsLoader;
        this.fileMap = fileMap.entrySet().stream().filter(entry -> !((String)entry.getKey()).toString().endsWith(".apex")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.fileMap.put(fileName, fileMap.get(fileName));
        this.appCtx = new APEXLangCompilerContext();
        this.appCtx.setCentralThemeAppId(appCtx.getCentralThemeAppId());
        this.appCtx.setCurrentTheme(appCtx.getCurrentTheme());
        this.appCtx.setGlobalPage(appCtx.getGlobalPage());
        this.appCtx.getReferencablesMap().putAll(appCtx.getReferencablesMap());
        this.compilationResult = compiler.compile(this.fileMap, this.appCtx);
    }

    public List<APEXLangSuggestion> getSuggestions() {
        Component component = null;
        ComponentGroup group = null;
        block0: for (Component comp : this.compilationResult.getComponentsParameters()) {
            if (!comp.getFilename().equals(this.filePath) || comp.getRange().getStart() > this.offset || comp.getRange().getEnd() < this.offset) continue;
            component = comp;
            for (Map.Entry<String, ComponentParameter> entry : comp.getParameters().entrySet()) {
                ComponentParameter componentParameter = entry.getValue();
                if (!componentParameter.isInSource() || componentParameter.getKeyRange().getEnd() > this.offset || componentParameter.getRange().getEnd() < this.offset) continue;
                return componentParameter.getSuggestions();
            }
            for (ComponentGroup grp : comp.getComponentGroups()) {
                if (grp.getRange().getStart() > this.offset || grp.getRange().getEnd() < this.offset) continue;
                group = grp;
                continue block0;
            }
        }
        for (APEXLangSyntaxError syntaxError : this.compilationResult.getErrors()) {
            if (!syntaxError.getFilename().equals(this.filePath)) continue;
            List<APEXLangSuggestion> suggestions = null;
            if (syntaxError.getRange().getStart() <= this.offset && syntaxError.getRange().getEnd() >= this.offset) {
                suggestions = syntaxError.getSuggestions();
            } else if (syntaxError.getErrorType().equals((Object)APEXLangSyntaxError.ErrorType.INVALID_PROPERTY) && syntaxError.getRange().getEnd() <= this.offset && syntaxError.getRange().getEnd() + 2 >= this.offset) {
                suggestions = syntaxError.getSuggestions();
            }
            if (suggestions == null) continue;
            return suggestions;
        }
        if (component != null) {
            ArrayList<APEXLangSuggestion> suggestions = new ArrayList<APEXLangSuggestion>();
            for (Component relatedComponent : component.getAllRelatedComponents()) {
                HashMap<String, ComponentType.ComponentProperty> unsetProperties = new HashMap<String, ComponentType.ComponentProperty>();
                HashSet<String> existingGroups = new HashSet<String>();
                boolean defaultGroupIncluded = false;
                unsetProperties.putAll(relatedComponent.getComponentType().getProperties());
                String defaultGroupId = relatedComponent.getComponentType().getDefaultGroupId();
                String defaultGroupName = defaultGroupId == null ? null : this.metametadata.getGroups().get(defaultGroupId).getName();
                for (Map.Entry<String, ComponentParameter> entry : relatedComponent.getParameters().entrySet()) {
                    ComponentParameter componentParameter = entry.getValue();
                    String groupName2 = componentParameter.getProperty().getGroupName();
                    if (!componentParameter.isInSource()) continue;
                    unsetProperties.remove(entry.getKey());
                    if (groupName2 == null || componentParameter.isImplicitGroup() || componentParameter.isExternalIdentifier().booleanValue()) continue;
                    existingGroups.add(groupName2);
                    if (!groupName2.equals(defaultGroupName)) continue;
                    defaultGroupIncluded = true;
                }
                if (group == null) {
                    if (!defaultGroupIncluded) {
                        this.addProperties(suggestions, unsetProperties, cp -> cp.getGroupName().equals(defaultGroupName), false, APEXLangSuggestion.SuggestionType.PROPERTY_IN_CURRENT_GROUP, relatedComponent);
                    }
                    this.addProperties(suggestions, unsetProperties, cp -> !existingGroups.contains(cp.getGroupName()), true, APEXLangSuggestion.SuggestionType.PROPERTY_IN_NEW_GROUP, relatedComponent);
                    this.addProperties(suggestions, unsetProperties, cp -> existingGroups.contains(cp.getGroupName()), true, APEXLangSuggestion.SuggestionType.PROPERTY_IN_EXISTING_GROUP, relatedComponent);
                    List<String> unusedGroupName = unsetProperties.values().stream().map(p -> p.getGroupName()).filter(groupName -> groupName != null && !groupName.equals(defaultGroupName) && !existingGroups.contains(groupName)).distinct().toList();
                    String detail = "Group";
                    suggestions.addAll(APEXLangSuggestion.fromStrings(unusedGroupName, APEXLangSuggestion.SuggestionType.GROUP, "Group"));
                    this.addChildComponentSuggestions(suggestions, relatedComponent);
                    continue;
                }
                String groupName3 = group.getName();
                this.addProperties(suggestions, unsetProperties, cp -> groupName3.equals(cp.getGroupName()), false, APEXLangSuggestion.SuggestionType.PROPERTY_IN_CURRENT_GROUP, relatedComponent);
            }
            return suggestions;
        }
        return null;
    }

    private void addProperties(List<APEXLangSuggestion> suggestions, Map<String, ComponentType.ComponentProperty> unsetProperties, Function<ComponentType.ComponentProperty, Boolean> filter, boolean addGroupName, APEXLangSuggestion.SuggestionType type, Component component) {
        for (Map.Entry<String, ComponentType.ComponentProperty> entry : unsetProperties.entrySet()) {
            String key = entry.getKey();
            ComponentType.ComponentProperty componentProperty = entry.getValue();
            if (!Boolean.TRUE.equals(filter.apply(componentProperty))) continue;
            Property property = this.metametadata.getProperties().get(key);
            this.addProperty(suggestions, property, addGroupName, type, component);
        }
    }

    private void addProperty(List<APEXLangSuggestion> suggestions, Property property, boolean addGroupName, APEXLangSuggestion.SuggestionType type, Component component) {
        String value = addGroupName ? property.getGroupName() + "." + property.getName() : property.getName();
        LOV lov = property.getLov();
        PropertyType propertyType = this.metametadata.getPropertyTypes().get(property.getType());
        String detail = this.initCap(propertyType.getDataType()) + " Property";
        if (lov != null) {
            String lovType = Arrays.stream(lov.getType().getValue().split("_")).map(w -> this.initCap(w.toLowerCase())).collect(Collectors.joining(" "));
            detail = detail + " (" + lovType + " LOV)";
        }
        APEXLangSuggestion suggestion = new APEXLangSuggestion(type, value, detail, property);
        if (lov != null) {
            if (lov.getType() == LOV.LOVType.STATIC) {
                suggestion.getChildren().addAll(APEXLangSuggestion.fromStrings(lov.getValues().stream().filter(v -> !v.isDeprecated() && !v.isInternal()).map(s -> s.getName()).toList(), APEXLangSuggestion.SuggestionType.VALUE));
            } else if (lov.getType() == LOV.LOVType.PLUGINS) {
                HashSet<String> pluginNames = new HashSet<String>();
                String[] pluginTypes = component.getComponentType().getPlugin().getTypes();
                if (pluginTypes != null) {
                    for (String pt : pluginTypes) {
                        Map<String, Component> pluginsFound = this.pluginsLoader.getPluginTypesMap().get(pt);
                        if (pluginsFound == null) continue;
                        pluginNames.addAll(pluginsFound.keySet());
                    }
                }
                if (!pluginNames.isEmpty()) {
                    suggestion.getChildren().addAll(APEXLangSuggestion.fromStrings(pluginNames, APEXLangSuggestion.SuggestionType.VALUE));
                }
            } else if (lov.getType() == LOV.LOVType.COMPONENT) {
                List<String> refs = this.compiler.getAvailableReferences(property, component, this.appCtx);
                suggestion.getChildren().addAll(APEXLangSuggestion.fromStrings(refs, APEXLangSuggestion.SuggestionType.VALUE));
            }
        } else if ("boolean".equals(propertyType.getDataType())) {
            suggestion.getChildren().addAll(APEXLangSuggestion.fromStrings(List.of("false", "true"), APEXLangSuggestion.SuggestionType.VALUE));
        }
        suggestions.add(suggestion);
    }

    private String initCap(String value) {
        return value == null ? null : value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildComponentSuggestions(List<APEXLangSuggestion> suggestions, Component parentComponent) {
        String uniqueId = "\"CHILD$" + Math.random() + "\"";
        APEXAppFile originalSource = this.fileMap.get(this.filePath);
        try {
            for (Map.Entry<String, ComponentType> entry : this.metametadata.getComponentTypes().entrySet()) {
                ComponentType testComponentType = entry.getValue();
                String componentTypeId = entry.getKey();
                if (!this.isValidCheck.apply(parentComponent, testComponentType).booleanValue()) continue;
                String componentName = testComponentType.getName().getSingular();
                String detail = this.initCap(componentName) + " Component";
                APEXLangSuggestion compSuggestion = new APEXLangSuggestion(APEXLangSuggestion.SuggestionType.COMPONENT, componentName, detail);
                StringBuilder sb1 = new StringBuilder();
                sb1.append("\n    ").append(componentName).append(" ").append(uniqueId).append(" (\n    )\n");
                StringBuilder sb2 = new StringBuilder();
                sb2.append(originalSource);
                sb2.insert(this.offset, sb1.toString());
                originalSource.setContentString(sb2.toString());
                APEXLangCompilationResult result2 = this.compiler.compile(this.fileMap, this.appCtx);
                APEXLangSyntaxError[] errors = result2.getErrors();
                if (errors != null && errors.length > 0) {
                    Component component = new Component(componentTypeId, testComponentType, parentComponent.getExternalIdentifier(), parentComponent, null, null);
                    List<Property> missing = Arrays.stream(errors).filter(e -> e.getRange().getStart() >= this.offset && e.getRange().getEnd() <= this.offset + sb1.length() && e.getErrorType() == APEXLangSyntaxError.ErrorType.MISSING_REQUIRED_PROPERTY).map(e -> ((APEXLangMissingRequiredPropertyError)e).getMissingProperty()).toList();
                    if (missing.size() > 0) {
                        Set groupNames = missing.stream().map(p -> p.getGroupName()).collect(Collectors.toSet());
                        String defaultGroupId = testComponentType.getDefaultGroupId();
                        String defaultGroupName = defaultGroupId == null ? null : this.metametadata.getGroups().get(defaultGroupId).getName();
                        for (String groupName : groupNames) {
                            APEXLangSuggestion parent;
                            if (groupName.equals(defaultGroupName)) {
                                parent = compSuggestion;
                            } else {
                                parent = new APEXLangSuggestion(APEXLangSuggestion.SuggestionType.GROUP, groupName, null);
                                compSuggestion.getChildren().add(parent);
                            }
                            List<APEXLangSuggestion> suggestions2 = parent.getChildren();
                            missing.stream().filter(p -> groupName.equals(p.getGroupName())).forEach(p -> this.addProperty(suggestions2, (Property)p, false, APEXLangSuggestion.SuggestionType.PROPERTY_IN_CURRENT_GROUP, component));
                        }
                    }
                }
                suggestions.add(compSuggestion);
            }
        }
        finally {
            this.fileMap.put(this.filePath, originalSource);
        }
    }
}

